/*
 * Decompiled with CFR 0.152.
 */
package improviser.gui;

import improviser.Chord;
import improviser.SongData;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class SongDisplay
extends JPanel {
    SongData song;
    int ddx;
    double dx;
    int hinset = 1;
    Thread scroller = new ScrollThread();
    public MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            int[] p = SongDisplay.this.xToTime(e.getX());
            int index = SongDisplay.this.song.chordIndexAtTime(p);
            if (index == -1 || index == -2) {
                SongDisplay.this.setSelected(-1);
            } else {
                SongDisplay.this.setSelected(index);
            }
            SongDisplay.this.repaint();
        }
    };
    int zoom = 10;
    int pos = 0;
    int dpos = 0;
    int selected = -1;
    int targetpos;
    ActionListener al = null;

    public SongDisplay() {
        this.setBackground(Color.white);
        this.addMouseListener(this.ml);
        this.scroller.start();
    }

    public SongData getSong() {
        return this.song;
    }

    public void setSong(SongData s) {
        this.song = s;
        this.setSelected(-1);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.song == null) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = this.pos - this.zoom / 2;
        int[] starttime = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = this.pos + this.zoom / 2;
        int[] endtime = nArray2;
        int startindex = this.song.chordIndexAtTime(starttime);
        int endindex = this.song.chordIndexAtTime(endtime);
        if (startindex == -1) {
            startindex = 0;
            starttime = new int[2];
        }
        if (endindex == -2) {
            endindex = this.song.size() - 1;
        }
        int i = startindex;
        while (i <= endindex) {
            if (i >= 0) {
                if (i == this.selected) {
                    g.setColor(Color.cyan);
                } else {
                    g.setColor(Color.yellow);
                }
                int[] lenofevent = this.song.timeOfChord(i);
                int[] endofevent = new int[]{starttime[0] + lenofevent[0], starttime[1] + lenofevent[1]};
                int x1 = this.timeToX(starttime);
                int x2 = this.timeToX(endofevent);
                if (lenofevent[0] == -1 && lenofevent[1] == -1) {
                    x2 = this.getWidth();
                }
                g.fillRect(x1, 0, x2 - x1, this.getHeight() - 1);
                g.setColor(Color.darkGray);
                g.drawRect(x1, 0, x2 - x1, this.getHeight() - 1);
                Chord chord = this.song.getChord(i);
                g.setColor(Color.black);
                g.drawString(chord.getSymbol(), this.timeToX(starttime), this.getHeight() - 10);
                starttime[0] = starttime[0] + lenofevent[0];
                starttime[1] = starttime[1] + lenofevent[1];
            }
            ++i;
        }
        g.setColor(Color.gray);
        i = 0;
        while (i <= this.zoom) {
            int xx = (int)((double)i * this.dx + (double)this.dpos);
            g.drawLine(xx, 0, xx, this.getHeight());
            int barno = i + this.pos - this.zoom / 2;
            if (barno >= 0 && this.dx > 20.0) {
                g.drawString(String.valueOf(barno + 1), xx, 10);
            }
            ++i;
        }
    }

    public int timeToX(int[] time) {
        double frac = ((double)(time[0] - (this.pos - this.zoom / 2)) + (double)time[1] / (double)this.song.beatsPerBar) / (double)this.zoom;
        return this.dpos + (int)((double)this.getWidth() * frac);
    }

    public int[] xToTime(int x) {
        double frac = (double)(x - this.dpos) / (double)this.getWidth();
        double r = (double)(this.pos - this.zoom / 2) + frac * (double)this.zoom;
        int[] p = new int[2];
        if (r > 0.0) {
            p[0] = (int)r;
            p[1] = (int)((r - (double)p[0]) * (double)this.song.beatsPerBar);
        } else {
            p[0] = -1;
            p[1] = -1;
        }
        return p;
    }

    void moved() {
        if (this.song != null) {
            this.dx = (double)this.getWidth() / (double)this.zoom;
            this.ddx = (int)(this.dx / (double)this.song.beatsPerBar);
            this.repaint();
        }
    }

    public void setZoom(int z) {
        this.zoom = z;
        this.moved();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setPos(int p) {
        this.targetpos = p;
    }

    public int getPos() {
        return this.pos;
    }

    public void addActionListener(ActionListener al2) {
        this.al = AWTEventMulticaster.add(this.al, al2);
    }

    public void removeActionListener(ActionListener al2) {
        this.al = AWTEventMulticaster.remove(al2, this.al);
    }

    public void setSelected(int index) {
        this.selected = index;
        this.al.actionPerformed(new ActionEvent(this, 1001, "Selected"));
    }

    public int getSelected() {
        return this.selected;
    }

    class ScrollThread
    extends Thread {
        boolean running = true;
        double d = 0.0;
        double x;

        public ScrollThread() {
            super("Scroller");
            this.x = SongDisplay.this.pos;
        }

        public synchronized void run() {
            while (this.running) {
                this.d = (this.d + ((double)SongDisplay.this.targetpos - this.x) * 0.4) * 0.4;
                this.x += this.d;
                SongDisplay.this.pos = (int)this.x;
                SongDisplay.this.dpos = -((int)((this.x - (double)SongDisplay.this.pos) * SongDisplay.this.dx));
                SongDisplay.this.moved();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

