/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Chord;
import java.io.Serializable;
import java.util.Vector;

public class SongData
implements Serializable {
    Vector chords = new Vector();
    Vector chordTimes = new Vector();
    public int tempo = 180;
    public int beatsPerBar = 4;

    public int size() {
        return this.chords.size();
    }

    public int[] length() {
        int iLast = this.size();
        int[] tLast = this.totalTimeToChord(iLast);
        int[] lLast = this.timeOfChord(iLast);
        tLast[0] = tLast[0] + lLast[0];
        tLast[1] = tLast[1] + lLast[1];
        return tLast;
    }

    public Chord getChord(int index) {
        return (Chord)this.chords.elementAt(index);
    }

    public final int[] timeOfChord(int index) {
        if (index >= this.size()) {
            return new int[]{-1, -1};
        }
        return (int[])this.chordTimes.elementAt(index);
    }

    public final int barOfChord(int index) {
        return this.timeOfChord(index)[0];
    }

    public final int beatOfChord(int index) {
        return this.timeOfChord(index)[1];
    }

    public final int[] chordIndicesInBar(int bar) {
        int b;
        int[] nArray = new int[2];
        nArray[0] = bar;
        int a0 = this.chordIndexAtTime(nArray);
        if (a0 < 0) {
            return null;
        }
        int i = a0;
        while ((b = this.totalTimeToChord(++i)[0]) <= bar && b >= 0) {
        }
        int[] f = new int[i - a0];
        int j = 0;
        while (j < f.length) {
            f[j] = a0 + j;
            ++j;
        }
        return f;
    }

    public void setChord(int index, Chord chord) {
        this.chords.setElementAt(chord, index);
    }

    public synchronized void insertChord(int index, Chord chord, int[] time) {
        this.chords.insertElementAt(chord, index);
        this.chordTimes.insertElementAt(time, index);
    }

    public synchronized void removeChord(int index) {
        this.chords.removeElementAt(index);
        this.chordTimes.removeElementAt(index);
    }

    public void setTimeOfChord(int index, int[] time) {
        this.chordTimes.set(index, time);
    }

    public int[] totalTimeToChord(int index) {
        int sum = 0;
        int i = 0;
        while (i < index) {
            int[] t = this.timeOfChord(i);
            sum += t[0] * this.beatsPerBar + t[1];
            ++i;
        }
        return new int[]{sum / this.beatsPerBar, sum % this.beatsPerBar};
    }

    /*
     * Unable to fully structure code
     */
    public int chordIndexAtTime(int[] time) {
        total = time[0] * this.beatsPerBar + time[1];
        sum = 0;
        index = 0;
        if (total >= 0) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            t = this.timeOfChord(index);
            sum += t[0] * this.beatsPerBar + t[1];
            ++index;
lbl9:
            // 2 sources

            ** while (sum <= total && index < this.size())
        }
lbl10:
        // 1 sources

        if (index > this.size() || total >= sum) {
            return -2;
        }
        return index - 1;
    }

    final int timeToBeats(int[] t) {
        return t[0] * this.beatsPerBar + t[1];
    }

    final int[] beatsToTime(int b) {
        return new int[]{b / this.beatsPerBar, b % this.beatsPerBar};
    }
}

