/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.CompositePhrase;
import improviser.Metre;
import improviser.Note;
import improviser.Phrase;
import improviser.SongData;
import improviser.sound.Swing;
import improviser.sound.Track;

public class SimplePhrase
implements Phrase {
    public static final int REST = -1;
    public int[] notes;
    public Metre metre;
    public boolean isMetric = true;
    public static int swingArch = 2;
    public static int dynamicArch = 2;
    public static int delayArch = 3;

    public void play(Track track) {
        if (this.notes == null) {
            return;
        }
        int initialVelocity = track.trackVelocity;
        int initialSwingDyn = Swing.swingDynamic;
        int i = 0;
        while (i < this.notes.length) {
            if (i < this.notes.length * 2 / 3) {
                track.trackVelocity += dynamicArch;
                Swing.swingDynamic += swingArch;
                Swing.msOut += delayArch;
            } else {
                track.trackVelocity -= 2 * dynamicArch;
                Swing.swingDynamic -= 2 * swingArch;
                Swing.msOut -= 2 * delayArch;
            }
            if (this.metre.type == 3 && i % 3 == 2) {
                track.trackVelocity += Swing.swingDynamic;
            }
            if (this.notes[i] == -1) {
                track.turnOffChord();
            } else {
                track.changeNote(this.notes[i]);
            }
            if (this.metre.type == 3 && i % 3 == 2) {
                track.trackVelocity -= Swing.swingDynamic;
            }
            switch (this.metre.type) {
                case 1: {
                    Swing.waitForWholeBeat(track);
                    break;
                }
                case 2: {
                    int nextnote = this.notes[++i];
                    if (nextnote == -1) {
                        Swing.waitForDuplet(track);
                    } else {
                        Swing.playOffbeatNote(nextnote, track);
                    }
                    Swing.waitForWholeBeat(track);
                    break;
                }
                case 3: {
                    Swing.waitForTriplet(track);
                    break;
                }
                case 4: {
                    Swing.waitForQuadruplet(track);
                }
            }
            ++i;
        }
        track.trackVelocity = initialVelocity;
        Swing.swingDynamic = initialSwingDyn;
    }

    public void transpose(int semitones) {
        int i = 0;
        while (i < this.notes.length) {
            if (this.notes[i] != -1) {
                int n = i;
                this.notes[n] = this.notes[n] + semitones;
            }
            ++i;
        }
    }

    public void enforceKey(Chord key) {
        int i = 0;
        while (i < this.notes.length) {
            this.enforceKeyOnNote(key, i);
            ++i;
        }
    }

    public void enforceKeys(SongData song, int[] beginTime) {
        if (this.notes == null) {
            return;
        }
        int i = 0;
        while (i < this.notes.length) {
            int[] time = Swing.addBeatsToChordTime(beginTime, i / this.metre.type, song);
            int[] tim2 = Swing.addBeatsToChordTime(beginTime, (i + 1) / this.metre.type, song);
            System.out.print(String.valueOf(time[0]) + "+" + time[1] + ":");
            Chord ch = song.getChord(song.chordIndexAtTime(time));
            Chord c2 = song.getChord(song.chordIndexAtTime(tim2));
            if (ch == c2) {
                this.enforceKeyOnNote(ch, i);
            } else {
                this.enforceKeysOnNote(ch, c2, i);
            }
            ++i;
        }
    }

    protected void enforceKeyOnNote(Chord key, int i) {
        int previous;
        if (this.notes[i] == -1) {
            return;
        }
        System.out.println(key.getSymbol());
        int n = previous = i < 1 ? -1 : this.notes[i - 1];
        if (!key.scaleContains(this.notes[i])) {
            this.notes[i] = Note.nextInChordUp(previous, key);
        }
        if (this.notes[i] == previous) {
            this.notes[i] = Note.nextInScaleDown(this.notes[i], key);
        }
    }

    protected void enforceKeysOnNote(Chord from, Chord to, int i) {
        int previous;
        System.out.println(String.valueOf(from.getSymbol()) + " & " + to.getSymbol());
        if (this.notes[i] == -1) {
            return;
        }
        int n = previous = i < 1 ? -1 : this.notes[i - 1];
        if (!from.scaleContains(this.notes[i]) || !to.scaleContains(this.notes[i])) {
            this.notes[i] = ChordProgression.nearestOverlapNote(this.notes[i], from, to);
        }
        if (this.notes[i] == previous) {
            this.notes[i] = Note.nextInScaleUp(this.notes[i], to);
        }
    }

    public void delay(int amount) {
        if (this.notes == null) {
            return;
        }
        int length = this.notes.length + amount;
        if (length % this.metre.type > 0) {
            length = (length / this.metre.type + 1) * this.metre.type;
        }
        int[] nnotes = new int[length];
        int i = 0;
        while (i < nnotes.length) {
            nnotes[i] = i < amount || i >= amount + this.notes.length ? -1 : this.notes[i - amount];
            ++i;
        }
        this.notes = nnotes;
    }

    public Phrase plus(Phrase next) {
        if (next instanceof SimplePhrase && ((SimplePhrase)next).notes == null) {
            return this;
        }
        if (this.notes == null) {
            return next;
        }
        if (next instanceof SimplePhrase && ((SimplePhrase)next).metre.type == this.metre.type) {
            SimplePhrase suffix = (SimplePhrase)next;
            SimplePhrase compound = new SimplePhrase();
            compound.metre = new Metre(this.metre.type);
            compound.notes = new int[this.notes.length + suffix.notes.length];
            int i = 0;
            while (i < compound.notes.length) {
                compound.notes[i] = i < this.notes.length ? this.notes[i] : suffix.notes[i - this.notes.length];
                ++i;
            }
            return compound;
        }
        return new CompositePhrase(this, next);
    }

    public int finalNote() {
        if (this.notes == null) {
            return -1;
        }
        int i = 1;
        while (i < this.notes.length) {
            int pitch = this.notes[this.notes.length - i];
            if (pitch != -1) {
                return pitch;
            }
            ++i;
        }
        return -1;
    }

    public int getBeatsDuration() {
        return this.notes.length / this.metre.type;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.notes.length) {
            if (i != 0) {
                s = String.valueOf(s) + " ";
            }
            s = this.notes[i] == -1 ? String.valueOf(s) + "-" : String.valueOf(s) + Note.name(this.notes[i]) + this.notes[i];
            ++i;
        }
        return "[" + s + "]";
    }

    public SimplePhrase(Metre m, int[] notes) {
        if (notes.length % m.type > 0) {
            throw new IllegalArgumentException("Not enough notes to create phrase");
        }
        this.notes = notes;
        this.metre = this.metre;
    }

    public SimplePhrase() {
    }
}

