/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.PlayControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlayWindow
extends JFrame
implements Runnable {
    private JPanel jPanel1 = new JPanel();
    private JToggleButton bplay = new JToggleButton();
    private JToggleButton bpause = new JToggleButton();
    private JButton bstop = new JButton();
    private JSlider posslider = new JSlider();
    protected PlayControl pc;
    public boolean stopOnClose = true;
    boolean running = true;
    Thread thread = new Thread((Runnable)this, "monitor playing");

    public PlayWindow(PlayControl pc) {
        this.pc = pc;
        this.init();
        this.setSize(300, 100);
        this.show();
        if (pc.isPlaying()) {
            this.bplay.setSelected(true);
        }
        this.thread.start();
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (PlayWindow.this.stopOnClose) {
                    PlayWindow.this.pc.stop();
                }
                PlayWindow.this.running = false;
            }
        });
        this.posslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PlayWindow.this.pc.setProgress((double)PlayWindow.this.posslider.getValue() / (double)PlayWindow.this.posslider.getMaximum());
            }
        });
    }

    private void jbInit() throws Exception {
        this.bplay.setToolTipText("");
        this.bplay.setText("Play");
        this.bplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayWindow.this.bplay_actionPerformed(e);
            }
        });
        this.bpause.setText("Pause");
        this.bpause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayWindow.this.bpause_actionPerformed(e);
            }
        });
        this.bstop.setText("Stop");
        this.bstop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayWindow.this.bstop_actionPerformed(e);
            }
        });
        this.setTitle("Play");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.bplay, null);
        this.jPanel1.add((Component)this.bpause, null);
        this.jPanel1.add((Component)this.bstop, null);
        this.jPanel1.add((Component)this.posslider, null);
        this.posslider.setValue(0);
    }

    void bplay_actionPerformed(ActionEvent e) {
        this.bpause.setSelected(false);
        this.pc.start();
    }

    void bpause_actionPerformed(ActionEvent e) {
        if (!this.bpause.isSelected()) {
            this.bplay.setSelected(true);
            this.pc.start();
        } else {
            this.bplay.setSelected(false);
            this.pc.pause();
        }
    }

    void bstop_actionPerformed(ActionEvent e) {
        this.bplay.setSelected(false);
        this.bpause.setSelected(false);
        this.pc.stop();
    }

    public void run() {
        while (this.running) {
            this.posslider.setValue((int)((double)this.posslider.getMaximum() * this.pc.getProgress()));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

