/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Chord;
import improviser.ChordProgression;
import improviser.Metre;
import improviser.Note;
import improviser.Phrase;
import improviser.SimplePhrase;
import improviser.SongData;
import improviser.sound.Swing;

public class PhraseFactory {
    public static Phrase generateScale(int startNote, boolean direction, boolean arpeggio, SongData song, int[] beginTime, int length, Metre metre) {
        SimplePhrase p = new SimplePhrase();
        if (length % metre.type > 0) {
            length = (length / metre.type + 1) * metre.type;
        }
        p.notes = new int[length];
        p.metre = metre;
        int[] time = new int[2];
        Chord currentChord = null;
        Chord nextChord = song.getChord(song.chordIndexAtTime(beginTime));
        int i = 0;
        while (i < length) {
            p.notes[i] = startNote;
            currentChord = nextChord;
            int elapsedBeats = (i + 1) / metre.type;
            time = Swing.addBeatsToChordTime(beginTime, elapsedBeats, song);
            nextChord = song.getChord(song.chordIndexAtTime(time));
            if (nextChord != currentChord) {
                p.notes[i] = startNote = ChordProgression.nearestOverlapNote(startNote, currentChord, nextChord);
            }
            if (direction) {
                startNote = Note.nextInScaleUp(startNote, nextChord);
                if (arpeggio) {
                    startNote = Note.nextInScaleUp(startNote, nextChord);
                }
            } else {
                startNote = Note.nextInScaleDown(startNote, nextChord);
                if (arpeggio) {
                    startNote = Note.nextInScaleDown(startNote, nextChord);
                }
            }
            ++i;
        }
        return p;
    }

    public static Phrase generateTurn(int finalNote, Chord key, Metre metre) {
        int finalDegree = Note.toBaseRange(finalNote - key.keyNote);
        if (key.typeIndex == 6 && finalDegree < 3 && finalDegree > -1 && metre.type == 4) {
            Phrase p = new SimplePhrase(metre, new int[]{2, 3, 2, 1}).plus(new SimplePhrase(new Metre(2), new int[]{-1, 2}));
            return p;
        }
        SimplePhrase p = new SimplePhrase();
        p.metre = metre;
        p.notes = new int[metre.type];
        if (metre.type == 2) {
            p.notes[0] = finalNote - 1;
            p.notes[1] = Note.nextInScaleUp(finalNote, key);
        } else if (metre.type == 3) {
            p.notes[0] = finalNote - 2;
            p.notes[1] = finalNote - 1;
            p.notes[2] = Note.nextInScaleUp(finalNote, key);
        } else if (metre.type == 4) {
            p.notes[0] = finalNote - 2;
            p.notes[1] = finalNote - 1;
            p.notes[2] = finalNote + 2;
            p.notes[3] = finalNote + 1;
        }
        return p;
    }

    public static Phrase createBlankPhrase() {
        return new SimplePhrase();
    }
}

