/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Chord;
import java.util.Vector;

public class Note {
    int pitch;
    public static String[] noteStrings = new String[]{"C", "C#", "D", "Eb", "E", "F", "F#", "G", "Ab", "A", "Bb", "B", "B#", "Db", "Ebb", "D#", "Fb", "E#", "Gb", "Fx", "G#", "Bbb", "A#", "Cb"};

    public Note() {
    }

    public Note(int pitch) {
        this.pitch = pitch;
    }

    public static String name(int noteValue) {
        return noteStrings[Note.toBaseRange(noteValue)];
    }

    public static int value(String name) {
        int i = 0;
        while (i < noteStrings.length) {
            if (noteStrings[i].equals(name)) {
                return i % 12;
            }
            ++i;
        }
        return -1;
    }

    public static final String nameInChord(int noteValue, Chord chord) {
        return Note.name(noteValue);
    }

    public static final int toBaseRange(int note) {
        while (note < 0) {
            note += 12;
        }
        return note % 12;
    }

    public static final int[] toBaseRange(int[] notes) {
        int[] p = new int[notes.length];
        int i = 0;
        while (i < notes.length) {
            p[i] = Note.toBaseRange(notes[i]);
            ++i;
        }
        return p;
    }

    public static final int bringIntoRange(int note, int startNote) {
        while (note < startNote) {
            note += 12;
        }
        while (note >= startNote + 12) {
            note -= 12;
        }
        return note;
    }

    public static int[] exclude(int[] parentSet, int[] excludeSet) {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < parentSet.length) {
            boolean iExcluded = false;
            int j = 0;
            while (j < excludeSet.length) {
                if (parentSet[i] == excludeSet[j]) {
                    iExcluded = true;
                }
                ++j;
            }
            if (!iExcluded) {
                v.add(new Integer(parentSet[i]));
            }
            ++i;
        }
        int[] e = new int[v.size()];
        int i2 = 0;
        while (i2 < e.length) {
            e[i2] = (Integer)v.get(i2);
            ++i2;
        }
        return e;
    }

    public static int[] combine(int[] set1, int[] set2) {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < set1.length) {
            v.add(new Integer(set1[i]));
            ++i;
        }
        i = 0;
        while (i < set2.length) {
            boolean repeated = false;
            int j = 0;
            while (j < set1.length) {
                if (set1[j] == set2[i]) {
                    repeated = true;
                }
                ++j;
            }
            if (!repeated) {
                v.add(new Integer(set2[i]));
            }
            ++i;
        }
        int[] sum = new int[v.size()];
        int i2 = 0;
        while (i2 < sum.length) {
            sum[i2] = (Integer)v.get(i2);
            ++i2;
        }
        return sum;
    }

    public static int[] intersect(int[] set1, int[] set2) {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < set1.length) {
            int j = 0;
            while (j < set2.length) {
                if (set1[i] == set2[j]) {
                    v.add(new Integer(set1[i]));
                }
                ++j;
            }
            ++i;
        }
        int[] s = new int[v.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (Integer)v.get(i2);
            ++i2;
        }
        return s;
    }

    public static int[] intersectScales(int[] scale1, int[] scale2) {
        return Note.intersect(Note.toBaseRange(scale1), Note.toBaseRange(scale2));
    }

    public static final int nextInScaleUp(int note, Chord chord) {
        int tries = 0;
        while (!chord.scaleContains(++note) && ++tries < 12) {
        }
        return note;
    }

    public static final int nextInScaleDown(int note, Chord chord) {
        int tries = 0;
        while (!chord.scaleContains(--note) && ++tries < 12) {
        }
        return note;
    }

    public static final int nextInChordUp(int note, Chord chord) {
        int tries = 0;
        while (!chord.chordContains(++note) && ++tries < 12) {
        }
        return note;
    }

    public static final int nextInChordDown(int note, Chord chord) {
        int tries = 0;
        while (!chord.chordContains(--note) && ++tries < 12) {
        }
        return note;
    }

    public static int nearestFromList(int note, int[] choices) {
        int mindiff = 255;
        int ch = choices[0];
        int i = 0;
        while (i < choices.length) {
            int d = Math.abs(choices[i] - note);
            if (d < mindiff) {
                mindiff = d;
                ch = i;
            }
            ++i;
        }
        return choices[ch];
    }

    public static int nearestFromScaleList(int note, int[] scale) {
        int n = Note.toBaseRange(note);
        int[] s = Note.toBaseRange(scale);
        int f = Note.nearestFromList(n, s);
        return f + 12 * (note / 12);
    }
}

