/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.SongData;
import improviser.gui.SongEditorPane;
import improviser.sound.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ImproviserFrame
extends JFrame
implements ActionListener {
    JMenuBar menuBar1 = new JMenuBar();
    JMenu menu1 = new JMenu();
    JMenuItem menuItem1 = new JMenuItem();
    JMenuItem menuItem2 = new JMenuItem();
    JMenuItem menuItem3 = new JMenuItem();
    JMenuItem menuItem4 = new JMenuItem();
    String defaultDirectory = "e:/charts";
    JFileChooser filer = new JFileChooser(this.defaultDirectory);
    Player player;
    FileFilter myfilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".cht");
        }

        public String getDescription() {
            return "Jazz chart (*.cht)";
        }
    };
    Border border1;
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JToggleButton playbutton = new JToggleButton();
    JLabel tensiontxt = new JLabel();
    JSlider tensionslider = new JSlider();
    JPanel jPanel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    SongEditorPane editor = new SongEditorPane();

    public ImproviserFrame() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.filer.addChoosableFileFilter(this.myfilter);
        this.filenew();
        this.jPanel2.registerKeyboardAction(this, "Open", KeyStroke.getKeyStroke(79, 2), 1);
        this.jPanel2.registerKeyboardAction(this, "Save", KeyStroke.getKeyStroke(83, 2), 1);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.control, 2);
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.menuBar1);
        this.setTitle("Sanjay's improviser");
        this.menu1.setText("File");
        this.menuItem1.setActionCommand("Save");
        this.menuItem1.setText("Save song...");
        this.menuItem1.addActionListener(this);
        this.menuItem2.setActionCommand("Open");
        this.menuItem2.setText("Open song...");
        this.menuItem2.addActionListener(this);
        this.menuItem3.setText("New song");
        this.menuItem3.addActionListener(this);
        this.menuItem4.setText("Exit");
        this.menuItem4.addActionListener(this);
        this.jPanel2.setLayout(this.borderLayout1);
        this.playbutton.setText("Play");
        this.playbutton.addActionListener(this);
        this.tensiontxt.setText("0.5");
        this.tensionslider.setValue(3);
        this.tensionslider.setPreferredSize(new Dimension(50, 26));
        this.tensionslider.setBorder(this.border1);
        this.tensionslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ImproviserFrame.this.change(e);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Tension");
        this.menuBar1.add(this.menu1);
        this.menu1.add(this.menuItem3);
        this.menu1.addSeparator();
        this.menu1.add(this.menuItem2);
        this.menu1.add(this.menuItem1);
        this.menu1.addSeparator();
        this.menu1.add(this.menuItem4);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.playbutton, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.tensionslider, null);
        this.jPanel1.add((Component)this.tensiontxt, null);
        this.jPanel2.add((Component)this.editor, "Center");
    }

    void filenew() {
        SongData s = new SongData();
        this.editor.setSong(s);
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("New song")) {
            this.filenew();
        }
        if (s.equals("Play")) {
            if (this.playbutton.isSelected()) {
                this.play();
            } else {
                this.stop();
            }
        }
        if (s.equals("Open")) {
            this.fileOpen();
        }
        if (s.equals("Save")) {
            this.fileSave();
        }
    }

    void play() {
        this.player = new Player(this.editor.getSong());
        this.player.tension = this.getTension();
        this.player.startChordIndex = this.editor.getSelected();
        if (this.player.startChordIndex < 0) {
            this.player.startChordIndex = 0;
        }
        this.player.editorPane = this.editor;
        this.player.followScoreSelection = true;
        this.player.followScoreScroll = false;
        this.player.start();
    }

    void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    void fileOpen() {
        this.checkErase();
        int res = this.filer.showOpenDialog(this);
        if (res == 1) {
            return;
        }
        File f = this.filer.getSelectedFile();
        if (f == null) {
            return;
        }
        try {
            SongData d = (SongData)new ObjectInputStream(new FileInputStream(f)).readObject();
            this.editor.setSong(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Error opening file", 0);
        }
    }

    void checkErase() {
    }

    void fileSave() {
        int res = this.filer.showSaveDialog(this);
        if (res == 1) {
            return;
        }
        File f = this.filer.getSelectedFile();
        if (f == null) {
            return;
        }
        try {
            new ObjectOutputStream(new FileOutputStream(f)).writeObject(this.editor.getSong());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.toString(), "Error saving file", 0);
        }
    }

    double getTension() {
        return (double)this.tensionslider.getValue() / 100.0;
    }

    void change(ChangeEvent e) {
        double f = this.getTension();
        if (this.player != null) {
            this.player.tension = f;
        }
        this.tensiontxt.setText(String.valueOf(f));
    }
}

