/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Chord;
import improviser.Phrase;
import improviser.SongData;
import improviser.sound.Swing;
import improviser.sound.Track;

public class CompositePhrase
implements Phrase {
    public Phrase first;
    public Phrase second;

    public CompositePhrase(Phrase a, Phrase b) {
        this.first = a;
        this.second = b;
    }

    public void transpose(int semitones) {
        this.first.transpose(semitones);
        this.second.transpose(semitones);
    }

    public void enforceKey(Chord chord) {
        this.first.enforceKey(chord);
        this.second.enforceKey(chord);
    }

    public Phrase plus(Phrase next) {
        return new CompositePhrase(this, next);
    }

    public void play(Track t) {
        this.first.play(t);
        this.second.play(t);
    }

    public int finalNote() {
        return this.second.finalNote();
    }

    public int getBeatsDuration() {
        return this.first.getBeatsDuration() + this.second.getBeatsDuration();
    }

    public void delay(int amount) {
        System.out.println("Mixed metre");
    }

    public void enforceKeys(SongData song, int[] beginTime) {
        this.first.enforceKeys(song, beginTime);
        int[] secondTime = Swing.addBeatsToChordTime(beginTime, this.first.getBeatsDuration(), song);
        this.second.enforceKeys(song, secondTime);
    }

    public String toString() {
        return String.valueOf(this.first.toString()) + " " + this.second.toString();
    }
}

