/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Chord;
import improviser.Note;

public class ChordProgression {
    public static boolean useMinorSeventh(Chord a) {
        return a.typeName.equals("m");
    }

    public static final boolean isII_V(Chord a, Chord b) {
        return ChordProgression.keyChangeInterval(a, b) == 5;
    }

    public static final boolean isII_I(Chord a, Chord b) {
        return ChordProgression.keyChangeInterval(a, b) == 10;
    }

    public static final int keyChangeInterval(Chord a, Chord b) {
        return Note.toBaseRange(b.keyNote - a.keyNote);
    }

    public static int getLeadingNote(Chord chord) {
        int[] sn = chord.getScaleNotes();
        return sn[sn.length - 1];
    }

    public static int getSupertonic(Chord chord, Chord nextChord) {
        int[] sn = chord.getScaleNotes();
        if (chord.typeIndex == 4 && ChordProgression.keyChangeInterval(chord, nextChord) == 5) {
            return sn[1] - 1;
        }
        return sn[1];
    }

    public static int getMediant(Chord chord) {
        return chord.getChordNotes()[1];
    }

    public static boolean hasFlat5(Chord chord) {
        return chord.typeIndex == 6 || chord.typeIndex == 7 || chord.typeIndex == 5;
    }

    public static int getDominant(Chord chord) {
        if (ChordProgression.hasFlat5(chord)) {
            return chord.keyNote + 6;
        }
        return chord.keyNote + 7;
    }

    public static boolean isMinor(Chord chord) {
        return chord.typeIndex == 1 || chord.typeIndex == 2;
    }

    public static boolean isMajor(Chord chord) {
        return chord.typeIndex == 0 || chord.typeIndex == 3;
    }

    public static int distanceOfHands(int[] chord1, int[] chord2) {
        int totalMovement = 0;
        int i = 0;
        while (i < chord1.length) {
            int closestj = 0;
            int jdist = 255;
            int j = 0;
            while (j < chord2.length) {
                int dist = Math.abs(chord1[i] - chord2[j]);
                if (dist < jdist) {
                    closestj = j;
                    jdist = dist;
                }
                ++j;
            }
            totalMovement += jdist;
            ++i;
        }
        return totalMovement;
    }

    public static int nearestScaleNote(int note, Chord chord) {
        if (chord.scaleContains(note)) {
            return note;
        }
        if (chord.scaleContains(note + 1)) {
            ++note;
        } else if (chord.scaleContains(note - 1)) {
            --note;
        } else if (chord.scaleContains(note + 2)) {
            note += 2;
        } else if (chord.scaleContains(note - 2)) {
            note -= 2;
        } else {
            throw new RuntimeException("Odd scale");
        }
        return note;
    }

    public static int nearestChordNote(int note, Chord chord) {
        if (chord.chordContains(note)) {
            return note;
        }
        int i = 0;
        while (i < 5) {
            if (chord.chordContains(note + i)) {
                return note + i;
            }
            if (chord.chordContains(note - i)) {
                return note - i;
            }
            ++i;
        }
        throw new RuntimeException("Odd chord");
    }

    public static int noteMustResolve(int note, Chord chord) {
        if (!chord.chordContains(note) && chord.chordContains(note + 1)) {
            return 1;
        }
        if (!chord.chordContains(note) && chord.chordContains(note - 1)) {
            return -1;
        }
        if (ChordProgression.noteRelativeToChord(note, chord) == 6 && !ChordProgression.hasFlat5(chord)) {
            return 1;
        }
        return 0;
    }

    public static int noteRelativeToChord(int note, Chord chord) {
        return Note.toBaseRange(note - chord.keyNote);
    }

    public static int nearestOverlapNote(int note, Chord chord1, Chord chord2) {
        if (chord1.scaleContains(note) && chord2.scaleContains(note)) {
            return note;
        }
        int i = 0;
        while (i < 7) {
            if (chord1.scaleContains(note + i) && chord2.scaleContains(note + i)) {
                return note + i;
            }
            if (chord1.scaleContains(note - i) && chord2.scaleContains(note - i)) {
                return note - i;
            }
            ++i;
        }
        throw new RuntimeException("Odd chords");
    }
}

