/*
 * Decompiled with CFR 0.152.
 */
package improviser;

import improviser.Note;
import java.io.Serializable;
import java.util.Vector;

public class Chord
implements Serializable {
    public static int FLAT9 = 2;
    public static int ADD9 = 4;
    public static int MIN3 = 8;
    public static int MAJ3 = 16;
    public static int ADD11 = 32;
    public static int SHARP11 = 64;
    public static int ADD12 = 128;
    public static int MIN13 = 256;
    public static int MAJ13 = 512;
    public static int MIN7 = 1024;
    public static int MAJ7 = 2048;
    static String[][] KchordNames = new String[][]{{"Major", "", "maj"}, {"Minor", "m", "min"}, {"Minor seventh", "m7", "min7"}, {"Major seventh", "maj7", "^"}, {"Seventh", "7"}, {"Half dim", "/", "h"}, {"Altered", "alt"}, {"Diminished", "o", "dim"}};
    static int[][] KchordNotes = new int[][]{{MAJ3 + ADD12, ADD9 + MAJ3 + ADD12 + MAJ13 + MAJ7}, {MIN3 + ADD12, ADD9 + MIN3 + ADD12 + MIN13 + MAJ13 + MIN7 + MAJ7}, {MIN3 + ADD12 + MIN7, ADD9 + MIN3 + ADD11 + ADD12 + MAJ13 + MIN7}, {MAJ3 + ADD12 + MAJ7, ADD9 + MAJ3 + ADD11 + SHARP11 + ADD12 + MAJ13 + MAJ7}, {MAJ3 + SHARP11 + MIN7, ADD9 + MAJ3 + SHARP11 + ADD12 + MAJ13 + MIN7}, {MIN3 + SHARP11 + MIN7, FLAT9 + MIN3 + ADD11 + SHARP11 + MIN13 + MIN7}, {MAJ3 + MIN13 + MIN7, FLAT9 + MIN3 + MAJ3 + SHARP11 + MIN13 + MIN7}, {MIN3 + SHARP11 + MAJ13, ADD9 + MIN3 + ADD11 + SHARP11 + MIN13 + MAJ13}};
    public static final int TYPE_MINOR = 1;
    public static final int TYPE_MINOR_SEVENTH = 2;
    public static final int TYPE_MAJOR_SEVENTH = 3;
    public static final int TYPE_SEVENTH = 4;
    public static final int TYPE_HALF_DIMINISHED = 5;
    public static final int TYPE_ALTERED = 6;
    public static final int TYPE_DIMINISHED = 7;
    public static final int TYPE_MAJOR = 0;
    public int keyNote = -1;
    public int chordDegrees = 0;
    public int typeIndex = -1;
    public int scaleDegrees;
    public String typeName = "";
    public String longName = "";

    public static String[][] getAllChordNames() {
        return KchordNames;
    }

    public static int[][] getAllChordNotes() {
        return KchordNotes;
    }

    public Chord() {
    }

    public Chord(int keyNote, String symbol) {
        this.keyNote = keyNote;
        this.typeName = symbol;
        int i = Chord.getAllChordNames().length - 1;
        while (i >= 0) {
            if (symbol.startsWith(Chord.getAllChordNames()[i][1])) {
                this.typeIndex = i;
            }
            --i;
        }
        if (this.typeIndex == -1) {
            throw new IllegalArgumentException("Unrecognised chord symbol: " + symbol);
        }
        this.initAsType(this.typeIndex);
    }

    void initAsType(int type) {
        this.typeIndex = type;
        this.chordDegrees = Chord.getAllChordNotes()[this.typeIndex][0];
        this.scaleDegrees = Chord.getAllChordNotes()[this.typeIndex][1];
        this.typeName = Chord.getAllChordNames()[this.typeIndex][1];
        this.longName = Chord.getAllChordNames()[this.typeIndex][0];
    }

    public Chord(String chordSymbol) {
        this.typeName = "";
        this.typeIndex = 0;
        String[][] cn = Chord.getAllChordNames();
        boolean found = false;
        int i = Chord.getAllChordNames().length - 1;
        while (i >= 0) {
            int j = 0;
            while (j < Chord.getAllChordNames()[i].length) {
                String test = Chord.getAllChordNames()[i][j];
                if (chordSymbol.endsWith(test)) {
                    chordSymbol = chordSymbol.substring(0, chordSymbol.length() - test.length());
                    this.typeName = test;
                    this.typeIndex = i;
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) break;
            --i;
        }
        this.keyNote = Note.value(chordSymbol);
        if (this.keyNote == -1) {
            throw new IllegalArgumentException("Unrecognised chord symbol: " + chordSymbol);
        }
        this.initAsType(this.typeIndex);
    }

    public boolean equals(Chord otherChord) {
        return this.getSymbol().equals(otherChord.getSymbol());
    }

    public String getSymbol() {
        return String.valueOf(Note.name(this.keyNote)) + this.typeName;
    }

    public int[] getChordNotes() {
        int[] p = this.listNotesIn(this.chordDegrees);
        int i = 0;
        while (i < p.length) {
            int n = i++;
            p[n] = p[n] + this.keyNote;
        }
        return p;
    }

    public int[] getScaleNotes() {
        int[] p = this.listNotesIn(this.scaleDegrees);
        int i = 0;
        while (i < p.length) {
            int n = i++;
            p[n] = p[n] + this.keyNote;
        }
        return p;
    }

    public boolean chordContains(int note) {
        int relativePos = Note.toBaseRange(note - this.keyNote);
        if (relativePos == 0) {
            return true;
        }
        return this.chordContains(this.chordDegrees, 1 << relativePos);
    }

    public boolean scaleContains(int note) {
        int relativePos = Note.toBaseRange(note - this.keyNote);
        if (relativePos == 0) {
            return true;
        }
        return this.chordContains(this.scaleDegrees, 1 << relativePos);
    }

    final int[] listNotesIn(int chord) {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < 12) {
            int j = 1 << i;
            if (this.chordContains(chord, j)) {
                v.add(new Integer(i));
            }
            ++i;
        }
        int[] e = new int[v.size() + 1];
        e[0] = 0;
        int i2 = 0;
        while (i2 < v.size()) {
            e[i2 + 1] = (Integer)v.get(i2);
            ++i2;
        }
        return e;
    }

    final boolean chordContains(int a, int b) {
        return (a & b) > 0;
    }
}

