/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.ObjectPath;
import evaluator.Operator;
import evaluator.ParseException;
import evaluator.Stack;
import evaluator.StackException;
import evaluator.VariableLookup;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class Variable
extends ObjectPath
implements Operator {
    static final int INTERNAL = 0;
    static final int EXTERNAL = 1;
    int type;
    String name;
    public static Hashtable table = new Hashtable();
    public static VariableLookup namespaceLookup = null;

    public static void set(String name, Object value) {
        table.put(name, value);
    }

    public static Object get(String name) {
        Object d = table.get(name);
        if (d != null) {
            return d;
        }
        return new Double(Double.NaN);
    }

    public static void remove(String name) {
        table.remove(name);
    }

    public final int getStackCount() {
        return 1;
    }

    public Variable(String name) throws ParseException {
        this.name = name;
        try {
            this.createPath(name);
            this.type = 1;
        }
        catch (Exception ex) {
            this.type = 0;
        }
        if (this.member == null) {
            this.type = 0;
        }
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        Object ans = null;
        switch (this.type) {
            case 0: {
                ans = table.get(this.name);
                if (ans != null) break;
                if (namespaceLookup != null) {
                    ans = namespaceLookup.getVariableValue(this.name);
                }
                if (ans != null) break;
                throw new MathException(stack, "Variable '" + this.name + "' has not been assigned.");
            }
            case 1: {
                if (this.member instanceof Method) {
                    Method method = (Method)this.member;
                    Class<?>[] paramtypes = method.getParameterTypes();
                    if (paramtypes.length != 0) {
                        throw new MathException(stack, method + " takes parameters");
                    }
                    try {
                        Object d;
                        ans = d = method.invoke(this.object, null);
                        break;
                    }
                    catch (Exception e) {
                        throw new MathException(stack, method + " could not be invoked" + " because of " + e.getMessage());
                    }
                }
                Field field = (Field)this.member;
                if (field.getType() != Double.TYPE) {
                    Method test = null;
                    try {
                        test = field.getType().getMethod("get", null);
                        ans = test.invoke(field.get(this.object), null);
                        break;
                    }
                    catch (Exception e) {
                        try {
                            ans = field.get(this.object);
                            break;
                        }
                        catch (Exception ex) {
                            throw new MathException(stack, field + " could not be read because of " + ex.getMessage());
                        }
                    }
                }
                try {
                    ans = new Double(field.getDouble(this.object));
                    break;
                }
                catch (Exception e) {
                    throw new MathException(stack, field + " could not be read " + "because of " + e.getMessage());
                }
            }
        }
        stack.push(ans);
    }
}

