/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.EquationException;
import evaluator.Expression;
import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.Variable;

public class Statement {
    String string;
    Expression expr;
    String left = null;

    public Statement(String s) throws ParseException {
        boolean needDummyVar;
        this.string = s;
        this.strip();
        int eq = s.indexOf(61);
        this.left = null;
        if (eq >= 0) {
            String right;
            this.left = s.substring(0, eq).trim();
            s = right = s.substring(eq + 1).trim();
        }
        boolean bl = needDummyVar = this.left != null && Variable.table.get(this.left) == null;
        if (needDummyVar) {
            Variable.set(this.left, "");
        }
        this.expr = new Expression(s);
        if (needDummyVar) {
            Variable.remove(this.left);
        }
    }

    public Object evaluate() throws MathException, StackException {
        Object ans = this.expr.evaluate();
        if (this.left != null) {
            this.set(this.left, ans);
        }
        return ans;
    }

    public void set(String vname, Object value) throws EquationException {
        Variable.set(vname, value);
    }

    String makeword(String s) {
        if (s.length() == 0) {
            return null;
        }
        String n = new String();
        char c = s.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return null;
        }
        n = String.valueOf(n) + c;
        int i = 1;
        while (i < s.length()) {
            c = s.charAt(i);
            if (!Character.isIdentifierIgnorable(c)) {
                if (Character.isJavaIdentifierPart(c) || c == '.') {
                    n = String.valueOf(n) + c;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return n;
    }

    public String getDefinition() {
        return this.string;
    }

    public void strip() {
        String oldString = this.string;
        this.string = this.string.trim();
        if (this.string.startsWith(";") || this.string.startsWith("\n")) {
            this.string = this.string.substring(1);
        }
        if (this.string.endsWith(";") || this.string.endsWith("\n")) {
            this.string = this.string.substring(0, this.string.length() - 1);
        }
        if (!this.string.equals(oldString)) {
            this.strip();
        }
    }
}

