/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.ObjectPath;
import evaluator.Operator;
import evaluator.ParseException;
import evaluator.Stack;
import evaluator.StackException;
import java.lang.reflect.Method;

public class Function
extends ObjectPath
implements Operator {
    String function;
    int parameters;

    public Function(String function, int parameters) throws ParseException {
        this.function = function;
        this.parameters = parameters;
        this.nParams = parameters;
        this.createPath(function);
    }

    public int getStackCount() {
        return 1 - this.parameters;
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        Object ans = null;
        if (!(this.member instanceof Method)) {
            throw new MathException(stack, this.member + " is not a method");
        }
        Method method = (Method)this.member;
        Class<?>[] paramtypes = method.getParameterTypes();
        Object[] o = new Object[this.parameters];
        int i = this.parameters - 1;
        while (i >= 0) {
            o[i] = stack.pop();
            --i;
        }
        if (paramtypes.length != this.parameters) {
            throw new MathException(stack, method + " does not take " + this.parameters + " parameter(s).");
        }
        try {
            ans = method.invoke(this.object, o);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MathException(stack, method + " could not be invoked" + " because of " + e.getMessage());
        }
        stack.push(ans);
    }
}

