/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.BinaryOperator;
import evaluator.FieldAccessOperator;
import evaluator.Function;
import evaluator.MathException;
import evaluator.MethodAccessOperator;
import evaluator.Operator;
import evaluator.ParseException;
import evaluator.Stack;
import evaluator.StackException;
import evaluator.UnaryMinus;
import evaluator.Value;
import evaluator.Variable;

public class Expression {
    private String definition;
    private Operator[] code;
    private Stack stack;
    private int pos = 0;
    private int codeSize = 0;

    public Expression(String definition) throws ParseException {
        try {
            this.parse(definition);
        }
        catch (ParseException e) {
            e.position = this.pos;
            e.parseString = definition;
            throw e;
        }
    }

    public double value() throws StackException, MathException {
        Object o = this.eval();
        if (o instanceof Double) {
            return (Double)o;
        }
        return Double.parseDouble(o.toString());
    }

    public Object evaluate() throws StackException, MathException {
        return this.eval();
    }

    public String getDefinition() {
        return this.definition;
    }

    private Object eval() throws MathException, StackException {
        Object ans = null;
        this.stack.reset();
        int i = 0;
        while (i < this.codeSize) {
            try {
                this.code[i].doStackOp(this.stack);
            }
            catch (MathException e) {
                e.code = this.code;
                e.location = i;
                throw e;
            }
            ++i;
        }
        ans = this.stack.pop();
        return ans;
    }

    private int computeStackUsage() {
        int s = 0;
        int max = 0;
        int i = 0;
        while (i < this.codeSize) {
            if ((s += this.code[i].getStackCount()) > max) {
                max = s;
            }
            ++i;
        }
        return max;
    }

    private void parse(String definition) throws ParseException {
        if (definition == null || definition.trim().equals("")) {
            throw new ParseException("No data provided to Expression constructor");
        }
        this.definition = definition;
        this.code = new Operator[definition.length()];
        this.parseExpression();
        this.skip();
        if (this.next() != '\u0000') {
            throw new ParseException("Extra data found after the end of the expression.");
        }
        int stackSize = this.computeStackUsage();
        this.stack = new Stack();
        Operator[] c = new Operator[this.codeSize];
        System.arraycopy(this.code, 0, c, 0, this.codeSize);
        this.code = c;
    }

    private char next() {
        if (this.pos >= this.definition.length()) {
            return '\u0000';
        }
        return this.definition.charAt(this.pos);
    }

    private void skip() {
        while (Character.isSpaceChar(this.next())) {
            ++this.pos;
        }
    }

    private void parseExpression() throws ParseException {
        boolean neg = false;
        this.skip();
        if (this.next() == '+' || this.next() == '-') {
            neg = this.next() == '-';
            ++this.pos;
            this.skip();
        }
        this.parseTerm();
        if (neg) {
            this.code[this.codeSize++] = new UnaryMinus();
        }
        this.skip();
        while (this.next() == '+' || this.next() == '-') {
            char op = this.next();
            ++this.pos;
            this.parseTerm();
            this.code[this.codeSize++] = op == '+' ? new BinaryOperator(0) : new BinaryOperator(1);
            this.skip();
        }
    }

    private void parseTerm() throws ParseException {
        this.parseFactor();
        this.skip();
        while (this.next() == '*' || this.next() == '/') {
            char op = this.next();
            ++this.pos;
            this.parseFactor();
            this.code[this.codeSize++] = op == '*' ? new BinaryOperator(2) : new BinaryOperator(3);
            this.skip();
        }
    }

    private void parseFactor() throws ParseException {
        this.parsePrimary();
        this.skip();
        while (this.next() == '^') {
            ++this.pos;
            this.parsePrimary();
            this.code[this.codeSize++] = new BinaryOperator(4);
            this.skip();
        }
    }

    private void parsePrimary() throws ParseException {
        this.skip();
        char ch = this.next();
        if (Character.isLetter(ch)) {
            this.parseWord();
        } else if (Character.isDigit(ch)) {
            this.parseNumber();
        } else if (ch == '(') {
            ++this.pos;
            this.parseExpression();
            this.skip();
            if (this.next() != ')') {
                throw new ParseException("Exprected a right parenthesis.");
            }
            ++this.pos;
        } else if (ch == '.') {
            ++this.pos;
            if (Character.isDigit(this.next())) {
                --this.pos;
                this.parseNumber();
            } else {
                this.parseMemberOperator();
            }
        } else if (ch == '\"') {
            String str = "";
            do {
                ++this.pos;
                if (this.next() == '\"') continue;
                str = String.valueOf(str) + this.next();
            } while (this.next() != '\"');
            ++this.pos;
            this.code[this.codeSize++] = new Value(str);
        } else {
            if (ch == ')') {
                throw new ParseException("Unmatched right parenthesis.");
            }
            if (ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '^') {
                throw new ParseException("Operator '" + ch + "' found in an unexpected position.");
            }
            if (ch == '\u0000') {
                throw new ParseException("Unexpected end of data in the middle of an expression.");
            }
            throw new ParseException("Illegal character '" + ch + "' found in data.");
        }
        this.skip();
        if (this.next() == '.') {
            this.parsePrimary();
        }
    }

    private void parseWord() throws ParseException {
        String w = "";
        while (Character.isLetterOrDigit(this.next()) || this.next() == '.') {
            w = String.valueOf(w) + this.next();
            ++this.pos;
        }
        this.skip();
        if (this.next() == '(') {
            int parameters = 0;
            ++this.pos;
            this.skip();
            while (this.next() != ')') {
                this.parseExpression();
                ++parameters;
                this.skip();
                if (this.next() != ',' && this.next() != ')') {
                    throw new ParseException("Missing right parenthesis after parameter " + parameters + " of function '" + w + "'.");
                }
                if (this.next() != ',') continue;
                ++this.pos;
                this.skip();
            }
            ++this.pos;
            this.skip();
            this.code[this.codeSize++] = new Function(w, parameters);
        } else {
            if (w.equals("false")) {
                this.code[this.codeSize++] = new Value(Boolean.FALSE);
                return;
            }
            if (w.equals("true")) {
                this.code[this.codeSize++] = new Value(Boolean.TRUE);
                return;
            }
            this.code[this.codeSize++] = new Variable(w);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseNumber() throws ParseException {
        block9: {
            w = "";
            while (Character.isDigit(this.next())) {
                w = String.valueOf(w) + this.next();
                ++this.pos;
            }
            if (this.next() == '.') {
                w = String.valueOf(w) + this.next();
                ++this.pos;
                while (Character.isDigit(this.next())) {
                    w = String.valueOf(w) + this.next();
                    ++this.pos;
                }
            }
            if (w.equals(".")) {
                throw new ParseException("Illegal number found, consisting of decimal point only.");
            }
            if (this.next() != 'E' && this.next() != 'e') break block9;
            w = String.valueOf(w) + this.next();
            ++this.pos;
            if (this.next() == '+' || this.next() == '-') {
                w = String.valueOf(w) + this.next();
                ++this.pos;
            }
            if (Character.isDigit(this.next())) ** GOTO lbl25
            throw new ParseException("Illegal number found, with no digits in its exponent.");
lbl-1000:
            // 1 sources

            {
                w = String.valueOf(w) + this.next();
                ++this.pos;
lbl25:
                // 2 sources

                ** while (Character.isDigit((char)this.next()))
            }
        }
        d = NaN;
        try {
            d = Double.valueOf(w);
        }
        catch (Exception var4_3) {
            // empty catch block
        }
        if (Double.isNaN(d)) {
            throw new ParseException("Illegal number '" + w + "' found in data.");
        }
        this.code[this.codeSize++] = new Value(new Double(d));
    }

    private void parseMemberOperator() {
        String w = "";
        while (Character.isLetterOrDigit(this.next())) {
            w = String.valueOf(w) + this.next();
            ++this.pos;
        }
        this.skip();
        if (this.next() == '(') {
            ++this.pos;
            this.skip();
            int parameters = 0;
            while (this.next() != ')') {
                this.parseExpression();
                ++parameters;
                this.skip();
                if (this.next() == ',' || this.next() == ')') continue;
                throw new ParseException("Missing right parenthesis after parameter " + parameters + " of function '" + w + "'.");
            }
            ++this.pos;
            this.code[this.codeSize++] = new MethodAccessOperator(w, parameters);
        } else {
            this.code[this.codeSize++] = new FieldAccessOperator(w);
        }
    }
}

