/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.EquationException;
import evaluator.Expression;
import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import evaluator.Variable;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class EvaluatorConsole
extends JTextPane {
    Action evaluateAction = new AbstractAction("Evaluate"){

        public void actionPerformed(ActionEvent e) {
            EvaluatorConsole.this.evaluateLine();
        }
    };
    JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(10, 0), "Evaluate")};
    JTextComponent c = new JTextPane();
    static SimpleAttributeSet aOutput = new SimpleAttributeSet();
    static SimpleAttributeSet aInput = new SimpleAttributeSet();
    static SimpleAttributeSet aError = new SimpleAttributeSet();

    static {
        aOutput.addAttribute(StyleConstants.Foreground, Color.blue);
        aError.addAttribute(StyleConstants.Foreground, Color.red);
        aInput.addAttribute(StyleConstants.Foreground, Color.black);
    }

    public String help(Object object) {
        Class<?> c = object.getClass();
        StringBuffer s = new StringBuffer(c.getName());
        s.append('{');
        Method[] m = c.getMethods();
        int i = 0;
        while (i < m.length) {
            s.append(m[i]);
            if (i < m.length - 1) {
                s.append(',');
            }
            ++i;
        }
        s.append("}\n{");
        Field[] f = c.getFields();
        int i2 = 0;
        while (i2 < f.length) {
            s.append(f[i2]);
            if (i2 < f.length - 1) {
                s.append(',');
            }
            ++i2;
        }
        s.append('}');
        return s.toString();
    }

    public String dir(Object o) {
        return this.help(o);
    }

    public EvaluatorConsole() {
        Keymap k = this.c.getKeymap();
        JTextComponent.loadKeymap(k, this.defaultBindings, new Action[]{this.evaluateAction});
        this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public void evaluateLine() {
        double ans = 0.0;
        String s = "";
        try {
            s = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int p = this.getCaretPosition();
        int a1 = s.lastIndexOf(10, p - 1) + 1;
        int a2 = s.indexOf(10, p);
        if (a1 <= 0) {
            a1 = 0;
        }
        if (a2 < 0) {
            a2 = s.length();
        }
        s = s.substring(a1, a2);
        try {
            s = this.evaluate(s);
            this.insert(String.valueOf('\n') + s + '\n', a2, aOutput);
        }
        catch (ParseException ex) {
            this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
        }
        catch (MathException ex) {
            this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
        }
        catch (StackException ex) {
            this.insert(String.valueOf('\n') + ex.getMessage() + '\n', a2, aError);
        }
        catch (Exception ex) {
            System.out.println("unknown exception");
            ex.printStackTrace();
        }
    }

    String evaluate(String s) throws MathException, ParseException, StackException {
        int eq = s.indexOf(61);
        String left = null;
        if (eq >= 0) {
            String right;
            left = s.substring(0, eq);
            s = right = s.substring(eq + 1);
        }
        Expression expr = new Expression(s);
        Object ans = expr.evaluate();
        if (left != null) {
            this.set(left, ans);
        }
        return this.formatAnswer(ans);
    }

    public void set(String vname, Object value) throws EquationException {
        String n = this.makeword(vname);
        if (n == null) {
            throw new EquationException("Invalid LHS");
        }
        Variable.set(n, value);
    }

    String makeword(String s) {
        if (s.length() == 0) {
            return null;
        }
        String n = new String();
        char c = s.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return null;
        }
        n = String.valueOf(n) + c;
        int i = 1;
        while (i < s.length()) {
            c = s.charAt(i);
            if (!Character.isIdentifierIgnorable(c)) {
                if (Character.isJavaIdentifierPart(c) || c == '.') {
                    n = String.valueOf(n) + c;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return n;
    }

    void insert(String s, int p, AttributeSet a) {
        try {
            this.getDocument().insertString(p, s, a);
            this.setCaretPosition(p + s.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCharacterAttributes(aInput, true);
    }

    public void append(String s) {
        try {
            this.getDocument().insertString(Math.max(0, this.getDocument().getLength() - 1), s, null);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    String formatAnswer(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            StringBuffer s = new StringBuffer(o.toString());
            s.append('{');
            int n = Array.getLength(o);
            int i = 0;
            while (i < n) {
                s.append(Array.get(o, i));
                if (i < n - 1) {
                    s.append(',');
                }
                ++i;
            }
            s.append('}');
            return s.toString();
        }
        if (o instanceof List) {
            StringBuffer s = new StringBuffer(o.toString());
            s.append('{');
            List l = (List)o;
            int i = 0;
            while (i < l.size()) {
                s.append(l.get(i));
                if (i < l.size() - 1) {
                    s.append(',');
                }
                ++i;
            }
            s.append('}');
            return s.toString();
        }
        return String.valueOf(o);
    }
}

