/*
 * Decompiled with CFR 0.152.
 */
package sanjay.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class Oscilloscope
extends JPanel
implements ActionListener {
    public JButton sweep;
    public JButton clear;
    public Timer timer;
    protected int posX;
    protected int[] posY;
    protected int[] baseY;
    protected int nTraces;
    public OScreen graph;
    public int xSpeed = 1;
    private ActionListener listener;
    public Panel buttons;

    public Oscilloscope() {
        this(1, null);
    }

    public Oscilloscope(int n, ActionListener list) {
        this.listener = list;
        this.nTraces = n;
        this.posY = new int[this.nTraces];
        this.baseY = new int[this.nTraces];
        this.setLayout(new BorderLayout());
        this.buttons = new Panel();
        this.buttons.setLayout(new GridLayout());
        this.sweep = new JButton("Sweep");
        this.buttons.add(this.sweep);
        this.sweep.addActionListener(this);
        this.clear = new JButton("Clear");
        this.buttons.add(this.clear);
        this.add((Component)this.buttons, "South");
        this.clear.addActionListener(this);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Oscilloscope.this.tick();
            }
        });
        this.graph = new OScreen();
        this.add((Component)this.graph, "Center");
        Color[] cols = new Color[this.nTraces];
        Color[] seq = new Color[]{Color.green, Color.red, Color.yellow, Color.white};
        int i = 0;
        while (i < this.nTraces) {
            cols[i] = seq[i % seq.length];
            ++i;
        }
        this.graph.init(cols);
        this.graph.repaint();
        this.sweep.doClick();
    }

    public void tick() {
        if ((this.posX += this.xSpeed) > this.graph.getDataWidth()) {
            this.timer.stop();
        } else {
            this.graph.pOld = this.graph.pNew;
            this.graph.pNew = new Point[this.graph.getNTraces()];
            this.setNewPoint();
            this.graph.paintTraces();
        }
    }

    public void drawScreenElements(Graphics g) {
    }

    private void setNewPoint() {
        int i = 0;
        while (i < this.graph.getNTraces()) {
            ((OScreen)this.graph).pNew[i] = new Point(this.posX, this.posY[i]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Sweep") {
            if (this.listener != null) {
                this.listener.actionPerformed(e);
            }
            this.posX = 0;
            this.setNewPoint();
            this.timer.start();
        } else if (e.getActionCommand() == "Clear") {
            this.graph.repaint();
            this.posX = 0;
            this.setNewPoint();
        }
    }

    public void setPosY(int[] ny) {
        this.posY = ny;
    }

    public int[] getPosY() {
        return this.posY;
    }

    public void setPosX(int nx) {
        this.posX = nx;
    }

    public int getPosX() {
        return this.posX;
    }

    public int[] getBaseY() {
        return this.baseY;
    }

    public void setBaseY(int[] nb) {
        this.baseY = nb;
    }

    public void setColors(Color[] c) {
        this.graph.color = c;
    }

    public Color[] getColors() {
        return this.graph.color;
    }

    public int getGutter() {
        return this.graph.gutter;
    }

    public void setGutter(int g) {
        this.graph.gutter = g;
    }

    public void finalize() throws Throwable {
        this.timer.stop();
        super.finalize();
    }

    public class OScreen
    extends Panel {
        private Point[] pOld;
        private Point[] pNew;
        private Color[] color;
        private Border bevel;
        private int gutter = 10;

        public int getNTraces() {
            return this.color.length;
        }

        public void init(Color[] c) {
            this.color = c;
            this.pOld = new Point[this.getNTraces()];
            this.pNew = new Point[this.getNTraces()];
            int i = 0;
            while (i < this.getNTraces()) {
                this.pOld[i] = new Point(0, 0);
                this.pNew[i] = new Point(0, 0);
                ++i;
            }
            this.bevel = BorderFactory.createLoweredBevelBorder();
            Oscilloscope.this.setBorder(this.bevel);
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.black);
            Rectangle rect = new Rectangle(this.gutter, this.gutter, this.getWidth() - 2 * this.gutter, this.getHeight() - 2 * this.gutter);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            Oscilloscope.this.drawScreenElements(g);
        }

        public float calcY(float y, int base) {
            float i = (float)this.gutter + y * (float)(this.getHeight() - 2 * this.gutter) / 1024.0f;
            if ((i += (float)base) < (float)this.gutter) {
                i = this.gutter;
            }
            if (i > (float)(this.getHeight() - this.gutter)) {
                i = this.getHeight() - this.gutter;
            }
            return i;
        }

        public int getDataWidth() {
            return this.getWidth() - 2 * this.gutter;
        }

        private void paintTraces() {
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            int trace = 0;
            while (trace < this.pOld.length) {
                g.setColor(this.color[trace]);
                g.drawLine(this.gutter + this.pOld[trace].x, (int)this.calcY(this.pOld[trace].y, Oscilloscope.this.baseY[trace]), this.gutter + this.pNew[trace].x, (int)this.calcY(this.pNew[trace].y, Oscilloscope.this.baseY[trace]));
                ++trace;
            }
        }

        public void finalize() throws Throwable {
            Oscilloscope.this.timer.stop();
            super.finalize();
        }
    }
}

