/*
 * Decompiled with CFR 0.152.
 */
package sanjay;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ROCApplet
extends Applet
implements AdjustmentListener {
    int x0 = 10;
    int y0 = 10;
    int xtick = 10;
    int ytick = 10;
    int ticklength = 4;
    double prevalance = 0.2;
    int population = 12000;
    int criterion = 70;
    int mu1 = 100;
    int mu2 = 160;
    int sigma1 = 50;
    int sigma2 = 25;
    private Panel panel = new Panel(){

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int base = size.height - ROCApplet.this.y0;
            g.drawLine(0, base, size.width, base);
            g.drawLine(ROCApplet.this.x0, 0, ROCApplet.this.x0, size.height);
            int i = 0;
            while (i < size.width) {
                g.drawLine(i, base, i, base - ROCApplet.this.ticklength);
                i += ROCApplet.this.xtick;
            }
            i = 0;
            while (i < size.height) {
                g.drawLine(ROCApplet.this.x0, i, ROCApplet.this.x0 + ROCApplet.this.ticklength, i);
                i += ROCApplet.this.ytick;
            }
            int oh = 0;
            ROCApplet.this.fn = 0;
            ROCApplet.this.fp = 0;
            ROCApplet.this.tn = 0;
            ROCApplet.this.tp = 0;
            g.setColor(Color.blue);
            double ampl1 = (double)ROCApplet.this.population * (1.0 - ROCApplet.this.prevalance) / (double)ROCApplet.this.sigma1;
            int i2 = 0;
            while (i2 < size.width) {
                int h = (int)(ampl1 * ROCApplet.this.gaussian((double)(i2 - ROCApplet.this.mu1) / (double)ROCApplet.this.sigma1));
                if (i2 < ROCApplet.this.criterion) {
                    ROCApplet.this.tn += h;
                } else {
                    ROCApplet.this.fp += h;
                }
                if (i2 < ROCApplet.this.criterion || i2 % 2 == 0) {
                    g.drawLine(i2 - 1, base - oh, i2, base - h);
                } else {
                    g.drawLine(i2, base, i2, base - h);
                }
                oh = h;
                ++i2;
            }
            g.setColor(Color.red);
            double ampl2 = (double)ROCApplet.this.population * ROCApplet.this.prevalance / (double)ROCApplet.this.sigma2;
            int i3 = 0;
            while (i3 < size.width) {
                int h = (int)(ampl2 * ROCApplet.this.gaussian((double)(i3 - ROCApplet.this.mu2) / (double)ROCApplet.this.sigma2));
                if (i3 < ROCApplet.this.criterion) {
                    ROCApplet.this.fn += h;
                } else {
                    ROCApplet.this.tp += h;
                }
                if (i3 < ROCApplet.this.criterion || i3 % 2 == 1) {
                    g.drawLine(i3 - 1, base - oh, i3, base - h);
                } else {
                    g.drawLine(i3, base, i3, base - h);
                }
                oh = h;
                ++i3;
            }
        }
    };
    int tp;
    int fp;
    int tn;
    int fn;
    private BorderLayout borderLayout1 = new BorderLayout();
    private Panel panel1 = new Panel();
    private Scrollbar critscroll = new Scrollbar();
    private Scrollbar prevscroll = new Scrollbar();
    private GridLayout gridLayout1 = new GridLayout();
    private Scrollbar mu2scroll = new Scrollbar();
    private Label label1 = new Label();
    private Label label2 = new Label();
    private Label label3 = new Label();
    private Scrollbar sigma2scroll = new Scrollbar();
    private Label label4 = new Label();
    private Panel bottompanel = new Panel();
    private Panel panel3 = new Panel();
    private Label label5 = new Label();
    private Button helpbutton = new Button();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Panel panel2 = new Panel();
    private GridLayout gridLayout2 = new GridLayout();
    private Label label6 = new Label();
    private Label tfn = new Label();
    private Label ttn = new Label();
    private Label tfp = new Label();
    private Label ttp = new Label();
    private Label label11 = new Label();
    private Label label12 = new Label();
    private Label label13 = new Label();
    private Panel panel4 = new Panel();
    private GridLayout gridLayout3 = new GridLayout();
    private Label label7 = new Label();
    private Label tnp = new Label();
    private Label tpp = new Label();
    private Label tspec = new Label();
    private Label tsens = new Label();
    private Label label15 = new Label();
    private Label label16 = new Label();
    private Label label17 = new Label();

    final double gaussian(double x) {
        return Math.exp(-x * x);
    }

    public ROCApplet() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.critscroll.addAdjustmentListener(this);
        this.prevscroll.addAdjustmentListener(this);
        this.mu2scroll.addAdjustmentListener(this);
        this.sigma2scroll.addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.panel.setLayout(this.borderLayout1);
        this.panel.setBackground(Color.white);
        this.panel.setSize(new Dimension(300, 300));
        this.critscroll.setMaximum(300);
        this.critscroll.setOrientation(0);
        this.critscroll.setBlockIncrement(25);
        this.critscroll.setUnitIncrement(5);
        this.critscroll.setValue(70);
        this.prevscroll.setOrientation(0);
        this.prevscroll.setValue(20);
        this.panel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(14);
        this.label1.setText("Criterion");
        this.label2.setText("Disease Prevalence");
        this.label3.setText("Disease Mean");
        this.mu2scroll.setMaximum(250);
        this.mu2scroll.setMinimum(50);
        this.mu2scroll.setOrientation(0);
        this.mu2scroll.setValue(160);
        this.sigma2scroll.setMinimum(1);
        this.sigma2scroll.setOrientation(0);
        this.sigma2scroll.setValue(25);
        this.label4.setText("Disease Deviation");
        this.label5.setText("Receiver operating characteristic");
        this.helpbutton.setLabel("Help");
        this.helpbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ROCApplet.this.helpbutton_actionPerformed(e);
            }
        });
        this.bottompanel.setLayout(this.borderLayout2);
        this.panel2.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(4);
        this.gridLayout2.setRows(2);
        this.label6.setBackground(Color.pink);
        this.label6.setForeground(Color.red);
        this.label6.setText("True positives");
        this.tfn.setText("0");
        this.ttn.setText("0");
        this.tfp.setText("0");
        this.ttp.setText("0");
        this.label11.setForeground(Color.red);
        this.label11.setText("False negatives");
        this.label12.setForeground(Color.blue);
        this.label12.setText("True negatives");
        this.label13.setForeground(Color.blue);
        this.label13.setText("False positives");
        this.panel4.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(4);
        this.gridLayout3.setRows(2);
        this.label7.setText("Sensitivity");
        this.tnp.setText("0");
        this.tpp.setText("0");
        this.tspec.setText("0");
        this.tsens.setText("0");
        this.label15.setText("Negative predictive");
        this.label16.setText("Positive Predictive");
        this.label17.setText("Specificity");
        this.add((Component)this.panel1, "East");
        this.panel1.add((Component)this.critscroll, null);
        this.panel1.add((Component)this.label1, null);
        this.panel1.add((Component)this.prevscroll, null);
        this.panel1.add((Component)this.label2, null);
        this.panel1.add((Component)this.mu2scroll, null);
        this.panel1.add((Component)this.label3, null);
        this.panel1.add((Component)this.sigma2scroll, null);
        this.panel1.add((Component)this.label4, null);
        this.critscroll.setSize(100, 20);
        this.add((Component)this.panel, "Center");
        this.add((Component)this.bottompanel, "South");
        this.bottompanel.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.label6, null);
        this.panel2.add((Component)this.label13, null);
        this.panel2.add((Component)this.label12, null);
        this.panel2.add((Component)this.label11, null);
        this.panel2.add((Component)this.ttp, null);
        this.panel2.add((Component)this.tfp, null);
        this.panel2.add((Component)this.ttn, null);
        this.panel2.add((Component)this.tfn, null);
        this.bottompanel.add((Component)this.panel4, "South");
        this.panel4.add((Component)this.label7, null);
        this.panel4.add((Component)this.label17, null);
        this.panel4.add((Component)this.label16, null);
        this.panel4.add((Component)this.label15, null);
        this.panel4.add((Component)this.tsens, null);
        this.panel4.add((Component)this.tspec, null);
        this.panel4.add((Component)this.tpp, null);
        this.panel4.add((Component)this.tnp, null);
        this.add((Component)this.panel3, "North");
        this.panel3.add((Component)this.label5, null);
        this.panel3.add((Component)this.helpbutton, null);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.criterion = this.critscroll.getValue();
        this.prevalance = (double)this.prevscroll.getValue() / 100.0;
        this.mu2 = this.mu2scroll.getValue();
        this.sigma2 = this.sigma2scroll.getValue();
        this.panel.repaint();
        this.calc();
    }

    void helpbutton_actionPerformed(ActionEvent e) {
    }

    void calc() {
        this.ttp.setText(String.valueOf(this.tp));
        this.tfp.setText(String.valueOf(this.fp));
        this.ttn.setText(String.valueOf(this.tn));
        this.tfn.setText(String.valueOf(this.fn));
        this.tsens.setText(this.percent((double)this.tp / (double)(this.tp + this.fn)));
        this.tspec.setText(this.percent((double)this.tn / (double)(this.fp + this.tn)));
        this.tpp.setText(this.percent((double)this.tp / (double)(this.tp + this.fp)));
        this.tnp.setText(this.percent((double)this.tn / (double)(this.fn + this.tn)));
    }

    String percent(double v) {
        return String.valueOf((double)((int)(v * 1000.0)) / 10.0);
    }
}

