/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import neurology.CNSData;
import neurology.FaceExaminationWithTools;
import neurology.NeurologyMainPanel;
import neurology.SliceView;

public class VisualFields
extends JPanel {
    public static final String[] quadrants = new String[]{"v1-left-left-inferior", "v1-right-left-inferior", "v1-right-left-superior", "v1-left-left-superior", "v1-left-right-inferior", "v1-right-right-inferior", "v1-right-right-superior", "v1-left-right-superior"};
    public static int ICONSIZE = 32;
    JPanel controls = new JPanel();
    JPanel controlspanel = new JPanel();
    JToggleButton snellenBtn = new JToggleButton();
    JToggleButton whitepinBtn = new JToggleButton();
    JToggleButton redpinBtn = new JToggleButton();
    JToggleButton revealBtn = new JToggleButton();
    ButtonGroup bg = new ButtonGroup();
    JPanel fieldsview = new JPanel();
    CardLayout fieldslayout = new CardLayout();
    double[] quadrantActivity = new double[quadrants.length];
    FieldView fieldimage;
    ClickImage clickimage = new ClickImage();
    SnellenImage snellenimage = new SnellenImage();
    CNSData data;
    FaceExaminationWithTools face;
    static final int SNELLEN = 0;
    static final int WHITEPIN = 1;
    static final int REDPIN = 2;
    static final int REVEAL = 3;
    public int mode = 1;
    Action snellenAction = new AbstractAction("Snellen", new ImageIcon(NeurologyMainPanel.getImage("snellen-icon.gif").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            VisualFields.this.mode = 0;
            VisualFields.this.fieldslayout.show(VisualFields.this.fieldsview, "SNELLEN");
            VisualFields.this.update();
        }
    };
    Action whitepinAction = new AbstractAction("WhitePin", new ImageIcon(NeurologyMainPanel.getImage("white-hatpin.jpg").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            VisualFields.this.mode = 1;
            VisualFields.this.fieldslayout.show(VisualFields.this.fieldsview, "HATPIN");
            VisualFields.this.clickimage.clear();
            VisualFields.this.update();
        }
    };
    Action redpinAction = new AbstractAction("RedPin", new ImageIcon(NeurologyMainPanel.getImage("red-hatpin.jpg").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            VisualFields.this.mode = 2;
            VisualFields.this.fieldslayout.show(VisualFields.this.fieldsview, "HATPIN");
            VisualFields.this.clickimage.clear();
            VisualFields.this.update();
        }
    };
    Action revealAction = new AbstractAction("Reveal", new ImageIcon(NeurologyMainPanel.getImage("reveal-icon.gif").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            VisualFields.this.mode = 3;
            VisualFields.this.fieldslayout.show(VisualFields.this.fieldsview, "REVEAL");
            VisualFields.this.update();
        }
    };

    public VisualFields() {
        this.snellenAction.putValue("ShortDescription", "<HTML><B>Snellen chart</B> for measuring visual acuity</HTML>");
        this.whitepinAction.putValue("ShortDescription", "<HTML><B>White hatpin</B> for testing visual fields<BR>Click in visual field to test.</HTML>");
        this.redpinAction.putValue("ShortDescription", "<HTML><B>Red hatpin</B> for testing colour vision<BR>Click in visual field to test.</HTML>");
        this.revealAction.putValue("ShortDescription", "<HTML><B>Reveal</B> shows visual field defects in green.</HTML>");
        this.setLayout(new BorderLayout());
        this.add((Component)this.controlspanel, "East");
        this.controlspanel.setLayout(new BorderLayout());
        this.controlspanel.add((Component)this.controls, "North");
        this.controls.setLayout(new BoxLayout(this.controls, 1));
        this.snellenBtn.setAction(this.snellenAction);
        this.whitepinBtn.setAction(this.whitepinAction);
        this.redpinBtn.setAction(this.redpinAction);
        this.revealBtn.setAction(this.revealAction);
        this.snellenBtn.setText("");
        this.whitepinBtn.setText("");
        this.redpinBtn.setText("");
        this.revealBtn.setText("");
        this.controls.add(this.snellenBtn);
        this.controls.add(this.whitepinBtn);
        this.controls.add(this.redpinBtn);
        this.controls.add(this.revealBtn);
        this.bg.add(this.snellenBtn);
        this.bg.add(this.whitepinBtn);
        this.bg.add(this.redpinBtn);
        this.bg.add(this.revealBtn);
        this.snellenBtn.setMargin(new Insets(2, 2, 2, 2));
        this.whitepinBtn.setMargin(new Insets(2, 2, 2, 2));
        this.redpinBtn.setMargin(new Insets(2, 2, 2, 2));
        this.revealBtn.setMargin(new Insets(2, 2, 2, 2));
        this.whitepinBtn.setSelected(true);
        this.add(this.fieldsview);
        this.fieldsview.setLayout(this.fieldslayout);
        this.fieldsview.add((Component)this.clickimage, "HATPIN");
        this.fieldsview.add((Component)this.snellenimage, "SNELLEN");
    }

    public void update() {
        if (this.fieldimage != null) {
            this.fieldimage.update();
        }
    }

    public void setFace(FaceExaminationWithTools f) {
        this.face = f;
    }

    public void setData(CNSData d) {
        this.data = d;
        if (this.fieldimage == null) {
            this.fieldimage = new FieldView();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualFields.this.fieldsview.add((Component)VisualFields.this.fieldimage, "REVEAL");
                }
            });
        }
        this.fieldimage.setData(d);
    }

    class ClickImage
    extends JPanel {
        Image im = NeurologyMainPanel.getImage("fields-with-crosshair.gif");
        int sz = 2;
        Color[] colors = new Color[]{Color.lightGray, Color.black, Color.red};
        final int INVISIBLE = 0;
        final int VISIBLE = 1;
        final int COLOUR = 2;
        Vector clicklist = new Vector();
        Vector clickoutcome = new Vector();
        MouseAdapter m = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                this.click(e.getPoint());
            }

            void click(Point e) {
                double z;
                CNSData.Region click;
                if (((ClickImage)ClickImage.this).VisualFields.this.fieldimage != null && (click = ((ClickImage)ClickImage.this).VisualFields.this.fieldimage.getRegionAt((int)((double)e.x * (z = ((ClickImage)ClickImage.this).VisualFields.this.fieldimage.zoom)), (int)((double)e.y * z))) != null) {
                    double active = ((ClickImage)ClickImage.this).VisualFields.this.fieldimage.brainR.getActivityFrom(click) + ((ClickImage)ClickImage.this).VisualFields.this.fieldimage.brainL.getActivityFrom(click);
                    int o = active > Math.random() ? (((ClickImage)ClickImage.this).VisualFields.this.mode == 2 ? 2 : 1) : 0;
                    ClickImage.this.clicklist.add(e);
                    ClickImage.this.clickoutcome.add(new Integer(o));
                    ClickImage.this.repaint();
                }
            }
        };

        public void paint(Graphics g) {
            super.paint(g);
            if (VisualFields.this.fieldimage != null) {
                double z = VisualFields.this.fieldimage.zoom;
                g.drawImage(this.im, 0, 0, (int)((double)this.im.getWidth(this) / z), (int)((double)this.im.getHeight(this) / z), this);
                int i = 0;
                while (i < this.clicklist.size()) {
                    Point p = (Point)this.clicklist.get(i);
                    int o = (Integer)this.clickoutcome.get(i);
                    g.setColor(this.colors[o]);
                    g.fillOval(p.x - this.sz, p.y - this.sz, this.sz * 2, this.sz * 2);
                    ++i;
                }
            }
        }

        public void clear() {
            this.clicklist.removeAllElements();
            this.clickoutcome.removeAllElements();
            this.repaint();
        }

        ClickImage() {
            this.addMouseListener(this.m);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    class FieldView
    extends SliceView {
        String[] sides;
        String brain;
        CNSData.Region brainR;
        CNSData.Region brainL;

        FieldView() {
            super(NeurologyMainPanel.mainpanel, NeurologyMainPanel.getResource("fields.txt"), null);
            this.sides = new String[]{"right", "left"};
            this.brain = "V1";
            this.setItem("fields");
            this.leftlabel.setText("Fields");
            this.paintArray = true;
            this.paintHover = false;
            this.zoom = 2.0;
            this.repaint();
        }

        public void addNotify() {
            super.addNotify();
            this.main = NeurologyMainPanel.mainpanel;
        }

        public void setData(CNSData d) {
            super.setData(d);
            this.update();
        }

        public void update() {
            if (this.data == null) {
                return;
            }
            if (this.brainR == null) {
                this.brainR = this.data.findRegion(String.valueOf(this.brain) + "-" + this.sides[0]);
                this.brainL = this.data.findRegion(String.valueOf(this.brain) + "-" + this.sides[1]);
            }
            int N = 0;
            if (this.mapRegions != null) {
                N = this.mapRegions.size();
            }
            if (this.paintArray && this.reg != null) {
                if (this.arrayItems == null || this.arrayItems.length != this.reg.length) {
                    this.arrayItems = new double[this.reg.length];
                }
                int i = 0;
                while (i < N - 1) {
                    SliceView.MapRegion r = (SliceView.MapRegion)this.mapRegions.get(i);
                    double a = this.brainL.getActivityFrom(r.region) + this.brainR.getActivityFrom(r.region);
                    System.out.println("FROM " + r.region + " TO " + this.brainL + " = " + this.brainL.getActivityFrom(r.region));
                    System.out.println("FROM " + r.region + " TO " + this.brainR + " = " + this.brainR.getActivityFrom(r.region));
                    this.arrayItems[i + 1] = a;
                    ++i;
                }
            }
            this.repaint();
        }
    }

    class SnellenImage
    extends JPanel {
        Image im = NeurologyMainPanel.getImage("snellen.gif");
        int sz = 2;
        String[] eyes = new String[]{"left", "right"};
        int eyeIndex = 0;
        CNSData.Region[] retina = new CNSData.Region[2];
        double oldacuity = 1.0;
        BufferedImage originalimage = null;
        BufferedImage filteredimage = null;
        BufferedImage drawim = null;
        ConvolveOp convolve;
        MouseAdapter m = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int y = e.getPoint().y;
                SnellenImage.this.repaint();
            }
        };

        double getAcuity() {
            if (this.retina[this.eyeIndex] == null) {
                this.retina[this.eyeIndex] = VisualFields.this.data.findRegion("retina-" + this.eyes[this.eyeIndex] + "-fovea");
            }
            return (VisualFields.this.fieldimage.brainR.getActivityFrom(this.retina[this.eyeIndex]) + VisualFields.this.fieldimage.brainL.getActivityFrom(this.retina[this.eyeIndex])) / 2.0;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.im.getWidth(this) < 1 || this.im.getHeight(this) < 1) {
                return;
            }
            double ac = this.getAcuity();
            if (ac != this.oldacuity || this.drawim == null) {
                if (this.originalimage == null) {
                    this.originalimage = new BufferedImage(this.im.getWidth(this), this.im.getHeight(this), 1);
                    this.originalimage.getGraphics().drawImage(this.im, 0, 0, null);
                }
                if (ac < 1.0) {
                    Kernel k = this.createBlurKernel(Math.min(1.0, (1.0 - ac) * 2.0));
                    if (k == null) {
                        this.drawim = this.originalimage;
                    } else {
                        this.convolve = new ConvolveOp(k, 0, null);
                        if (this.filteredimage == null) {
                            this.filteredimage = this.convolve.createCompatibleDestImage(this.originalimage, this.originalimage.getColorModel());
                            this.filteredimage.getGraphics().drawImage(this.originalimage, 0, 0, null);
                        }
                        this.drawim = this.convolve.filter(this.originalimage, this.filteredimage);
                    }
                } else {
                    this.drawim = this.originalimage;
                }
            }
            g.drawImage(this.drawim, 0, 0, this.getWidth(), this.getHeight(), this);
            this.oldacuity = ac;
        }

        Kernel createBlurKernel(double s) {
            int j;
            int KMAX = 40;
            int w = 1 + 2 * (int)Math.max(0.0, Math.min((double)KMAX, Math.floor(s * (double)KMAX)));
            if (w < 3) {
                return null;
            }
            float[] k = new float[w * w];
            float total = 0.0f;
            int i = 0;
            while (i < w) {
                j = 0;
                while (j < w) {
                    float x;
                    float dsq = (i - w / 2) * (i - w / 2) + (j - w / 2) * (j - w / 2);
                    float sigmasq = w * w / 4;
                    k[i + j * w] = x = (float)Math.exp(-dsq / sigmasq);
                    total += x;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < w) {
                j = 0;
                while (j < w) {
                    int n = i + j * w;
                    k[n] = k[n] / total;
                    ++j;
                }
                ++i;
            }
            return new Kernel(w, w, k);
        }

        SnellenImage() {
            this.addMouseListener(this.m);
        }
    }
}

