/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import neurology.CNSData;
import neurology.NeurologyMainPanel;
import neurology.Selection;

public class Tester
implements Runnable {
    Thread thread = new Thread((Runnable)this, "NeurologyTester");
    NeurologyMainPanel panel;
    static Tester currentTest;
    boolean stopping = false;
    CNSData.Region answer = null;
    static int serial;
    int npatients;
    int gaveup;
    int ncorrect;
    static Selection selection;
    boolean giveup;
    int attempts;
    int totalscore;
    boolean correct;
    CNSData.Region lastResponse;
    JPanel testpane = new JPanel();
    JButton giveupButton = new JButton();
    JLabel messagelabel = new JLabel();

    static {
        serial = 0;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void stop() {
        this.stopping = true;
        this.notifyAll();
        String comment = "";
        if (this.npatients > 1 && this.totalscore / (this.npatients - 1) > 2) {
            comment = "Very good!";
        }
        if (this.npatients > 1 && this.totalscore / (this.npatients - 1) > 5) {
            comment = "Excellent!";
        }
        JOptionPane.showMessageDialog(null, "<HTML><H2>Test ended</H2>You saw " + this.npatients + " patients.<BR>" + "You gave up on " + this.gaveup + ".<BR>" + "You got " + this.ncorrect + " right.<BR>" + "Your score was " + this.totalscore + ". " + comment + "</HTML>");
    }

    Tester(NeurologyMainPanel p) {
        currentTest = this;
        this.panel = p;
        this.initGUI();
        this.initTest();
    }

    private void initTest() {
        this.panel.masterImage1.setVisible(false);
        this.panel.sliceView1.setVisible(false);
        this.panel.regionProperties1.setVisible(false);
        this.panel.regionList.lesiononlycheck.setSelected(false);
        this.panel.regionList.lesiononlycheck.setEnabled(false);
        this.panel.regionList.hiddencheck.setSelected(false);
        this.panel.regionList.sliceOnlyCheck.setSelected(false);
        this.panel.regionList.updateList();
        this.panel.lowerPane.add((Component)this.testpane, "South");
        if (selection == null) {
            selection = new Selection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setSelectedRegion(CNSData.Region r) {
                    super.setSelectedRegion(r);
                    Tester tester = currentTest;
                    synchronized (tester) {
                        currentTest.notifyAll();
                    }
                }
            };
        }
        this.panel.jTabbedPane1.setSelectedIndex(1);
    }

    private void cleanup() {
        this.panel.masterImage1.setVisible(true);
        this.panel.sliceView1.setVisible(true);
        this.panel.regionProperties1.setVisible(true);
        this.panel.regionList.lesiononlycheck.setEnabled(true);
        this.panel.lowerPane.remove(this.testpane);
    }

    public void run() {
        try {
            try {
                this.totalscore = 0;
                this.npatients = 0;
                this.gaveup = 0;
                this.ncorrect = 0;
                Vector regions = this.panel.data.regions;
                while (!this.stopping) {
                    JOptionPane.showMessageDialog(null, "<HTML><H2>Examine this patient</H2>There is no history.<BR> When you know the location of the lesion, enter it in the box on the left.</HTML>");
                    this.messagelabel.setText("Patient " + ++serial);
                    CNSData.Region r = null;
                    while (r == null || r.hidden || this.exclude(r)) {
                        r = (CNSData.Region)regions.get((int)(Math.random() * (double)regions.size()));
                    }
                    this.panel.data.clearAllLesionsAction.actionPerformed(new ActionEvent(this, 0, "Clear lesions"));
                    r.setLesion(1.0);
                    this.answer = r;
                    try {
                        this.awaitResponse();
                    }
                    catch (InterruptedException e) {
                        this.stopping = true;
                    }
                    if (!this.correct) continue;
                    this.totalscore += Math.max(0, 20 - this.attempts);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred in the test: " + e + ". The answer was " + this.answer + ".");
                this.cleanup();
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitResponse() throws InterruptedException {
        this.giveup = false;
        this.correct = false;
        this.attempts = 0;
        while (!this.correct & !this.giveup) {
            CNSData.Region r;
            Tester tester = this;
            synchronized (tester) {
                this.wait();
            }
            if (this.stopping) {
                this.giveup = true;
            }
            if ((r = this.panel.selection.getSelectedRegion()) == null) continue;
            if (r == this.answer || r.contains(this.answer)) {
                JOptionPane.showMessageDialog(this.panel, "Correct! The " + this.answer + " was lesioned.");
                this.correct = true;
                continue;
            }
            if (this.lastResponse == r) continue;
            this.messagelabel.setText("Patient " + serial + ", Attempt " + ++this.attempts + ": There is no lesion in the " + r + ".");
            this.lastResponse = r;
        }
        if (this.giveup) {
            ++this.gaveup;
            JOptionPane.showMessageDialog(this.panel, "The lesion was in the " + this.answer + ". Try another problem.");
        }
    }

    void initGUI() {
        this.testpane.add(this.messagelabel);
        this.testpane.add(this.giveupButton);
        this.giveupButton.setText("Give up");
        this.giveupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tester.this.giveUp();
            }
        });
    }

    synchronized void giveUp() {
        this.giveup = true;
        this.notify();
    }

    boolean exclude(CNSData.Region r) {
        if (r.name.contains("touch-receptor")) {
            return true;
        }
        return r.name.contains("pain-receptor");
    }
}

