/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import neurology.CNSData;
import neurology.MasterImage;
import neurology.NeurologyMainPanel;
import neurology.Selection;

public class SliceView
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener,
ImageObserver,
MouseWheelListener {
    NeurologyMainPanel main;
    Properties props = new Properties();
    MasterImage master;
    String tooltipText = "<HTML><B>Left mouse button</B> = click to select, drag to move or draw. <BR><B>Middle/right button</B> = drag to zoom up/down, <BR><B>Wheel</B> to select slice<BR><B>Right button</B> = menu</HTML>";
    Image image;
    Image mapimage;
    Raster map;
    String name;
    String[] reg;
    double xp = 0.0;
    double yp = 0.0;
    double zoom = 1.0;
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel leftlabel = new JLabel();
    JLabel rightlabel = new JLabel();
    JPanel mainpanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            if (SliceView.this.image != null) {
                g.drawImage(SliceView.this.image, 0, 0, this.getWidth(), this.getHeight(), (int)SliceView.this.xp, (int)SliceView.this.yp, (int)(SliceView.this.xp + (double)this.getWidth() * SliceView.this.zoom), (int)(SliceView.this.yp + (double)this.getHeight() * SliceView.this.zoom), this);
            }
            SliceView.this.paintHighlights(g);
        }
    };
    boolean paintAllRegions = false;
    boolean paintHover = true;
    boolean paintArray = true;
    double[] arrayItems;
    String[] im;
    String sliceItemName;
    Selection selection = new Selection(){

        public void setSelectedRegion(CNSData.Region r) {
            super.setSelectedRegion(r);
            SliceView.this.repaint();
        }
    };
    int hover = -1;
    int[] pix = new int[1];
    ActionListener sl;
    boolean initialiseZoom = true;
    Thread mapTracerThread;
    boolean interruptTracing = false;
    ColorModel mapColorModel;
    boolean[][] visited;
    MediaTracker mt = new MediaTracker(this);
    Vector mapRegions;
    boolean tracingComplete = false;
    boolean readingDataInProgress = false;
    Thread readerThread = null;
    int[] tmp = new int[1];
    int LR = 0;
    int UD = 1;
    int RL = 2;
    int DU = 3;
    int MOVE = 0;
    int LESION = 1;
    int UNLESION = 2;
    int mode = this.MOVE;
    String sMOVE = "Move/select";
    String sLESION = "Create lesion";
    String sUNLESION = "Remove lesion";
    boolean canSelect = true;
    Point om;
    Point md;
    ButtonGroup bg = new ButtonGroup();
    JPopupMenu popup = new JPopupMenu();
    JCheckBoxMenuItem showregionsCheckbox = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showlesionsCheckbox = new JCheckBoxMenuItem();
    JRadioButtonMenuItem lesionModeMenuItem1 = new JRadioButtonMenuItem();
    JRadioButtonMenuItem lesionModeMenuItem2 = new JRadioButtonMenuItem();
    JRadioButtonMenuItem lesionModeMenuItem3 = new JRadioButtonMenuItem();
    public Action lesionMode = new AbstractAction(this.sLESION){

        public void actionPerformed(ActionEvent e) {
            SliceView.this.mode = SliceView.this.lesionModeMenuItem1.isSelected() ? SliceView.this.MOVE : (SliceView.this.lesionModeMenuItem2.isSelected() ? SliceView.this.LESION : SliceView.this.UNLESION);
            if (SliceView.this.mode == SliceView.this.MOVE) {
                SliceView.this.mainpanel.setCursor(Cursor.getPredefinedCursor(12));
                SliceView.this.paintHover = true;
            } else if (SliceView.this.mode == SliceView.this.LESION) {
                SliceView.this.mainpanel.setCursor(Cursor.getPredefinedCursor(1));
                SliceView.this.paintHover = false;
            } else if (SliceView.this.mode == SliceView.this.UNLESION) {
                SliceView.this.mainpanel.setCursor(Cursor.getPredefinedCursor(1));
                SliceView.this.paintHover = false;
            }
        }
    };
    public Action showLesions = new AbstractAction("Show lesions"){

        public void actionPerformed(ActionEvent e) {
            SliceView.this.paintArray = !SliceView.this.paintArray;
            SliceView.this.update();
        }
    };
    public Action showRegions = new AbstractAction("Show all regions"){

        public void actionPerformed(ActionEvent e) {
            SliceView.this.paintAllRegions = !SliceView.this.paintAllRegions;
            SliceView.this.repaint();
        }
    };
    CNSData data;
    JMenuItem clearAllLesionsMenuItem = new JMenuItem();

    public SliceView(NeurologyMainPanel p, URL imageResourceFile, MasterImage master) {
        this();
        this.main = p;
        this.master = master;
        try {
            this.props.load(imageResourceFile.openStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.mainpanel.addMouseListener(this);
        this.mainpanel.addMouseMotionListener(this);
        this.mainpanel.addMouseWheelListener(this);
        this.mainpanel.setCursor(Cursor.getPredefinedCursor(12));
        this.leftlabel.setToolTipText(this.tooltipText);
        this.rightlabel.setToolTipText(this.tooltipText);
    }

    private SliceView() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String c = e.getActionCommand();
        if (c != null && c.length() > 0) {
            this.setItem(c);
        } else {
            this.setItem(null);
        }
    }

    int xi2s(int x) {
        return (int)(((double)x - this.xp) / this.zoom);
    }

    int yi2s(int y) {
        return (int)(((double)y - this.yp) / this.zoom);
    }

    int xs2i(int x) {
        return (int)(this.xp + (double)x * this.zoom);
    }

    int ys2i(int y) {
        return (int)(this.yp + (double)y * this.zoom);
    }

    public void setItem(String s) {
        this.sliceItemName = s;
        this.name = NeurologyMainPanel.friendlyName(s);
        try {
            this.im = this.props.getProperty(String.valueOf(s) + "-images").split("\\s*,\\s*");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.error("Can't find item " + s + "-images in Images.txt");
        }
        this.image = NeurologyMainPanel.getImage(this.im[0]);
        try {
            Method m = Class.forName("javax.imageio.ImageIO").getMethod("read", InputStream.class);
            this.mapimage = (BufferedImage)m.invoke(null, NeurologyMainPanel.getResource(this.im[1]).openConnection().getInputStream());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.mapimage == null) {
            this.mapimage = NeurologyMainPanel.getImage(this.im[1]);
        }
        if (this.mapimage != null) {
            this.createMapImageDelayed();
            this.readDataAsync();
        } else {
            System.out.println("No map for " + this.im[1]);
        }
        this.reg = this.props.getProperty(String.valueOf(s) + "-regions").split("\\s*,\\s*");
        int i = 0;
        while (i < this.reg.length) {
            if (this.reg[i].startsWith("#")) {
                ArrayList<String> l = new ArrayList<String>();
                l.addAll(Arrays.asList(this.reg));
                l.remove(i);
                this.reg = l.toArray(new String[this.reg.length - 1]);
                --i;
            }
            ++i;
        }
        if (this.reg.length == 1 && this.reg[0].length() == 0) {
            this.reg = new String[0];
        }
        this.leftlabel.setText(this.name);
        this.update();
        this.repaint();
    }

    public void error(String s) {
        JOptionPane.showMessageDialog(this, s, "Error loading images", 0);
    }

    public void setSelection(int idx) {
        if (idx < 1) {
            this.selection.clearSelection();
            return;
        }
        CNSData.Region r = this.selection.getSelectedRegion();
        if (r != null && r.name.equals(this.reg[idx])) {
            return;
        }
        this.selection.setSelectedRegion(this.reg[idx]);
    }

    int findRegion(String s) {
        if (this.reg == null) {
            return -1;
        }
        int i = 0;
        while (i < this.reg.length) {
            if (this.reg[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getRegionIdxAt(int x, int y) {
        if (this.map == null) {
            return -1;
        }
        if (x < 0 || y < 0 || x >= this.map.getWidth() || y >= this.map.getHeight()) {
            return 0;
        }
        int[] nArray = new int[25];
        nArray[1] = -1;
        nArray[3] = 1;
        nArray[4] = -1;
        nArray[5] = 1;
        nArray[6] = -1;
        nArray[8] = 1;
        nArray[9] = -2;
        nArray[10] = -1;
        nArray[12] = 1;
        nArray[13] = 2;
        nArray[14] = -2;
        nArray[15] = 2;
        nArray[16] = -2;
        nArray[17] = 2;
        nArray[18] = -2;
        nArray[19] = 2;
        nArray[20] = -2;
        nArray[21] = -1;
        nArray[23] = 1;
        nArray[24] = 2;
        int[] huntX = nArray;
        int[] nArray2 = new int[25];
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[3] = -1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = -2;
        nArray2[10] = -2;
        nArray2[11] = -2;
        nArray2[12] = -2;
        nArray2[13] = -2;
        nArray2[14] = -1;
        nArray2[15] = -1;
        nArray2[18] = 1;
        nArray2[19] = 1;
        nArray2[20] = 2;
        nArray2[21] = 2;
        nArray2[22] = 2;
        nArray2[23] = 2;
        nArray2[24] = 2;
        int[] huntY = nArray2;
        int h = 0;
        while (h < huntX.length) {
            int p = this.pixel(x + huntX[h], y + huntY[h]);
            if (p >= 0 && p < this.reg.length) {
                return p;
            }
            ++h;
        }
        return -1;
    }

    public CNSData.Region getRegionAt(int x, int y) {
        int r = this.getRegionIdxAt(x, y);
        if (r >= 0 && r < this.reg.length && this.reg != null) {
            return this.main.data.findRegion(this.reg[r]);
        }
        return null;
    }

    public void addActionListener(ActionListener al) {
        this.sl = AWTEventMulticaster.add(al, this.sl);
    }

    public void removeActionListener(ActionListener al) {
        this.sl = AWTEventMulticaster.remove(al, this.sl);
    }

    void createMapImageDelayed() {
        if (this.mapRegions != null) {
            this.mapRegions.removeAllElements();
        }
        if (this.mapTracerThread != null && this.mapTracerThread.isAlive()) {
            try {
                this.interruptTracing = true;
                if (this.mapTracerThread != null) {
                    this.mapTracerThread.interrupt();
                }
                if (this.mapTracerThread != null) {
                    this.mapTracerThread.join();
                }
                this.interruptTracing = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.readerThread != null && this.readerThread.isAlive()) {
            this.readerThread.interrupt();
            try {
                this.readerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mapTracerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SliceView sliceView = SliceView.this;
                synchronized (sliceView) {
                    Cursor oldCursor = SliceView.this.getCursor();
                    SliceView.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        while ((SliceView.this.image.getWidth(SliceView.this) <= 0 || SliceView.this.image.getHeight(SliceView.this) <= 0 || !(SliceView.this.getWidth() > 0 & SliceView.this.getHeight() > 0)) & !SliceView.this.interruptTracing) {
                            Thread.sleep(250L);
                        }
                        SliceView.this.createMapImage();
                        if (SliceView.this.initialiseZoom) {
                            SliceView.this.zoom = Math.min((double)SliceView.this.image.getWidth(SliceView.this) / (double)SliceView.this.getWidth(), (double)SliceView.this.image.getHeight(SliceView.this) / (double)SliceView.this.getHeight());
                            SliceView.this.initialiseZoom = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    SliceView.this.setCursor(oldCursor);
                }
                SliceView.this.repaint();
                SliceView.this.mapTracerThread = null;
            }
        }, "Image tracer");
        this.mapTracerThread.start();
    }

    synchronized void createMapImage() throws InterruptedException {
        ColorModel cm;
        this.waitFor(this.mapimage);
        ColourModelListener cml = new ColourModelListener();
        this.mapimage.getSource().startProduction(cml);
        this.mapColorModel = cm = cml.getColourModel();
        if (this.interruptTracing) {
            return;
        }
        int x = this.mapimage.getWidth(this);
        int y = this.mapimage.getHeight(this);
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalStateException("Map image " + this.im[1] + " needs to be a paletted gif");
        }
        if (this.mapimage instanceof RenderedImage) {
            this.map = ((RenderedImage)((Object)this.mapimage)).getData();
        } else if (x > 0 && y > 0) {
            BufferedImage mapbuff = new BufferedImage(this.mapimage.getWidth(this), this.mapimage.getHeight(this), 13, (IndexColorModel)cm);
            mapbuff.getGraphics().drawImage(this.mapimage, 0, 0, this);
            this.map = mapbuff.getRaster();
        } else {
            throw new IllegalStateException("Image " + this.im[1] + " is empty");
        }
        if (this.interruptTracing) {
            return;
        }
        this.createTraces();
        if (!this.interruptTracing) {
            this.calculatePositions();
        }
    }

    void waitFor(Image i) throws InterruptedException {
        this.mt.addImage(i, 0);
        this.mt.waitForAll();
    }

    MapRegion getRegion(int index) {
        if (index < 1 || index >= this.mapRegions.size()) {
            return null;
        }
        return (MapRegion)this.mapRegions.get(index - 1);
    }

    MapRegion getRegion(CNSData.Region r) {
        if (r == null || this.reg == null || this.mapRegions == null) {
            return null;
        }
        int i = 1;
        while (i < this.reg.length) {
            if (this.reg[i] != null && this.reg[i].equals(r.name)) {
                if (this.mapRegions.size() < i) {
                    return null;
                }
                return (MapRegion)this.mapRegions.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    public void createTraces() throws InterruptedException {
        this.tracingComplete = false;
        if (this.map == null) {
            throw new IllegalStateException("No map object");
        }
        if (this.interruptTracing) {
            return;
        }
        this.mapRegions = new Vector();
        int traceColour = 1;
        while (traceColour < this.reg.length + 1) {
            this.visited = new boolean[this.map.getWidth()][this.map.getHeight()];
            GeneralPath currShape = new GeneralPath();
            currShape.setWindingRule(0);
            int lastpix = 0;
            int i = 1;
            while (i < this.map.getWidth()) {
                lastpix = this.pixel(i, 0);
                int j = 1;
                while (j < this.map.getHeight()) {
                    int currpix = this.pixel(i, j);
                    if (this.visited[i][j]) {
                        lastpix = currpix;
                    } else {
                        if (currpix == traceColour && lastpix != traceColour) {
                            currShape.moveTo(i, j);
                            this.huntNextPixel(i, j, this.LR, traceColour, currShape);
                        } else if (currpix != traceColour && lastpix == traceColour) {
                            currShape.moveTo(i, j);
                            this.huntNextPixel(i - 1, j, this.RL, traceColour, currShape);
                        }
                        lastpix = currpix;
                        if (this.interruptTracing) break;
                    }
                    ++j;
                }
                if (this.interruptTracing) break;
                ++i;
            }
            MapRegion mr = new MapRegion(currShape, traceColour);
            this.mapRegions.add(mr);
            if (this.interruptTracing) break;
            ++traceColour;
        }
        this.tracingComplete = true;
    }

    void readDataAsync() {
        if (this.readingDataInProgress && this.readerThread != null) {
            this.readerThread.interrupt();
            try {
                this.readerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.readingDataInProgress = false;
        }
        this.readerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        while (SliceView.this.data == null || SliceView.this.mapRegions == null || !SliceView.this.tracingComplete || SliceView.this.mapTracerThread != null && SliceView.this.mapTracerThread.isAlive()) {
                            Thread.sleep(200L);
                        }
                        int i = 0;
                        while (i < SliceView.this.mapRegions.size()) {
                            if (i + 1 < SliceView.this.reg.length && SliceView.this.reg[i + 1] != null && SliceView.this.reg[i + 1].trim().length() > 0) {
                                ((MapRegion)SliceView.this.mapRegions.get((int)i)).region = SliceView.this.data.findRegion(SliceView.this.reg[i + 1]);
                            }
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        SliceView.this.readingDataInProgress = false;
                    }
                }
                finally {
                    SliceView.this.readingDataInProgress = false;
                }
            }
        });
        this.readingDataInProgress = true;
        this.readerThread.start();
    }

    int pixel(int x, int y) {
        try {
            return this.map.getPixel(x, y, this.tmp)[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    int movex(int x, int dir) {
        return x + (dir == this.LR ? 1 : (dir == this.RL ? -1 : 0));
    }

    int movey(int y, int dir) {
        return y + (dir == this.UD ? 1 : (dir == this.DU ? -1 : 0));
    }

    int perp(int dir) {
        return (dir + 1) % 4;
    }

    int inv(int dir) {
        return (dir + 2) % 4;
    }

    void huntNextPixel(int x, int y, int dir, int traceColour, GeneralPath p) {
        int lx = x;
        int ly = y;
        int stuck = 0;
        while (stuck < 4) {
            int tx = lx - x;
            int ty = ly - y;
            if (tx * tx + ty * ty < 25 && stuck == 0 && this.visited[lx][ly]) break;
            this.visited[lx][ly] = true;
            int cx = this.movex(lx, this.perp(dir));
            int cy = this.movey(ly, this.perp(dir));
            int cp = this.pixel(cx, cy);
            int c1x = this.movex(cx, this.inv(dir));
            int c1y = this.movey(cy, this.inv(dir));
            int c1p = this.pixel(c1x, c1y);
            if (cp == traceColour && c1p != traceColour) {
                p.lineTo(cx, cy);
                stuck = 0;
                lx = cx;
                ly = cy;
                continue;
            }
            if (c1p == traceColour && cp == traceColour) {
                p.lineTo(c1x, c1y);
                stuck = 0;
                lx = c1x;
                ly = c1y;
                dir = this.perp(dir);
                continue;
            }
            ++stuck;
            dir = this.inv(this.perp(dir));
        }
        p.closePath();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) > 0) {
            if (img == this.image) {
                this.repaint();
            } else if (img == this.mapimage) {
                this.createMapImageDelayed();
            }
        }
        return (infoflags & 0x20) == 0;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.image == null) {
            return;
        }
        if (this.mode == this.MOVE || (e.getModifiers() & 2) > 0 || (e.getModifiers() & 0x10) <= 0) {
            if (this.om != null) {
                int dx = e.getPoint().x - this.om.x;
                int dy = e.getPoint().y - this.om.y;
                this.om = e.getPoint();
                if ((e.getModifiers() & 0x10) > 0) {
                    this.xp = this.zoom * Math.max(0.0, Math.min(this.xp / this.zoom - (double)dx, (double)this.image.getWidth(this) / this.zoom - (double)this.mainpanel.getWidth()));
                    this.yp = this.zoom * Math.max(0.0, Math.min(this.yp / this.zoom - (double)dy, (double)this.image.getHeight(this) / this.zoom - (double)this.mainpanel.getHeight()));
                } else {
                    double minz = 3.0 / Math.max((double)this.getWidth() / (double)this.image.getWidth(this), (double)this.getHeight() / (double)this.image.getHeight(this));
                    double maxz = 0.3;
                    double ocx = this.xp + (double)(this.getWidth() / 2) * this.zoom;
                    double ocy = this.yp + (double)(this.getHeight() / 2) * this.zoom;
                    this.zoom = Math.max(maxz, Math.min(minz, this.zoom - 0.005 * (double)dy));
                    this.xp = Math.max(0.0, Math.min(ocx - (double)(this.getWidth() / 2) * this.zoom, (double)this.image.getWidth(this) - (double)this.getWidth() * this.zoom));
                    this.yp = Math.max(0.0, Math.min(ocy - (double)(this.getHeight() / 2) * this.zoom, (double)this.image.getHeight(this) - (double)this.getHeight() * this.zoom));
                }
                this.mainpanel.repaint();
            }
        } else if (this.mode == this.LESION) {
            this.setCurrentDrawingBitsAt(e.getPoint(), true);
        } else if (this.mode == this.UNLESION) {
            this.setCurrentDrawingBitsAt(e.getPoint(), false);
        }
    }

    public void setCurrentDrawingBitsAt(Point p, boolean t) {
    }

    void calculatePositions() {
        double minz = 3.0 / Math.max((double)this.getWidth() / (double)this.image.getWidth(this), (double)this.getHeight() / (double)this.image.getHeight(this));
        double maxz = 0.3;
        double ocx = this.xp + (double)(this.getWidth() / 2) * this.zoom;
        double ocy = this.yp + (double)(this.getHeight() / 2) * this.zoom;
        this.zoom = Math.max(maxz, Math.min(minz, this.zoom));
        this.xp = Math.max(0.0, Math.min(ocx - (double)(this.getWidth() / 2) * this.zoom, (double)this.image.getWidth(this) - (double)this.getWidth() * this.zoom));
        this.yp = Math.max(0.0, Math.min(ocy - (double)(this.getHeight() / 2) * this.zoom, (double)this.image.getHeight(this) - (double)this.getHeight() * this.zoom));
    }

    public void mouseMoved(MouseEvent e) {
        CNSData.Region r;
        int idx;
        int x = this.xs2i(e.getX());
        int y = this.ys2i(e.getY());
        this.hover = idx = this.getRegionIdxAt(x, y);
        if (this.paintHover) {
            this.repaint();
        }
        if ((r = this.getRegionAt(x, y)) != null) {
            this.rightlabel.setText(r.toString());
        } else {
            this.rightlabel.setText("");
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(this, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.hover > 0) {
            this.hover = -1;
            if (this.paintHover) {
                this.repaint();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.om = this.md = e.getPoint();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(this, e.getX(), e.getY());
        } else if (this.canSelect) {
            int ty;
            int tx = this.md.x - e.getX();
            if (tx * tx + (ty = this.md.y - e.getY()) * ty > 16) {
                return;
            }
            int x = this.xs2i(e.getX());
            int y = this.ys2i(e.getY());
            int i = this.getRegionIdxAt(x, y);
            this.setSelection(i);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.leftlabel.setOpaque(true);
        this.leftlabel.setText("Select a slice");
        this.rightlabel.setOpaque(true);
        this.rightlabel.setText("region");
        this.showregionsCheckbox.setAction(this.showRegions);
        this.showlesionsCheckbox.setAction(this.showLesions);
        this.showlesionsCheckbox.setSelected(this.paintArray);
        this.lesionModeMenuItem1.addActionListener(this.lesionMode);
        this.lesionModeMenuItem2.addActionListener(this.lesionMode);
        this.lesionModeMenuItem3.addActionListener(this.lesionMode);
        this.lesionModeMenuItem1.setText(this.sMOVE);
        this.lesionModeMenuItem2.setText(this.sLESION);
        this.lesionModeMenuItem3.setText(this.sUNLESION);
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.leftlabel, "West");
        this.jPanel1.add((Component)this.rightlabel, "East");
        this.add((Component)this.mainpanel, "Center");
        this.popup.add(this.showregionsCheckbox);
        this.popup.add(this.showlesionsCheckbox);
        this.popup.add(this.lesionModeMenuItem1);
        this.popup.add(this.lesionModeMenuItem2);
        this.popup.add(this.lesionModeMenuItem3);
        this.bg.add(this.lesionModeMenuItem1);
        this.bg.add(this.lesionModeMenuItem2);
        this.bg.add(this.lesionModeMenuItem3);
        this.popup.add(this.clearAllLesionsMenuItem);
        this.lesionModeMenuItem1.setSelected(true);
    }

    public void update() {
        if (this.paintArray && this.reg != null && this.data != null) {
            if (this.arrayItems == null || this.arrayItems.length != this.reg.length) {
                this.arrayItems = new double[this.reg.length];
            }
            int i = 1;
            while (i < this.reg.length) {
                if (this.reg[i] != null) {
                    this.arrayItems[i] = 1.0 - this.data.findRegion(this.reg[i]).getLesion();
                }
                ++i;
            }
            this.repaint();
        }
    }

    public void setData(CNSData d) {
        this.data = d;
        this.update();
        this.clearAllLesionsMenuItem.setAction(Selection.data.clearAllLesionsAction);
        this.readDataAsync();
    }

    public boolean containsRegion(CNSData.Region r) {
        if (this.reg == null) {
            return false;
        }
        int i = 0;
        while (i < this.reg.length) {
            if (r.name.equals(this.reg[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    String getItemWithRegion(CNSData.Region r) {
        if (r == null) {
            return null;
        }
        Enumeration<Object> i = this.props.keys();
        while (i.hasMoreElements()) {
            String s = (String)i.nextElement();
            String v = (String)this.props.get(s);
            if (v == null || v.indexOf(r.name) <= 0 || s == null || !s.endsWith("-regions")) continue;
            return s.substring(0, s.length() - 8);
        }
        return null;
    }

    public void paintHighlights(Graphics g) {
        MapRegion h;
        CNSData.Region selreg;
        if (this.paintAllRegions && this.mapRegions != null) {
            int i = 0;
            while (i < this.mapRegions.size()) {
                ((MapRegion)this.mapRegions.get(i)).paint(g, Color.red, 0.3f, false, true);
                ++i;
            }
        }
        if ((selreg = this.selection.getSelectedRegion()) != null) {
            MapRegion s = this.getRegion(selreg);
            if (s != null) {
                s.paint(g, Color.red, 0.4f, true, true);
            }
            if (this.mapRegions != null) {
                int i = 0;
                while (i < this.mapRegions.size()) {
                    MapRegion mr = (MapRegion)this.mapRegions.get(i);
                    if (mr.region != null && mr.region != selreg) {
                        if (mr.region.isIn(selreg)) {
                            mr.paint(g, Color.red, 0.3f, true, true);
                        } else if (selreg.isIn(mr.region)) {
                            mr.paint(g, Color.red, 0.2f, true, true);
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.paintHover && this.hover >= 0 && (h = this.getRegion(this.hover)) != null) {
            h.paint(g, Color.red, 0.2f, true, true);
        }
        if (this.paintArray && this.arrayItems != null && this.mapRegions != null) {
            int i = 0;
            while (i < this.arrayItems.length) {
                MapRegion h2;
                if (!(this.arrayItems[i] >= 1.0) && (h2 = this.getRegion(i)) != null) {
                    h2.paint(g, Color.green, (float)(1.0 - this.arrayItems[i]), false, true);
                }
                ++i;
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.master != null) {
            if (e.getWheelRotation() > 0) {
                this.master.gotoNextSlice();
            } else {
                this.master.gotoPreviousSlice();
            }
        }
    }

    class ColourModelListener
    implements ImageConsumer {
        ColorModel cm;
        long timeout = 10000L;
        boolean complete = false;

        ColourModelListener() {
        }

        public ColorModel getColourModel() throws InterruptedException {
            long t = System.currentTimeMillis();
            while (!(this.cm != null && this.complete || System.currentTimeMillis() >= t + this.timeout)) {
                Thread.sleep(200L);
            }
            if (this.cm == null) {
                throw new RuntimeException("Image timeout");
            }
            return this.cm;
        }

        public void imageComplete(int status) {
            this.complete = true;
        }

        public void setHints(int hintflags) {
        }

        public void setDimensions(int width, int height) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        }

        public void setColorModel(ColorModel model) {
            this.cm = model;
        }

        public void setProperties(Hashtable props) {
        }
    }

    class MapRegion {
        GeneralPath p;
        int index;
        CNSData.Region region;

        public MapRegion(GeneralPath path, int index) {
            this.p = path;
            this.index = index;
        }

        void paint(Graphics g, Color c, float alpha, boolean outline, boolean fill) {
            AffineTransform a1 = new AffineTransform(1.0, 0.0, 0.0, 1.0, -SliceView.this.xp, -SliceView.this.yp);
            AffineTransform a2 = new AffineTransform(1.0 / SliceView.this.zoom, 0.0, 0.0, 1.0 / SliceView.this.zoom, 0.0, 0.0);
            Shape p2 = a2.createTransformedShape(a1.createTransformedShape(this.p));
            g.setColor(c);
            Graphics2D g2 = (Graphics2D)g;
            AlphaComposite comp = AlphaComposite.getInstance(3, alpha);
            g2.setComposite(comp);
            if (fill) {
                ((Graphics2D)g).fill(p2);
            }
            if (outline) {
                ((Graphics2D)g).draw(p2);
            }
        }
    }
}

