/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import neurology.CNSData;
import neurology.NeurologyMainPanel;
import neurology.SliceView;

public class SensoryExamination
extends SliceView {
    String[] modalities = new String[]{"touch-receptor", "pain-receptor"};
    String[] sides = new String[]{"right", "left"};
    String[] brain = new String[]{"primary-sensory-cortex", "medial-dorsal-thalamus"};
    CNSData.Region[][] regions;
    double[] lesion;
    JPanel jPanel1 = new JPanel();
    JRadioButton ltradio = new JRadioButton();
    JRadioButton ppradio = new JRadioButton();
    JCheckBox revealcheckbox = new JCheckBox();
    boolean haveUpdatedRegionNames = false;
    ActionListener updateListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SensoryExamination.this.update();
        }
    };
    ButtonGroup bg = new ButtonGroup();

    public SensoryExamination(NeurologyMainPanel p, URL resource) {
        super(p, resource, null);
        this.initialiseZoom = false;
        this.setPreferredSize(new Dimension(200, 460));
        this.setItem("dermatome");
        this.leftlabel.setText("Sensation");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.paintArray = true;
        this.paintHover = true;
        this.zoom = 2.0;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.revealcheckbox.isSelected()) {
            super.mouseReleased(e);
        }
    }

    public void update() {
        if (!this.haveUpdatedRegionNames || this.data == null) {
            return;
        }
        if (this.regions == null && this.reg != null) {
            this.lesion = new double[this.reg.length];
            this.regions = new CNSData.Region[this.reg.length][2];
            int i = 0;
            while (i < this.regions.length) {
                int j = 0;
                while (j < 2) {
                    if (this.reg[i] != null) {
                        this.regions[i][j] = this.convertStringToRegion(this.reg[i], j);
                    }
                    ++j;
                }
                ++i;
            }
        }
        int modal = this.getCurrentModality();
        CNSData.Region brainR = this.data.findRegion(String.valueOf(this.brain[modal]) + "-" + this.sides[0]);
        CNSData.Region brainL = this.data.findRegion(String.valueOf(this.brain[modal]) + "-" + this.sides[1]);
        int i = 1;
        while (i < this.regions.length) {
            this.lesion[i] = (i % 2 == 1 ? brainL : brainR).getActivityFrom(this.regions[i][modal]);
            ++i;
        }
        this.arrayItems = this.lesion;
        this.repaint();
    }

    public void setItem(String s) {
        this.haveUpdatedRegionNames = false;
        super.setItem(s);
        String[] reg2 = new String[this.reg.length * 2];
        String[] oldreg = this.reg;
        int i = 1;
        while (i < this.reg.length) {
            reg2[2 * i - 1] = String.valueOf(this.reg[i]) + "-" + this.sides[0];
            reg2[2 * i] = String.valueOf(this.reg[i]) + "-" + this.sides[1];
            ++i;
        }
        this.reg = reg2;
        this.haveUpdatedRegionNames = true;
        if (this.mapRegions == null || this.mapRegions.size() == oldreg.length) {
            this.createMapImageDelayed();
        }
        this.repaint();
    }

    public void createMapImage() throws InterruptedException {
        super.createMapImage();
        this.repaint();
    }

    public void setSelection(int idx) {
        if (idx < 1) {
            this.selection.clearSelection();
            return;
        }
        CNSData.Region r = this.selection.getSelectedRegion();
        this.selection.setSelectedRegion(this.convertStringToRegion(this.reg[idx], this.getCurrentModality()));
    }

    int getCurrentModality() {
        return this.ltradio.isSelected() ? 0 : 1;
    }

    CNSData.Region convertStringToRegion(String reg, int modality) {
        if (reg == null || reg.length() == 0) {
            return null;
        }
        int k = reg.lastIndexOf(45);
        return this.data.findRegion(String.valueOf(reg.substring(0, k)) + "-" + this.modalities[modality] + reg.substring(k));
    }

    SliceView.MapRegion getRegion(CNSData.Region r) {
        if (r == null || this.reg == null || this.mapRegions == null) {
            return null;
        }
        SliceView.MapRegion r0 = super.getRegion(r);
        if (r0 != null) {
            return r0;
        }
        int i = 1;
        while (i < this.reg.length) {
            if (this.reg[i] != null && (this.convertStringToRegion(this.reg[i], 0) == r || this.convertStringToRegion(this.reg[i], 1) == r)) {
                if (this.mapRegions.size() < i) {
                    return null;
                }
                return (SliceView.MapRegion)this.mapRegions.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    private void jbInit() throws Exception {
        this.ltradio.setToolTipText("Ligh touch and vibration");
        this.ltradio.setText("LT/Vib");
        this.ltradio.addActionListener(this.updateListener);
        this.ppradio.setToolTipText("Pinprick (pain) and temperature");
        this.ppradio.setText("PP/Temp");
        this.ppradio.addActionListener(this.updateListener);
        this.revealcheckbox.setToolTipText("Reveal the areas which are impaired");
        this.revealcheckbox.setText("Reveal");
        this.revealcheckbox.setSelected(true);
        this.ltradio.setSelected(true);
        this.revealcheckbox.addActionListener(this.updateListener);
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.ltradio, null);
        this.jPanel1.add((Component)this.ppradio, null);
        this.bg.add(this.ltradio);
        this.bg.add(this.ppradio);
    }
}

