/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import neurology.CNSData;
import neurology.NeurologyMainPanel;
import neurology.PathwayDiagram;
import neurology.RegionEditor;
import neurology.Selection;

public class RegionProperties
extends JPanel {
    NeurologyMainPanel neurologyMainPanel;
    HTMLEditorKit ek = new HTMLEditorKit();
    HTMLDocument hdoc = new HTMLDocument();
    Selection selection = new Selection(){

        public void setSelectedRegion(CNSData.Region r) {
            super.setSelectedRegion(r);
            RegionProperties.this.updateDisplay();
        }
    };
    boolean altering_slider;
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JSlider lesionslider = new JSlider();
    JEditorPane pathwayTextEditorPane = new JEditorPane();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane pathwayTextScrollPane = new JScrollPane();
    JButton editButton = new JButton();
    ActionListener al = null;
    JLabel percentagetxt = new JLabel();
    JLabel jLabel5 = new JLabel();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    PathwayDiagram pathwayDiagram1 = new PathwayDiagram();
    AbstractAction editAction = new AbstractAction("Edit..."){

        public void actionPerformed(ActionEvent e) {
            if (RegionProperties.this.selection.selection == null) {
                return;
            }
            RegionEditor re = new RegionEditor(RegionProperties.this.neurologyMainPanel, NeurologyMainPanel.getResource("Images.txt"));
            re.setSelection(RegionProperties.this.selection.selection);
            JDialog d = new JDialog();
            d.getContentPane().add(re);
            d.setTitle(RegionProperties.this.selection.selection.toString());
            d.pack();
            d.setModal(true);
            d.setVisible(true);
            RegionProperties.this.updateDisplay();
        }
    };

    public RegionProperties() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pathwayTextEditorPane.setEditorKit(this.ek);
        this.pathwayTextEditorPane.setDocument(this.hdoc);
        this.setPathwayVisible(true);
        this.setDiagramVisible(false);
    }

    public void updateDisplay() {
        CNSData.Region r = this.selection.selection;
        if (r == null) {
            this.jLabel2.setText("");
            this.lesionslider.setEnabled(false);
            try {
                this.hdoc.remove(0, this.hdoc.getLength());
            }
            catch (BadLocationException ex2) {
                ex2.printStackTrace();
            }
            return;
        }
        this.jLabel2.setText(r.getFriendlyName());
        this.lesionslider.setEnabled(true);
        this.altering_slider = true;
        this.lesionslider.setValue((int)(r.getLesion() * 100.0));
        this.altering_slider = false;
        try {
            this.hdoc.remove(0, this.hdoc.getLength());
            this.ek.insertHTML(this.hdoc, 0, r.getHypertextDescription(), 0, 0, null);
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    void lesionslider_stateChanged(ChangeEvent e) {
        CNSData.Region r = this.selection.getSelectedRegion();
        if (r == null) {
            return;
        }
        double q = (double)this.lesionslider.getValue() / 100.0;
        if (!this.altering_slider) {
            r.setLesion(q);
        }
        this.percentagetxt.setText(String.valueOf((int)(100.0 * q)));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setText("Name:");
        this.jLabel2.setMaximumSize(new Dimension(34, 15));
        this.jLabel2.setText("");
        this.jLabel3.setText("Lesion:");
        this.lesionslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RegionProperties.this.lesionslider_stateChanged(e);
            }
        });
        this.lesionslider.setToolTipText("Adjust the amount of damage to this region");
        this.jPanel2.setLayout(this.borderLayout2);
        this.pathwayTextEditorPane.setEditable(false);
        this.pathwayTextEditorPane.setText("");
        this.pathwayTextEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                RegionProperties.this.jEditorPane1_hyperlinkUpdate(e);
            }
        });
        this.percentagetxt.setText("0");
        this.jLabel5.setText("%");
        this.lesionslider.setPreferredSize(new Dimension(100, 24));
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLastDividerLocation(80);
        this.jPanel4.setLayout(this.borderLayout3);
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jLabel3, null);
        this.jPanel3.add((Component)this.lesionslider, null);
        this.jPanel3.add((Component)this.percentagetxt, null);
        this.jPanel3.add((Component)this.jLabel5, null);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.pathwayTextScrollPane, "top");
        this.jSplitPane1.add((Component)this.jPanel4, "bottom");
        this.jPanel4.add((Component)this.pathwayDiagram1, "Center");
        this.pathwayTextScrollPane.getViewport().add((Component)this.pathwayTextEditorPane, null);
        this.add((Component)this.jPanel1, "North");
        this.editButton.setAction(this.editAction);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jLabel2, null);
        this.jPanel1.add(this.editButton);
        this.lesionslider.setValue(0);
        this.jSplitPane1.setDividerLocation(0.5);
        this.jSplitPane1.setResizeWeight(0.5);
    }

    void jEditorPane1_hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.selection.setSelectedRegion(e.getDescription());
        }
    }

    public void addActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.add(this.al, a);
    }

    public void setPathwayVisible(boolean b) {
        if (!b) {
            this.pathwayTextScrollPane.setVisible(false);
            this.jSplitPane1.setDividerLocation(0.0);
        } else {
            this.pathwayTextScrollPane.setVisible(true);
            if (this.pathwayDiagram1.isVisible()) {
                this.jSplitPane1.setDividerLocation(0.5);
            } else {
                this.jSplitPane1.setDividerLocation(1.0);
            }
            this.validate();
        }
    }

    public void setDiagramVisible(boolean b) {
        if (!b) {
            this.pathwayDiagram1.setVisible(false);
            this.jSplitPane1.setDividerLocation(1.0);
        } else {
            this.pathwayDiagram1.setVisible(true);
            if (this.pathwayTextScrollPane.isVisible()) {
                this.jSplitPane1.setDividerLocation(0.5);
            } else {
                this.jSplitPane1.setDividerLocation(0.0);
            }
            this.validate();
        }
    }
}

