/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import neurology.CNSData;
import neurology.MasterImage;
import neurology.Selection;
import neurology.SliceView;

class RegionList
extends JPanel
implements ActionListener {
    CNSData data;
    SliceView sliceView;
    MasterImage masterImage;
    Selection selection = new Selection(){

        public void setSelectedRegion(CNSData.Region r) {
            super.setSelectedRegion(r);
            if (RegionList.this.regionlist.getSelectedValue() != r) {
                if (RegionList.this.regionlistmodel.contains(r)) {
                    RegionList.this.regionlist.setSelectedValue(r, true);
                } else {
                    RegionList.this.regionlist.clearSelection();
                }
            }
        }
    };
    Action findSliceAction = new AbstractAction("Find slice"){

        public void actionPerformed(ActionEvent e) {
            String item = RegionList.this.sliceView.getItemWithRegion(RegionList.this.selection.getSelectedRegion());
            if (item != null) {
                RegionList.this.masterImage.setSlice(item);
                RegionList.this.sliceView.setItem(item);
            }
        }
    };
    Box box1 = new Box(1);
    Box box2 = new Box(1);
    FlowLayout flowlayout = new FlowLayout();
    JCheckBox sortcheck = new JCheckBox();
    JCheckBox hiddencheck = new JCheckBox();
    JCheckBox sliceOnlyCheck = new JCheckBox();
    JCheckBox lesiononlycheck = new JCheckBox();
    JScrollPane jScrollPane2 = new JScrollPane();
    JList regionlist = new JList();
    JPanel jPanel10 = new JPanel();
    BorderLayout borderLayout9 = new BorderLayout();
    DefaultListModel regionlistmodel = new DefaultListModel();
    JTextField jTextField1 = new JTextField();
    JButton clrbtn = new JButton();
    JPanel jPanel9 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JButton findSlice = new JButton(this.findSliceAction);
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout10 = new BorderLayout();
    ActionListener updatelistAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            RegionList.this.updateList();
        }
    };

    public void actionPerformed(ActionEvent e) {
        this.updateList();
    }

    public void setData(CNSData d) {
        this.data = d;
    }

    public void setSliceView(SliceView s) {
        this.sliceView = s;
    }

    public void updateList() {
        if (this.data == null) {
            return;
        }
        CNSData.Region currsel = this.selection.getSelectedRegion();
        String str = this.jTextField1.getText().toLowerCase();
        Vector v = (Vector)this.data.regions.clone();
        if (this.sortcheck.isSelected()) {
            Collections.sort(v);
        }
        this.regionlistmodel.removeAllElements();
        boolean showhidden = this.hiddencheck.isSelected();
        boolean lesionOnly = this.lesiononlycheck.isSelected();
        boolean sliceOnly = this.sliceOnlyCheck.isSelected();
        int i = 0;
        while (i < v.size()) {
            CNSData.Region r = (CNSData.Region)v.get(i);
            if (!(lesionOnly && r.getLesion() == 0.0 || sliceOnly && !this.sliceView.containsRegion(r) || str != null && str.length() > 0 && r.friendlyName.toLowerCase().indexOf(str) < 0 || !showhidden && r.hidden)) {
                this.regionlistmodel.addElement(r);
            }
            ++i;
        }
        if (this.regionlistmodel.contains(currsel)) {
            this.regionlist.setSelectedValue(currsel, true);
        }
    }

    void regionlist_valueChanged(ListSelectionEvent e) {
        this.selection.setSelectedRegion((CNSData.Region)this.regionlist.getSelectedValue());
    }

    public RegionList() {
        this.setLayout(new BorderLayout());
        this.jPanel7.setLayout(this.borderLayout9);
        this.jPanel6.setLayout(this.borderLayout5);
        this.jPanel10.setLayout(this.borderLayout10);
        this.regionlist.setModel(this.regionlistmodel);
        this.regionlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RegionList.this.regionlist_valueChanged(e);
            }
        });
        this.sortcheck.setSelected(true);
        this.sortcheck.setText("Sort");
        this.sortcheck.addActionListener(this.updatelistAction);
        this.hiddencheck.setText("Hidden");
        this.hiddencheck.addActionListener(this.updatelistAction);
        this.lesiononlycheck.setText("Lesions only");
        this.lesiononlycheck.addActionListener(this.updatelistAction);
        this.sliceOnlyCheck.setText("Slice only");
        this.sliceOnlyCheck.addActionListener(this.updatelistAction);
        this.jTextField1.setText("");
        this.jTextField1.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                RegionList.this.jTextField1_caretUpdate(e);
            }
        });
        this.clrbtn.setText("Clear");
        this.clrbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegionList.this.clrbtn_actionPerformed(e);
            }
        });
        this.jScrollPane2.getViewport().add((Component)this.regionlist, null);
        this.jPanel9.add(this.box1);
        this.box1.add(this.lesiononlycheck);
        this.box1.add(this.sliceOnlyCheck);
        this.jPanel9.add(this.box2);
        this.box2.add(this.sortcheck);
        this.box2.add(this.hiddencheck);
        this.jPanel9.add(this.findSlice);
        this.jPanel9.setLayout(this.flowlayout);
        this.lesiononlycheck.setToolTipText("Display only those regions that are currently lesioned");
        this.hiddencheck.setToolTipText("Display hidden regions (used only for debugging)");
        this.sortcheck.setToolTipText("Sort regions in alphabetical order, or in order of connection");
        this.findSlice.setToolTipText("Go to an image slice that shows the selected region");
        this.sliceOnlyCheck.setToolTipText("Display only those regions that are on the current image slice");
        this.jPanel7.add((Component)this.jPanel9, "Center");
        this.jPanel6.add((Component)this.jScrollPane2, "Center");
        this.add((Component)this.jPanel6, "Center");
        this.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.jPanel10, "North");
        this.jPanel10.add((Component)this.jTextField1, "Center");
        this.jPanel10.add((Component)this.clrbtn, "East");
    }

    void jTextField1_caretUpdate(CaretEvent e) {
        this.updateList();
    }

    void clrbtn_actionPerformed(ActionEvent e) {
        this.jTextField1.setText("");
        this.updateList();
    }

    void setMasterImage(MasterImage m) {
        this.masterImage = m;
    }
}

