/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import neurology.CNSData;
import neurology.MasterImage;
import neurology.NeurologyMainPanel;
import neurology.PaintableSlice;
import neurology.SliceView;

public class RegionEditor
extends JPanel {
    CNSData.Region region;
    Action revertAction = new AbstractAction("Revert slice"){

        public void actionPerformed(ActionEvent e) {
            RegionEditor.this.drawOriginal();
        }
    };
    ActionListener initialisePaintableImage = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            RegionEditor.this.drawOriginal();
        }
    };
    JPanel mainPanel = new JPanel();
    JPanel lowerpanel = new JPanel();
    MasterImage mi;
    JPanel leftPanel = new JPanel();
    RList inputList = new RList(1, "Inputs from");
    RList outputList = new RList(0, "Outputs to");
    RList parentList = new RList(5, "Parents");
    RList contentList = new RList(4, "Contents");
    RList viaList = new RList(2, "Fibres via here, to");
    RList thruList = new RList(3, "Inputs come via");
    PaintableSlice slice;
    boolean editedConnections = false;
    boolean alreadySavedAndExited = false;
    AncestorListener closeListener = new AncestorListener(){

        public void ancestorRemoved(AncestorEvent e) {
            if (NeurologyMainPanel.DEBUG && RegionEditor.this.region.content.size() + RegionEditor.this.region.input.size() + RegionEditor.this.region.via.size() == 0) {
                JOptionPane.showMessageDialog(RegionEditor.this, "This region " + RegionEditor.this.region + " will not be stored as a separate" + " line in the file, only referenced by other items.");
            }
            RegionEditor.this.slice.savePaintedRegion(RegionEditor.this.editedConnections);
            RegionEditor.this.alreadySavedAndExited = true;
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
        }
    };

    public void setSelection(CNSData.Region r) {
        int choice;
        if (this.editedConnections | this.slice.hasPainted && (choice = JOptionPane.showConfirmDialog(this, "Changes will be lost if selecting " + r + " instead of " + this.region, "Warning", 2)) == 2) {
            return;
        }
        this.region = r;
        this.update();
        this.editedConnections = false;
    }

    public RegionEditor(NeurologyMainPanel mainpanel, URL resource) {
        this.mi = new MasterImage(mainpanel);
        this.slice = new PaintableSlice(mainpanel, resource, this.mi);
        this.slice.setData(mainpanel.data);
        this.mi.addActionListener(this.slice);
        this.mi.setPreferredSize(new Dimension(100, 400));
        this.slice.setPreferredSize(new Dimension(450, 400));
        this.slice.paintHover = false;
        this.slice.canSelect = false;
        this.slice.selection.setSelectedRegion(mainpanel.selection.selection);
        this.slice.sMOVE = "Move";
        this.slice.sLESION = "Draw region";
        this.slice.sUNLESION = "Erase region";
        this.slice.lesionModeMenuItem1.setText(this.slice.sMOVE);
        this.slice.lesionModeMenuItem2.setText(this.slice.sLESION);
        this.slice.lesionModeMenuItem3.setText(this.slice.sUNLESION);
        this.slice.popup.remove(this.slice.showlesionsCheckbox);
        this.slice.clearAllLesionsMenuItem.setText("Clear slice");
        this.slice.clearAllLesionsMenuItem.removeActionListener(this.slice.data.clearAllLesionsAction);
        this.slice.popup.add(this.revertAction);
        this.mi.findAndSelectRegion(mainpanel.selection.selection);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "West");
        this.add((Component)this.lowerpanel, "Center");
        this.mainPanel.setPreferredSize(new Dimension(480, 500));
        this.lowerpanel.add(this.mi);
        this.lowerpanel.add(this.slice);
        this.mainPanel.add(this.inputList);
        this.mainPanel.add(this.thruList);
        this.mainPanel.add(this.outputList);
        this.mainPanel.add(this.parentList);
        this.mainPanel.add(this.contentList);
        this.mainPanel.add(this.viaList);
        this.slice.addInitialisePaintableImageListener(this.initialisePaintableImage);
        this.addAncestorListener(this.closeListener);
    }

    void drawOriginal() {
        SliceView.MapRegion r = this.slice.getRegion(this.slice.selection.getSelectedRegion());
        this.slice.clearBits();
        if (r != null) {
            Graphics2D g = (Graphics2D)this.slice.paintableImage.getGraphics();
            g.setColor(Color.white);
            g.fill(r.p);
        }
        this.slice.hasPainted = false;
    }

    void update() {
        this.inputList.updateFromSourceList();
        this.outputList.updateFromSourceList();
        this.viaList.updateFromSourceList();
        this.thruList.updateFromSourceList();
        this.contentList.updateFromSourceList();
        this.parentList.updateFromSourceList();
    }

    class RList
    extends JPanel
    implements MouseListener {
        JComboBox combo = new JComboBox();
        JList list = new JList();
        JLabel label = new JLabel();
        DefaultListModel model = new DefaultListModel();
        JScrollPane scroll = new JScrollPane();
        int direction;
        JPanel toppanel = new JPanel();
        boolean changing = false;
        ActionListener comboAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object o = RList.this.combo.getSelectedItem();
                if (o == null) {
                    return;
                }
                String s = RList.this.combo.getSelectedItem().toString();
                CNSData.Region r = null;
                if (((RList)RList.this).RegionEditor.this.region != null) {
                    CNSData.Region[] rs = ((RList)RList.this).RegionEditor.this.region.data.getMatchingRegions(s);
                    if (rs.length > 1) {
                        RList.this.changing = true;
                        DefaultComboBoxModel<CNSData.Region> cbm = new DefaultComboBoxModel<CNSData.Region>(rs);
                        cbm.setSelectedItem(s);
                        RList.this.combo.setModel(cbm);
                        RList.this.combo.showPopup();
                        RList.this.changing = false;
                    } else if (rs.length == 1 & !RList.this.changing) {
                        r = rs[0];
                    }
                }
                if (r != null) {
                    RList.this.model.addElement(r);
                    ((RList)RList.this).RegionEditor.this.region.getListOf(RList.this.direction).add(r);
                    r.getListOf(((RList)RList.this).RegionEditor.this.region.oppositeDirection(RList.this.direction)).add(r);
                    ((RList)RList.this).RegionEditor.this.editedConnections = true;
                }
            }
        };
        JPopupMenu popup = new JPopupMenu();
        Action copyAction = new AbstractAction("Copy"){

            public void actionPerformed(ActionEvent e) {
                StringSelection strng = new StringSelection(RList.this.list.getSelectedValue().toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(strng, strng);
            }
        };
        Action pasteAction = new AbstractAction("Paste"){

            public void actionPerformed(ActionEvent e) {
                try {
                    String s = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor).toString();
                    RList.this.combo.setSelectedItem(s);
                    RList.this.combo.actionPerformed(new ActionEvent(RList.this.combo, 0, s));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        Action deleteAction = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent e) {
                CNSData.Region r = (CNSData.Region)RList.this.list.getSelectedValue();
                if (r != null) {
                    ((RList)RList.this).RegionEditor.this.region.getListOf(RList.this.direction).remove(r);
                    r.getListOf(r.oppositeDirection(RList.this.direction)).remove(((RList)RList.this).RegionEditor.this.region);
                    RList.this.updateFromSourceList();
                }
            }
        };
        Action moveUpAction = new AbstractAction("Move up"){

            public void actionPerformed(ActionEvent e) {
                CNSData.Region r = (CNSData.Region)RList.this.list.getSelectedValue();
                if (r != null) {
                    Vector v = ((RList)RList.this).RegionEditor.this.region.getListOf(RList.this.direction);
                    int i = v.indexOf(r);
                    if (i > 0) {
                        Object tmp = v.get(i - 1);
                        v.setElementAt(r, i - 1);
                        v.setElementAt(tmp, i);
                    }
                    RList.this.updateFromSourceList();
                }
            }
        };
        Action moveDownAction = new AbstractAction("Move down"){

            public void actionPerformed(ActionEvent e) {
                CNSData.Region r = (CNSData.Region)RList.this.list.getSelectedValue();
                if (r != null) {
                    Vector v = ((RList)RList.this).RegionEditor.this.region.getListOf(RList.this.direction);
                    int i = v.indexOf(r);
                    if (i < v.size() - 1) {
                        Object tmp = v.get(i + 1);
                        v.setElementAt(r, i + 1);
                        v.setElementAt(tmp, i);
                    }
                    RList.this.updateFromSourceList();
                }
            }
        };

        RList(int direction, String title) {
            this.setBorder(new EtchedBorder(1));
            this.setLayout(new BorderLayout());
            this.add((Component)this.toppanel, "North");
            this.toppanel.setLayout(new BorderLayout());
            this.toppanel.add((Component)this.combo, "Center");
            this.toppanel.add((Component)this.label, "North");
            this.label.setText(title);
            this.add((Component)this.scroll, "Center");
            this.scroll.getViewport().setView(this.list);
            this.combo.addActionListener(this.comboAL);
            this.combo.setEditable(true);
            this.list.setModel(this.model);
            this.setPreferredSize(new Dimension(210, 140));
            this.direction = direction;
            this.list.addMouseListener(this);
            this.popup.add(this.copyAction);
            this.popup.add(this.deleteAction);
            this.popup.add(this.pasteAction);
            this.popup.addSeparator();
            this.popup.add(this.moveUpAction);
            this.popup.add(this.moveDownAction);
        }

        public void updateFromSourceList() {
            this.model.removeAllElements();
            Vector v = RegionEditor.this.region.getListOf(this.direction);
            int i = 0;
            while (i < v.size()) {
                this.model.addElement(v.get(i));
                ++i;
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(this.list, e.getX(), e.getY());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(this.list, e.getX(), e.getY());
            }
        }
    }
}

