/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import neurology.CNSData;
import neurology.NeurologyMainPanel;

public class ReflexPanel
extends JPanel {
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel12 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jjlabel = new JLabel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel ulpanel = new JPanel();
    JPanel llpanel = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    Border border1;
    Border border2;
    Border border3;
    JPanel jPanel4 = new JPanel();
    GridLayout gridLayout4 = new GridLayout();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel ltCorneal = new JLabel();
    JLabel rtVOR = new JLabel();
    JLabel ltVOR = new JLabel();
    JLabel rtGag = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel rtCorneal = new JLabel();
    JLabel ltGag = new JLabel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    JLabel[][] rl;
    String[] sides = new String[]{"-right", "-left"};
    LabelMouseListener lml = new LabelMouseListener();
    String[] rstr = new String[]{"-", "+", "++", "+++", "++++"};
    CNSData data;
    ActionListener al;
    String[][] arcs = new String[][]{{"B", "Biceps jerk", "biceps"}, {"Br", "Brachioradialis (supinator jerk)", "brachioradialis"}, {"T", "Triceps jerk", "triceps"}, {"FJ", "Finger jerk", "flexor-digitorum"}, {"K", "Knee jerk", "quadriceps"}, {"A", "Ankle jerk", "gastrocnemius"}, {"P", "Plantar", "gastrocnemius"}};
    String[][] cnArcs = new String[][]{{"ophthalmic-pain-receptor", "orbicularis-oculi"}, {"vestibular-organ", "lateral-rectus"}, {"palatal-touch-receptor", "palatal-muscle"}};
    JLabel[] cnReflexLabel = new JLabel[]{this.rtCorneal, this.ltCorneal, this.rtVOR, this.ltVOR, this.rtGag, this.ltGag};

    public ReflexPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rl = new JLabel[this.arcs.length][2];
        this.jjlabel.putClientProperty("muscle", "pterygoid-left");
        int i = 0;
        while (i < this.arcs.length) {
            JLabel lab = new JLabel(this.arcs[i][0]);
            lab.setToolTipText(this.arcs[i][1]);
            int j = 0;
            while (j < 2) {
                String side = this.sides[j];
                this.rl[i][j] = new JLabel();
                this.setupJLabel(this.rl[i][j], String.valueOf(this.arcs[i][2]) + side);
                ++j;
            }
            JPanel dst = i < 4 ? this.ulpanel : this.llpanel;
            dst.add(lab);
            dst.add(this.rl[i][0]);
            dst.add(this.rl[i][1]);
            ++i;
        }
        i = 0;
        while (i < this.cnReflexLabel.length) {
            this.setupJLabel(this.cnReflexLabel[i], String.valueOf(this.cnArcs[i / 2][1]) + this.sides[i % 2]);
            ++i;
        }
    }

    void setupJLabel(JLabel a, String s) {
        a.setCursor(Cursor.getPredefinedCursor(12));
        a.addMouseListener(this.lml);
        a.putClientProperty("muscle", s);
        a.setToolTipText(NeurologyMainPanel.friendlyName(s));
    }

    void update() {
        CNSData.Region r1 = this.data.findRegion("pterygoid-left");
        CNSData.Region r2 = this.data.findRegion("pterygoid-right");
        CNSData.Region h1 = (CNSData.Region)r1.input.get(0);
        CNSData.Region h2 = (CNSData.Region)r2.input.get(0);
        double lmn = (r1.getActivityFrom(h1) + r2.getActivityFrom(h2)) / 2.0;
        double umn = (h1.getActivity() + h2.getActivity()) / 2.0;
        this.jjlabel.setText(this.getReflexString(lmn * (1.0 - 0.75 * umn)));
        int i = 0;
        while (i < this.rl.length) {
            int j = 0;
            while (j < 2) {
                String muscle = this.rl[i][j].getClientProperty("muscle").toString();
                CNSData.Region r = this.data.findRegion(muscle);
                CNSData.Region h = (CNSData.Region)r.input.get(0);
                lmn = r.getActivityFrom(h);
                umn = h.getActivity();
                if (i == 6) {
                    this.rl[i][j].setText(lmn < 0.15 ? "Mute" : (umn < 0.91 ? "Extensor" : "Flexor"));
                } else {
                    this.rl[i][j].setText(this.getReflexString(lmn * (1.0 - 0.75 * umn)));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            r1 = this.data.findRegion(String.valueOf(this.cnArcs[i / 2][0]) + this.sides[i % 2]);
            r2 = this.data.findRegion(String.valueOf(this.cnArcs[i / 2][1]) + this.sides[i % 2]);
            this.cnReflexLabel[i].setText(this.getCranialReflexString(this.data.findRegion(String.valueOf(this.cnArcs[i / 2][1]) + this.sides[i % 2]).getActivityFrom(this.data.findRegion(String.valueOf(this.cnArcs[i / 2][0]) + this.sides[i % 2]))));
            ++i;
        }
    }

    String getReflexString(double x) {
        return this.rstr[Math.max(0, Math.min((int)(x * 6.0), this.rstr.length - 1))];
    }

    String getCranialReflexString(double x) {
        return x > 0.7 ? "+" : "-";
    }

    void setData(CNSData data) {
        this.data = data;
        this.update();
    }

    public void addActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.add(this.al, a);
    }

    public void removeActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.remove(a, this.al);
    }

    private void jbInit() throws Exception {
        this.border2 = BorderFactory.createCompoundBorder(new EtchedBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border3 = BorderFactory.createCompoundBorder(new EtchedBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.borderLayout1);
        this.jPanel12.setLayout(this.borderLayout2);
        this.jLabel1.setToolTipText("Jaw jerk");
        this.jLabel1.setText("JJ");
        this.jjlabel.setText("++");
        this.jPanel3.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(1);
        this.ulpanel.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(3);
        this.gridLayout2.setRows(4);
        this.llpanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(3);
        this.gridLayout3.setRows(3);
        this.ulpanel.setBorder(this.border2);
        this.llpanel.setBorder(this.border3);
        this.jPanel4.setLayout(this.gridLayout4);
        this.gridLayout4.setColumns(2);
        this.gridLayout4.setRows(1);
        this.jLabel2.setToolTipText("Corneal reflexes");
        this.jLabel2.setText("Corneal");
        this.ltCorneal.setText("jLabel6");
        this.rtVOR.setText("jLabel7");
        this.ltVOR.setText("jLabel8");
        this.rtGag.setText("jLabel9");
        this.jLabel10.setToolTipText("Gag reflex");
        this.jLabel10.setText("Gag");
        this.rtCorneal.setOpaque(false);
        this.rtCorneal.setText("jLabel11");
        this.ltGag.setText("jLabel12");
        this.jPanel6.setLayout(this.gridLayout5);
        this.gridLayout5.setColumns(2);
        this.gridLayout5.setRows(3);
        this.jPanel5.setLayout(this.gridLayout6);
        this.gridLayout6.setColumns(2);
        this.gridLayout6.setRows(3);
        this.jLabel5.setToolTipText("Vestibulo-ocular reflex");
        this.jLabel5.setText("VOR");
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jPanel12, null);
        this.jPanel12.add((Component)this.jLabel1, "West");
        this.jPanel12.add((Component)this.jjlabel, "East");
        this.jPanel12.add((Component)this.jPanel2, "Center");
        this.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.ulpanel, null);
        this.jPanel3.add((Component)this.llpanel, null);
        this.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jLabel2, null);
        this.jPanel6.add((Component)this.jLabel5, null);
        this.jPanel6.add((Component)this.jLabel10, null);
        this.jPanel4.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.rtCorneal, null);
        this.jPanel5.add((Component)this.ltCorneal, null);
        this.jPanel5.add((Component)this.rtVOR, null);
        this.jPanel5.add((Component)this.ltVOR, null);
        this.jPanel5.add((Component)this.rtGag, null);
        this.jPanel5.add((Component)this.ltGag, null);
    }

    class LabelMouseListener
    extends MouseAdapter {
        LabelMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            String s = ((JComponent)e.getSource()).getClientProperty("muscle").toString();
            ReflexPanel.this.al.actionPerformed(new ActionEvent(this, 0, s));
        }
    }
}

