/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import neurology.CNSData;
import neurology.NeurologyMainPanel;
import neurology.OptionsPanel;
import neurology.Selection;

public class PathwayDiagram
extends JPanel
implements MouseListener {
    int NC = 25;
    int NL = 3;
    int SC = 6;
    Selection selection = new Selection(){

        public void setSelectedRegion(CNSData.Region r) {
            super.setSelectedRegion(r);
            PathwayDiagram.this.updateDiagram(r);
        }
    };
    boolean holdDiagram = false;
    DiagramUpdater diagramUpdater = new DiagramUpdater();
    int[] columnnums;
    Vector boxes = new Vector();
    GridBagLayout gbl;
    boolean showVia = false;
    boolean showHidden = false;
    boolean showContents = true;
    boolean showParents = true;
    boolean displaySelfFirst = false;
    boolean showCarries = false;
    boolean test_wires = false;
    public static final boolean DEBUG = true;
    Action holdDiagramAction = new AbstractAction("Hold diagram"){
        {
            this.putValue("ShortDescription", "Keep diagram despite changes in selection");
        }

        public void actionPerformed(ActionEvent e) {
            PathwayDiagram.this.holdDiagram = OptionsPanel.getBoolean(e);
        }
    };
    JPopupMenu popupMenu = new JPopupMenu();
    JCheckBoxMenuItem option = new JCheckBoxMenuItem();

    public void updateDiagram(CNSData.Region r) {
        this.diagramUpdater.region = r;
        new Thread(this.diagramUpdater).start();
    }

    private void updateDiagramImpl(CNSData.Region r) {
        if (!this.holdDiagram) {
            this.removeAll();
            this.boxes = new Vector();
            if (r != null) {
                System.out.println("----start");
                this.columnnums = new int[this.NC];
                this.boxes = new Vector();
                Box b = new Box(r);
                if (this.displaySelfFirst || r.input.size() + r.output.size() == 0) {
                    b.gbc.gridx = this.SC;
                    b.gbc.gridy = 0;
                    int n = b.gbc.gridx;
                    this.columnnums[n] = this.columnnums[n] + 1;
                    System.out.println("added root " + r + " at " + b.gbc.gridx + ", " + b.gbc.gridy);
                    this.add((Component)b, b.gbc);
                    b.added = true;
                }
                b.create(this.NL, this.SC);
            }
        }
        this.update();
    }

    public void updateDiagram() {
        this.updateDiagram(this.selection.getSelectedRegion());
    }

    public void paint(Graphics g) {
        super.paint(g);
        int i = 0;
        while (i < this.boxes.size()) {
            Vector in;
            Box b = (Box)this.boxes.get(i);
            if (b != null && (in = b.getExistingInputs()) != null) {
                int j = 0;
                while (j < in.size()) {
                    Box b2 = (Box)in.get(j);
                    b2.arrowTo(g, b);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void add(Component b, Object constraints) {
        if (b instanceof Box && ((Box)b).hidden) {
            return;
        }
        int n = ((GridBagConstraints)constraints).gridy;
        if (n > 0 && this.getHeight() / n < 18) {
            System.out.println(">" + n + " items in column " + ((GridBagConstraints)constraints).gridx);
            ((Box)b).hidden = true;
            return;
        }
        super.add(b, constraints);
    }

    Box displayed(Box b) {
        if (!b.region.hidden) {
            return b;
        }
        int i = 0;
        while (i < b.region.parents.size()) {
            Box b2 = this.find((CNSData.Region)b.region.parents.get(i));
            if (b2 != null) {
                if (b2.region.hidden) {
                    return this.displayed(b2);
                }
                return b2;
            }
            ++i;
        }
        return b;
    }

    Box find(CNSData.Region r) {
        int i = 0;
        while (i < this.boxes.size()) {
            Box b = (Box)this.boxes.get(i);
            if (b.region == r) {
                return b;
            }
            ++i;
        }
        return null;
    }

    Box findOrCreate(CNSData.Region r) {
        Box b = this.find(r);
        if (b == null) {
            b = new Box(r);
        }
        return b;
    }

    public void updateLesions() {
        CNSData.Region sel = this.selection.getSelectedRegion();
        int i = 0;
        while (i < this.boxes.size()) {
            Box b = (Box)this.boxes.get(i);
            if (b.region == sel) {
                b.setBackground(new Color(255, 192, 192));
            } else {
                double lesion = Math.max(0.0, Math.min(1.0, b.region.getLesion()));
                if (lesion > 0.0) {
                    b.setBackground(NeurologyMainPanel.getLesionColor(lesion));
                } else {
                    b.setBackground(null);
                }
            }
            ++i;
        }
    }

    public void update() {
        this.updateLesions();
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e.getPoint());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e.getPoint());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e.getPoint());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public PathwayDiagram() {
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        this.option.setAction(this.holdDiagramAction);
        this.popupMenu.add(this.option);
        this.addMouseListener(this);
    }

    void popup(Point p) {
        this.option.setSelected(this.holdDiagram);
        this.popupMenu.show(this, p.x, p.y);
    }

    static /* synthetic */ void access$0(PathwayDiagram pathwayDiagram, CNSData.Region region) {
        pathwayDiagram.updateDiagramImpl(region);
    }

    class Box
    extends JPanel
    implements MouseListener {
        CNSData.Region region;
        Vector in;
        Vector out;
        boolean added = false;
        JLabel label = new JLabel();
        int d = 5;
        boolean hidden;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 0, 15), 2, 0);
        int createdDepth = 0;
        int numCarries = 0;
        Vector wiresTo;

        public void add(Component b, Object constraints) {
            if (b instanceof Box && ((Box)b).region.hidden && !PathwayDiagram.this.showHidden) {
                return;
            }
            super.add(b, constraints);
        }

        Box(CNSData.Region r) {
            PathwayDiagram.this.boxes.add(this);
            this.region = r;
            this.hidden = this.region.hidden && !PathwayDiagram.this.showHidden;
            this.setLayout(new GridBagLayout());
            if (PathwayDiagram.this.selection.getSelectedRegion() == this.region) {
                this.setBackground(SystemColor.textHighlight);
            }
            this.label.setText(r.getAbbreviatedName());
            this.label.setToolTipText(r.getFriendlyName());
            this.add(this.label);
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.label.addMouseListener(this);
            this.label.setCursor(Cursor.getPredefinedCursor(12));
        }

        Vector getInputs() {
            if (this.region.input.size() > 0) {
                return this.getBoxes(this.region.input);
            }
            return null;
        }

        Vector getOutputs() {
            Vector v = new Vector();
            if (this.region.output.size() > 0) {
                return this.getBoxes(this.region.output);
            }
            return null;
        }

        Vector getContents() {
            if (this.region.content.size() > 0) {
                return this.getBoxes(this.region.content);
            }
            return null;
        }

        Vector getParents() {
            if (this.region.parents.size() > 0) {
                return this.getBoxes(this.region.parents);
            }
            return null;
        }

        Vector getCarries() {
            if (this.region.thru.size() > 0) {
                return this.getBoxes(this.region.thru);
            }
            return null;
        }

        Vector getExistingInputs() {
            Vector<Box> v = new Vector<Box>();
            int i = 0;
            while (i < PathwayDiagram.this.boxes.size()) {
                Box b = (Box)PathwayDiagram.this.boxes.get(i);
                Vector in = this.region.input;
                if (in.contains(b.region)) {
                    v.add(b);
                }
                ++i;
            }
            return v;
        }

        Vector getVia() {
            if (this.region.via.size() > 0) {
                return this.getBoxes(this.region.via);
            }
            return null;
        }

        Vector getBoxes(Vector regions) {
            Vector<Box> v = new Vector<Box>();
            int i = 0;
            while (i < regions.size()) {
                CNSData.Region r = (CNSData.Region)regions.get(i);
                Box b = PathwayDiagram.this.findOrCreate(r);
                v.add(b);
                ++i;
            }
            return v;
        }

        void arrowTo(Graphics g, Box b) {
            Rectangle r = PathwayDiagram.this.displayed(this).getAbsBounds();
            Rectangle r2 = PathwayDiagram.this.displayed(b).getAbsBounds();
            Point from = new Point(r.x + r.width, r.y + r.height / 2);
            if (from.x == 0 && from.y == 0) {
                System.out.println(this.region + " box (from) has invalid location");
                return;
            }
            if (r2.x == 0 && r2.y == 0) {
                System.out.println(b.region + " (displayed " + PathwayDiagram.this.displayed((Box)b).region + ") (to) has invalid location");
                return;
            }
            int i = b.region.via.size() - 1;
            while (i >= 0) {
                Box bv = PathwayDiagram.this.find((CNSData.Region)b.region.via.get(i));
                if (bv != null) {
                    Rectangle rv = PathwayDiagram.this.displayed(bv).getAbsBounds();
                    if (PathwayDiagram.this.test_wires) {
                        if (bv.wiresTo != null) {
                            int wireIdx = bv.wiresTo.indexOf(b);
                            if (wireIdx < 0) {
                                System.out.println("Error: via " + bv.region + " (from " + this.region + ") was not added");
                            }
                            Point to = new Point(rv.x + rv.width / 2, rv.y + 3 + 3 * wireIdx);
                            if (rv.x != 0 || rv.y != 0) {
                                g.drawLine(from.x, from.y, to.x, to.y);
                                from = to;
                            }
                        } else {
                            System.out.println("Error: via " + bv.region + " (from " + this.region + ") has no wires");
                        }
                    }
                }
                --i;
            }
            g.drawLine(from.x, from.y, r2.x, r2.y + r2.height / 2);
            g.drawLine(r2.x - this.d, r2.y + r2.height / 2 - this.d, r2.x, r2.y + r2.height / 2);
            g.drawLine(r2.x - this.d, r2.y + r2.height / 2 + this.d, r2.x, r2.y + r2.height / 2);
        }

        Rectangle getAbsBounds() {
            if (this.getParent() instanceof Box) {
                Rectangle pb = ((Box)this.getParent()).getAbsBounds();
                Rectangle a = this.getBounds();
                a.translate(pb.x, pb.y);
                return a;
            }
            return this.getBounds();
        }

        public int getColumn() {
            if (this.getParent() == null) {
                throw new IllegalStateException("getColumn called on " + this.region + ", but not displayed");
            }
            if (this.getParent() instanceof PathwayDiagram) {
                return this.gbc.gridx;
            }
            return ((Box)this.getParent()).getColumn();
        }

        int countAllDisplayedChildren() {
            if (this.hidden) {
                return 0;
            }
            int cc = this.getComponentCount();
            if (cc < 2) {
                return cc;
            }
            int a = 1;
            int i = 0;
            while (i < cc) {
                Component c = this.getComponent(i);
                if (c instanceof Box) {
                    Box b = (Box)c;
                    a += b.countAllDisplayedChildren();
                }
                ++i;
            }
            return a;
        }

        void ensureCreatedToDepth(int depth, int startx) {
            if (this.createdDepth >= depth) {
                return;
            }
            this.create(depth, startx);
        }

        void create(int depth, int startx) {
            GridBagConstraints gbc1;
            Component c2;
            Box b;
            if (this.region.hidden && !PathwayDiagram.this.showHidden) {
                ++depth;
            }
            this.createdDepth = depth;
            if (depth == 0) {
                return;
            }
            Vector v = this.getInputs();
            if (v != null) {
                if (this.gbc.gridheight < v.size()) {
                    this.gbc.gridheight = v.size();
                }
                int i = 0;
                while (i < v.size()) {
                    Box b2 = (Box)v.get(i);
                    if (!b2.added) {
                        b2.gbc.gridx = startx - 1;
                        b2.gbc.gridy = PathwayDiagram.this.columnnums[startx - 1];
                        PathwayDiagram.this.add((Component)b2, b2.gbc);
                        if (b2.getParent() != null) {
                            int n = startx - 1;
                            PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + 1;
                            System.out.println("added input " + b2.region + " at " + b2.gbc.gridx + ", " + b2.gbc.gridy);
                        }
                        b2.added = true;
                        b2.create(depth - 1, startx - 1);
                    } else {
                        b2.ensureCreatedToDepth(depth - 1, startx - 1);
                    }
                    ++i;
                }
            }
            int nstartx = startx;
            if (PathwayDiagram.this.showVia && (v = this.getVia()) != null) {
                int i = 0;
                while (i < v.size()) {
                    b = (Box)v.get(i);
                    if (!b.added && nstartx < PathwayDiagram.this.NC) {
                        b.gbc.gridx = ++nstartx;
                        b.gbc.gridy = PathwayDiagram.this.columnnums[nstartx];
                        PathwayDiagram.this.add((Component)b, b.gbc);
                        if (b.getParent() != null) {
                            int n = nstartx;
                            PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + 1;
                            System.out.println("added via " + b.region + " at " + b.gbc.gridx + ", " + b.gbc.gridy);
                        }
                        b.added = true;
                        b.create(depth - 1, nstartx);
                    } else {
                        b.ensureCreatedToDepth(depth - 1, nstartx);
                    }
                    ++i;
                }
            }
            if ((v = this.getOutputs()) != null) {
                int i = 0;
                while (i < v.size()) {
                    b = (Box)v.get(i);
                    if (!b.added) {
                        b.gbc.gridx = nstartx + 1;
                        b.gbc.gridy = PathwayDiagram.this.columnnums[nstartx + 1];
                        PathwayDiagram.this.add((Component)b, b.gbc);
                        if (b.getParent() != null) {
                            int n = nstartx + 1;
                            PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + 1;
                            System.out.println("added output " + b.region + " at " + b.gbc.gridx + ", " + b.gbc.gridy);
                        }
                        b.added = true;
                        b.create(depth - 1, nstartx + 1);
                    } else {
                        b.ensureCreatedToDepth(depth - 1, nstartx + 1);
                    }
                    ++i;
                }
            }
            if ((v = this.getContents()) != null && PathwayDiagram.this.showContents) {
                int i = 0;
                while (i < v.size()) {
                    b = (Box)v.get(i);
                    if (!b.added) {
                        b.gbc.gridy = this.getComponentCount();
                        this.add((Component)b, b.gbc);
                        if (b.getParent() != null) {
                            System.out.println("added content " + b.region + " into " + this.region + " at " + b.gbc.gridx + ", " + b.gbc.gridy);
                            if (PathwayDiagram.this.columnnums[nstartx] >= this.gbc.gridy + this.gbc.gridheight && this.getParent() != null) {
                                int j = 0;
                                while (j < this.getParent().getComponentCount()) {
                                    c2 = this.getParent().getComponent(j);
                                    gbc1 = PathwayDiagram.this.gbl.getConstraints(c2);
                                    if (gbc1.gridx == nstartx && gbc1.gridy >= this.gbc.gridy && this != c2) {
                                        ++gbc1.gridy;
                                        PathwayDiagram.this.gbl.setConstraints(c2, gbc1);
                                        System.out.println("shifed " + ((Box)c2).region + " down to " + gbc1.gridx + ", " + gbc1.gridy);
                                    }
                                    ++j;
                                }
                            }
                            ++this.gbc.gridheight;
                            PathwayDiagram.this.gbl.setConstraints(this, this.gbc);
                            int n = startx;
                            PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + b.gbc.gridheight;
                            System.out.println("resized " + this.region + " up to " + this.gbc.gridheight + " at " + this.gbc.gridx + ", " + this.gbc.gridy);
                        }
                        b.added = true;
                        b.create(depth - 1, startx);
                    } else if (b.getParent() == PathwayDiagram.this) {
                        Container op = b.getParent();
                        if (op != null) {
                            int n = b.getColumn();
                            PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] - b.gbc.gridheight;
                            op.remove(b);
                            b.gbc.gridx = 0;
                            b.gbc.gridy = PathwayDiagram.this.columnnums[this.getColumn()];
                            this.add((Component)b, b.gbc);
                            if (b.getParent() != null) {
                                int n2 = this.getColumn();
                                PathwayDiagram.this.columnnums[n2] = PathwayDiagram.this.columnnums[n2] + b.gbc.gridheight;
                                System.out.println("placed " + b.region + " into " + this.region + " sz " + this.gbc.gridheight + " at " + this.gbc.gridx + ", " + this.gbc.gridy);
                            }
                        }
                        b.ensureCreatedToDepth(depth - 1, startx);
                    }
                    ++i;
                }
            }
            if ((v = this.getParents()) != null && PathwayDiagram.this.showParents) {
                if (v.size() > 1) {
                    System.out.println("item " + this.region + " has " + v.size() + " parents:");
                    int i = 0;
                    while (i < v.size()) {
                        System.out.println(" - " + ((Box)v.get((int)i)).region.name);
                        ++i;
                    }
                    i = 1;
                    while (i < v.size()) {
                        b = (Box)v.get(i);
                        if (!b.added) {
                            PathwayDiagram.this.boxes.remove(b);
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < 1) {
                    b = (Box)v.get(i);
                    if (this.getParent() != b) {
                        if (!b.added) {
                            if (this.getParent() != null) {
                                b.gbc.gridx = startx;
                                b.gbc.gridy = this.gbc.gridy;
                                b.gbc.gridheight = b.countAllDisplayedChildren() + this.countAllDisplayedChildren();
                            } else {
                                b.gbc.gridx = startx;
                                b.gbc.gridy = PathwayDiagram.this.columnnums[startx];
                                b.gbc.gridheight = b.countAllDisplayedChildren() + this.countAllDisplayedChildren();
                            }
                            PathwayDiagram.this.add((Component)b, b.gbc);
                            if (b.getParent() != null) {
                                int n = startx;
                                PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + (b.gbc.gridheight - this.gbc.gridheight);
                                System.out.println("added parent " + b.region + " of " + this.region + " at " + b.gbc.gridx + ", " + b.gbc.gridy + ", h=" + b.gbc.gridheight);
                            }
                            b.added = true;
                            PathwayDiagram.this.remove(this);
                            this.gbc.gridx = 0;
                            this.gbc.gridy = b.countAllDisplayedChildren();
                            b.add((Component)this, this.gbc);
                            if (this.getParent() != null) {
                                System.out.println("put " + this.region + " into " + b.region + " at " + this.gbc.gridx + ", " + this.gbc.gridy + ", h=" + this.gbc.gridheight);
                            }
                            b.create(depth - 1, startx);
                        } else {
                            PathwayDiagram.this.remove(this);
                            this.gbc.gridx = 0;
                            this.gbc.gridy = b.countAllDisplayedChildren();
                            b.add((Component)this, this.gbc);
                            if (this.getParent() != null) {
                                ++b.gbc.gridheight;
                                PathwayDiagram.this.gbl.setConstraints(b, b.gbc);
                                System.out.println("added child " + this.region + " into " + b.region + " at " + this.gbc.gridx + ", " + this.gbc.gridy);
                            }
                            if (PathwayDiagram.this.columnnums[b.gbc.gridx] >= b.gbc.gridy + b.gbc.gridheight && b.getParent() != null) {
                                int j = 0;
                                while (j < b.getParent().getComponentCount()) {
                                    c2 = b.getParent().getComponent(j);
                                    gbc1 = PathwayDiagram.this.gbl.getConstraints(c2);
                                    if (gbc1.gridx == b.gbc.gridx && gbc1.gridy >= b.gbc.gridy && b != c2) {
                                        ++gbc1.gridy;
                                        PathwayDiagram.this.gbl.setConstraints(c2, gbc1);
                                        System.out.println("shifed " + ((Box)c2).region + " down to " + gbc1.gridx + ", " + gbc1.gridy);
                                    }
                                    ++j;
                                }
                            }
                            b.ensureCreatedToDepth(depth - 1, startx);
                        }
                    }
                    ++i;
                }
            }
            if (PathwayDiagram.this.showCarries && (v = this.getCarries()) != null) {
                Box b1;
                this.numCarries += v.size();
                this.wiresTo = new Vector();
                Vector<Box> toCreateLeft = new Vector<Box>();
                Vector<Box> toCreateRight = new Vector<Box>();
                int i = 0;
                while (i < v.size()) {
                    b1 = (Box)v.get(i);
                    Vector v2 = b1.getInputs();
                    if (!b1.added) {
                        b1.gbc.gridx = startx + 1;
                        b1.gbc.gridy = PathwayDiagram.this.columnnums[startx + 1];
                        PathwayDiagram.this.add((Component)b1, b1.gbc);
                        if (b1.getParent() != null) {
                            System.out.println("added via dest " + b1.region + " of " + this.region + " at " + b1.gbc.gridx + ", " + b1.gbc.gridy);
                            int n = startx + 1;
                            PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + 1;
                        }
                        b1.added = true;
                        b1.createdDepth = depth - 1;
                        toCreateLeft.add(b1);
                    }
                    int j = 0;
                    while (j < v2.size()) {
                        Box b2 = (Box)v2.get(j);
                        if (!b2.added) {
                            b2.gbc.gridx = startx - 1;
                            b2.gbc.gridy = PathwayDiagram.this.columnnums[startx - 1];
                            PathwayDiagram.this.add((Component)b2, b2.gbc);
                            if (b2.getParent() != null) {
                                System.out.println("added via src " + b2.region + " of " + this.region + " at " + b2.gbc.gridx + ", " + b2.gbc.gridy);
                                int n = startx - 1;
                                PathwayDiagram.this.columnnums[n] = PathwayDiagram.this.columnnums[n] + 1;
                            }
                            b2.added = true;
                            b2.createdDepth = depth - 1;
                            toCreateRight.add(b2);
                        }
                        ++j;
                    }
                    this.wiresTo.add(b1);
                    ++i;
                }
                i = 0;
                while (i < toCreateLeft.size()) {
                    b1 = (Box)toCreateLeft.get(i);
                    b1.create(depth - 1, startx + 1);
                    ++i;
                }
                int j = 0;
                while (j < toCreateRight.size()) {
                    Box b2 = (Box)toCreateRight.get(j);
                    b2.create(depth - 1, startx - 1);
                    ++j;
                }
                Container par = this.getParent();
                if (par != null) {
                    par.remove(this);
                    par.add((Component)this, this.gbc);
                    System.out.println("moved " + this.region + " to " + this.gbc.gridx + ", " + this.gbc.gridy + ", ht " + this.gbc.gridheight);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (PathwayDiagram.this.selection.getSelectedRegion() != this.region) {
                PathwayDiagram.this.selection.setSelectedRegion(this.region);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class DiagramUpdater
    implements Runnable {
        boolean reinvoke = false;
        boolean running = false;
        CNSData.Region region;

        DiagramUpdater() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            this.reinvoke = true;
            if (!this.running) ** GOTO lbl12
            return;
lbl-1000:
            // 1 sources

            {
                this.reinvoke = false;
                this.running = true;
                try {
                    PathwayDiagram.access$0(PathwayDiagram.this, this.region);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.running = false;
lbl12:
                // 2 sources

                ** while (this.reinvoke)
            }
lbl13:
            // 1 sources

            PathwayDiagram.this.invalidate();
            PathwayDiagram.this.validate();
            PathwayDiagram.this.repaint();
        }
    }
}

