/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import neurology.MasterImage;
import neurology.NeurologyMainPanel;
import neurology.SliceView;

public class PaintableSlice
extends SliceView {
    byte[] currentBits;
    int XSb;
    int XSp;
    int YS;
    ActionListener initialisePaintableImage;
    BufferedImage paintableImage = null;
    int penSelection = 4;
    byte[][] penShape;
    ActionListener paintListener = null;
    boolean hasPainted = false;
    boolean hasPaintedSinceDataUpdate = false;
    Color drawingBitsColour = Color.yellow;
    boolean paintDrawingBits = true;
    float drawingAlpha = 0.4f;
    JMenu penmenupopup = new JMenu("Pen");
    ActionListener clearListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PaintableSlice.this.clearBits();
            PaintableSlice.this.repaint();
        }
    };
    WritableRaster drawtemp;

    public PaintableSlice(NeurologyMainPanel p, URL imageResourceFile, MasterImage mi) {
        super(p, imageResourceFile, mi);
        this.popup.add(this.createPenMenu());
        this.clearAllLesionsMenuItem.addActionListener(this.clearListener);
    }

    public void setItem(String s) {
        this.currentBits = null;
        super.setItem(s);
    }

    void calculatePositions() {
        super.calculatePositions();
        this.XSb = this.image.getWidth(this) / 8 + 1;
        this.XSp = this.XSb * 8;
        this.YS = this.image.getHeight(this);
        this.currentBits = new byte[this.XSb * this.YS];
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        byte[] byArray2 = new byte[2];
        byArray2[1] = -1;
        byte[] byArray3 = new byte[2];
        byArray3[1] = -1;
        this.paintableImage = new BufferedImage(new IndexColorModel(1, 2, byArray, byArray2, new byte[2], byArray3), Raster.createWritableRaster(new MultiPixelPackedSampleModel(0, this.XSp, this.YS, 1), new DataBufferByte(this.currentBits, this.XSb * this.YS), new Point(0, 0)), false, null);
        if (this.initialisePaintableImage != null) {
            this.initialisePaintableImage.actionPerformed(null);
        }
        this.hasPainted = false;
        this.hasPaintedSinceDataUpdate = false;
    }

    public void addInitialisePaintableImageListener(ActionListener e) {
        this.initialisePaintableImage = AWTEventMulticaster.add(this.initialisePaintableImage, e);
    }

    public void setCurrentDrawingBitsAt(Point p, boolean t) {
        int ox = this.xs2i(p.x);
        int oy = this.ys2i(p.y);
        int ix = ox;
        int iy = oy;
        int psx = this.penShape.length;
        int psy = this.penShape[0].length;
        int dx = 0;
        while (dx < this.penShape.length) {
            int dy = 0;
            while (dy < this.penShape[0].length) {
                ix = ox + dx - psx / 2;
                iy = oy + dy - psy / 2;
                if (this.penShape[dx][dy] > 0 && ix > 0 && iy > 0 && ix < this.image.getWidth(this) && iy < this.image.getWidth(this)) {
                    int bit = 1 << 7 - ix % 8;
                    if (!t) {
                        int n = ix / 8 + iy * this.XSb;
                        this.currentBits[n] = (byte)(this.currentBits[n] & ~bit);
                    } else {
                        int n = ix / 8 + iy * this.XSb;
                        this.currentBits[n] = (byte)(this.currentBits[n] | bit);
                    }
                }
                ++dy;
            }
            ++dx;
        }
        this.hasPainted = true;
        this.hasPaintedSinceDataUpdate = true;
        if (this.paintListener != null) {
            this.paintListener.actionPerformed(new ActionEvent(this, 0, ""));
        }
        this.repaint();
    }

    public void paintHighlights(Graphics g) {
        super.paintHighlights(g);
        if (this.paintDrawingBits && this.currentBits != null && this.paintableImage != null) {
            g.setColor(Color.yellow);
            Graphics2D g2 = (Graphics2D)g;
            AlphaComposite comp = AlphaComposite.getInstance(3, this.drawingAlpha);
            g2.setComposite(comp);
            g2.drawImage(this.paintableImage, 0, 0, this.getWidth(), this.getHeight(), (int)this.xp, (int)this.yp, (int)(this.xp + (double)this.getWidth() * this.zoom), (int)(this.yp + (double)this.getHeight() * this.zoom), this);
        }
    }

    JMenu createPenMenu() {
        ButtonGroup bg = new ButtonGroup();
        int i = 0;
        while (i < 7) {
            JRadioButtonMenuItem penitem = new JRadioButtonMenuItem(new PenAction(i));
            bg.add(penitem);
            if (i == 4) {
                penitem.setSelected(true);
            }
            this.selectPen(4);
            this.penmenupopup.add(penitem);
            ++i;
        }
        return this.penmenupopup;
    }

    void selectPen(int type) {
        if (type < 0 || type >= 7) {
            return;
        }
        this.penSelection = type;
        switch (type) {
            case 0: {
                this.penShape = new byte[][]{{1}};
                return;
            }
            case 1: {
                this.penShape = new byte[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}};
                return;
            }
            case 2: {
                this.penShape = new byte[][]{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}};
                return;
            }
            case 3: {
                this.penShape = new byte[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}};
                return;
            }
            case 4: {
                this.penShape = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}};
                return;
            }
            case 5: {
                byte[][] byArrayArray = new byte[9][];
                byte[] byArray = new byte[9];
                byArray[3] = 1;
                byArray[4] = 1;
                byArray[5] = 1;
                byArrayArray[0] = byArray;
                byte[] byArray2 = new byte[9];
                byArray2[2] = 1;
                byArray2[3] = 1;
                byArray2[4] = 1;
                byArray2[5] = 1;
                byArray2[6] = 1;
                byArrayArray[1] = byArray2;
                byte[] byArray3 = new byte[9];
                byArray3[1] = 1;
                byArray3[2] = 1;
                byArray3[3] = 1;
                byArray3[4] = 1;
                byArray3[5] = 1;
                byArray3[6] = 1;
                byArray3[7] = 1;
                byArrayArray[2] = byArray3;
                byArrayArray[3] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
                byArrayArray[4] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
                byArrayArray[5] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
                byte[] byArray4 = new byte[9];
                byArray4[1] = 1;
                byArray4[2] = 1;
                byArray4[3] = 1;
                byArray4[4] = 1;
                byArray4[5] = 1;
                byArray4[6] = 1;
                byArray4[7] = 1;
                byArrayArray[6] = byArray4;
                byte[] byArray5 = new byte[9];
                byArray5[2] = 1;
                byArray5[3] = 1;
                byArray5[4] = 1;
                byArray5[5] = 1;
                byArray5[6] = 1;
                byArrayArray[7] = byArray5;
                byte[] byArray6 = new byte[9];
                byArray6[3] = 1;
                byArray6[4] = 1;
                byArray6[5] = 1;
                byArrayArray[8] = byArray6;
                this.penShape = byArrayArray;
                return;
            }
            case 6: {
                byte[][] byArrayArray = new byte[12][];
                byte[] byArray = new byte[12];
                byArray[4] = 1;
                byArray[5] = 1;
                byArray[6] = 1;
                byArray[7] = 1;
                byArrayArray[0] = byArray;
                byte[] byArray7 = new byte[12];
                byArray7[2] = 1;
                byArray7[3] = 1;
                byArray7[4] = 1;
                byArray7[5] = 1;
                byArray7[6] = 1;
                byArray7[7] = 1;
                byArray7[8] = 1;
                byArray7[9] = 1;
                byArrayArray[1] = byArray7;
                byte[] byArray8 = new byte[12];
                byArray8[1] = 1;
                byArray8[2] = 1;
                byArray8[3] = 1;
                byArray8[4] = 1;
                byArray8[5] = 1;
                byArray8[6] = 1;
                byArray8[7] = 1;
                byArray8[8] = 1;
                byArray8[9] = 1;
                byArrayArray[2] = byArray8;
                byte[] byArray9 = new byte[12];
                byArray9[1] = 1;
                byArray9[2] = 1;
                byArray9[3] = 1;
                byArray9[4] = 1;
                byArray9[5] = 1;
                byArray9[6] = 1;
                byArray9[7] = 1;
                byArray9[8] = 1;
                byArray9[9] = 1;
                byArrayArray[3] = byArray9;
                byArrayArray[4] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                byArrayArray[5] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                byArrayArray[6] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                byArrayArray[7] = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                byte[] byArray10 = new byte[12];
                byArray10[1] = 1;
                byArray10[2] = 1;
                byArray10[3] = 1;
                byArray10[4] = 1;
                byArray10[5] = 1;
                byArray10[6] = 1;
                byArray10[7] = 1;
                byArray10[8] = 1;
                byArray10[9] = 1;
                byArrayArray[8] = byArray10;
                byte[] byArray11 = new byte[12];
                byArray11[1] = 1;
                byArray11[2] = 1;
                byArray11[3] = 1;
                byArray11[4] = 1;
                byArray11[5] = 1;
                byArray11[6] = 1;
                byArray11[7] = 1;
                byArray11[8] = 1;
                byArray11[9] = 1;
                byArrayArray[9] = byArray11;
                byte[] byArray12 = new byte[12];
                byArray12[2] = 1;
                byArray12[3] = 1;
                byArray12[4] = 1;
                byArray12[5] = 1;
                byArray12[6] = 1;
                byArray12[7] = 1;
                byArray12[8] = 1;
                byArray12[9] = 1;
                byArrayArray[10] = byArray12;
                byte[] byArray13 = new byte[12];
                byArray13[4] = 1;
                byArray13[5] = 1;
                byArray13[6] = 1;
                byArray13[7] = 1;
                byArrayArray[11] = byArray13;
                this.penShape = byArrayArray;
                return;
            }
        }
    }

    void clearBits() {
        int i = 0;
        while (i < this.XSb * this.YS) {
            this.currentBits[i] = 0;
            ++i;
        }
    }

    public boolean writeNewMapImage(int paintColourIndex, OutputStream os) throws IOException {
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!(this.mapColorModel instanceof IndexColorModel)) {
                throw new RuntimeException("Map image is not indexed.");
            }
            BufferedImage im = new BufferedImage(this.map.getWidth(), this.map.getHeight(), 13, (IndexColorModel)this.mapColorModel);
            im.getGraphics().drawImage(this.mapimage, 0, 0, this);
            int pixelCount = 0;
            int i = 0;
            while (i < im.getWidth()) {
                int j = 0;
                while (j < im.getHeight()) {
                    if (this.getCurrentBit(i, j)) {
                        im.getRaster().setPixel(i, j, new int[]{paintColourIndex});
                        ++pixelCount;
                    } else if (im.getRaster().getPixel(i, j, this.tmp)[0] == paintColourIndex) {
                        im.getRaster().setPixel(i, j, new int[1]);
                    }
                    ++j;
                }
                ++i;
            }
            if (pixelCount == 0) {
                JOptionPane.showMessageDialog(this, "The region " + this.selection.selection.friendlyName + " is not visible in this slice " + this.sliceItemName + ", but has not been deleted fully.", "Warning", 2);
            }
            boolean bl = ImageIO.write((RenderedImage)im, "gif", os);
            return bl;
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    final boolean getCurrentBit(int x, int y) {
        int b = 1 << 7 - x % 8;
        return (this.currentBits[x / 8 + y * this.XSb] & b) > 0;
    }

    final void setCurrentBit(int x, int y, boolean t) {
        int b = 1 << 7 - x % 8;
        if (t) {
            int n = x / 8 + y * this.XSb;
            this.currentBits[n] = (byte)(this.currentBits[n] | b);
        } else {
            int n = x / 8 + y * this.XSb;
            this.currentBits[n] = (byte)(this.currentBits[n] & ~b);
        }
    }

    void savePaintedRegion(boolean alsoSaveCNSData) {
        FileOutputStream os;
        File f;
        int choice;
        JFileChooser fc;
        SliceView.MapRegion r = this.getRegion(this.selection.selection);
        boolean propertiesChanged = false;
        if (this.hasPainted) {
            int itemIndex;
            if (r != null) {
                itemIndex = r.index;
            } else {
                propertiesChanged = true;
                itemIndex = this.mapRegions.size() + 1;
                String sliceRegionProp = String.valueOf(this.sliceItemName) + "-regions";
                String sliceRegionList = String.valueOf(this.props.getProperty(sliceRegionProp)) + ", " + this.selection.selection.name;
                this.props.setProperty(sliceRegionProp, sliceRegionList);
            }
            fc = new JFileChooser();
            fc.setAcceptAllFileFilterUsed(true);
            fc.addChoosableFileFilter(NeurologyMainPanel.gifFilter);
            fc.setSelectedFile(new File(this.im[1]));
            choice = fc.showSaveDialog(this);
            if (choice == 0) {
                try {
                    f = fc.getSelectedFile();
                    os = new FileOutputStream(f);
                    if (!this.writeNewMapImage(itemIndex - 1, os)) {
                        throw new IOException("No writer found");
                    }
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "<HTML>Error saving image " + fc.getSelectedFile() + ": " + e + "<BR>You need Java 1.6 or newer to save GIF files - (copyright issues)</HTML>", "Unable to save image", 0);
                    e.printStackTrace();
                }
            }
        }
        if (propertiesChanged) {
            fc = new JFileChooser();
            fc.setAcceptAllFileFilterUsed(true);
            fc.addChoosableFileFilter(NeurologyMainPanel.textFilter);
            fc.setSelectedFile(new File("Images.txt"));
            choice = fc.showSaveDialog(this);
            if (choice == 0) {
                try {
                    f = fc.getSelectedFile();
                    os = new FileOutputStream(f);
                    this.props.store(os, "Images.txt - data for Neurology slices (c) Sanjay Manohar");
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error saving image properties file +" + fc.getSelectedFile() + ": " + e, "Unable to save image properties", 0);
                    e.printStackTrace();
                }
            }
        }
        if (alsoSaveCNSData) {
            fc = new JFileChooser();
            fc.setAcceptAllFileFilterUsed(true);
            fc.addChoosableFileFilter(NeurologyMainPanel.textFilter);
            fc.setSelectedFile(new File("Neurology.txt"));
            choice = fc.showSaveDialog(this);
            if (choice == 0) {
                try {
                    f = fc.getSelectedFile();
                    os = new FileOutputStream(f);
                    this.data.store(os);
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Error saving neurology properties file +" + fc.getSelectedFile() + ": " + e, "Unable to save neurology data", 0);
                    e.printStackTrace();
                }
            }
        }
    }

    double getPaintOverlap(SliceView.MapRegion r) {
        boolean count = false;
        if (this.drawtemp == null) {
            this.drawtemp = this.paintableImage.getRaster().createCompatibleWritableRaster();
        }
        return 0.0;
    }

    class PenAction
    extends AbstractAction {
        int type;

        PenAction(int i) {
            super("Pen " + i);
            this.type = i;
        }

        public void actionPerformed(ActionEvent e) {
            PaintableSlice.this.selectPen(this.type);
        }
    }
}

