/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import neurology.CNSData;
import neurology.ExaminationPanel;
import neurology.MasterImage;
import neurology.OptionsPanel;
import neurology.PaintableSlice;
import neurology.RegionList;
import neurology.RegionProperties;
import neurology.Selection;

public class NeurologyMainPanel
extends JPanel {
    static String imagesExternalResourcePath;
    static String neurologyExternalResourcePath;
    static String imageFolderExternalResourcePath;
    static NeurologyMainPanel mainpanel;
    Thread loaderThread = null;
    Runnable dataLoader = new Runnable(){

        public void run() {
            Selection.data = NeurologyMainPanel.this.data = new CNSData(NeurologyMainPanel.getResource("Neurology.txt"));
            NeurologyMainPanel.this.examinationPanel1.setData(NeurologyMainPanel.this.data);
            NeurologyMainPanel.this.sliceView1.setData(NeurologyMainPanel.this.data);
            NeurologyMainPanel.this.regionList.updateList();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    (this).NeurologyMainPanel.this.data.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ((this).this).NeurologyMainPanel.this.examinationPanel1.update();
                            ((this).this).NeurologyMainPanel.this.sliceView1.update();
                            if (((this).this).NeurologyMainPanel.this.regionList.lesiononlycheck.isSelected()) {
                                ((this).this).NeurologyMainPanel.this.regionList.updateList();
                            }
                            ((this).this).NeurologyMainPanel.this.regionProperties1.pathwayDiagram1.update();
                        }
                    });
                }
            });
            NeurologyMainPanel.this.regionList.setData(NeurologyMainPanel.this.data);
            NeurologyMainPanel.this.masterImage1.getCurrentSubimage().selectSlice(0);
            NeurologyMainPanel.this.data.recalculate();
            NeurologyMainPanel.this.regionList.setSliceView(NeurologyMainPanel.this.sliceView1);
            NeurologyMainPanel.this.regionList.setMasterImage(NeurologyMainPanel.this.masterImage1);
        }
    };
    RegionList regionList = new RegionList();
    Selection selection = new Selection(){};
    CNSData data;
    static boolean DEBUG;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel leftPanel = new JPanel();
    JSplitPane jSplitUD1 = new JSplitPane();
    JSplitPane jSplitLR2 = new JSplitPane();
    JPanel lowerPane = new JPanel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane examinationScrollPanel = new JScrollPane();
    ExaminationPanel examinationPanel1;
    JPanel rightPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel onexaminationLabel = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    RegionProperties regionProperties1 = new RegionProperties();
    JPanel jPanel8 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    MasterImage masterImage1 = new MasterImage(this);
    PaintableSlice sliceView1 = new PaintableSlice(this, NeurologyMainPanel.getResource("Images.txt"), this.masterImage1);
    JSplitPane jSplitLR0 = new JSplitPane();
    BorderLayout borderLayout8 = new BorderLayout();
    OptionsPanel optionsPanel1 = new OptionsPanel();
    public static FileFilter gifFilter;
    public static FileFilter textFilter;
    ActionListener paintListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
        }
    };

    static {
        DEBUG = false;
        gifFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("gif");
            }

            public String getDescription() {
                return "GIF image files";
            }
        };
        textFilter = new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("txt");
            }

            public String getDescription() {
                return "Text files";
            }
        };
    }

    public NeurologyMainPanel() {
        this.examinationPanel1 = new ExaminationPanel(this);
        mainpanel = this;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.masterImage1.addActionListener(this.sliceView1);
        this.masterImage1.addActionListener(this.regionList);
        this.examinationPanel1.addActionListener(this.selection);
        this.examinationPanel1.motor.addActionListener(this.selection);
        this.examinationPanel1.reflex.addActionListener(this.selection);
        this.loaderThread = new Thread(this.dataLoader);
        this.loaderThread.start();
    }

    public static Color getLesionColor(double lesion) {
        return new Color(192, 192 + (int)(63.0 * lesion), 192);
    }

    public static Color getLesionPrimary() {
        return Color.green;
    }

    public static URL getResource(String resource) {
        URL s;
        if (resource == "Images.txt" && imagesExternalResourcePath != null) {
            try {
                return new File(imagesExternalResourcePath).toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Unable to load image properties " + imagesExternalResourcePath, "Warning", 2);
            }
        }
        if ((s = NeurologyMainPanel.class.getResource(resource)) == null) {
            String message = "Can't open resource " + resource;
            if (DEBUG) {
                throw new RuntimeException(message);
            }
            JOptionPane.showMessageDialog(null, message, "Error reading file", 0);
        }
        return s;
    }

    public static Image getImage(String resource) {
        if (imagesExternalResourcePath != null) {
            return Toolkit.getDefaultToolkit().createImage(new File(imagesExternalResourcePath, resource).getAbsolutePath());
        }
        URL res = NeurologyMainPanel.getResource(resource);
        if (res == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(res);
    }

    private void jbInit() throws Exception {
        this.regionProperties1.neurologyMainPanel = this;
        this.setLayout(this.borderLayout1);
        this.jSplitUD1.setOrientation(0);
        this.jSplitUD1.setLastDividerLocation(315);
        this.jSplitUD1.setResizeWeight(0.5);
        this.jSplitLR2.setOrientation(1);
        this.jSplitLR2.setLastDividerLocation(250);
        this.jSplitLR2.setResizeWeight(0.5);
        this.rightPanel.setLayout(this.borderLayout2);
        this.jPanel4.setLayout(this.borderLayout3);
        this.onexaminationLabel.setText("On examination:");
        this.jTabbedPane1.setTabPlacement(3);
        this.jPanel8.setLayout(this.borderLayout6);
        this.leftPanel.setLayout(this.borderLayout7);
        this.jSplitLR0.setOrientation(1);
        this.lowerPane.setLayout(this.borderLayout8);
        this.rightPanel.add((Component)this.examinationScrollPanel, "Center");
        this.examinationScrollPanel.getVerticalScrollBar().setBlockIncrement(200);
        this.rightPanel.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.onexaminationLabel, "West");
        Font oefont = this.onexaminationLabel.getFont();
        this.onexaminationLabel.setFont(new Font(oefont.getName(), 3, oefont.getSize() + 4));
        this.jSplitLR2.add((Component)this.jTabbedPane1, "top");
        this.examinationScrollPanel.getViewport().add((Component)this.examinationPanel1, null);
        this.jSplitLR2.add((Component)this.rightPanel, "bottom");
        this.jTabbedPane1.add((Component)this.jPanel8, "Slice");
        this.jPanel8.add((Component)this.sliceView1, "Center");
        this.jSplitUD1.add((Component)this.lowerPane, "bottom");
        this.lowerPane.add((Component)this.regionProperties1, "Center");
        this.jTabbedPane1.add((Component)this.regionList, "List");
        this.jTabbedPane1.add((Component)this.optionsPanel1, "Options");
        this.jSplitUD1.add((Component)this.jSplitLR2, "top");
        this.add((Component)this.jSplitLR0, "Center");
        this.jSplitLR0.add((Component)this.leftPanel, "top");
        this.leftPanel.add((Component)this.masterImage1, "Center");
        this.jSplitLR0.add((Component)this.jSplitUD1, "bottom");
        this.jSplitUD1.setDividerLocation(0.8);
        this.jSplitUD1.setResizeWeight(0.8);
        this.jSplitLR2.setDividerLocation(0.26);
        this.jSplitLR2.setResizeWeight(0.3);
        this.jSplitLR0.setDividerLocation(0.14);
        this.jSplitLR0.setResizeWeight(0.14);
        this.optionsPanel1.setMainPanel(this);
        this.sliceView1.paintListener = this.paintListener;
    }

    public static String friendlyName(String s) {
        if (s.length() == 0) {
            return "";
        }
        return (String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1)).replace('-', ' ');
    }

    public static Color lesionGreyscale(Color unlesioned, double f) {
        Color p = NeurologyMainPanel.getLesionPrimary();
        Color u = unlesioned;
        return new Color(p.getRed() + (int)(f * (double)(u.getRed() - p.getRed())), p.getGreen() + (int)(f * (double)(u.getGreen() - p.getGreen())), p.getBlue() + (int)(f * (double)(u.getBlue() - p.getBlue())));
    }
}

