/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import neurology.CNSData;
import neurology.NeurologyMainPanel;

public class MotorExamination
extends JPanel {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jLabel11 = new JLabel();
    JLabel jLabel12 = new JLabel();
    JLabel jLabel13 = new JLabel();
    JLabel jLabel14 = new JLabel();
    JLabel jLabel15 = new JLabel();
    JLabel jLabel16 = new JLabel();
    JLabel jLabel17 = new JLabel();
    JLabel jLabel18 = new JLabel();
    JLabel jLabel19 = new JLabel();
    JLabel jLabel20 = new JLabel();
    JLabel jLabel21 = new JLabel();
    Border border1;
    Border border2;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    PowerLabel[][] powlabel = new PowerLabel[4][11];
    CNSData data;
    String[][] muscles = new String[][]{{"deltoid", "arm-motor-strip"}, {"biceps", "arm-motor-strip"}, {"triceps", "arm-motor-strip"}, {"flexor-carpi-radialis", "arm-motor-strip"}, {"extensor-carpi-radialis", "arm-motor-strip"}, {"flexor-digitorum", "hand-motor-strip"}, {"extensor-digitorum", "arm-motor-strip"}, {"interossei", "hand-motor-strip"}, {"opponens-pollicis", "hand-motor-strip"}, {"abductor-pollicis-brevis", "hand-motor-strip"}, {"psoas", "leg-motor-strip"}, {"gluteus", "leg-motor-strip"}, {"adductor-magnus", "leg-motor-strip"}, {"gluteus", "leg-motor-strip"}, {"hamstrings", "leg-motor-strip"}, {"quadriceps", "leg-motor-strip"}, {"tibialis-anterior", "leg-motor-strip"}, {"gastrocnemius", "leg-motor-strip"}, {"peroneus-longus", "leg-motor-strip"}, {"tibialis-posterior", "leg-motor-strip"}, {"extensor-hallucis-longus", "leg-motor-strip"}};
    double[] pyr = new double[]{0.5, 0.0, 0.5, 0.0, 0.5, 0.0, 0.5, 0.5, 0.5, 0.5, 0.0, 0.5, 0.0, 0.0, 0.5, 0.5, 0.0, 0.5, 0.0, 0.5, 0.5};
    String[] sides = new String[]{"-right", "-left"};
    ActionListener al;
    GridBagConstraints tmpGBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    GridLayout gridLayout1 = new GridLayout();

    public void setData(CNSData d) {
        this.data = d;
        this.update();
    }

    void update() {
        int i = 0;
        while (i < this.muscles.length) {
            int j = 0;
            while (j < 2) {
                String s1 = this.sides[j % 2];
                String s2 = this.sides[(j + 1) % 2];
                CNSData.Region m = this.data.findRegion(String.valueOf(this.muscles[i][0]) + s1);
                CNSData.Region cx = this.data.findRegion(String.valueOf(this.muscles[i][1]) + s2);
                CNSData.Region umn = null;
                if (m.input.size() > 0) {
                    umn = (CNSData.Region)m.input.get(0);
                }
                double p = m.getActivityFrom(cx);
                if (umn != null) {
                    p = Math.min(1.0, Math.max(0.0, 1.4 * p - 0.5 * this.pyr[i] * m.getActivityFrom(umn)));
                }
                this.powlabel[j + (i > 9 ? 2 : 0)][i - (i > 9 ? 10 : 0)].setPower(p);
                ++j;
            }
            ++i;
        }
    }

    public MotorExamination() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 10 + (i > 1 ? 1 : 0)) {
                int a = j + 10 * (i / 2);
                String side = i % 2 == 0 ? "-right" : "-left";
                String m = String.valueOf(this.muscles[a][0]) + side;
                this.powlabel[i][j] = new PowerLabel(m, this.al);
                if (i < 2) {
                    this.jPanel1.add((Component)this.powlabel[i][j], this.gbc(i % 2 + 1, j));
                } else {
                    this.jPanel2.add((Component)this.powlabel[i][j], this.gbc(i % 2 + 1, j));
                }
                ++j;
            }
            ++i;
        }
    }

    void setMuscleAL(ActionListener al) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 10 + (i > 1 ? 1 : 0)) {
                this.powlabel[i][j].al = al;
                ++j;
            }
            ++i;
        }
    }

    public void addActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.add(a, this.al);
        this.setMuscleAL(this.al);
    }

    public void removeActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.remove(a, this.al);
        this.setMuscleAL(this.al);
    }

    public GridBagConstraints gbc(int x, int y) {
        this.tmpGBC.gridx = x;
        this.tmpGBC.gridy = y;
        return this.tmpGBC;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(new EtchedBorder(0), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.border2 = BorderFactory.createCompoundBorder(new EtchedBorder(0), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(this.gridLayout1);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jLabel1.setToolTipText("Shoulder abduction");
        this.jLabel1.setText("Sh Ab");
        this.jLabel2.setToolTipText("Elbow flexion");
        this.jLabel2.setText("EF");
        this.jLabel3.setText("EE");
        this.jLabel5.setToolTipText("Wrist extension");
        this.jLabel5.setText("WE");
        this.jLabel6.setToolTipText("Finger flexion");
        this.jLabel6.setText("FF");
        this.jLabel7.setToolTipText("Finger extension");
        this.jLabel7.setText("FE");
        this.jLabel8.setToolTipText("Finger abduction");
        this.jLabel8.setText("F Ab");
        this.jLabel9.setToolTipText("Opponens pollicis");
        this.jLabel9.setText("Opp");
        this.jLabel10.setToolTipText("Abductor pollicis brevis");
        this.jLabel10.setText("APB");
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.jLabel11.setToolTipText("Hip flexion");
        this.jLabel11.setText("HF");
        this.jLabel12.setToolTipText("Hip extension");
        this.jLabel12.setText("HE");
        this.jLabel13.setToolTipText("Hip abduction");
        this.jLabel13.setText("H Ab");
        this.jLabel14.setToolTipText("Hip adduction");
        this.jLabel14.setText("H Ad");
        this.jLabel15.setToolTipText("Knee flexion");
        this.jLabel15.setText("KF");
        this.jLabel16.setToolTipText("Knee extension");
        this.jLabel16.setText("KE");
        this.jLabel17.setToolTipText("Ankle plantar-flexion");
        this.jLabel17.setText("AP");
        this.jLabel18.setToolTipText("Ankle dorsiflexion (extension)");
        this.jLabel18.setText("AD");
        this.jLabel19.setToolTipText("Ankle eversion");
        this.jLabel19.setText("A Ev");
        this.jLabel20.setToolTipText("Ankle inversion");
        this.jLabel20.setText("A Inv");
        this.jLabel21.setToolTipText("Extensor hallucis longus");
        this.jLabel21.setText("EHL");
        this.jLabel4.setToolTipText("Wrist flexion");
        this.jLabel4.setText("WF");
        this.jPanel1.setBorder(this.border1);
        this.jPanel2.setBorder(this.border2);
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jLabel1, this.gbc(0, 0));
        this.jPanel1.add((Component)this.jLabel2, this.gbc(0, 1));
        this.jPanel1.add((Component)this.jLabel3, this.gbc(0, 2));
        this.jPanel1.add((Component)this.jLabel4, this.gbc(0, 3));
        this.jPanel1.add((Component)this.jLabel5, this.gbc(0, 4));
        this.jPanel1.add((Component)this.jLabel6, this.gbc(0, 5));
        this.jPanel1.add((Component)this.jLabel7, this.gbc(0, 6));
        this.jPanel1.add((Component)this.jLabel8, this.gbc(0, 7));
        this.jPanel1.add((Component)this.jLabel9, this.gbc(0, 8));
        this.jPanel1.add((Component)this.jLabel10, this.gbc(0, 9));
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jLabel11, this.gbc(0, 0));
        this.jPanel2.add((Component)this.jLabel12, this.gbc(0, 1));
        this.jPanel2.add((Component)this.jLabel13, this.gbc(0, 2));
        this.jPanel2.add((Component)this.jLabel14, this.gbc(0, 3));
        this.jPanel2.add((Component)this.jLabel15, this.gbc(0, 4));
        this.jPanel2.add((Component)this.jLabel16, this.gbc(0, 5));
        this.jPanel2.add((Component)this.jLabel17, this.gbc(0, 6));
        this.jPanel2.add((Component)this.jLabel18, this.gbc(0, 7));
        this.jPanel2.add((Component)this.jLabel19, this.gbc(0, 8));
        this.jPanel2.add((Component)this.jLabel20, this.gbc(0, 9));
        this.jPanel2.add((Component)this.jLabel21, this.gbc(0, 10));
    }

    public static class PowerLabel
    extends JLabel {
        ActionListener al;
        double power;
        String[] powerTxt = new String[]{"0", "1", "2-", "2", "2+", "3-", "3", "3+", "4-", "4", "4+", "5-", "5"};

        public PowerLabel(String muscle, ActionListener al) {
            this.al = al;
            this.putClientProperty("muscle", muscle);
            this.addMouseListener(new LabelListener());
            this.setToolTipText(NeurologyMainPanel.friendlyName(muscle));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setPower(1.0);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height));
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(NeurologyMainPanel.getLesionColor(1.0 - this.power));
            g.fill3DRect(0, 0, (int)((double)this.getWidth() * this.power - 1.0), this.getHeight(), true);
            g.translate(4, 0);
            super.paint(g);
        }

        void setPower(double p) {
            this.power = Math.max(Math.min(p, 1.0), 0.0);
            int q = (int)(this.power * (double)(this.getNumPowers() - 1));
            this.setText(this.getPowerTxt(q));
        }

        public String getPowerTxt(int i) {
            return this.powerTxt[i];
        }

        public int getNumPowers() {
            return this.powerTxt.length;
        }

        class LabelListener
        extends MouseAdapter {
            LabelListener() {
            }

            public void mouseClicked(MouseEvent e) {
                ActionEvent ev = new ActionEvent(this, 0, ((JLabel)e.getSource()).getClientProperty("muscle").toString());
                if (PowerLabel.this.al != null) {
                    PowerLabel.this.al.actionPerformed(ev);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        }
    }
}

