/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import neurology.CNSData;
import neurology.NeurologyMainPanel;

public class MasterImage
extends JPanel {
    Image theImage;
    String imageList = "Images.txt";
    Properties props;
    String[] names;
    BorderLayout borderLayout1 = new BorderLayout();
    SubImage[] subimages;
    NeurologyMainPanel main;
    ActionListener actionListener;
    JTabbedPane jTabbedPane1 = new JTabbedPane();

    public MasterImage(NeurologyMainPanel main) {
        this();
        this.main = main;
        this.props = new Properties();
        try {
            this.props.load(NeurologyMainPanel.getResource(this.imageList).openStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.names = this.props.getProperty("master-images").split("\\s*,\\s*");
        this.subimages = new SubImage[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            try {
                String[] s = this.props.getProperty(String.valueOf(this.names[i]) + "-images").split("\\s*,\\s*");
                String[] a = this.props.getProperty(String.valueOf(this.names[i]) + "-slices").split("\\s*,\\s*");
                String[] t = this.props.getProperty(String.valueOf(this.names[i]) + "-axis").split("\\s*,\\s*");
                this.subimages[i] = new SubImage(s, a, t);
                this.jTabbedPane1.add(NeurologyMainPanel.friendlyName(this.names[i]), this.subimages[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("error at " + this.names[i]);
            }
            ++i;
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(al, this.actionListener);
    }

    protected MasterImage() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    void setSlice(String s) {
        int i = 0;
        while (i < this.subimages.length) {
            String[] items = this.subimages[i].items;
            int j = 0;
            while (j < items.length) {
                if (items[j].equals(s)) {
                    this.jTabbedPane1.setSelectedComponent(this.subimages[i]);
                    this.subimages[i].selectedSlice = j;
                    this.repaint();
                }
                ++j;
            }
            ++i;
        }
    }

    boolean findAndSelectRegion(CNSData.Region r) {
        int foundItem = -1;
        SubImage s = (SubImage)this.jTabbedPane1.getSelectedComponent();
        int n = -1;
        while (n < this.subimages.length) {
            int i = 0;
            while (i < s.items.length) {
                String[] regions = this.props.getProperty(String.valueOf(s.items[i]) + "-regions").split("\\s*,\\s*");
                int j = 0;
                while (j < regions.length) {
                    if (regions[j].equalsIgnoreCase(r.name)) {
                        if (s != this.jTabbedPane1.getSelectedComponent()) {
                            this.jTabbedPane1.setSelectedComponent(s);
                        }
                        s.selectSlice(i);
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            if (++n >= this.subimages.length) continue;
            s = this.subimages[n];
        }
        return false;
    }

    public SubImage getCurrentSubimage() {
        return (SubImage)this.jTabbedPane1.getSelectedComponent();
    }

    public void gotoNextSlice() {
        SubImage s = (SubImage)this.jTabbedPane1.getSelectedComponent();
        int i = s.selectedSlice;
        int max = s.items.length;
        if (++i < max) {
            s.selectSlice(i);
        }
    }

    public void gotoPreviousSlice() {
        SubImage s = (SubImage)this.jTabbedPane1.getSelectedComponent();
        int i = s.selectedSlice;
        int max = s.items.length;
        if (--i >= 0) {
            s.selectSlice(i);
        }
    }

    class SubImage
    extends JPanel
    implements ImageObserver,
    MouseListener,
    MouseMotionListener {
        static final boolean X = true;
        static final boolean Y = false;
        Image image;
        String[] items;
        boolean axis;
        int[] axisItems;
        int selectedSlice = -1;
        int hoverSlice = -1;
        double zoom = 1.0;

        SubImage(String[] imageNames, String[] slices, String[] itemAxis) {
            this.image = NeurologyMainPanel.getImage(imageNames[0]);
            this.items = slices;
            this.axis = itemAxis[0].equalsIgnoreCase("X");
            this.axisItems = new int[itemAxis.length - 1];
            if (this.axisItems.length != slices.length) {
                throw new IllegalStateException("Different numbers of items in " + imageNames[0]);
            }
            int i = 0;
            while (i < this.axisItems.length) {
                this.axisItems[i] = Integer.parseInt(itemAxis[i + 1]);
                ++i;
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setForeground(Color.white);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.image == null) {
                return;
            }
            if (this.image.getWidth(this) < 1) {
                return;
            }
            this.zoom = (double)this.getWidth() / (double)this.image.getWidth(this);
            g.drawImage(this.image, 0, 0, (int)((double)this.image.getWidth(this) * this.zoom), (int)((double)this.image.getHeight(this) * this.zoom), this);
            if (this.selectedSlice >= 0) {
                g.setColor(this.getForeground().darker());
                this.drawSliceLine(g, (int)((double)this.axisItems[this.selectedSlice] * this.zoom));
            }
            if (this.hoverSlice >= 0) {
                g.setColor(this.getForeground());
                this.drawSliceLine(g, (int)((double)this.axisItems[this.hoverSlice] * this.zoom));
            }
        }

        void drawSliceLine(Graphics g, int h) {
            if (this.axis) {
                g.drawLine(h, 0, h, this.getHeight());
            } else {
                g.drawLine(0, h, this.getWidth(), h);
            }
        }

        int getNearestSlice(int coord) {
            int nearest = -1;
            int dist = Integer.MAX_VALUE;
            coord = (int)((double)coord / this.zoom);
            int i = 0;
            while (i < this.axisItems.length) {
                int q = Math.abs(this.axisItems[i] - coord);
                if (q < dist) {
                    dist = q;
                    nearest = i;
                }
                ++i;
            }
            return nearest;
        }

        public void mouseClicked(MouseEvent e) {
            int h = this.axis ? e.getX() : e.getY();
            int sl = this.getNearestSlice(h);
            this.selectSlice(sl);
        }

        public void selectSlice(int i) {
            if (i >= 0 && i < this.items.length) {
                this.selectedSlice = i;
                if (MasterImage.this.actionListener != null) {
                    MasterImage.this.actionListener.actionPerformed(new ActionEvent(this, i, this.items[i]));
                }
                this.repaint();
            } else {
                System.out.println("Slice out of range: " + i);
            }
        }

        public void mouseMoved(MouseEvent e) {
            int sl;
            int h = this.axis ? e.getX() : e.getY();
            this.hoverSlice = sl = this.getNearestSlice(h);
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.hoverSlice = -1;
            this.repaint();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x20) > 0) {
                this.repaint();
            }
            return (infoflags & 0x20) == 0;
        }
    }
}

