/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import neurology.CNSData;
import neurology.NeurologyMainPanel;

public class HearingExamination
extends JPanel {
    JLabel rlabel = new JLabel();
    JPanel rpanel = new JPanel();
    Rinne[] rinn = new Rinne[2];
    Weber weber = new Weber();
    JPanel wpanel = new JPanel();
    JLabel descrLabel = new JLabel();
    JLabel wlabel = new JLabel(){

        public Dimension getPreferredSize() {
            return new Dimension(HearingExamination.this.getWidth() / 3, 20);
        }
    };
    CNSData data;
    String[] sides = new String[]{"right", "left"};
    double[] ac = new double[2];
    double[] bc = new double[2];

    HearingExamination() {
        this.setLayout(new BoxLayout(this, 1));
        this.rlabel.setText("Rinne");
        this.rpanel.setLayout(new GridLayout(1, 3));
        this.rpanel.add(this.rlabel);
        int i = 0;
        while (i < 2) {
            this.rinn[i] = new Rinne(i);
            this.rinn[i].setHorizontalAlignment(0);
            this.rpanel.add(this.rinn[i]);
            ++i;
        }
        this.wlabel.setText("Weber");
        this.wpanel.setLayout(new BorderLayout());
        this.wpanel.add((Component)this.wlabel, "West");
        this.wpanel.add((Component)this.weber, "Center");
        this.weber.setBorder(new BevelBorder(1));
        this.add(this.rpanel);
        this.add(this.wpanel);
        this.add(this.descrLabel);
    }

    void setData(CNSData d) {
        this.data = d;
    }

    public void update() {
        if (this.data == null) {
            return;
        }
        int i = 0;
        while (i < 2) {
            this.rinn[i].setText("Air > Bone");
            this.ac[i] = this.data.findRegion("auditory-cortex-left").getActivityFrom(this.data.findRegion("cochlea-" + this.sides[i]));
            ++i;
        }
        String d = "";
        double thr = 0.1;
        d = this.ac[0] == this.ac[1] ? (this.ac[0] == 1.0 ? "Normal hearing" : (this.ac[0] < 1.0 && this.ac[0] > thr ? "Symmetrical but quiet" : "Can't hear anything")) : (this.ac[0] < thr & this.ac[1] > thr ? "Can't hear anything on the right" : (this.ac[0] > thr & this.ac[1] < thr ? "Can't hear anything on the left" : (this.ac[0] < thr & this.ac[1] < thr ? "Can't hear anything" : (this.ac[0] > this.ac[1] ? "Sounds louder on the right" : "Sounds louder on the left"))));
        this.descrLabel.setText(d);
    }

    class Rinne
    extends JLabel {
        int side;

        Rinne(int i) {
            this.side = i;
            Font f = this.getFont();
            this.setFont(new Font(f.getName(), 1, f.getSize() + 2));
        }

        public void paint(Graphics g) {
            g.setColor(NeurologyMainPanel.getLesionColor(1.0 - HearingExamination.this.ac[this.side]));
            g.fill3DRect(1, 1, this.getWidth() - 1, this.getHeight() - 1, true);
            g.setColor(this.getForeground());
            super.paint(g);
        }
    }

    class Weber
    extends JPanel {
        Weber() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            int x = (int)((double)this.getWidth() * (0.5 + HearingExamination.this.ac[1] / 2.0 - HearingExamination.this.ac[0] / 2.0));
            x = Math.max(5, Math.min(this.getWidth() - 10, x));
            g.setColor(NeurologyMainPanel.getLesionColor(1.0 - (HearingExamination.this.ac[0] + HearingExamination.this.ac[1]) / 2.0));
            g.fill3DRect(x - 3, 3, 6, this.getHeight() - 6, true);
        }
    }
}

