/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;
import neurology.CNSData;
import neurology.FaceExamination;
import neurology.NeurologyMainPanel;

public class FaceExaminationWithTools
extends JPanel {
    public static int ICONSIZE = 32;
    String[] side = new String[]{"right", "left"};
    String[] division = new String[]{"ophthalmic", "maxillary", "mandibular"};
    String[] feeling = new String[]{"Slightly", "Yes, but it's not normal", "Yes"};
    MouseListener mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            block7: {
                block5: {
                    String f;
                    double a;
                    block8: {
                        block6: {
                            if (FaceExaminationWithTools.this.mode != 1) break block5;
                            int i = 0;
                            while (i < 2) {
                                if (FaceExaminationWithTools.this.face.scleraout[i].contains(e.getPoint())) {
                                    double a2 = FaceExaminationWithTools.this.data.findRegion("trigeminal-ophthalmic-pain-nucleus-" + FaceExaminationWithTools.this.side[1 - i]).getActivity();
                                    if (Math.random() < a2) {
                                        FaceExaminationWithTools.this.face.initiateBlink();
                                    }
                                }
                                ++i;
                            }
                            i = Math.max(0, Math.min(2, (e.getY() - 50) / 100));
                            int j = e.getX() > FaceExaminationWithTools.this.face.getWidth() / 2 ? 0 : 1;
                            a = FaceExaminationWithTools.this.data.findRegion(String.valueOf(FaceExaminationWithTools.this.division[i]) + "-face-sensory-strip-" + FaceExaminationWithTools.this.side[1 - j]).getActivityFrom(FaceExaminationWithTools.this.data.findRegion(String.valueOf(FaceExaminationWithTools.this.division[i]) + "-touch-receptor-" + FaceExaminationWithTools.this.side[j]));
                            f = "";
                            if (a != 1.0) break block6;
                            f = FaceExaminationWithTools.this.feeling[2];
                            break block7;
                        }
                        if (!(a > 0.5)) break block8;
                        f = FaceExaminationWithTools.this.feeling[1];
                        break block7;
                    }
                    if (!(a > 0.1)) break block7;
                    f = FaceExaminationWithTools.this.feeling[0];
                    break block7;
                }
                if (FaceExaminationWithTools.this.mode == 2) {
                    FaceExaminationWithTools.this.face.saccadeTimeout = 15;
                    FaceExaminationWithTools.this.face.saccade = false;
                    FaceExaminationWithTools.this.face.eyeCalculations.isRefractory = 10;
                    FaceExaminationWithTools.this.face.distanceOfTarget = FaceExaminationWithTools.this.convergenceDistance;
                    int i = 0;
                    while (i < 2) {
                        double a = FaceExaminationWithTools.this.data.findRegion("constrictor-pupillae-" + FaceExaminationWithTools.this.side[i]).getActivityFrom(FaceExaminationWithTools.this.data.findRegion("edinger-westphal-nucleus"));
                        FaceExaminationWithTools.this.face.pupilSizeModification = -3.0;
                        ++i;
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (FaceExaminationWithTools.this.mode == 2) {
                FaceExaminationWithTools.this.face.saccadeTimeout = 15;
                FaceExaminationWithTools.this.face.saccade = false;
                FaceExaminationWithTools.this.face.eyeCalculations.isRefractory = 10;
                FaceExaminationWithTools.this.face.distanceOfTarget = FaceExaminationWithTools.this.naturalVergenceDistance;
                FaceExaminationWithTools.this.face.pupilSizeModification = 0.0;
            }
        }
    };
    int naturalVergenceDistance;
    int convergenceDistance;
    JPanel speechArea = null;
    Timer timer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FaceExaminationWithTools.this.timer.stop();
            FaceExaminationWithTools.this.removeSpeechArea();
        }
    });
    CNSData data;
    JToggleButton torchBtn = new JToggleButton();
    JToggleButton woolBtn = new JToggleButton();
    JToggleButton distBtn = new JToggleButton();
    ButtonGroup bg = new ButtonGroup();
    JPanel tools = new JPanel();
    JPanel toolpanel = new JPanel();
    FaceExamination face = new FaceExamination();
    static final int TORCH = 0;
    static final int WOOL = 1;
    static final int DIST = 2;
    public int mode = 0;
    Action torchAction = new AbstractAction("Torch", new ImageIcon(NeurologyMainPanel.getImage("torch.gif").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            FaceExaminationWithTools.this.mode = 0;
            FaceExaminationWithTools.this.face.torchEnabled = true;
        }
    };
    Action woolAction = new AbstractAction("Wool", new ImageIcon(NeurologyMainPanel.getImage("wool.gif").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            FaceExaminationWithTools.this.mode = 1;
            FaceExaminationWithTools.this.face.torchEnabled = false;
        }
    };
    Action distAction = new AbstractAction("Depth", new ImageIcon(NeurologyMainPanel.getImage("dist.gif").getScaledInstance(ICONSIZE, ICONSIZE, 4))){

        public void actionPerformed(ActionEvent e) {
            FaceExaminationWithTools.this.mode = 2;
            FaceExaminationWithTools.this.face.torchEnabled = false;
        }
    };

    public FaceExaminationWithTools() {
        this.setPreferredSize(new Dimension(200, 330));
        this.torchAction.putValue("ShortDescription", "<HTML><B>Pentorch</B> for testing light reflex<BR>Press & hold over eyes.</HTML>");
        this.woolAction.putValue("ShortDescription", "<HTML><B>Cotton wool</B> for testing corneal reflex<BR>Click over cornea.</HTML>");
        this.distAction.putValue("ShortDescription", "<HTML><B>Move hand near</B> to test vergence and accommodation<BR>Press & hold mouse button.</HTML>");
        this.setLayout(new BorderLayout());
        this.add((Component)this.face, "Center");
        this.add((Component)this.toolpanel, "East");
        this.toolpanel.setLayout(new BorderLayout());
        this.toolpanel.add((Component)this.tools, "North");
        this.tools.setLayout(new BoxLayout(this.tools, 1));
        this.torchBtn.setAction(this.torchAction);
        this.woolBtn.setAction(this.woolAction);
        this.distBtn.setAction(this.distAction);
        this.torchBtn.setText("");
        this.woolBtn.setText("");
        this.distBtn.setText("");
        this.tools.add(this.torchBtn);
        this.tools.add(this.woolBtn);
        this.tools.add(this.distBtn);
        this.bg.add(this.torchBtn);
        this.bg.add(this.woolBtn);
        this.bg.add(this.distBtn);
        this.torchBtn.setMargin(new Insets(2, 2, 2, 2));
        this.distBtn.setMargin(new Insets(2, 2, 2, 2));
        this.woolBtn.setMargin(new Insets(2, 2, 2, 2));
        this.torchBtn.setSelected(true);
        this.face.addMouseListener(this.mouseListener);
        this.naturalVergenceDistance = this.face.distanceOfTarget;
        this.convergenceDistance = this.naturalVergenceDistance / 5;
    }

    public void speechBubble(String s) {
        if (this.speechArea != null) {
            this.removeSpeechArea();
        }
        JPanel bubble = new JPanel();
        JTextField tf = new JTextField();
        bubble.setBorder(new MatteBorder(2, 2, 2, 2, Color.black));
        bubble.setLayout(new BorderLayout());
        tf.setText(s);
        Font f = tf.getFont();
        tf.setFont(new Font(f.getName(), 3, f.getSize() + 6));
        bubble.add(tf);
        this.face.add((Component)bubble, null);
        bubble.setBounds(new Rectangle(this.getWidth() / 2, this.face.mouthArea.getLocation().y - 40, 100, 30));
        this.speechArea = bubble;
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void removeSpeechArea() {
        if (this.speechArea != null) {
            this.face.remove(this.speechArea);
        }
        this.speechArea = null;
    }

    public void setQuadrantActivity(double[] a) {
        if (this.face != null) {
            this.face.setQuadrantActivity(a);
        }
    }

    public void update() {
        if (this.face != null) {
            this.face.update();
        }
    }

    public void setData(CNSData d) {
        this.data = d;
        this.face.setData(d);
    }
}

