/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import neurology.CNSData;
import neurology.EyeExamBase;

public class FaceExamination
extends EyeExamBase {
    MouseMotionListener newMouseInput = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e) {
            e.translatePoint(FaceExamination.this.mouthArea.getLocation().x, FaceExamination.this.mouthArea.getLocation().y);
            FaceExamination.this.mouseInput.mouseMoved(e);
        }
    };
    ComponentListener cl = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            FaceExamination.this.mouthArea.setBounds(0, FaceExamination.this.getHeight() * 2 / 3, FaceExamination.this.getWidth(), FaceExamination.this.getHeight() / 3);
        }
    };
    JLabel mouthArea = new JLabel();
    MouseListener mouthMouse = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            FaceExamination.this.openMouthCommand = true;
            FaceExamination.this.update();
        }

        public void mouseReleased(MouseEvent e) {
            FaceExamination.this.openMouthCommand = false;
            FaceExamination.this.update();
        }
    };
    boolean openMouthCommand = false;
    CNSData data;
    String[] sides = new String[]{"right", "left"};
    double[] upperFacialPalsy = new double[2];
    double[] lowerFacialPalsy = new double[2];
    double[] tonguePalsy = new double[2];
    double[] vagusPalsy = new double[2];
    double[] ptosis = new double[2];
    double mouthOpen = 0.2;
    double[] eyesOpen = new double[2];
    double[] eyelidCommand = new double[2];
    double[] canBlink = new double[2];
    int blinkTime = 0;
    double blinkProbability = 0.02;
    boolean storingEyePos = false;
    int[] storedEye = new int[2];
    public double[] quadrantActivity;
    EyeCalculations eyeCalculations;

    public FaceExamination() {
        this.setPreferredSize(new Dimension(100, 330));
        this.setLayout(null);
        this.mouthArea.addMouseListener(this.mouthMouse);
        this.add((Component)this.mouthArea, null);
        this.mouthArea.addMouseMotionListener(this.newMouseInput);
        this.addComponentListener(this.cl);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.distanceOfTarget = 300;
    }

    public void setData(CNSData d) {
        this.data = d;
        this.eyeCalculations = new EyeCalculations();
        this.update();
    }

    public void initialisePoints() {
        super.initialisePoints();
        this.eyes[0].centre.y -= 50;
        this.eyes[1].centre.y -= 50;
    }

    public void updateEyes() {
        this.eyes[0].opticPalsy = 1.0 - this.data.findRegion("edinger-westphal-nucleus").getActivityFrom(this.data.findRegion("retina-right"));
        this.eyes[1].opticPalsy = 1.0 - this.data.findRegion("edinger-westphal-nucleus").getActivityFrom(this.data.findRegion("retina-left"));
        int i = 0;
        while (i < 2) {
            String e = i == 0 ? "-right" : "-left";
            this.eyes[i].lr = this.getlesion("lateral-rectus" + e);
            this.eyes[i].mr = this.getlesion("medial-rectus" + e);
            this.eyes[i].ir = this.getlesion("inferior-rectus" + e);
            this.eyes[i].sr = this.getlesion("superior-rectus" + e);
            this.eyes[i].so = this.getlesion("superior-oblique" + e);
            this.eyes[i].sympatheticPalsy = this.getlesion("dilator-pupillae" + e);
            this.eyes[i].parasympatheticPalsy = this.getlesion("constrictor-pupillae" + e);
            ++i;
        }
        this.lookSpeed = 0.3;
        this.topExtremeLimit = 3;
        this.leftExtremeLimit = 3;
        this.rightExtremeLimit = 3;
        this.bottomExtremeLimit = 1;
    }

    double getlesion(String region) {
        return 1.0 - Math.max(0.0, Math.min(1.0, this.data.findRegion(region).getActivity()));
    }

    public void update() {
        if (this.data == null) {
            return;
        }
        int i = 0;
        while (i < 2) {
            CNSData.Region mu = this.data.findRegion("upper-facial-muscles-" + this.sides[i]);
            CNSData.Region ml = this.data.findRegion("lower-facial-muscles-" + this.sides[i]);
            CNSData.Region tg = this.data.findRegion("tongue-" + this.sides[i]);
            CNSData.Region ey = this.data.findRegion("orbicularis-oculi-" + this.sides[i]);
            CNSData.Region cx = this.data.findRegion("face-motor-strip-" + this.sides[(i + 1) % 2]);
            CNSData.Region uv = this.data.findRegion("palatal-muscle-" + this.sides[i]);
            CNSData.Region ps = this.data.findRegion("palatal-touch-receptor-" + this.sides[i]);
            CNSData.Region cxo = this.data.findRegion("face-motor-strip-" + this.sides[i]);
            CNSData.Region lp = this.data.findRegion("levator-palpebrae-superioris-" + this.sides[i]);
            CNSData.Region sn = this.data.findRegion("sympathetic-nucleus");
            CNSData.Region st = this.data.findRegion("superior-tarsal-muscle-" + this.sides[i]);
            CNSData.Region om = this.data.findRegion("oculomotor-nucleus-" + this.sides[i]);
            this.upperFacialPalsy[i] = Math.min(1.0, mu.getActivityFrom(cx) + mu.getActivityFrom(cxo));
            this.lowerFacialPalsy[i] = Math.min(1.0, ml.getActivityFrom(cx));
            this.tonguePalsy[i] = 1.0 - Math.max(0.0, Math.min(1.0, tg.getActivityFrom(cx) + tg.getActivityFrom(cxo)));
            this.canBlink[i] = Math.max(0.0, Math.min(1.0, ey.getActivity()));
            this.vagusPalsy[i] = Math.max(0.0, Math.min(1.0, uv.getActivityFrom(ps)));
            this.ptosis[i] = Math.max(0.0, Math.min(1.0, st.getActivityFrom(sn) * 0.5 + lp.getActivityFrom(om) * 0.5));
            ++i;
        }
        this.updateEyes();
        this.repaint();
        this.eyeCalculations.calcMuscleLesions();
    }

    public void tick() {
        super.tick();
        if (this.data == null) {
            return;
        }
        if (this.eyeCalculations != null) {
            this.eyeCalculations.calculateEyeMovement();
        }
        this.mouthOpen += 0.4 * (0.2 + (this.openMouthCommand ? 0.8 : 0.0) - this.mouthOpen);
        int i = 0;
        while (i < 2) {
            int n = i;
            this.eyesOpen[n] = this.eyesOpen[n] + 0.8 * (this.eyelidCommand[i] * 1.0 - this.eyesOpen[i]);
            this.esy[i] = (int)(20.0 * this.eyesOpen[i] * this.ptosis[i]);
            if (this.blinkTime > 0) {
                if (!this.storingEyePos) {
                    this.storingEyePos = true;
                    this.storedEye[i] = this.eyes[i].pupilCentre.y;
                }
                this.eyes[i].pupilCentre.y = this.eyes[i].centre.y - 10 * (this.blinkTime < 4 ? this.blinkTime : 6 - this.blinkTime);
            } else if (this.storingEyePos) {
                this.storingEyePos = false;
                this.eyes[i].pupilCentre.y = this.storedEye[i];
            }
            ++i;
        }
        if ((this.eyelidCommand[0] > 0.8 || this.eyelidCommand[1] > 0.8) && Math.random() < this.blinkProbability) {
            this.initiateBlink();
        }
        if (this.blinkTime >= 0) {
            if (this.blinkTime > 0) {
                --this.blinkTime;
            }
            if (this.blinkTime <= 0) {
                this.eyelidCommand[1] = 1.0;
                this.eyelidCommand[0] = 1.0;
            }
        }
    }

    public void initiateBlink() {
        this.eyelidCommand[0] = 1.0 - this.canBlink[0];
        this.eyelidCommand[1] = 1.0 - this.canBlink[1];
        this.blinkTime = 5;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.tick();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f));
        int i = 0;
        while (i < 3) {
            int y = 30 + i * 18;
            int x0 = this.getWidth() / 5;
            int hyr = (int)(15.0 * this.upperFacialPalsy[0]);
            int hyl = (int)(15.0 * this.upperFacialPalsy[1]);
            int hym = (hyl + hyr) / 2;
            int yr = y + (int)(10.0 * (1.0 - this.upperFacialPalsy[0]));
            int yl = y + (int)(10.0 * (1.0 - this.upperFacialPalsy[1]));
            int rx = this.eyes[0].centre.x - 50;
            int lx = this.eyes[1].centre.x + 50;
            int d3 = (lx - rx) / 3;
            GeneralPath p = new GeneralPath();
            p.moveTo(rx, yr);
            g.setColor(this.tone(this.skinColour, 1.0 - 0.15 * this.upperFacialPalsy[0]));
            p.curveTo((float)rx + (float)d3 * 0.4f, y - hyr, (float)rx + (float)d3 * 0.6f, y - hyr, rx + d3, y);
            g2.draw(p);
            p.reset();
            p.moveTo(rx + d3, y);
            g.setColor(this.tone(this.skinColour, 1.0 - 0.15 * (this.upperFacialPalsy[0] + this.upperFacialPalsy[1]) / 2.0));
            p.curveTo((float)rx + (float)d3 * 1.4f, y + hym, (float)rx + (float)d3 * 1.6f, y + hym, rx + d3 * 2, y);
            g2.draw(p);
            p.reset();
            p.moveTo(rx + d3 * 2, y);
            g.setColor(this.tone(this.skinColour, 1.0 - 0.15 * this.upperFacialPalsy[1]));
            p.curveTo((float)rx + (float)d3 * 2.4f, y - hyl, (float)rx + (float)d3 * 2.6f, y - hyl, rx + d3 * 3, yl);
            g2.draw(p);
            ++i;
        }
        g2.setColor(this.tone(this.skinColour, 0.8));
        GeneralPath p = new GeneralPath();
        int rx = this.eyes[0].centre.x + 60;
        int ty = this.eyes[0].centre.y + 20;
        int lx = this.eyes[1].centre.x - 60;
        int by = ty + 70;
        int mid = this.getWidth() / 2;
        p.moveTo(rx, ty);
        p.curveTo(rx - 5, ty + 50, rx - 40, by - 10, rx - 25, by);
        p.curveTo(rx, by, rx + 5, by + 10, mid, by + 10);
        p.curveTo(lx - 5, by + 10, lx, by, lx + 25, by);
        p.curveTo(lx + 40, by - 10, lx + 5, ty + 50, lx, ty);
        g2.draw(p);
        p.reset();
        double open = this.mouthOpen;
        rx = this.eyes[0].centre.x;
        lx = this.eyes[1].centre.x;
        ty = by + 25;
        by = ty + 30 + (int)(open * 45.0);
        int t2yl = ty + 35 - (int)(40.0 * this.lowerFacialPalsy[1]);
        int t2yr = ty + 35 - (int)(40.0 * this.lowerFacialPalsy[0]);
        p.moveTo(rx, t2yr);
        p.curveTo(rx + 20, ty + 10, mid - 20, ty + 5, mid - 8, ty);
        p.curveTo(mid - 5, ty + 3, mid + 5, ty + 3, mid + 8, ty);
        p.curveTo(mid + 20, ty + 5, lx - 20, ty + 10, lx, t2yl);
        int hl = (int)(0.3 * (double)mid + 0.7 * (double)lx);
        int hr = (int)(0.3 * (double)mid + 0.7 * (double)rx);
        p.curveTo(lx - 2, t2yl + 8, hl, by, mid, by);
        p.curveTo(hr, by, rx + 2, t2yr + 8, rx, t2yr);
        p.closePath();
        g2.setColor(new Color(160, 80, 90));
        g2.fill(p);
        int thk = 17;
        int rhy = (int)((double)t2yr * 0.5 + (double)(ty + thk) * 0.5);
        int lhy = (int)((double)t2yl * 0.5 + (double)(ty + thk) * 0.5);
        g2.setColor(Color.black);
        p.reset();
        p.moveTo(rx, t2yr);
        p.curveTo(rx + 5, rhy, hr, ty + thk, mid, ty + thk);
        p.curveTo(hl, ty + thk, lx - 5, lhy, lx, t2yl);
        p.curveTo(lx - 1, t2yl + 5, hl, by - thk, mid, by - thk);
        p.curveTo(hr, by - thk, rx + 1, t2yr + 5, rx, t2yr);
        g2.fill(p);
        g2.setColor(new Color(50, 10, 30));
        p.reset();
        int uhgt = (int)(open * 9.0);
        double deviation = this.vagusPalsy[1] - this.vagusPalsy[0];
        int uvdev = (int)(deviation * 15.0);
        int lip = ty + 17;
        int basew = 18;
        if (uhgt > 1) {
            p.moveTo(mid - basew, lip);
            p.curveTo(mid + uvdev, lip + uhgt, mid + uvdev, lip + uhgt, mid - 5 + uvdev, lip + 2 * uhgt);
            p.curveTo(mid + uvdev, lip + 3 * uhgt, mid + uvdev, lip + 3 * uhgt, mid + 5 + uvdev, lip + 2 * uhgt);
            p.curveTo(mid + uvdev, lip + uhgt, mid + uvdev, lip + uhgt, mid + basew, lip);
            p.lineTo(mid - basew, lip);
            g2.fill(p);
        }
        g2.setColor(new Color(150, 30, 90));
        p.reset();
        int tght = (int)(open * 40.0);
        double wasting = Math.pow((this.tonguePalsy[0] + this.tonguePalsy[1]) / 2.0, 2.0);
        deviation = this.tonguePalsy[1] - this.tonguePalsy[0];
        int wthk = (int)(25.0 * (1.0 - 0.4 * wasting));
        int wthn = (int)(10.0 * wasting);
        int tgmid = mid + (int)(deviation * 25.0);
        if (tght > 8) {
            int tgl = (rx + mid) / 2;
            int tgr = (lx + mid) / 2;
            int twy = (int)(0.2 * (double)t2yr + 0.8 * (double)(by - thk));
            p.moveTo(tgl, twy);
            p.curveTo(tgl + 5, twy - tght / 6, tgr - 5, twy - tght / 6, tgr, twy);
            p.curveTo(tgr, twy + 5, tgmid + wthk, twy + tght - wthn, tgmid, twy + tght);
            p.curveTo(tgmid - wthk, twy + tght - wthn, tgl, twy + 5, tgl, twy);
            g2.fill(p);
        }
    }

    Color tone(Color c, double d) {
        return new Color((int)Math.max(0.0, Math.min(255.0, (double)c.getRed() * d)), (int)Math.max(0.0, Math.min(255.0, (double)c.getGreen() * d)), (int)Math.max(0.0, Math.min(255.0, (double)c.getBlue() * d)));
    }

    public void setQuadrantActivity(double[] a) {
        this.quadrantActivity = a;
    }

    class EyeCalculations {
        Point2D.Double[] targetAngle = new Point2D.Double[2];
        double saccadeThresholdDistance = 1.0;
        double saccadeStopThreshold = 0.1;
        int saccadicRefractoryPeriod = 10;
        int fovealDistance = 50;
        Muscle[] lr = new Muscle[2];
        Muscle[] mr = new Muscle[2];
        Muscle[] sr = new Muscle[2];
        Muscle[] ir = new Muscle[2];
        Muscle[] so = new Muscle[2];
        Muscle[] io = new Muscle[2];
        Muscle[][] muscles = new Muscle[6][2];
        String[] muscleNames = new String[]{"medial-rectus", "superior-oblique", "superior-rectus", "lateral-rectus", "inferior-oblique", "inferior-rectus"};
        double[] muscleDirections = new double[]{0.0, 1.0471975511965976, 1.5707963267948966, Math.PI, 4.1887902047863905, 4.71238898038469};
        int isRefractory;
        boolean saccade = false;
        double[] eyeAngX = new double[2];
        double[] eyeAngY = new double[2];
        double[] saccTargetX = new double[2];
        double[] saccTargetY = new double[2];

        void calcMuscleLesions() {
            int i = 0;
            while (i < 6) {
                int j = 0;
                while (j < 2) {
                    this.muscles[i][j].calcLesion();
                    ++j;
                }
                ++i;
            }
        }

        EyeCalculations() {
            int i = 0;
            while (i < 2) {
                this.targetAngle[i] = new Point2D.Double();
                int j = 0;
                while (j < 6) {
                    this.muscles[j][i] = new Muscle(i, this.muscleNames[j], this.muscleDirections[j]);
                    ++j;
                }
                this.mr[i] = this.muscles[0][i];
                this.so[i] = this.muscles[1][i];
                this.sr[i] = this.muscles[2][i];
                this.lr[i] = this.muscles[3][i];
                this.io[i] = this.muscles[4][i];
                this.ir[i] = this.muscles[5][i];
                ++i;
            }
        }

        public void calculateEyeMovement() {
            double[] diffX = new double[2];
            double[] diffY = new double[2];
            int i = 0;
            while (i < 2) {
                this.targetAngle[i].x = (FaceExamination.this.mouseInput.lookingAt.x - FaceExamination.this.eyes[i].centre.x) / FaceExamination.this.distanceOfTarget;
                this.targetAngle[i].y = (FaceExamination.this.mouseInput.lookingAt.y - FaceExamination.this.eyes[i].centre.y) / FaceExamination.this.distanceOfTarget;
                this.eyeAngX[i] = FaceExamination.this.eyes[i].pupilCentre.x / FaceExamination.this.distanceOfTarget;
                this.eyeAngY[i] = FaceExamination.this.eyes[i].pupilCentre.y / FaceExamination.this.distanceOfTarget;
                diffX[i] = this.targetAngle[i].x - this.eyeAngX[i];
                diffY[i] = this.targetAngle[i].y - this.eyeAngY[i];
                ++i;
            }
            double diffxm = (diffX[0] + diffX[1]) / 2.0;
            double diffym = (diffY[0] + diffY[1]) / 2.0;
            double diff = (Math.sqrt(diffX[0] * diffX[0] + diffY[0] * diffY[0]) + Math.sqrt(diffX[1] * diffX[1] + diffY[1] * diffY[1])) / 2.0;
            boolean cantsee = false;
            double[] q = FaceExamination.this.quadrantActivity;
            if (diff > (double)this.fovealDistance) {
                if (diffxm < 0.0 && diffym > 0.0 && q[0] + q[4] < 0.01) {
                    cantsee = true;
                }
                if (diffxm < 0.0 && diffym < 0.0 && q[1] + q[5] < 0.01) {
                    cantsee = true;
                }
                if (diffxm > 0.0 && diffym > 0.0 && q[2] + q[6] < 0.01) {
                    cantsee = true;
                }
                if (diffxm > 0.0 && diffym < 0.0 && q[3] + q[7] < 0.01) {
                    cantsee = true;
                }
            }
            if (!cantsee) {
                if (this.isRefractory > 0) {
                    --this.isRefractory;
                }
                if (diff > this.saccadeThresholdDistance && this.isRefractory <= 0) {
                    this.startSaccade(diffX, diffY);
                }
                if (this.saccade) {
                    this.continueSaccade();
                } else {
                    int i2 = 0;
                    while (i2 < 2) {
                        this.lr[i2].setForce(this.targetAngle[i2].x - (double)FaceExamination.this.eyes[i2].pupilCentre.x);
                        this.mr[i2].setForce(0.0);
                        this.sr[i2].setForce(0.0);
                        this.ir[i2].setForce(0.0);
                        this.so[i2].setForce(0.0);
                        this.io[i2].setForce(0.0);
                        this.lr[i2].getForce();
                        ++i2;
                    }
                }
            }
        }

        void startSaccade(double[] angleX, double[] angleY) {
            this.saccade = true;
            int i = 0;
            while (i < 2) {
                this.saccTargetX[i] = angleX[i];
                this.saccTargetY[i] = angleY[i];
                ++i;
            }
        }

        void continueSaccade() {
            double[] diffX = new double[2];
            double[] diffY = new double[2];
            int i = 0;
            while (i < 2) {
                diffX[i] = this.saccTargetX[i] - this.eyeAngX[i];
                diffY[i] = this.saccTargetY[i] - this.eyeAngY[i];
                ++i;
            }
            double diffTarg = (Math.sqrt(diffX[0] * diffX[0] + diffY[0] * diffY[0]) + Math.sqrt(diffX[1] * diffX[1] + diffY[1] * diffY[1])) / 2.0;
            if (diffTarg < this.saccadeStopThreshold) {
                this.saccade = false;
                this.isRefractory = this.saccadicRefractoryPeriod;
            }
        }

        class Muscle {
            double force;
            double lesion;
            double componentAngle;
            String[] sideString = new String[]{"right", "left"};
            String regionName;
            CNSData.Region region;

            public Muscle(int side, String regionName, double componentAngle) {
                this.regionName = regionName;
                this.componentAngle = componentAngle;
                this.region = ((EyeCalculations)EyeCalculations.this).FaceExamination.this.data.findRegion(String.valueOf(regionName) + "-" + this.sideString[side]);
            }

            public void setForce(double d) {
                this.force = d;
            }

            public void calcLesion() {
                this.lesion = 1.0 - this.region.getActivity();
            }

            public double getForce() {
                return this.force * this.lesion;
            }
        }
    }
}

