/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import neurology.Eye;
import sanjay.common.RadialPaint;

public class EyeExamBase
extends JPanel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public Eye left = new Eye();
    public Eye right = new Eye();
    public Eye[] eyes = new Eye[]{this.left, this.right};
    public int interocularDistance = 150;
    public EyeInput mouseInput = new EyeInput();
    boolean torchEnabled = true;
    private boolean lightOn = false;
    Point currentDirection = new Point();
    Timer timer = new Timer(100, new TimerListener());
    public double pupilSizeModification = 0.0;
    public int distanceOfTarget = 300;
    public int radiusOfEyeball = 20;
    public double accommodationRate = 0.2;
    Point[] lastDeflections = new Point[2];
    boolean saccade;
    boolean microSaccade;
    int saccadeTimeout;
    double meanError;
    double saccErrorThresh;
    Point muscPosL;
    Point muscPosR;
    Point desiredL;
    Point desiredR;
    double saccvxl;
    double saccvyl;
    double saccvxr;
    double saccvyr;
    double maxSaccadeSpeed;
    int minimumSaccadeInterval;
    int saccadeFramesLeft;
    int thinkingTimeLeft;
    double microsaccadeProbability;
    double microsaccadeMagnitude;
    int thinkingDelay;
    double cumulativeError;
    double maxErrorFrames;
    int leftExtremeLimit;
    int rightExtremeLimit;
    int topExtremeLimit;
    int bottomExtremeLimit;
    public double lookSpeed;
    double pupilSizeCommand;
    public int esx;
    public int iris;
    public int[] esy;
    public int lightRadius;
    public Color[] irisColor;
    Shape[] sclera;
    Shape[] scleraout;
    public Color skinColour;

    public EyeExamBase() {
        this.lastDeflections[0] = new Point();
        this.lastDeflections[1] = new Point();
        this.saccade = false;
        this.microSaccade = false;
        this.saccadeTimeout = 0;
        this.meanError = 0.0;
        this.saccErrorThresh = 1600.0;
        this.muscPosL = new Point();
        this.muscPosR = new Point();
        this.desiredL = new Point();
        this.desiredR = new Point();
        this.saccvxl = 0.0;
        this.saccvyl = 0.0;
        this.maxSaccadeSpeed = 20.0;
        this.minimumSaccadeInterval = 5;
        this.thinkingTimeLeft = -1;
        this.microsaccadeProbability = 0.07;
        this.microsaccadeMagnitude = 3.0;
        this.thinkingDelay = 1;
        this.cumulativeError = 0.0;
        this.maxErrorFrames = 3.0;
        this.leftExtremeLimit = 3;
        this.rightExtremeLimit = 3;
        this.topExtremeLimit = 3;
        this.bottomExtremeLimit = 1;
        this.lookSpeed = 0.3;
        this.pupilSizeCommand = 4.0;
        this.esx = 40;
        this.iris = 18;
        this.esy = new int[]{20, 20};
        this.lightRadius = 50;
        this.irisColor = new Color[]{new Color(154, 108, 108), new Color(92, 48, 48)};
        this.sclera = new Shape[2];
        this.scleraout = new Shape[2];
        this.skinColour = new Color(250, 230, 220);
        this.initialisePoints();
        this.addMouseListener(this.mouseInput);
        this.addMouseMotionListener(this.mouseInput);
        this.jbInit();
    }

    public void addNotify() {
        super.addNotify();
        this.timer.start();
    }

    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    public void initialisePoints() {
        this.eyes[0].centre = new Point((this.getWidth() - this.interocularDistance) / 2, this.getHeight() / 2);
        this.eyes[1].centre = new Point((this.getWidth() + this.interocularDistance) / 2, this.getHeight() / 2);
        int i = 0;
        while (i < 2) {
            this.eyes[i].pupilCentre = (Point)this.eyes[i].centre.clone();
            ++i;
        }
    }

    public void tick() {
    }

    public void movePupilsToLookAt(Point p) {
        double ratio = (double)this.radiusOfEyeball / (double)this.distanceOfTarget;
        double dxl = this.desiredL.x - this.lastDeflections[1].x;
        double dxr = this.desiredR.x - this.lastDeflections[0].x;
        double dyl = this.desiredL.y - this.lastDeflections[1].y;
        double dyr = this.desiredR.y - this.lastDeflections[0].y;
        this.meanError = dxl * dxl + dyl * dyl + dxr * dxr + dyr * dyr;
        this.cumulativeError += this.meanError * 4.0;
        this.saccErrorThresh = 1600.0;
        if (this.meanError > this.saccErrorThresh | this.cumulativeError > this.saccErrorThresh * this.maxErrorFrames && !this.saccade && this.saccadeTimeout == 0) {
            double thl = Math.atan2(dyl, dxl);
            double thr = Math.atan2(dyr, dxr);
            double mgl = dxl * dxl + dyl * dyl;
            double mgr = dxr * dxr + dyr * dyr;
            double spL = mgl * 2.0 / (mgl + mgr);
            double spR = mgr * 2.0 / (mgl + mgr);
            int frames = (int)((Math.sqrt(mgl) + Math.sqrt(mgr)) / 2.0 / this.maxSaccadeSpeed);
            frames = Math.max(frames, 1);
            this.saccvxl = dxl / (double)frames;
            this.saccvyl = dyl / (double)frames;
            this.saccvxr = dxr / (double)frames;
            this.saccvyr = dyr / (double)frames;
            double fvxl = 1.0 - (this.muscPosL.x >= 0 ? this.eyes[1].lr : this.eyes[1].mr);
            double fvxr = 1.0 - (this.muscPosR.x >= 0 ? this.eyes[0].lr : this.eyes[0].mr);
            double fvyl = 1.0 - (this.muscPosL.y < 0 ? this.eyes[1].sr : Math.min(1.0, this.eyes[1].ir + (double)(-Math.min(this.muscPosL.x, 0)) * this.eyes[1].so));
            double fvyr = 1.0 - (this.muscPosR.y < 0 ? this.eyes[0].sr : Math.min(1.0, this.eyes[0].ir + (double)(-Math.min(this.muscPosR.x, 0)) * this.eyes[0].so));
            fvxl = 1.0 - (this.saccvxl >= 0.0 ? this.eyes[1].lr : this.eyes[1].mr);
            fvxr = 1.0 - (this.saccvxr >= 0.0 ? this.eyes[0].lr : this.eyes[0].mr);
            fvyl = 1.0 - (this.saccvyl < 0.0 ? this.eyes[1].sr : Math.min(1.0, this.eyes[1].ir + -Math.min(this.saccvxl, 0.0) * this.eyes[1].so));
            fvyr = 1.0 - (this.saccvyr < 0.0 ? this.eyes[0].sr : Math.min(1.0, this.eyes[0].ir + -Math.min(this.saccvxr, 0.0) * this.eyes[0].so));
            this.saccvxl *= fvxl;
            this.saccvxr *= fvxr;
            this.saccvyl *= fvyl;
            this.saccvyr *= fvyr;
            this.saccadeFramesLeft = frames + 1;
            if (this.thinkingTimeLeft == -1) {
                this.thinkingTimeLeft = this.thinkingDelay;
            } else if (this.thinkingTimeLeft == 0) {
                this.saccade = true;
                this.cumulativeError = 0.0;
                this.thinkingTimeLeft = -1;
            } else {
                --this.thinkingTimeLeft;
            }
        }
        if (this.saccadeTimeout > 0) {
            --this.saccadeTimeout;
        }
        if (this.saccade) {
            --this.saccadeFramesLeft;
            if (this.saccadeFramesLeft <= 0) {
                this.saccade = false;
                if (!this.microSaccade) {
                    this.saccadeTimeout = this.minimumSaccadeInterval;
                }
                this.microSaccade = false;
            }
        }
        if (!this.saccade & this.saccadeTimeout == 0 & this.thinkingTimeLeft == -1 & this.meanError < 100.0 & Math.random() < this.microsaccadeProbability) {
            this.saccadeFramesLeft = 1;
            this.saccvxl = (Math.random() - 0.5) * this.microsaccadeMagnitude;
            this.saccvxr = -this.saccvxl;
            this.saccvyl = this.saccvyr = (Math.random() - 0.5) * this.microsaccadeMagnitude;
            this.saccade = true;
            this.microSaccade = true;
        }
        int i = 0;
        while (i < 2) {
            int LR;
            int n = LR = i == 0 ? -1 : 1;
            if (this.saccade) {
                this.lastDeflections[i].x = (int)((double)this.lastDeflections[i].x + (i == 0 ? this.saccvxr : this.saccvxl));
                this.lastDeflections[i].y = (int)((double)this.lastDeflections[i].y + (i == 0 ? this.saccvyr : this.saccvyl));
            } else if (this.thinkingTimeLeft == -1) {
                Point desired = i == 0 ? this.muscPosR : this.muscPosL;
                this.lastDeflections[i].x = (int)((double)this.lastDeflections[i].x + this.lookSpeed * (double)(desired.x - this.lastDeflections[i].x));
                this.lastDeflections[i].y = (int)((double)this.lastDeflections[i].y + this.lookSpeed * (double)(desired.y - this.lastDeflections[i].y));
            }
            double px = (p.x - this.getWidth() / 2) * 2 + this.getWidth() / 2;
            double py = (p.y - this.getHeight() / 2) * 2 + this.getHeight() / 2;
            Point deflection = new Point((int)((double)LR * (px - (double)this.eyes[i].centre.x + (double)this.eyes[i].strabismusX) * ratio), (int)((py - (double)this.eyes[i].centre.y + (double)this.eyes[i].strabismusY) * ratio));
            deflection.x = Math.max(-33, Math.min(33, deflection.x));
            deflection.y = Math.max(-23, Math.min(23, deflection.y));
            if (i == 0) {
                this.desiredR.setLocation(deflection);
            } else {
                this.desiredL.setLocation(deflection);
            }
            deflection.x = (int)((double)deflection.x * (1.0 - (deflection.x > 0 ? this.eyes[i].lr : this.eyes[i].mr)));
            deflection.y = (int)((double)deflection.y * (1.0 - (deflection.y < 0 ? this.eyes[i].sr : Math.min(1.0, this.eyes[i].ir + -Math.max(0.0, (double)deflection.x / 20.0) * (1.0 - this.eyes[i].so) - Math.min(0.0, (double)deflection.x / 20.0) * this.eyes[i].so))));
            deflection.x = Math.max(-33 + this.leftExtremeLimit, Math.min(33 - this.rightExtremeLimit, deflection.x));
            deflection.y = Math.max(-23 + this.topExtremeLimit, Math.min(18 - this.bottomExtremeLimit, deflection.y));
            if (i == 0) {
                this.muscPosR.setLocation(deflection);
            } else {
                this.muscPosL.setLocation(deflection);
            }
            this.eyes[i].pupilCentre.x = this.eyes[i].centre.x + LR * this.lastDeflections[i].x;
            this.eyes[i].pupilCentre.y = this.eyes[i].centre.y + this.lastDeflections[i].y;
            this.calcPupilSize(i);
            ++i;
        }
    }

    public void calcPupilSize(int i) {
        double targetPupilSize = this.pupilSizeCommand;
        targetPupilSize = Math.min(12.0, Math.max(2.0, (1.0 - this.eyes[i].sympatheticPalsy) * (targetPupilSize + 9.0 * this.eyes[i].parasympatheticPalsy)));
        this.eyes[i].pupilSize += this.accommodationRate * (targetPupilSize - this.eyes[i].pupilSize);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < 2) {
            g.setColor(new Color(128, 92, 92));
            this.scleraout[i] = new Ellipse2D.Double(this.eyes[i].centre.x - this.esx - 1, this.eyes[i].centre.y - this.esy[i] - 1, this.esx * 2 + 2, this.esy[i] * 2 + 2);
            g2.draw(this.scleraout[i]);
            g2.setPaint(new RadialPaint(Color.white, Color.lightGray, new Point(this.eyes[i].centre.x - 10, this.eyes[i].centre.y - 10), 50));
            this.sclera[i] = new Ellipse2D.Double(this.eyes[i].centre.x - this.esx, this.eyes[i].centre.y - this.esy[i], this.esx * 2, this.esy[i] * 2);
            g2.fill(this.sclera[i]);
            g2.setPaint(new RadialPaint(this.irisColor[0], this.irisColor[1], new Point(this.eyes[i].centre.x - 10, this.eyes[i].centre.y - 10), 20));
            g.fillOval(this.eyes[i].pupilCentre.x - this.iris, this.eyes[i].pupilCentre.y - this.iris, this.iris * 2, this.iris * 2);
            double ps = this.eyes[i].pupilSize;
            g2.setPaint(new RadialPaint(new Color(128, 128, 128), Color.black, new Point(this.eyes[i].centre.x - 10, this.eyes[i].centre.y - 10), 15));
            g2.fill(new Ellipse2D.Double((double)this.eyes[i].pupilCentre.x - ps, (double)this.eyes[i].pupilCentre.y - ps, ps * 2.0, ps * 2.0));
            g.setColor(new Color(255, 255, 255, 156));
            g.fillOval(this.eyes[i].centre.x - 15, this.eyes[i].centre.y - 15, 10, 10);
            ++i;
        }
        g.setColor(this.skinColour);
        GeneralPath s = new GeneralPath(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        s.append(this.scleraout[0], false);
        s.append(this.scleraout[1], false);
        s.setWindingRule(0);
        g2.fill(s);
        if (this.lightOn) {
            g2.setColor(new Color(255, 255, 192, 108));
            g2.fillOval(this.mouseInput.lookingAt.x - this.lightRadius, this.mouseInput.lookingAt.y - this.lightRadius, this.lightRadius * 2, this.lightRadius * 2);
        }
    }

    private void jbInit() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                EyeExamBase.this.this_componentResized(e);
            }
        });
    }

    void this_componentResized(ComponentEvent e) {
        this.initialisePoints();
    }

    public class EyeInput
    extends MouseInputAdapter {
        public Point lookingAt = new Point(0, 0);

        public void mousePressed(MouseEvent e) {
            if (EyeExamBase.this.torchEnabled) {
                EyeExamBase.this.lightOn = true;
            }
            EyeExamBase.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            EyeExamBase.this.lightOn = false;
            EyeExamBase.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            this.lookingAt.setLocation(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            this.lookingAt.setLocation(e.getX(), e.getY());
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Point t = EyeExamBase.this.mouseInput.lookingAt;
            EyeExamBase.this.movePupilsToLookAt(t);
            EyeExamBase.this.tick();
            double totalLight = 0.0;
            int i = 0;
            while (i < 2) {
                double distLight = EyeExamBase.this.mouseInput.lookingAt.distance(EyeExamBase.this.eyes[i].pupilCentre);
                if (EyeExamBase.this.lightOn) {
                    totalLight += distLight < (double)EyeExamBase.this.lightRadius ? 1.0 - EyeExamBase.this.eyes[i].opticPalsy : 0.0;
                }
                ++i;
            }
            EyeExamBase.this.pupilSizeCommand = Math.max(9.0 - totalLight * 5.0 + EyeExamBase.this.pupilSizeModification, 3.0);
            EyeExamBase.this.repaint();
        }
    }
}

