/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import neurology.ArmPanel;
import neurology.CNSData;
import neurology.FaceExaminationWithTools;
import neurology.HearingExamination;
import neurology.MotorExamination;
import neurology.NeurologyMainPanel;
import neurology.ReflexPanel;
import neurology.SensoryExamination;
import neurology.VisualFields;

public class ExaminationPanel
extends JPanel
implements Scrollable {
    JPanel tmp = new JPanel();
    CNSData data;
    JPanel smellPanel = new JPanel();
    JLabel smellLabel = new JLabel();
    SmellLabel[] nostril = new SmellLabel[2];
    VisualFields fields = new VisualFields();
    String[] side = new String[]{"right", "left"};
    public static String[] status = new String[]{"Absent", "Poor", "Impaired", "Good"};
    HearingExamination hearing = new HearingExamination();
    FaceExaminationWithTools face = new FaceExaminationWithTools();
    MotorExamination motor = new MotorExamination();
    ReflexPanel reflex = new ReflexPanel();
    SensoryExamination sensory;
    ArmPanel armpanel = new ArmPanel();
    ActionListener al;
    ActionListener nostrilAL = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (ExaminationPanel.this.al != null) {
                ExaminationPanel.this.al.actionPerformed(e);
            }
        }
    };

    public ExaminationPanel(NeurologyMainPanel p) {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.smellPanel);
        this.smellPanel.setLayout(new GridLayout(1, 3));
        this.smellPanel.add(this.smellLabel);
        this.smellLabel.setText("Sense of smell:");
        int i = 0;
        while (i < 2) {
            this.nostril[i] = new SmellLabel("olfactory-bulb-" + this.side[i], this.nostrilAL);
            this.smellPanel.add(this.nostril[i]);
            ++i;
        }
        this.add(this.tmp);
        this.tmp.setLayout(new BorderLayout());
        this.setPanelBorder(this.tmp, "Visual fields");
        this.tmp.add(this.fields);
        this.setPanelBorder(this.face, "Facial examination");
        this.add(this.face);
        this.setPanelBorder(this.motor, "Limb power");
        this.add(this.hearing);
        this.setPanelBorder(this.hearing, "Hearing");
        this.add(this.motor);
        this.setPanelBorder(this.reflex, "Reflexes");
        this.add(this.reflex);
        this.sensory = new SensoryExamination(p, NeurologyMainPanel.getResource("Dermatomes.txt"));
        this.setPanelBorder(this.sensory, "Sensory");
        this.add(this.sensory);
        this.add(this.armpanel);
    }

    void setPanelBorder(JComponent c, String title) {
        c.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
    }

    public void setData(CNSData d) {
        this.data = d;
        this.motor.setData(d);
        this.reflex.setData(d);
        this.face.setData(d);
        this.sensory.setData(d);
        this.armpanel.setData(d);
        this.hearing.setData(d);
        this.fields.setData(d);
        this.fields.setFace(this.face);
        this.repaint();
    }

    public void update() {
        this.motor.update();
        this.reflex.update();
        this.face.update();
        this.sensory.update();
        this.armpanel.update();
        this.hearing.update();
        this.updateSmell();
        this.fields.update();
        this.repaint();
    }

    public void updateSmell() {
        int i = 0;
        while (i < 2) {
            double s = this.data.findRegion("entorhinal-cortex-" + this.side[i]).getActivity();
            this.nostril[i].setPower(s);
            ++i;
        }
    }

    public void addActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.add(a, this.al);
    }

    public void removeActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.remove(a, this.al);
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 25;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    class SmellLabel
    extends MotorExamination.PowerLabel {
        public SmellLabel(String region, ActionListener al) {
            super(region, al);
        }

        public String getPowerTxt(int i) {
            return status[i];
        }

        public int getNumPowers() {
            return 4;
        }
    }
}

