/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import neurology.CNSData;
import neurology.NeurologyMainPanel;

public class EffectsBox
extends JPanel {
    JScrollPane scrollPane = new JScrollPane();
    JList list = new JList();
    JPanel opts = new JPanel();
    private JCheckBox onlyCurrentChk = new JCheckBox();
    CNSData.Region lipMuscles;
    CNSData.Region tongueMuscles;
    CNSData.Region palateMuscles;

    public EffectsBox() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.opts, "North");
        this.scrollPane.getViewport().setView(this.list);
        this.onlyCurrentChk.setToolTipText("Only show the effects of currently active lesions");
        this.onlyCurrentChk.setText("Only active");
        this.opts.add(this.onlyCurrentChk);
        this.list.setCellRenderer(new Renderer());
    }

    class Effect {
        String q = "";
        double lesion;

        Effect() {
        }

        String getAnswer() {
            return "";
        }
    }

    class Renderer
    extends JPanel
    implements ListCellRenderer {
        JLabel question = new JLabel();
        JLabel answer = new JLabel();

        Renderer() {
            this.setPreferredSize(new Dimension(100, 40));
            Font baseFont = this.getFont();
            this.question.setFont(new Font(baseFont.getName(), 1, baseFont.getSize()));
            this.answer.setFont(new Font(baseFont.getName(), 2, baseFont.getSize()));
            this.setLayout(new BorderLayout());
            this.add((Component)this.question, "North");
            this.add((Component)this.answer, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Effect effect = (Effect)value;
            this.question.setText(effect.q);
            this.answer.setForeground(NeurologyMainPanel.lesionGreyscale(this.getForeground(), effect.lesion));
            this.answer.setText(effect.getAnswer());
            return this;
        }
    }
}

