/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import neurology.NeurologyMainPanel;

public class CNSData {
    public static boolean AVERAGE = false;
    Properties originalProperties;
    ActionListener listener = null;
    static final String possibleModes = "vcihs";
    Vector regions = new Vector();
    boolean needsRecalculating = false;
    Runnable recalc = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (CNSData.this.needsRecalculating) {
                Runnable runnable = CNSData.this.recalc;
                synchronized (runnable) {
                    CNSData.this.needsRecalculating = false;
                }
                CNSData.this.recalculateImpl();
            }
            CNSData.this.recalcThread = null;
        }
    };
    Thread recalcThread;
    public Action clearAllLesionsAction = new AbstractAction("Clear all lesions"){

        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < CNSData.this.regions.size()) {
                Region r = (Region)CNSData.this.regions.get(i);
                r.lesion = 0.0;
                ++i;
            }
            CNSData.this.recalculate();
        }
    };
    String[][] abbreviations = new String[][]{{"nucleus", "nuc."}, {"nuclei", "nn."}, {"nerve", "n."}, {"third", "3rd"}, {"fourth", "4th"}, {"artery", "a."}, {"left", "L"}, {"right", "R"}, {"muscle", "m"}, {"anterior", "ant."}, {"posterior", "post."}, {"abductor", "abd."}, {"adductor", "add."}, {"pollicis", "poll."}, {"opponens", "opp."}, {"receptor", "r."}, {"superior", "sup."}, {"inferior", "inf."}, {"corticospinal", "corticosp."}};

    public CNSData(URL resource) {
        Properties p = new Properties();
        try {
            p.load(resource.openStream());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.readFrom(p);
    }

    void readFrom(Properties p) {
        this.originalProperties = p;
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement().toString();
            String[] v = p.getProperty(k).split("[\\s,]+");
            Region r = this.findRegion(k);
            char mode = 'v';
            boolean mirror = false;
            int i = 0;
            while (i < v.length) {
                block9: {
                    block10: {
                        char m;
                        block12: {
                            block11: {
                                if (v[i].length() == 0) break block9;
                                if (!v[i].startsWith("-")) break block10;
                                m = v[i].charAt(1);
                                if (m != 'h') break block11;
                                r.hidden = true;
                                break block9;
                            }
                            if (m != 'm') break block12;
                            mirror = true;
                            break block9;
                        }
                        mode = m;
                        v[i] = v[i].substring(2).trim();
                        if (possibleModes.indexOf(mode) < 0) {
                            throw new IllegalArgumentException("No such mode '" + mode + "' at item " + k);
                        }
                        if (v[i].length() == 0) break block9;
                    }
                    if (mode == 's') {
                        r.synonyms.add(v[i]);
                    } else {
                        try {
                            Region r2 = this.findRegion(v[i]);
                            r.connectTo(r2, mode);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new IllegalArgumentException("Error parsing Neurology.txt at item " + k, ex);
                        }
                    }
                }
                ++i;
            }
            if (!mirror) continue;
            this.createMirror(r);
        }
    }

    void store(OutputStream os) throws IOException {
        String removedlist = "";
        int i = 0;
        while (i < this.regions.size()) {
            Region r = (Region)this.regions.get(i);
            int c = r.content.size() + r.input.size() + r.via.size();
            if (c > 0) {
                int j;
                StringBuilder str = new StringBuilder();
                if (r.input.size() > 0) {
                    str.append("-i ");
                    j = 0;
                    while (j < r.input.size()) {
                        str.append(r.input.get(j));
                        str.append(' ');
                        ++j;
                    }
                }
                if (r.via.size() > 0) {
                    str.append("-v ");
                    j = 0;
                    while (j < r.via.size()) {
                        str.append(r.via.get(j));
                        str.append(' ');
                        ++j;
                    }
                }
                if (r.content.size() > 0) {
                    str.append("-c ");
                    j = 0;
                    while (j < r.content.size()) {
                        str.append(r.content.get(j));
                        str.append(' ');
                        ++j;
                    }
                }
                if (r.synonyms.size() > 0) {
                    str.append("-s ");
                    j = 0;
                    while (j < r.synonyms.size()) {
                        str.append(r.synonyms.get(j));
                        str.append(' ');
                        ++j;
                    }
                }
                this.originalProperties.put(r.name, str.toString());
            } else {
                this.originalProperties.remove(r.name);
                removedlist = String.valueOf(removedlist) + r.name + ",";
            }
            ++i;
        }
        int choice = JOptionPane.showConfirmDialog(null, "Removing items " + removedlist + ". OK?", "Warning", 2);
        if (choice == 0) {
            this.originalProperties.store(os, "Neurology pathways properties file - Neurology application (c) Sanjay Manohar");
        }
    }

    Region createMirror(Region r) {
        Region m = this.findRegion(this.mirrorName(r.name));
        if (m == r) {
            throw new IllegalStateException("Cannot mirror " + r.name + ": no 'left' or 'right'.");
        }
        int i = 0;
        while (i < r.input.size()) {
            m.connectTo(this.findRegion(this.mirrorName(((Region)r.input.get((int)i)).name)), 'i');
            ++i;
        }
        i = 0;
        while (i < r.via.size()) {
            m.connectTo(this.findRegion(this.mirrorName(((Region)r.via.get((int)i)).name)), 'v');
            ++i;
        }
        i = 0;
        while (i < r.content.size()) {
            m.connectTo(this.findRegion(this.mirrorName(((Region)r.content.get((int)i)).name)), 'c');
            ++i;
        }
        i = 0;
        while (i < r.synonyms.size()) {
            m.synonyms.add(this.mirrorName((String)r.synonyms.get(i)));
            ++i;
        }
        m.hidden = r.hidden;
        return m;
    }

    String mirrorName(String name) {
        StringBuffer m = new StringBuffer();
        String[] t = name.split("-");
        int i = 0;
        while (i < t.length) {
            if (i > 0) {
                m.append('-');
            }
            if (t[i].equals("right")) {
                t[i] = "left";
            } else if (t[i].equals("left")) {
                t[i] = "right";
            }
            m.append(t[i]);
            ++i;
        }
        return m.toString();
    }

    public void addActionListener(ActionListener i) {
        this.listener = AWTEventMulticaster.add(this.listener, i);
    }

    public void removeActionListener(ActionListener i) {
        this.listener = AWTEventMulticaster.remove(i, this.listener);
    }

    public Region findRegion(String name) {
        if (name == null || name.length() < 1) {
            return null;
        }
        if (!name.matches("[a-zA-Z0-9\\-]*")) {
            throw new IllegalArgumentException("Illegal region name " + name);
        }
        int i = 0;
        while (i < this.regions.size()) {
            Region r = (Region)this.regions.get(i);
            if (r.name.equalsIgnoreCase(name)) {
                return r;
            }
            ++i;
        }
        Region r = new Region();
        r.setName(name);
        this.regions.add(r);
        return r;
    }

    public void clearActivity(double a) {
        int i = 0;
        while (i < this.regions.size()) {
            ((Region)this.regions.get(i)).clear(a);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculate() {
        Runnable runnable = this.recalc;
        synchronized (runnable) {
            this.needsRecalculating = true;
            if (this.recalcThread == null) {
                this.recalcThread = new Thread(this.recalc);
                this.recalcThread.start();
            }
        }
    }

    void recalculateImpl() {
        this.clearActivity(1.0);
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, "Lesion change"));
        }
    }

    public Region[] getMatchingRegions(String s) {
        HashSet<Region> v = new HashSet<Region>();
        Pattern p = Pattern.compile(".*" + s + ".*", 2);
        int i = 0;
        while (i < this.regions.size()) {
            Region r0 = (Region)this.regions.get(i);
            if (p.matcher(r0.name).matches()) {
                v.add(r0);
            }
            if (p.matcher(r0.friendlyName).matches()) {
                v.add(r0);
            }
            if (p.matcher(r0.getAbbreviatedName()).matches()) {
                v.add(r0);
            }
            ++i;
        }
        Region[] r = new Region[v.size()];
        r = v.toArray(r);
        return r;
    }

    public class Region
    implements Comparable {
        public String name;
        public CNSData data;
        public String friendlyName;
        private double activity;
        private double lesion;
        public boolean hidden;
        public static final int direction_OUTPUT = 0;
        public static final int direction_INPUT = 1;
        public static final int direction_VIA = 2;
        public static final int direction_THRU = 3;
        public static final int direction_CONTENTS = 4;
        public static final int direction_PARENTS = 5;
        private boolean calculated;
        Vector via;
        Vector thru;
        Vector content;
        Vector parents;
        Vector input;
        Vector output;
        Vector synonyms;

        public Region() {
            this.data = CNSData.this;
            this.friendlyName = null;
            this.activity = 1.0;
            this.lesion = 0.0;
            this.via = new Vector();
            this.thru = new Vector();
            this.content = new Vector();
            this.parents = new Vector();
            this.input = new Vector();
            this.output = new Vector();
            this.synonyms = new Vector();
        }

        public void setName(String name) {
            this.name = name;
            this.friendlyName = NeurologyMainPanel.friendlyName(name);
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public String toString() {
            return this.getFriendlyName();
        }

        public double getActivity() {
            if (this.calculated) {
                return this.activity;
            }
            this.calculated = true;
            if (this.input.size() == 0) {
                if (this.content.size() > 0) {
                    double total = 0.0;
                    int i = 0;
                    while (i < this.content.size()) {
                        total += ((Region)this.content.get(i)).getActivity();
                        ++i;
                    }
                    this.activity = total / (double)this.content.size();
                }
                this.activity *= 1.0 - this.getLesion();
                return this.activity;
            }
            double total = 0.0;
            double cond = 1.0;
            int i = 0;
            while (i < this.via.size()) {
                cond *= 1.0 - ((Region)this.via.get(i)).getLesion();
                ++i;
            }
            i = 0;
            while (i < this.input.size()) {
                total += ((Region)this.input.get(i)).getActivity();
                ++i;
            }
            this.activity = total * cond * (1.0 - this.getLesion());
            return this.activity;
        }

        public int oppositeDirection(int direction) {
            switch (direction) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 4;
                }
            }
            throw new IllegalArgumentException("No sucb direction " + direction);
        }

        public Vector getListOf(int direction) {
            switch (direction) {
                case 0: {
                    return this.output;
                }
                case 1: {
                    return this.input;
                }
                case 2: {
                    return this.thru;
                }
                case 3: {
                    return this.via;
                }
                case 4: {
                    return this.content;
                }
                case 5: {
                    return this.parents;
                }
            }
            throw new IllegalArgumentException("No such direction " + direction);
        }

        public double getActivityFrom(Region f, Vector visited) {
            boolean[] allow = new boolean[6];
            int i = 0;
            while (i < 6) {
                allow[i] = true;
                ++i;
            }
            return this.getActivityFrom(f, visited, allow);
        }

        public double getActivityFrom(Region f, Vector visited, boolean[] allowDirs) {
            int i;
            double total;
            boolean[] allow;
            if (this == f) {
                return 1.0 - this.getLesion();
            }
            if (visited == null) {
                visited = new Vector<Region>();
            }
            if (visited.contains(this)) {
                return 0.0;
            }
            visited.add(this);
            double tmpActivity = 0.0;
            if (allowDirs[4] && this.content.size() > 0) {
                allow = (boolean[])allowDirs.clone();
                allow[5] = false;
                total = 0.0;
                i = 0;
                while (i < this.content.size()) {
                    total += ((Region)this.content.get(i)).getActivityFrom(f, visited, allow);
                    ++i;
                }
                tmpActivity += total;
            }
            if (allowDirs[5] && this.parents.size() > 0) {
                allow = (boolean[])allowDirs.clone();
                allow[4] = false;
                total = 0.0;
                i = 0;
                while (i < this.parents.size()) {
                    total += ((Region)this.parents.get(i)).getActivityFrom(f, visited, allow);
                    ++i;
                }
                tmpActivity += total;
            }
            tmpActivity *= 1.0 - this.getLesion();
            double total2 = 0.0;
            double cond = 1.0;
            int i2 = 0;
            while (i2 < this.via.size()) {
                cond *= 1.0 - ((Region)this.via.get(i2)).getLesion();
                ++i2;
            }
            if (allowDirs[1]) {
                i2 = 0;
                while (i2 < this.input.size()) {
                    total2 += ((Region)this.input.get(i2)).getActivityFrom(f, visited);
                    ++i2;
                }
            }
            tmpActivity = Math.min(1.0, tmpActivity + total2 * cond * (1.0 - this.getLesion()));
            return tmpActivity;
        }

        public double getActivityFrom(Region f) {
            return this.getActivityFrom(f, null);
        }

        public void setActivity(double a) {
            this.activity = a;
            this.calculated = true;
        }

        protected void clear(double a) {
            this.activity = a;
            this.calculated = false;
        }

        public double getLesion() {
            double child = this.getAverageChildLesion();
            double parent = this.getCumulativeParentLesion();
            double parentOnly = (1.0 - parent) / (1.0 - this.lesion);
            if (Double.isNaN(parentOnly = 1.0 - parentOnly)) {
                parentOnly = parent;
            }
            double q = child + parentOnly * (1.0 - child);
            if (Double.isNaN(q += (1.0 - q) * this.lesion)) {
                throw new IllegalStateException("Bad lesion value in " + this.friendlyName);
            }
            return q;
        }

        public void setLesion(double d) {
            Region r;
            this.lesion = d;
            int i = 0;
            while (i < this.content.size()) {
                r = (Region)this.content.get(i);
                if (AVERAGE) {
                    r.setLesion(d);
                } else {
                    r.lesion = 0.0;
                }
                ++i;
            }
            i = 0;
            while (i < this.parents.size()) {
                r = (Region)this.parents.get(i);
                if (!AVERAGE) {
                    r.lesion = 0.0;
                }
                ++i;
            }
            CNSData.this.recalculate();
        }

        protected double getAverageChildLesion() {
            if (this.content.size() == 0) {
                return this.lesion;
            }
            double t = 0.0;
            double p = 1.0;
            int i = 0;
            while (i < this.content.size()) {
                double content_cl = ((Region)this.content.get(i)).getAverageChildLesion();
                t += content_cl;
                p *= 1.0 - content_cl;
                ++i;
            }
            t = Math.min(1.0, t);
            t /= (double)this.content.size();
            t += (1.0 - t) * this.lesion;
            p *= 1.0 - this.lesion;
            if (AVERAGE) {
                return t;
            }
            return 1.0 - p;
        }

        protected double getCumulativeParentLesion() {
            double t = 1.0 - this.lesion;
            int i = 0;
            while (i < this.parents.size()) {
                t *= 1.0 - ((Region)this.parents.get(i)).getCumulativeParentLesion();
                ++i;
            }
            t = Math.max(0.0, Math.min(1.0, t));
            return 1.0 - t;
        }

        public void connectTo(Region r, char mode) {
            switch (mode) {
                case 'v': {
                    this.via.add(r);
                    r.thru.add(this);
                    break;
                }
                case 'c': {
                    this.content.add(r);
                    r.parents.add(this);
                    break;
                }
                case 'i': {
                    this.input.add(r);
                    r.output.add(this);
                }
            }
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((Region)o).name);
        }

        public String getHypertextDescription() {
            String s = "";
            if (this.synonyms.size() > 0) {
                s = String.valueOf(s) + "<b>Synonyms: </b>";
                int i = 0;
                while (i < this.synonyms.size()) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + NeurologyMainPanel.friendlyName((String)this.synonyms.get(i));
                    ++i;
                }
                s = String.valueOf(s) + "\n<BR>";
            }
            s = String.valueOf(s) + this.listOfRegionLinks("Consists of: ", this.content);
            s = String.valueOf(s) + this.listOfRegionLinks("Is part of: ", this.parents);
            s = String.valueOf(s) + this.listOfRegionLinks("Receives input from: ", this.input);
            s = String.valueOf(s) + this.listOfRegionLinks("Input comes via: ", this.via);
            s = String.valueOf(s) + this.listOfRegionLinks("Sends output to: ", this.output);
            if ((s = String.valueOf(s) + this.listOfRegionLinks("Conveys information to: ", this.thru)).endsWith("<BR>")) {
                s = s.substring(0, s.length() - 4);
            }
            return s;
        }

        String listOfRegionLinks(String title, Vector items) {
            String s = "";
            if (items.size() > 0) {
                s = String.valueOf(s) + "<B>" + title + "</B>";
                int i = 0;
                while (i < items.size()) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    Region r = (Region)items.get(i);
                    int lescol = (int)Math.min(15.0, Math.max(0.0, 15.0 * r.lesion));
                    String lescolstr = Integer.toHexString(lescol);
                    String colstr = "#00" + lescolstr + lescolstr + "00";
                    s = String.valueOf(s) + "<A HREF=" + r.name + "><font color='" + colstr + "'>" + r.friendlyName + "</font></A>";
                    ++i;
                }
                s = String.valueOf(s) + "\n<BR>";
            }
            return s;
        }

        public String getAbbreviatedName() {
            String[] e = this.name.split("-");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < e.length) {
                int j = 0;
                while (j < CNSData.this.abbreviations.length) {
                    if (e[i].equals(CNSData.this.abbreviations[j][0])) {
                        e[i] = CNSData.this.abbreviations[j][1];
                    }
                    ++j;
                }
                if (i == 0) {
                    e[i] = String.valueOf(Character.toUpperCase(e[i].charAt(0))) + e[i].substring(1);
                }
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(e[i]);
                ++i;
            }
            return sb.toString();
        }

        public boolean isIn(Region region) {
            if (region == this) {
                return true;
            }
            int i = 0;
            while (i < this.parents.size()) {
                if (((Region)this.parents.get(i)).isIn(region)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean contains(Region region) {
            if (region == this) {
                return true;
            }
            int i = 0;
            while (i < this.content.size()) {
                if (((Region)this.content.get(i)).contains(region)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

