/*
 * Decompiled with CFR 0.152.
 */
package neurology;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import neurology.ArmWidgetsPanel;
import neurology.CNSData;
import neurology.NeurologyMainPanel;

public class ArmPanel
extends JPanel {
    ArmWidgetsPanel widgets = new ArmWidgetsPanel(this);
    int h;
    double cx = 5.0;
    double cy = 5.0;
    double sl = 30.0;
    double el = 30.0;
    double wl = 8.0;
    double em = 1.0;
    double wm = 1.0;
    double fm = 1.0;
    double dsa;
    double dea;
    double dwa;
    double damping = 0.8;
    double gravity = 1.0;
    double restingx = 55.0;
    double restingy;
    double nosex;
    double nosey = 15.0;
    double RTmillis = 0.0;
    double correctionRate = 1.0;
    double feedbackSpeed = 1.0;
    double mx;
    double my;
    boolean isResting = true;
    boolean eyesClosed = false;
    Image faceImage;
    CNSData data;
    CNSData.Region rDeltoid;
    CNSData.Region rBiceps;
    CNSData.Region rTriceps;
    CNSData.Region rExtensorCarpi;
    CNSData.Region rFlexorCarpi;
    CNSData.Region rNigra;
    double deltoid;
    double biceps;
    double triceps;
    double extensorCarpi;
    double flexorCarpi;
    double coord;
    double parkinson;
    double essential;
    double visualFeedback;
    double proprioFeedback;
    long commandTime;
    int armSide = 0;
    String[] sides = new String[]{"left", "right"};
    Pos cpos = new Pos();
    Pos estimated = new Pos();
    double otargx;
    double otargy;
    double targx;
    double targy;
    Pos targPos = new Pos();
    Pos otargPos = new Pos();
    Pos ctargpos = new Pos();
    Pos ptargpos = new Pos();
    double movementSpeed = 2.0;
    long fingerNosePeriod = 1200L;
    boolean mouseDown = false;
    boolean doFingerNose = false;
    long mouseDownTime = 0L;
    Mouse mouse = new Mouse();
    ActionListener timeral = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ArmPanel.this.calc();
        }
    };
    Timer timer = new Timer(50, this.timeral);

    public ArmPanel() {
        this.cpos = new Pos(this.cx, this.cy + 40.0, -1.0471975511965976, 1.0461975511965977, 0.001);
        this.restingy = this.cx;
        this.nosex = this.cx;
        this.commandTime = System.currentTimeMillis();
        this.setPreferredSize(new Dimension(80, 140));
        this.addMouseListener(this.mouse);
        this.addMouseMotionListener(this.mouse);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ArmPanel.this.reset();
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.faceImage = NeurologyMainPanel.getImage("img/face_profile.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.widgets, "East");
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.faceImage != null) {
            g.drawImage(this.faceImage, 0, 0, (int)((double)this.h * 0.6), (int)((double)this.h * 0.6), this);
        }
        g.setColor(Color.blue);
        g.fillRect(0, (int)((double)this.h * 0.6), 5, (int)((double)this.h * 0.4));
        g2.setStroke(new BasicStroke(10.0f, 1, 1));
        g.drawLine((int)this.cpos.sx, (int)this.cpos.sy, (int)this.cpos.ex, (int)this.cpos.ey);
        g.drawLine((int)this.cpos.ex, (int)this.cpos.ey, (int)this.cpos.wx, (int)this.cpos.wy);
        g.setColor(Color.pink);
        g2.setStroke(new BasicStroke(4.0f, 1, 1));
        g.drawLine((int)this.cpos.wx, (int)this.cpos.wy, (int)this.cpos.fx, (int)this.cpos.fy);
        g2.setStroke(new BasicStroke(12.0f, 1, 1));
        g.drawLine((int)this.cpos.wx, (int)this.cpos.wy, (int)(this.cpos.wx + 1.0), (int)(this.cpos.wy + 1.0));
    }

    void calcAngles() {
        this.cpos.sa += this.dsa;
        this.cpos.ea += this.dea;
        this.cpos.wa += this.dwa;
    }

    void setData(CNSData d) {
        this.data = d;
        this.update();
    }

    void update() {
        if (this.data == null) {
            return;
        }
        String side = this.sides[this.armSide];
        String contraSide = this.sides[(this.armSide + 1) % 2];
        this.rDeltoid = this.data.findRegion("deltoid-" + side);
        this.rBiceps = this.data.findRegion("biceps-" + side);
        this.rTriceps = this.data.findRegion("triceps-" + side);
        this.rExtensorCarpi = this.data.findRegion("extensor-carpi-radialis-" + side);
        this.rFlexorCarpi = this.data.findRegion("flexor-carpi-radialis-" + side);
        this.rNigra = this.data.findRegion("substantia-nigra-" + side);
        CNSData.Region motorCortex = this.data.findRegion("primary-motor-cortex-" + this.sides[1 - this.armSide]);
        this.deltoid = this.rDeltoid.getActivityFrom(motorCortex);
        this.biceps = this.rBiceps.getActivityFrom(motorCortex);
        this.triceps = this.rTriceps.getActivityFrom(motorCortex);
        this.extensorCarpi = this.rExtensorCarpi.getActivityFrom(motorCortex);
        this.flexorCarpi = this.rFlexorCarpi.getActivityFrom(motorCortex);
        double bgactivity = this.rNigra.getActivity();
        this.fingerNosePeriod = (int)((1.0 - bgactivity) * 2400.0) + 1200;
        this.movementSpeed = bgactivity * 2.0;
        this.RTmillis = (1.0 - bgactivity) * 500.0;
        double cbmlesion = 1.0 - this.data.findRegion("ventrolateral-thalamus-" + contraSide).getActivityFrom(this.data.findRegion("c7-dorsal-spinocerebellar-tract-" + side));
        this.correctionRate = 20.0 * Math.max(0.0, cbmlesion + bgactivity - 1.0);
        this.feedbackSpeed = cbmlesion;
        this.visualFeedback = Math.min(1.0, this.data.findRegion("v1-left").getActivity() + this.data.findRegion("v1-right").getActivity());
        this.proprioFeedback = Math.min(1.0, this.data.findRegion("primary-sensory-cortex-" + contraSide).getActivityFrom(this.data.findRegion("anterior-index-finger-touch-receptor-" + side)));
        if (this.eyesClosed) {
            this.visualFeedback = 0.0;
        }
    }

    void calcVelocities() {
        long time = System.currentTimeMillis() - this.commandTime;
        double fraction = this.profile(time);
        this.ctargpos.interpolate(this.otargPos, this.targPos, fraction);
        double fb = Math.min(1.0, (double)(System.currentTimeMillis() - this.commandTime) * 0.001 / 2.0);
        this.estimated.interpolate(this.ctargpos, this.cpos, fb * Math.min(1.0, this.proprioFeedback + this.visualFeedback));
        double ndsa = this.ctargpos.sa - this.ptargpos.sa;
        double ndea = this.ctargpos.ea - this.ptargpos.ea;
        double ndwa = this.ctargpos.wa - this.ptargpos.wa;
        double storq = -this.em * this.gravity * (this.estimated.ex - this.estimated.sx) - this.wm * this.gravity * (this.estimated.wx - this.estimated.sx) - this.fm * this.gravity * (this.estimated.fx - this.estimated.sx) + this.estimated.smi * (ndsa - this.dsa);
        double etorq = -this.wm * this.gravity * (this.estimated.wx - this.estimated.ex) - this.fm * this.gravity * (this.estimated.fx - this.estimated.ex) + this.estimated.emi * (ndea - this.dea);
        double wtorq = -this.fm * this.gravity * (this.estimated.fx - this.estimated.wx) + this.estimated.wmi * (ndwa - this.dwa);
        fb = Math.min(1.0, (double)(System.currentTimeMillis() - this.commandTime - 100L) * 0.001 * this.feedbackSpeed);
        this.estimated.interpolate(this.ctargpos, this.cpos, fb * Math.min(1.0, this.proprioFeedback + this.visualFeedback));
        double poserrx = this.targx - this.estimated.fx;
        double poserry = this.targy - this.estimated.fy;
        double sfa = this.cpos.sa + this.cpos.ea + this.cpos.wa;
        double errcrosswrist = -poserrx * Math.sin(sfa) + poserry * Math.cos(sfa);
        double efx = this.cpos.fx - this.cpos.ex;
        double efy = this.cpos.fy - this.cpos.ey;
        double efmod = Math.sqrt(efx * efx + efy * efy);
        double uprpex = -efy / efmod;
        double uprpey = efx / efmod;
        double errcrosselb = uprpex * poserrx + uprpey * poserry;
        double sfx = this.cpos.fx - this.cpos.sx;
        double sfy = this.cpos.fy - this.cpos.sy;
        double sfmod = Math.sqrt(sfx * sfx + sfy * sfy);
        double uprpsx = -sfx / sfmod;
        double uprpsy = sfx / sfmod;
        double errcrossshl = uprpsx * poserrx + uprpsy * poserry;
        double cr = this.isResting ? 1.0 : this.correctionRate;
        storq += Math.min(1.0, this.visualFeedback + this.proprioFeedback) * 10.0 * cr * fb * errcrossshl;
        etorq += Math.min(1.0, this.visualFeedback + this.proprioFeedback) * 6.0 * cr * fb * errcrosselb;
        wtorq += Math.min(1.0, this.visualFeedback + this.proprioFeedback) * 0.5 * cr * fb * errcrosswrist;
        if (storq < 0.0) {
            storq *= this.deltoid;
        }
        if (etorq < 0.0) {
            etorq *= this.biceps;
        }
        if (etorq > 0.0) {
            etorq *= this.triceps;
        }
        if (wtorq < 0.0) {
            wtorq *= this.extensorCarpi;
        }
        if (wtorq > 0.0) {
            wtorq *= this.flexorCarpi;
        }
        Pos d = this.cpos;
        double ddsa = (storq + this.em * this.gravity * (d.ex - d.sx) + this.wm * this.gravity * (d.wx - d.sx) + this.fm * this.gravity * (d.fx - d.sx)) / d.smi;
        double ddea = (etorq + this.wm * this.gravity * (d.wx - d.ex) + this.fm * this.gravity * (d.fx - d.ex)) / d.emi;
        double ddwa = (wtorq + this.fm * this.gravity * (d.fx - d.wx)) / d.wmi;
        this.dsa += ddsa;
        this.dea += ddea;
        this.dwa += ddwa;
        if (this.cpos.ey >= this.restingy) {
            this.dsa = Math.min(0.0, this.dsa);
        }
        if (this.cpos.wy >= this.restingy) {
            this.dea = Math.min(0.0, this.dea);
        }
        if (this.cpos.fx >= this.restingy) {
            this.dwa = Math.min(0.0, this.dwa);
        }
        if (this.cpos.ea > 0.02) {
            this.dea = 0.0;
            this.cpos.ea = 0.02;
        }
        if (this.cpos.ea < -3.121592653589793) {
            this.dea = 0.0;
            this.cpos.ea = -3.121592653589793;
        }
        this.ptargpos.copyFrom(this.ctargpos);
    }

    void calcCommand() {
        this.otargx = this.targx;
        this.otargy = this.targy;
        if (this.mouseDown) {
            if (this.doFingerNose & !this.eyesClosed) {
                if ((System.currentTimeMillis() - this.mouseDownTime) % this.fingerNosePeriod < this.fingerNosePeriod / 2L) {
                    this.targx = this.mx;
                    this.targy = this.my;
                } else {
                    this.targx = this.nosex;
                    this.targy = this.nosey;
                }
            } else if (this.eyesClosed) {
                this.targx = this.getWidth();
                this.targy = this.getHeight() / 2;
            } else {
                this.targx = this.mx;
                this.targy = this.my;
            }
            this.isResting = false;
        } else {
            this.targx = this.restingx;
            this.targy = this.restingy;
            this.isResting = true;
        }
        if (this.targx != this.otargx || this.targy != this.otargy) {
            this.commandTime = System.currentTimeMillis();
            this.otargPos = new Pos(this.cpos);
            this.targPos.relaxTo(this.targx, this.targy);
            this.ctargpos.copyFrom(this.cpos);
            this.ptargpos.copyFrom(this.ctargpos);
        }
    }

    double profile(long millis) {
        double t = Math.max(0.0, Math.min(1.0, this.movementSpeed * ((double)millis - this.RTmillis) / 1000.0));
        return (1.0 - Math.cos(Math.PI * t)) / 2.0;
    }

    void calc() {
        if (this.data == null) {
            return;
        }
        this.calcCommand();
        this.cpos.calcMI();
        this.calcVelocities();
        this.calcAngles();
        this.cpos.anglesToPos();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.timer.start();
    }

    public void removeNotify() {
        super.removeNotify();
        this.timer.stop();
    }

    public void reset() {
        this.h = this.getHeight();
        this.restingy = this.h - 5;
        this.restingx = 0.95 * (double)this.h;
        this.sl = (double)this.h * 0.45;
        this.el = (double)this.h * 0.4;
        this.wl = (double)this.h * 0.11;
        this.nosey = (double)this.h * 0.24;
        this.cpos.sy = (double)this.h * 0.7;
        this.cpos.relaxTo(this.restingx, this.restingy);
        this.dsa = 0.0;
        this.dea = 0.0;
        this.dwa = 0.0;
        this.targPos.copyFrom(this.cpos);
        this.ptargpos.copyFrom(this.cpos);
        this.update();
        this.calc();
    }

    class Mouse
    extends MouseAdapter
    implements MouseMotionListener {
        Mouse() {
        }

        public void mousePressed(MouseEvent e) {
            ArmPanel.this.mouseDown = true;
            ArmPanel.this.mouseDownTime = System.currentTimeMillis();
            ArmPanel.this.mx = e.getX();
            ArmPanel.this.my = e.getY();
        }

        public void mouseReleased(MouseEvent e) {
            ArmPanel.this.mouseDown = false;
        }

        public void mouseDragged(MouseEvent e) {
            ArmPanel.this.mx = e.getX();
            ArmPanel.this.my = e.getY();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    class Pos {
        double fx;
        double fy;
        double wx;
        double wy;
        double ex;
        double ey;
        double sx;
        double sy;
        double sa;
        double ea;
        double wa;
        double smi;
        double emi;
        double wmi;

        Pos(double sx, double sy, double sa, double ea, double wa) {
            this.sx = sx;
            this.sy = sy;
            this.sa = sa;
            this.ea = ea;
            this.wa = wa;
            this.anglesToPos();
        }

        Pos() {
        }

        Pos(Pos p) {
            this.copyFrom(p);
        }

        void anglesToPos() {
            this.ex = this.sx + ArmPanel.this.sl * Math.cos(this.sa);
            this.ey = this.sy + ArmPanel.this.sl * Math.sin(this.sa);
            this.wx = this.ex + ArmPanel.this.el * Math.cos(this.sa + this.ea);
            this.wy = this.ey + ArmPanel.this.el * Math.sin(this.sa + this.ea);
            this.fx = this.wx + ArmPanel.this.wl * Math.cos(this.sa + this.ea + this.wa);
            this.fy = this.wy + ArmPanel.this.wl * Math.sin(this.sa + this.ea + this.wa);
        }

        void copyFrom(Pos p) {
            this.fx = p.fx;
            this.fy = p.fy;
            this.wx = p.wx;
            this.wy = p.wy;
            this.ex = p.ex;
            this.ey = p.ey;
            this.sx = p.sx;
            this.sy = p.sy;
            this.sa = p.sa;
            this.ea = p.ea;
            this.wa = p.wa;
        }

        void interpolate(Pos p1, Pos p2, double f) {
            this.sx = p1.sx + (p2.sx - p1.sx) * f;
            this.sy = p1.sy + (p2.sy - p1.sy) * f;
            this.sa = p1.sa + (p2.sa - p1.sa) * f;
            this.ea = p1.ea + (p2.ea - p1.ea) * f;
            this.wa = p1.wa + (p2.wa - p1.wa) * f;
            this.anglesToPos();
            this.calcMI();
        }

        void relaxTo(double targx, double targy) {
            this.anglesToPos();
            double q = 0.99;
            int i = 0;
            while (i < 50) {
                this.fx = targx;
                this.fy = targy + 0.0;
                double fdist = Math.sqrt((this.wx - this.fx) * (this.wx - this.fx) + (this.wy - this.fy) * (this.wy - this.fy));
                double imptensf = q * (fdist - ArmPanel.this.wl);
                this.wx += (this.fx - this.wx) / fdist * imptensf;
                this.wy += (this.fy - this.wy) / fdist * imptensf;
                double edist = Math.sqrt((this.ex - this.wx) * (this.ex - this.wx) + (this.ey - this.wy) * (this.ey - this.wy));
                double imptense = q * (edist - ArmPanel.this.el);
                double sdist = Math.sqrt((this.sx - this.ex) * (this.sx - this.ex) + (this.sy - this.ey) * (this.sy - this.ey));
                double imptenss = q * (sdist - ArmPanel.this.sl);
                this.ex += (this.wx - this.ex) / edist * imptense + (this.sx - this.ex) / sdist * imptenss;
                this.ey += (this.wy - this.ey) / edist * imptense + (this.sy - this.ey) / sdist * imptenss;
                this.ey += 5.0;
                this.wy += 0.2;
                this.fx += 1.0;
                this.posToAngles();
                if (this.ea > 0.0) {
                    this.ea = -this.ea;
                    this.anglesToPos();
                }
                ++i;
            }
            this.anglesToPos();
        }

        void posToAngles() {
            this.sa = Math.atan2(this.ey - this.sy, this.ex - this.sx);
            this.ea = Math.atan2(this.wy - this.ey, this.wx - this.ex) - this.sa;
            this.wa = Math.atan2(this.fy - this.wy, this.fx - this.wx) - this.ea - this.sa;
        }

        void calcMI() {
            double tmp = ArmPanel.this.sl + ArmPanel.this.el * Math.cos(this.ea);
            double d = ArmPanel.this.em * ArmPanel.this.sl * ArmPanel.this.sl + ArmPanel.this.wm * tmp * tmp;
            tmp = ArmPanel.this.sl + ArmPanel.this.el * Math.cos(this.ea) + ArmPanel.this.wl * Math.cos(this.ea + this.wa);
            this.smi = d + ArmPanel.this.fm * tmp * tmp;
            tmp = ArmPanel.this.wl * Math.cos(this.wa);
            this.emi = ArmPanel.this.wm * ArmPanel.this.el * ArmPanel.this.el + ArmPanel.this.fm * tmp * tmp;
            this.wmi = ArmPanel.this.fm * ArmPanel.this.wl * ArmPanel.this.wl;
        }
    }
}

