/*
 * Decompiled with CFR 0.152.
 */
package sanjay.common;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RadialPaint
implements Paint,
PaintContext {
    Color c1;
    Color c2;
    Point centre;
    int fallof;
    BufferedImage im = null;
    ColorModel cm = ColorModel.getRGBdefault();
    Rectangle b;
    AffineTransform tf = AffineTransform.getTranslateInstance(0.0, 0.0);

    public RadialPaint(Color c1, Color c2, Point centre, int fallof) {
        this.c1 = c1;
        this.c2 = c2;
        this.centre = centre;
        this.fallof = fallof;
    }

    public void dispose() {
        this.im = null;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        Point2D p = this.tf.transform(new Point(x, y), null);
        Point2D c = this.tf.transform(this.centre, null);
        WritableRaster r = this.getColorModel().createCompatibleWritableRaster(w, h);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                double f = Math.min(c.distance(i + x, j + y) / (double)this.fallof, 1.0);
                r.setPixel(i, j, new int[]{(int)((double)this.c1.getRed() * (1.0 - f) + (double)this.c2.getRed() * f), (int)((double)this.c1.getGreen() * (1.0 - f) + (double)this.c2.getGreen() * f), (int)((double)this.c1.getBlue() * (1.0 - f) + (double)this.c2.getBlue() * f), 255});
                ++j;
            }
            ++i;
        }
        return r;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        int x = (int)userBounds.getX();
        int y = (int)userBounds.getY();
        int w = (int)userBounds.getWidth();
        int h = (int)userBounds.getHeight();
        this.b = new Rectangle(x, y, w, h);
        this.tf = xform;
        return this;
    }

    public int getTransparency() {
        return 1;
    }
}

