/*
 * Decompiled with CFR 0.152.
 */
package sanjay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.UIManager;

public class ROCPanel
extends JPanel
implements AdjustmentListener {
    int x0 = 10;
    int y0 = 10;
    int xtick = 10;
    int ytick = 10;
    int ticklength = 4;
    double prevalance = 0.2;
    int population = 12000;
    int criterion = 70;
    int mu1 = 100;
    int mu2 = 160;
    int sigma1 = 50;
    int sigma2 = 25;
    private JPanel panel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension size = this.getSize();
            int base = size.height - ROCPanel.this.y0;
            g.drawLine(0, base, size.width, base);
            g.drawLine(ROCPanel.this.x0, 0, ROCPanel.this.x0, size.height);
            int i = 0;
            while (i < size.width) {
                g.drawLine(i, base, i, base - ROCPanel.this.ticklength);
                i += ROCPanel.this.xtick;
            }
            i = 0;
            while (i < size.height) {
                g.drawLine(ROCPanel.this.x0, i, ROCPanel.this.x0 + ROCPanel.this.ticklength, i);
                i += ROCPanel.this.ytick;
            }
            int oh = 0;
            ROCPanel.this.fn = 0;
            ROCPanel.this.fp = 0;
            ROCPanel.this.tn = 0;
            ROCPanel.this.tp = 0;
            g.setColor(Color.blue);
            double ampl1 = (double)ROCPanel.this.population * (1.0 - ROCPanel.this.prevalance) / (double)ROCPanel.this.sigma1;
            int i2 = 0;
            while (i2 < size.width) {
                int h = (int)(ampl1 * ROCPanel.this.gaussian((double)(i2 - ROCPanel.this.mu1) / (double)ROCPanel.this.sigma1));
                if (i2 < ROCPanel.this.criterion) {
                    ROCPanel.this.tn += h;
                } else {
                    ROCPanel.this.fp += h;
                }
                if (i2 < ROCPanel.this.criterion || i2 % 2 == 0) {
                    g.drawLine(i2 - 1, base - oh, i2, base - h);
                } else {
                    g.drawLine(i2, base, i2, base - h);
                }
                oh = h;
                ++i2;
            }
            g.setColor(Color.red);
            double ampl2 = (double)ROCPanel.this.population * ROCPanel.this.prevalance / (double)ROCPanel.this.sigma2;
            int i3 = 0;
            while (i3 < size.width) {
                int h = (int)(ampl2 * ROCPanel.this.gaussian((double)(i3 - ROCPanel.this.mu2) / (double)ROCPanel.this.sigma2));
                if (i3 < ROCPanel.this.criterion) {
                    ROCPanel.this.fn += h;
                } else {
                    ROCPanel.this.tp += h;
                }
                if (i3 < ROCPanel.this.criterion || i3 % 2 == 1) {
                    g.drawLine(i3 - 1, base - oh, i3, base - h);
                } else {
                    g.drawLine(i3, base, i3, base - h);
                }
                oh = h;
                ++i3;
            }
            ROCPanel.this.total = ROCPanel.this.fn + ROCPanel.this.fp + ROCPanel.this.tn + ROCPanel.this.tp;
        }
    };
    int tp;
    int fp;
    int tn;
    int fn;
    double total;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel panel1 = new JPanel();
    private JScrollBar critscroll = new JScrollBar();
    private JScrollBar prevscroll = new JScrollBar();
    private GridLayout gridLayout1 = new GridLayout();
    private JScrollBar mu2scroll = new JScrollBar();
    private JLabel JLabel1 = new JLabel();
    private JLabel JLabel2 = new JLabel();
    private JLabel JLabel3 = new JLabel();
    private JScrollBar sigma2scroll = new JScrollBar();
    private JLabel JLabel4 = new JLabel();
    private JPanel bottompanel = new JPanel();
    private ROCgPanel rocpanel = new ROCgPanel();
    private JPanel panel3 = new JPanel();
    private JLabel JLabel5 = new JLabel();
    private JButton helpbutton = new JButton();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel panel2 = new JPanel();
    private GridLayout gridLayout2 = new GridLayout();
    private JLabel JLabel6 = new JLabel();
    private JLabel tfn = new JLabel();
    private JLabel ttn = new JLabel();
    private JLabel tfp = new JLabel();
    private JLabel ttp = new JLabel();
    private JLabel JLabel11 = new JLabel();
    private JLabel JLabel12 = new JLabel();
    private JLabel JLabel13 = new JLabel();
    private JPanel panel4 = new JPanel();
    private GridLayout gridLayout3 = new GridLayout();
    private JLabel JLabel7 = new JLabel();
    private JLabel tnp = new JLabel();
    private JLabel tpp = new JLabel();
    private JLabel tspec = new JLabel();
    private JLabel tsens = new JLabel();
    private JLabel JLabel15 = new JLabel();
    private JLabel JLabel16 = new JLabel();
    private JLabel JLabel17 = new JLabel();
    JPanel controlpane = new JPanel();

    final double gaussian(double x) {
        return Math.exp(-x * x);
    }

    public ROCPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] s) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame();
        f.getContentPane().add((Component)new ROCPanel(), "Center");
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setTitle("Receiver Operating Characteristic");
        f.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.critscroll.addAdjustmentListener(this);
        this.prevscroll.addAdjustmentListener(this);
        this.mu2scroll.addAdjustmentListener(this);
        this.sigma2scroll.addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.panel.setLayout(this.borderLayout1);
        this.panel.setBackground(Color.white);
        this.panel.setSize(new Dimension(300, 300));
        this.critscroll.setMaximum(300);
        this.critscroll.setOrientation(0);
        this.critscroll.setBlockIncrement(25);
        this.critscroll.setUnitIncrement(5);
        this.critscroll.setValue(70);
        this.prevscroll.setOrientation(0);
        this.prevscroll.setValue(20);
        this.controlpane.setLayout(new BorderLayout());
        this.controlpane.add((Component)this.panel1, "North");
        this.controlpane.add((Component)this.rocpanel, "Center");
        this.add((Component)this.controlpane, "East");
        this.panel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(14);
        this.JLabel1.setText("Criterion");
        this.JLabel2.setText("Disease Prevalence");
        this.JLabel3.setText("Disease Mean");
        this.mu2scroll.setMaximum(250);
        this.mu2scroll.setMinimum(50);
        this.mu2scroll.setOrientation(0);
        this.mu2scroll.setValue(160);
        this.sigma2scroll.setMinimum(1);
        this.sigma2scroll.setOrientation(0);
        this.sigma2scroll.setValue(25);
        this.JLabel4.setText("Disease Deviation");
        this.JLabel5.setText("Receiver operating characteristic");
        this.helpbutton.setText("Help");
        this.helpbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ROCPanel.this.helpbutton_actionPerformed(e);
            }
        });
        this.bottompanel.setLayout(this.borderLayout2);
        this.panel2.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(4);
        this.gridLayout2.setRows(2);
        this.JLabel6.setBackground(Color.pink);
        this.JLabel6.setForeground(Color.red);
        this.JLabel6.setText("True positives");
        this.tfn.setText("0");
        this.ttn.setText("0");
        this.tfp.setText("0");
        this.ttp.setText("0");
        this.JLabel11.setForeground(Color.red);
        this.JLabel11.setText("False negatives");
        this.JLabel12.setForeground(Color.blue);
        this.JLabel12.setText("True negatives");
        this.JLabel13.setForeground(Color.blue);
        this.JLabel13.setText("False positives");
        this.JLabel13.setBackground(new Color(128, 128, 255));
        this.panel4.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(4);
        this.gridLayout3.setRows(2);
        this.JLabel7.setText("Sensitivity");
        this.tnp.setText("0");
        this.tpp.setText("0");
        this.tspec.setText("0");
        this.tsens.setText("0");
        this.JLabel15.setText("Negative predictive");
        this.JLabel16.setText("Positive Predictive");
        this.JLabel17.setText("Specificity");
        this.panel1.add((Component)this.JLabel2, null);
        this.panel1.add((Component)this.prevscroll, null);
        this.panel1.add((Component)this.JLabel3, null);
        this.panel1.add((Component)this.mu2scroll, null);
        this.panel1.add((Component)this.JLabel4, null);
        this.panel1.add((Component)this.sigma2scroll, null);
        this.panel1.add(this.JLabel1);
        this.panel1.add(this.critscroll);
        this.critscroll.setSize(100, 20);
        this.rocpanel.setPreferredSize(new Dimension(100, 100));
        this.rocpanel.setBackground(Color.white);
        this.add((Component)this.panel, "Center");
        this.panel.setPreferredSize(new Dimension(279, 238));
        this.add((Component)this.bottompanel, "South");
        this.bottompanel.add((Component)this.panel2, "Center");
        this.panel2.add((Component)this.JLabel6, null);
        this.JLabel6.setOpaque(true);
        this.panel2.add((Component)this.JLabel13, null);
        this.JLabel13.setOpaque(true);
        this.panel2.add((Component)this.JLabel12, null);
        this.panel2.add((Component)this.JLabel11, null);
        this.panel2.add((Component)this.ttp, null);
        this.panel2.add((Component)this.tfp, null);
        this.panel2.add((Component)this.ttn, null);
        this.panel2.add((Component)this.tfn, null);
        this.bottompanel.add((Component)this.panel4, "South");
        this.panel4.add((Component)this.JLabel7, null);
        this.panel4.add((Component)this.JLabel17, null);
        this.panel4.add((Component)this.JLabel16, null);
        this.panel4.add((Component)this.JLabel15, null);
        this.panel4.add((Component)this.tsens, null);
        this.panel4.add((Component)this.tspec, null);
        this.panel4.add((Component)this.tpp, null);
        this.panel4.add((Component)this.tnp, null);
        this.add((Component)this.panel3, "North");
        this.panel3.add((Component)this.JLabel5, null);
        this.panel3.add((Component)this.helpbutton, null);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.criterion = this.critscroll.getValue();
        this.prevalance = (double)this.prevscroll.getValue() / 100.0;
        this.mu2 = this.mu2scroll.getValue();
        this.sigma2 = this.sigma2scroll.getValue();
        this.panel.repaint();
        if (this.rocpanel != null) {
            this.rocpanel.repaint();
        }
        this.calc();
    }

    void helpbutton_actionPerformed(ActionEvent e) {
    }

    void calc() {
        if (this.total > 0.0) {
            this.ttp.setText(this.percent((double)this.tp / this.total));
            this.tfp.setText(this.percent((double)this.fp / this.total));
            this.ttn.setText(this.percent((double)this.tn / this.total));
            this.tfn.setText(this.percent((double)this.fn / this.total));
        }
        this.tsens.setText(this.percent((double)this.tp / (double)(this.tp + this.fn)));
        this.tspec.setText(this.percent((double)this.tn / (double)(this.fp + this.tn)));
        this.tpp.setText(this.percent((double)this.tp / (double)(this.tp + this.fp)));
        this.tnp.setText(this.percent((double)this.tn / (double)(this.fn + this.tn)));
    }

    String percent(double v) {
        return String.valueOf(String.valueOf((double)((int)(v * 1000.0)) / 10.0)) + "%";
    }

    class ROCgPanel
    extends JPanel {
        ROCgPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension size = this.getSize();
            int base = size.height - ROCPanel.this.y0;
            g.drawLine(0, base, size.width, base);
            g.drawLine(ROCPanel.this.x0, 0, ROCPanel.this.x0, size.height);
            int i = 0;
            while (i < size.width) {
                g.drawLine(i, base, i, base - ROCPanel.this.ticklength);
                i += ROCPanel.this.xtick;
            }
            i = 0;
            while (i < size.height) {
                g.drawLine(ROCPanel.this.x0, i, ROCPanel.this.x0 + ROCPanel.this.ticklength, i);
                i += ROCPanel.this.ytick;
            }
            int N = size.width;
            int[] tnc = new int[N];
            int[] fpc = new int[N];
            int[] fnc = new int[N];
            int[] tpc = new int[N];
            int ox = -1;
            int oy = -1;
            int cri = 0;
            while (cri < size.width) {
                double ampl1 = (double)ROCPanel.this.population * (1.0 - ROCPanel.this.prevalance) / (double)ROCPanel.this.sigma1;
                int i2 = 0;
                while (i2 < size.width) {
                    int h = (int)(ampl1 * ROCPanel.this.gaussian((double)(i2 - ROCPanel.this.mu1) / (double)ROCPanel.this.sigma1));
                    if (i2 < cri) {
                        int n = cri;
                        tnc[n] = tnc[n] + h;
                    } else {
                        int n = cri;
                        fpc[n] = fpc[n] + h;
                    }
                    ++i2;
                }
                double ampl2 = (double)ROCPanel.this.population * ROCPanel.this.prevalance / (double)ROCPanel.this.sigma2;
                int i3 = 0;
                while (i3 < size.width) {
                    int h = (int)(ampl2 * ROCPanel.this.gaussian((double)(i3 - ROCPanel.this.mu2) / (double)ROCPanel.this.sigma2));
                    if (i3 < cri) {
                        int n = cri;
                        fnc[n] = fnc[n] + h;
                    } else {
                        int n = cri;
                        tpc[n] = tpc[n] + h;
                    }
                    ++i3;
                }
                double totalc = tpc[cri] + fnc[cri] + tnc[cri] + fnc[cri];
                double totaln = tnc[cri] + fpc[cri];
                double totalp = tpc[cri] + fnc[cri];
                if (totalp > 0.0 && totaln > 0.0) {
                    int x = (int)((double)fpc[cri] / totaln * (double)size.width);
                    int y = size.height - (int)((double)tpc[cri] / totalp * (double)size.height);
                    if (ox >= 0) {
                        g.drawLine(ox, oy, x, y);
                    }
                    ox = x;
                    oy = y;
                }
                ++cri;
            }
        }
    }
}

