/*
 * Decompiled with CFR 0.152.
 */
package sanjay;

import sanjay.Matrix;
import sanjay.Vector3;

public class Matrix33
implements Matrix,
Cloneable {
    double[][] a = new double[3][3];
    public static Matrix33 identity = new Matrix33(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);

    public Matrix33() {
    }

    public Matrix33(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        this.a[0][0] = a00;
        this.a[0][1] = a01;
        this.a[0][2] = a02;
        this.a[1][0] = a10;
        this.a[1][1] = a11;
        this.a[1][2] = a12;
        this.a[2][0] = a20;
        this.a[2][1] = a21;
        this.a[2][2] = a22;
    }

    public Matrix scalarMultiply(double d) {
        Matrix33 m = null;
        try {
            m = (Matrix33)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double[] dArray = m.a[i];
                int n = j++;
                dArray[n] = dArray[n] * d;
            }
            ++i;
        }
        return m;
    }

    public Matrix33 dot(Matrix33 m) {
        if (!(m instanceof Matrix33)) {
            throw new IllegalArgumentException("Requires Matrix33");
        }
        Matrix33 m2 = m;
        Matrix33 v = new Matrix33();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    double[] dArray = v.a[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.a[i][j] * m2.a[j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Matrix addElements(Matrix m) {
        if (!(m instanceof Matrix33)) {
            throw new IllegalArgumentException("Requires Matrix33");
        }
        Matrix33 m3 = null;
        Matrix33 m2 = null;
        try {
            m3 = (Matrix33)this.clone();
            m2 = (Matrix33)m;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double[] dArray = m3.a[i];
                int n = j;
                dArray[n] = dArray[n] + m2.a[i][j];
                ++j;
            }
            ++i;
        }
        return m3;
    }

    public double determinant() {
        return this.a[0][0] * (this.a[1][1] * this.a[2][2] - this.a[2][1] * this.a[1][2]) - this.a[1][0] * (this.a[0][1] * this.a[2][2] - this.a[2][1] * this.a[0][2]) + this.a[2][1] * (this.a[0][1] * this.a[1][2] - this.a[1][1] * this.a[0][2]);
    }

    public Vector3 dot(Vector3 v) {
        Vector3 r = new Vector3();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int n = i;
                r.a[n] = r.a[n] + this.a[i][j] * v.a[j];
                ++j;
            }
            ++i;
        }
        return r;
    }
}

