/*
 * Decompiled with CFR 0.152.
 */
package medicine.visual;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JPanel;
import medicine.Entity;
import medicine.visual.Node;

public class GraphicPane
extends JPanel
implements Runnable {
    int dragx;
    int dragy;
    Entity entity;
    public int rangeC = 3;
    public int rangeH = 0;
    boolean forward;
    boolean backward;
    Node central;
    Node dragging;
    Vector visibleNodes = new Vector();
    int[] left;
    int[] right;
    int[] up;
    int[] down;
    Thread thread;
    boolean running;
    double defaultLength;
    double rate;
    double repulsion;
    double damping;

    public GraphicPane() {
        int[] nArray = new int[2];
        nArray[0] = -1;
        this.left = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        this.right = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = -1;
        this.up = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        this.down = nArray4;
        this.thread = new Thread((Runnable)this, "Arranger");
        this.running = true;
        this.defaultLength = 70.0;
        this.rate = 0.3;
        this.repulsion = 100.0;
        this.damping = 0.8;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Node n = GraphicPane.this.nodeFromPoint(e.getPoint());
                if (n != null) {
                    GraphicPane.this.dragging = n;
                    GraphicPane.this.dragx = e.getX();
                    GraphicPane.this.dragy = e.getY();
                }
            }

            public void mouseReleased(MouseEvent e) {
                GraphicPane.this.dragging = null;
            }

            public void mouseClicked(MouseEvent e) {
                Node n;
                if (e.getClickCount() == 2 && (n = GraphicPane.this.nodeFromPoint(e.getPoint())) != null) {
                    GraphicPane.this.setEntity(n.entity);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (GraphicPane.this.dragging != null) {
                    int dx = e.getX() - GraphicPane.this.dragx;
                    int dy = e.getY() - GraphicPane.this.dragy;
                    GraphicPane.this.dragging.x += (double)dx;
                    GraphicPane.this.dragging.y += (double)dy;
                    GraphicPane.this.dragx = e.getX();
                    GraphicPane.this.dragy = e.getY();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                GraphicPane.this.central.x = GraphicPane.this.getWidth() / 2;
                GraphicPane.this.central.y = GraphicPane.this.getHeight() / 2;
            }
        });
        this.setBackground(new Color(0, 0, 128));
        this.thread.start();
    }

    public void setEntity(Entity e) {
        this.entity = e;
        this.initialiseNodes();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setRange(int c, int h) {
        this.rangeC = c;
        this.rangeH = h;
        this.initialiseNodes();
    }

    void initialiseNodes() {
        this.visibleNodes = new Vector();
        this.central = new Node(this.entity, this.getWidth() / 2, this.getHeight() / 2);
        this.visibleNodes.add(this.central);
        if (this.rangeC > 0) {
            this.doBranch(this.central, 4, this.left, this.rangeC - 1);
            this.doBranch(this.central, 8, this.right, this.rangeC - 1);
        }
        if (this.rangeH > 0) {
            this.doBranch(this.central, 2, this.down, this.rangeH - 1);
            this.doBranch(this.central, 1, this.up, this.rangeH - 1);
        }
        this.repaint();
    }

    void doBranch(Node node, int rel, int[] direction, int count) {
        Vector v = node.createBranches(rel, direction);
        if (count > 0) {
            int i = 0;
            while (i < v.size()) {
                Node n = (Node)v.get(i);
                this.doBranch(n, rel, direction, count - 1);
                ++i;
            }
        }
        this.visibleNodes.addAll(v);
    }

    public Node nodeFromPoint(Point p) {
        int i = 0;
        while (i < this.visibleNodes.size()) {
            Node n = (Node)this.visibleNodes.get(i);
            if (n.contains(p)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        int i = 0;
        while (i < this.visibleNodes.size()) {
            Node n = (Node)this.visibleNodes.get(i);
            n.paint(g);
            ++i;
        }
    }

    int[] directionForRelation(int relation) {
        switch (relation) {
            case 4: {
                return this.left;
            }
            case 8: {
                return this.right;
            }
            case 1: {
                return this.up;
            }
            case 2: {
                return this.down;
            }
        }
        return null;
    }

    public void run() {
        while (this.running) {
            this.rearrange();
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void rearrange() {
        double krepulsion = this.repulsion / (double)this.visibleNodes.size();
        int i = 0;
        while (i < this.visibleNodes.size()) {
            Node node = (Node)this.visibleNodes.get(i);
            if (this.dragging != node && node != this.central) {
                double fx = 0.0;
                double fy = 0.0;
                int j = 0;
                while (j < this.visibleNodes.size()) {
                    double ty;
                    double tx;
                    double d;
                    Node cnode = (Node)this.visibleNodes.get(j);
                    if (cnode != node && (d = Math.sqrt((tx = cnode.x - node.x) * tx + (ty = cnode.y - node.y) * ty)) != 0.0) {
                        double forceFrac;
                        if (node.rconnections.indexOf(cnode) >= 0) {
                            forceFrac = this.rate * (1.0 - this.defaultLength / d);
                            fx += tx * forceFrac;
                            fy += ty * forceFrac;
                        } else {
                            forceFrac = krepulsion / (d * d + 0.01);
                            fx -= tx * forceFrac;
                            fy -= ty * forceFrac;
                        }
                    }
                    ++j;
                }
                node.vx += fx;
                node.vy += fy;
                node.vx *= this.damping;
                node.vy *= this.damping;
                node.x += node.vx;
                node.y += node.vy;
                if (node.x < 0.0) {
                    node.x = 0.0;
                }
                if (node.x > (double)this.getWidth()) {
                    node.x = this.getWidth();
                }
                if (node.y < 0.0) {
                    node.y = 0.0;
                }
                if (node.y > (double)this.getHeight()) {
                    node.y = this.getHeight();
                }
            }
            ++i;
        }
    }

    public void setDirection(boolean forward, boolean backward) {
        this.forward = forward;
        this.backward = backward;
        this.initialiseNodes();
    }
}

