/*
 * Decompiled with CFR 0.152.
 */
package medicine.mcq;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import medicine.Entities;
import medicine.Entity;

public class RootCreator
extends JDialog {
    CreatorPane cp = new CreatorPane();
    public String text = "";
    Action exit = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            RootCreator.this.text = RootCreator.this.cp.text.getText();
            RootCreator.this.setVisible(false);
        }
    };

    public RootCreator(Entity root, int dir, Entity correct, String text) {
        this.cp.text.setText(text);
        this.cp.setRootAndCorrect(root, dir, correct);
        this.getContentPane().add(this.cp);
        JPanel butPan = new JPanel();
        this.getContentPane().add((Component)butPan, "South");
        butPan.add(new JButton(this.exit));
        this.pack();
    }

    class CreatorPane
    extends JPanel {
        Entity root;
        Entity correct;
        int dir;
        String symptomlist;
        AbstractAction listAddAction = new AbstractAction("Add"){

            public void actionPerformed(ActionEvent e) {
                Entity a = (Entity)CreatorPane.this.addingList.getSelectedValue();
                CreatorPane.this.addedFeatures.add(a);
                CreatorPane.this.updateText();
            }
        };
        JTextPane text = new JTextPane();
        JPanel addingPanel = new JPanel();
        JList addingList = new JList();
        JPanel directionRadios = new JPanel();
        JRadioButton bRC = new JRadioButton("Root Causes");
        JRadioButton bRE = new JRadioButton("Root Effects");
        JRadioButton bCC = new JRadioButton("Correct Causes");
        JRadioButton bCE = new JRadioButton("Correct Effects");
        ButtonGroup bg = new ButtonGroup();
        JButton listAddButton = new JButton(this.listAddAction);
        JPanel topPanel = new JPanel();
        JSpinner ageSpin = new JSpinner();
        JComboBox sexCombo = new JComboBox();
        JScrollPane scroll = new JScrollPane(this.addingList);
        JCheckBox useRootCheck = new JCheckBox("Mention root?", true);
        JSpinner listDepth = new JSpinner(new SpinnerNumberModel(2, 1, 5, 1));
        Vector addedFeatures = new Vector();
        int listtype = -1;
        int DEPTH = 2;
        ActionListener radiolisten = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreatorPane.this.updateList();
            }
        };
        int EXTRADIRFLAGS = 1;
        boolean SHOWROOT = true;
        ActionListener updAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreatorPane.this.updateText();
            }
        };
        ItemListener updIL = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CreatorPane.this.updateText();
            }
        };
        ChangeListener updCL = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CreatorPane.this.updateText();
            }
        };

        void setRootAndCorrect(Entity r, int d, Entity c) {
            this.root = r;
            this.dir = d;
            this.correct = c;
            this.bRC.setText("Causes of " + r);
            this.bRE.setText("Effects of " + r);
            this.bCC.setText("Causes of " + c);
            this.bCE.setText("Effects of " + c);
            this.bRE.doClick();
            this.updateText();
        }

        public CreatorPane() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.text, "Center");
            this.add((Component)this.addingPanel, "East");
            this.add((Component)this.topPanel, "North");
            this.addingPanel.setLayout(new BorderLayout());
            this.addingPanel.add((Component)this.scroll, "Center");
            this.addingPanel.add((Component)this.directionRadios, "North");
            this.directionRadios.setPreferredSize(new Dimension(200, 120));
            this.text.setPreferredSize(new Dimension(200, 400));
            this.addingPanel.add((Component)this.listAddButton, "South");
            this.directionRadios.add(this.bRC);
            this.directionRadios.add(this.bRE);
            this.directionRadios.add(this.bCC);
            this.directionRadios.add(this.bCE);
            this.bg.add(this.bRC);
            this.bg.add(this.bRE);
            this.bg.add(this.bCC);
            this.bg.add(this.bCE);
            this.bRC.addActionListener(this.radiolisten);
            this.bRE.addActionListener(this.radiolisten);
            this.bCC.addActionListener(this.radiolisten);
            this.bCE.addActionListener(this.radiolisten);
            this.topPanel.add(this.ageSpin);
            this.ageSpin.setModel(new SpinnerNumberModel(55, 25, 85, 10));
            this.ageSpin.addChangeListener(this.updCL);
            this.listDepth.addChangeListener(this.updCL);
            this.topPanel.add(this.sexCombo);
            this.topPanel.add(this.useRootCheck);
            this.topPanel.add(this.listDepth);
            this.useRootCheck.addActionListener(this.updAL);
            this.sexCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"man", "woman"}));
            this.sexCombo.addItemListener(this.updIL);
        }

        public void updateList() {
            Set lst = new HashSet();
            if (this.bRC.isSelected()) {
                this.listtype = 0;
                lst = Entities.getExtensiveListOf(4 | this.EXTRADIRFLAGS, this.root, this.DEPTH);
            } else if (this.bRE.isSelected()) {
                this.listtype = 1;
                lst = Entities.getExtensiveListOf(8 | this.EXTRADIRFLAGS, this.root, this.DEPTH);
            } else if (this.bCC.isSelected()) {
                this.listtype = 2;
                lst = Entities.getExtensiveListOf(4 | this.EXTRADIRFLAGS, this.correct, this.DEPTH);
            } else if (this.bCE.isSelected()) {
                this.listtype = 3;
                lst = Entities.getExtensiveListOf(8 | this.EXTRADIRFLAGS, this.correct, this.DEPTH);
            }
            Vector lst2 = new Vector(lst);
            if (lst2.size() > 0) {
                Entities.filterVectorForStandardParents(lst2, Entities.E_SIGN | Entities.E_SYMPTOM | Entities.E_PATHOLOGY);
            }
            this.addingList.setListData(lst2);
        }

        String getPronoun() {
            if (this.sexCombo.getSelectedIndex() == 0) {
                return "He";
            }
            return "She";
        }

        void updateText() {
            String str = "";
            this.SHOWROOT = this.useRootCheck.isSelected();
            this.DEPTH = (Integer)this.listDepth.getValue();
            boolean index = false;
            int age = (Integer)this.ageSpin.getValue() + (int)(Math.random() * 11.0) - 5;
            str = String.valueOf(str) + "A " + age + "-year-old " + this.sexCombo.getSelectedItem();
            if (this.SHOWROOT) {
                str = String.valueOf(str) + " has " + this.root + ". " + this.listGrouped(this.addedFeatures, true);
            } else if (this.addedFeatures.size() > 0) {
                str = String.valueOf(str) + this.listGrouped(this.addedFeatures, false);
            }
            this.text.setText(str);
            this.updateList();
        }

        String listGrouped(Vector v, boolean sentence) {
            Vector<String> info = new Vector<String>();
            int infot = 0;
            Vector v1 = new Vector(v);
            Entities.filterVectorForStandardParents(v1, Entities.E_SYMPTOM);
            if (v1.size() > 0) {
                if (sentence) {
                    info.add(String.valueOf(this.getPronoun()) + " presented with " + Entities.listToText(v1) + ". ");
                } else {
                    info.add("presented with " + Entities.listToText(v1) + ". ");
                }
                infot |= Entities.E_SYMPTOM;
                sentence = true;
            }
            v1 = new Vector(v);
            Entities.filterVectorForStandardParents(v1, Entities.E_SIGN);
            if (v1.size() > 0) {
                if (sentence) {
                    info.add("Examination revealed " + Entities.listToText(v1) + ". ");
                } else {
                    info.add("was noted to have " + Entities.listToText(v1) + " on examination. ");
                }
                infot |= Entities.E_SIGN;
            }
            v1 = new Vector(v);
            Entities.filterVectorForStandardParents(v1, Entities.E_PATHOLOGY);
            if (v1.size() > 0) {
                if (sentence) {
                    info.add(String.valueOf(this.getPronoun()) + " had " + Entities.listToText(v1) + ". ");
                } else {
                    info.add("had " + Entities.listToText(v1) + ". ");
                }
                infot |= Entities.E_PATHOLOGY;
            }
            v1 = new Vector(v);
            Entities.filterVectorForStandardParents(v1, Entities.E_INVESTIGATION);
            if (v1.size() > 0) {
                if (sentence) {
                    info.add("Investigations showed " + Entities.listToText(v1) + ". ");
                } else {
                    info.add("was found to have " + Entities.listToText(v1) + " on investigation. ");
                }
                infot |= Entities.E_INVESTIGATION;
            }
            String list = "";
            int i = 0;
            while (i < info.size()) {
                list = String.valueOf(list) + (String)info.get(i);
                ++i;
            }
            return list;
        }
    }
}

