/*
 * Decompiled with CFR 0.152.
 */
package medicine.mcq;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import medicine.Entity;
import medicine.EntityData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Question
implements Serializable {
    Vector<Stem> correctStem = new Vector();
    Vector<Stem> errorStems = new Vector();
    int direction;
    Entity root;
    String head;
    int mode;
    int difficulty;
    static final int DIF1 = 1;
    static final int DIF2 = 2;
    static final int DIF3 = 3;
    static final int DIF4 = 4;
    int status;
    static final int STAT_OK = 3;
    static final int STAT_CHECK = 2;
    static final int STAT_UNCHECKED = 1;

    Vector<Stem> getCorrectStems() {
        return this.correctStem;
    }

    Vector<Stem> getIncorrectStems() {
        return this.errorStems;
    }

    Properties toProps() {
        Properties p = new Properties();
        int i = 0;
        while (i < this.correctStem.size()) {
            p.setProperty("Correct" + i, this.correctStem.get((int)i).entity.toString());
            p.setProperty("CorrectReasoning" + i, this.correctStem.get((int)i).reasoning);
            ++i;
        }
        i = 0;
        while (i < this.errorStems.size()) {
            p.setProperty("Incorrect" + i, this.errorStems.get((int)i).entity.toString());
            p.setProperty("IncorrectReasoning" + i, this.errorStems.get((int)i).reasoning);
            ++i;
        }
        p.setProperty("Head", this.head);
        p.setProperty("Root", this.root.toString());
        p.setProperty("Direction", String.valueOf(this.direction));
        p.setProperty("Mode", String.valueOf(this.mode));
        p.setProperty("Difficulty", String.valueOf(this.difficulty));
        return p;
    }

    void fromProps(Properties p, EntityData ed) {
        Stem s;
        String o;
        int i = 0;
        do {
            if ((o = p.getProperty("Correct" + i)) != null) {
                s = new Stem();
                s.correct = true;
                s.entity = ed.findEntityExact(o);
                if (s.entity == null) {
                    s.entity = new FakeEntity(o);
                }
                s.reasoning = p.getProperty("CorrectReasoning" + i);
                this.correctStem.add(s);
            }
            ++i;
        } while (o != null);
        i = 0;
        o = null;
        do {
            if ((o = p.getProperty("Incorrect" + i)) != null) {
                s = new Stem();
                s.correct = false;
                s.entity = ed.findEntityExact(o);
                if (s.entity == null) {
                    s.entity = new FakeEntity(o);
                }
                s.reasoning = p.getProperty("IncorrectReasoning" + i);
                this.errorStems.add(s);
            }
            ++i;
        } while (o != null);
        this.head = p.getProperty("Head");
        this.root = ed.findEntityExact(p.getProperty("Root"));
        this.direction = Integer.valueOf(p.getProperty("Direction"));
        this.mode = Integer.valueOf(p.getProperty("Mode"));
        this.difficulty = Integer.valueOf(p.getProperty("Difficulty"));
    }

    public static Vector<Question> readText(BufferedReader r, EntityData ed) throws IOException {
        Vector<Question> v = new Vector<Question>();
        String s = r.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null) {
            if (s.trim().equals("{")) {
                while (s != null && !s.trim().equals("}")) {
                    s = r.readLine();
                    sb.append(String.valueOf(s) + "\n");
                }
                Question q = new Question();
                Properties p = new Properties();
                p.load(new ByteArrayInputStream(sb.toString().getBytes("ISO-8859-1")));
                if (p.size() <= 0) continue;
                q.fromProps(p, ed);
                v.add(q);
                continue;
            }
            s = r.readLine();
        }
        return v;
    }

    public static void writeText(Vector<Question> v, PrintWriter w) throws IOException {
        Vector<Question> errors = new Vector<Question>();
        int i = 0;
        while (i < v.size()) {
            block7: {
                w.println("{");
                try {
                    try {
                        v.get(i).toProps().store(w, "Question " + i);
                    }
                    catch (Exception e) {
                        errors.add(v.get(i));
                        w.println("}");
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    w.println("}");
                    throw throwable;
                }
                w.println("}");
            }
            ++i;
        }
        if (errors.size() > 0) {
            throw new IOException("Unable to write " + errors.size() + " questions.");
        }
    }

    public static class FakeEntity
    extends Entity {
        FakeEntity(String s) {
            super(null, 0);
            this.name = s;
        }
    }

    static class Stem {
        Entity entity;
        boolean correct;
        String reasoning;

        Stem() {
        }
    }
}

