/*
 * Decompiled with CFR 0.152.
 */
package medicine.mcq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.Essay;
import medicine.mcq.Question;

public class Logic {
    static final int MODE_RANDOM_TYPED = 0;
    static final int MODE_RANDOM_RELATED = 1;
    static final int MODE_COMPLETELY_RANDOM = 2;
    static final int MODE_SOUNDS_SIMILAR = 3;
    static final int MODE_BROTHER_OF_CORRECT = 4;
    static final int MODE_BROTHER_OF_ROOT = 5;
    static final String[] MODE_NAMES = new String[]{"Random typed", "Random related", "Random.", "Looks similar", "Brother of correct", "Brother of root"};
    EntityData ed;
    Entity seed;
    int N = 4;
    boolean randomroot = false;
    boolean restrRoot = false;
    boolean restrChoice = false;
    boolean INCLUDE_DESCRIPTION = true;
    int[] DIRECTIONS = new int[]{4, 8, 32, 16};
    String[][] questionHead = new String[][]{{"Which of the following is most likely to be the cause of ", "?"}, {"Which of the following are commonly associated with ", "?"}, {"Which of the following might be used to treat ", "?"}, {"Which of the following is most likely to be treated with ", "?"}};
    Entity[] incorrect;
    String infoText;
    String[] infoIncor;
    String infoCorrect;
    Vector currentBank = new Vector();
    Question q;

    void newQuestion(int mode) {
        String rel2;
        String rel1;
        Entity correct;
        int d2;
        int d1;
        this.q = new Question();
        if (this.randomroot) {
            boolean ok = false;
            while (!ok) {
                this.q.root = this.ed.getRandomEntity();
                ok = !this.restrRoot | Entities.hasAStandardUltimateParent(this.q.root);
            }
        } else {
            this.q.root = this.seed;
        }
        this.seed = this.q.root;
        this.q.mode = mode;
        int attempt = 0;
        int numposs = 0;
        do {
            this.q.direction = (int)Math.floor(Math.random() * (double)this.DIRECTIONS.length);
            d1 = this.DIRECTIONS[this.q.direction];
            d2 = Entity.inverseOf(d1);
            this.q.head = String.valueOf(this.questionHead[this.q.direction][0]) + this.q.root + this.questionHead[this.q.direction][1];
        } while ((numposs = this.q.root.listOf(d1).size()) == 0 && attempt++ < 10);
        if (attempt >= 10) {
            throw new IllegalStateException("Unable to find any questions for " + this.q.root);
        }
        Question.Stem corrStem = new Question.Stem();
        this.q.correctStem.add(corrStem);
        corrStem.correct = true;
        corrStem.entity = correct = (Entity)this.q.root.listOf(d1).get((int)Math.floor(Math.random() * (double)numposs));
        Entity correctTypeT = Entities.getUltimateParents(correct);
        Vector corrD2 = correct.listOf(d2);
        corrD2.remove(this.q.root);
        String string = d1 == 4 ? "Causes" : (d1 == 8 ? "Effects" : (d1 == 32 ? "Treatments" : (rel1 = d1 == 16 ? "Uses" : "ERROR")));
        String string2 = d1 == 4 ? "can cause" : (d1 == 8 ? "can be caused by" : (rel2 = d1 == 32 ? "can treat" : "can be treated by"));
        String rel3 = d1 == 4 ? "Effects" : (d1 == 8 ? "Causes" : (d1 == 32 ? "Uses" : "Treatments"));
        corrStem.reasoning = String.valueOf(rel1) + " of " + this.q.root + " include " + Entities.listToText(this.q.root.listOf(d1)) + ". \n";
        if (corrD2.size() > 0) {
            corrStem.reasoning = String.valueOf(corrStem.reasoning) + correct + " also " + rel2 + " " + Entities.listToText(corrD2) + ".";
        }
        if (this.INCLUDE_DESCRIPTION) {
            corrStem.reasoning = String.valueOf(corrStem.reasoning) + '\n' + this.q.root.description;
        }
        this.incorrect = new Entity[this.N];
        this.infoIncor = new String[this.N];
        int i = 0;
        while (i < this.N) {
            Question.Stem s = this.newIncorrect(this.incorrect, this.q.root, correct, this.q.direction, this.q.mode);
            this.q.errorStems.add(s);
            this.incorrect[i] = s.entity;
            ++i;
        }
        this.infoText = "Incorrect answers are all " + this.infoText;
    }

    Question.Stem newIncorrect(Entity[] exclude, Entity root, Entity correct, int dirn, int mode) {
        int attempt = 0;
        boolean isOK = false;
        Question.Stem s = null;
        while (attempt++ < 100 && !isOK) {
            s = this.newIncorrect(root, correct, dirn, mode);
            isOK = true;
            int i = 0;
            while (i < exclude.length) {
                if (s.entity == exclude[i]) {
                    isOK = false;
                }
                ++i;
            }
        }
        if (!isOK) {
            throw new TryAgain();
        }
        return s;
    }

    Question.Stem newIncorrect(Entity root, Entity correct, int dirn, int mode) {
        String rel4;
        Question.Stem stem = new Question.Stem();
        stem.correct = false;
        int d1 = this.DIRECTIONS[dirn];
        int d2 = Entity.inverseOf(d1);
        String rel1 = d1 == 4 ? "Causes" : "Effects";
        String rel2 = d1 == 4 ? "can cause" : "can be caused by";
        String rel3 = d1 == 4 ? "Effects" : "Causes";
        String string = rel4 = d1 == 4 ? "can be caused by" : "can cause";
        if (mode == 0 || mode == 1 || mode == 2) {
            Entity tmp;
            if (correct.parents.size() == 0) {
                throw new TryAgain();
            }
            Entity correctType1 = (Entity)correct.parents.get(0);
            Entity correctType2 = null;
            if (correctType1.parents.size() > 0 && Math.random() > 0.5) {
                correctType2 = (Entity)correctType1.parents.get(0);
            }
            Entity correctType0 = Entities.getUltimateParents(correct);
            int attempt = 0;
            boolean sametype = false;
            do {
                tmp = this.ed.getRandomEntity();
                if (mode == 1) {
                    Entity tmpp;
                    sametype = tmp.parents.size() == 0 ? false : (tmpp = (Entity)tmp.parents.get(0)) == correctType1;
                    stem.reasoning = tmp + " is related to " + correct + " by being a type of " + correctType1;
                    continue;
                }
                if (mode == 0) {
                    sametype = Entities.getUltimateParents(tmp) == correctType0;
                    stem.reasoning = tmp + " is a " + correctType0;
                    continue;
                }
                if (mode != 2) continue;
                sametype = true;
                stem.reasoning = "";
            } while ((!sametype || Entities.isRelatedTo(root, tmp, d2 | 1 | 2, 3, null) || correct == tmp) && attempt++ < 5000);
            if (attempt >= 5000) {
                throw new IllegalStateException("Unable to find an unrelated (" + d1 + ") item to " + root + ", of type " + correctType1);
            }
            this.infoText = "randomly related";
            stem.entity = tmp;
            if (stem.entity.listOf(d1).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel4 + " " + Entities.listToText(stem.entity.listOf(d1)) + ".";
            }
            if (stem.entity.listOf(d2).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel2 + " " + Entities.listToText(stem.entity.listOf(d2)) + ".";
            }
        } else if (mode == 3) {
            int NS = 7;
            Collection es = this.ed.getAllEntities();
            double[] score = new double[es.size()];
            double[] hiscore = new double[NS];
            Entity[] hient = new Entity[NS];
            int idx = 0;
            int i = 0;
            while (i < NS) {
                hiscore[i] = Double.MIN_VALUE;
                ++i;
            }
            for (Entity ei : es) {
                if (ei != correct && !Entities.isRelatedTo(ei, correct, 3 | d1, 2, null)) {
                    score[idx] = Logic.compareStrings(ei.name, correct.name);
                    if (score[idx] > hiscore[0]) {
                        int inspos = 0;
                        while (inspos < NS - 1 && score[idx] > hiscore[inspos + 1]) {
                            ++inspos;
                        }
                        int j = 0;
                        while (j < inspos) {
                            hiscore[j] = hiscore[j + 1];
                            hient[j] = hient[j + 1];
                            ++j;
                        }
                        hiscore[inspos] = score[idx];
                        hient[inspos] = ei;
                    }
                    this.infoText = "Lexically similar to " + correct;
                }
                ++idx;
            }
            i = 0;
            while (i < NS) {
                ++i;
            }
            i = 0;
            while (i < 5) {
                if (hiscore[i] < 0.5) {
                    throw new TryAgain();
                }
                ++i;
            }
            this.currentBank = new Vector<Entity>(Arrays.asList(hient));
            i = (int)((double)NS * Math.random());
            stem.entity = hient[i];
            stem.reasoning = hient[i] + " could be confused with " + correct + ".";
            if (stem.entity.listOf(d1).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel4 + " " + Entities.listToText(stem.entity.listOf(d1)) + ".";
            }
            if (stem.entity.listOf(d2).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel2 + " " + Entities.listToText(stem.entity.listOf(d2)) + ".";
            }
        } else if (mode == 4) {
            if (correct.parents.size() == 0) {
                throw new TryAgain();
            }
            Entity p = (Entity)correct.parents.get(0);
            Vector s = new Vector(Entities.getExtensiveListOf(2, p, 10));
            this.filterOutRelations(s, root, d2 | 2, 3);
            s.remove(correct);
            this.infoText = "Brothers of " + correct;
            if (s.size() < this.N) {
                if (p.parents.size() > 0) {
                    p = (Entity)p.parents.get(0);
                }
                s.addAll(Entities.getExtensiveListOf(2, p, 10));
                this.filterOutRelations(s, root, d2 | 2, 3);
                s.remove(correct);
                if (s.size() < this.N) {
                    throw new TryAgain();
                }
                this.infoText = "Cousins of " + correct;
            }
            this.currentBank = s;
            int i = (int)((double)s.size() * Math.random());
            stem.entity = (Entity)s.get(i);
            stem.reasoning = stem.entity + " is a type of " + p + ".";
            if (stem.entity.listOf(d1).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel4 + " " + Entities.listToText(stem.entity.listOf(d1)) + ".";
            }
            if (stem.entity.listOf(d2).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel2 + " " + Entities.listToText(stem.entity.listOf(d2)) + ".";
            }
        } else if (mode == 5) {
            if (root.parents.size() == 0) {
                throw new TryAgain();
            }
            Entity p = (Entity)root.parents.get(0);
            HashSet<Entity> exclude = new HashSet<Entity>();
            exclude.add(root);
            Set brothrs = Entities.getExtensiveListOf(2, p, 2, exclude);
            HashSet rels = new HashSet();
            for (Entity b : brothrs) {
                exclude = new HashSet();
                exclude.add(root);
                rels.addAll(Entities.getExtensiveListOf(d1, b, 1, exclude));
            }
            rels.removeAll(brothrs);
            Vector v = new Vector(rels);
            this.filterOutRelations(v, root, d2, 3);
            if (v.size() == 0) {
                throw new TryAgain();
            }
            this.currentBank = v;
            int i = (int)((double)v.size() * Math.random());
            stem.entity = (Entity)v.get(i);
            Vector ch = Entities.findRelationChains(p, stem.entity, 2 | d1, 4, null, null, null, 0);
            if (ch.size() == 0) {
                throw new IllegalStateException("Could not find chain for brother of root: " + p + "'s children's " + Entities.getRelationNamesFromBits(d1) + " don't include " + stem.entity);
            }
            int shortest = 0;
            int shortlen = 100;
            int j = 0;
            while (j < ch.size()) {
                int tmp = ((Vector)ch.get(j)).size();
                if (tmp < shortlen) {
                    shortest = j;
                    shortlen = tmp;
                }
                ++j;
            }
            Vector inf = (Vector)ch.get(shortest);
            Collections.reverse(inf);
            try {
                stem.reasoning = Entities.chainText(inf);
            }
            catch (IllegalArgumentException x) {
                x.printStackTrace();
            }
            if (stem.entity.listOf(d1).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel4 + " " + Entities.listToText(stem.entity.listOf(d1)) + ".";
            }
            if (stem.entity.listOf(d2).size() > 0) {
                stem.reasoning = String.valueOf(stem.reasoning) + " It " + rel2 + " " + Entities.listToText(stem.entity.listOf(d2)) + ".";
            }
        }
        if (this.INCLUDE_DESCRIPTION) {
            stem.reasoning = String.valueOf(stem.reasoning) + '\n' + stem.entity.description;
        }
        return stem;
    }

    boolean anyarrayequal(Entity[] a, int N, Entity e) {
        boolean f = false;
        int i = 0;
        while (i < N) {
            if (a[i] == e) {
                f = true;
            }
            ++i;
        }
        return f;
    }

    Vector choose(Collection s, int n) {
        int ns = s.size();
        Vector result = new Vector();
        if (ns < n) {
            throw new IllegalStateException("Cannot choose " + n + " items from a set " + s + " of " + ns);
        }
        Vector<Integer> r = new Vector<Integer>();
        int i = 0;
        while (i < ns) {
            r.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(r);
        Iterator it = s.iterator();
        int un = 0;
        int i2 = 0;
        while (i2 < ns) {
            Object o = it.next();
            int j = 0;
            while (j < n) {
                if ((Integer)r.get(j) == i2) {
                    result.add(o);
                    ++un;
                }
                ++j;
            }
            if (un >= n) break;
            ++i2;
        }
        return result;
    }

    void filterOutRelations(Vector v, Entity relative, int relations, int depth) {
        Vector rm = new Vector();
        int i = 0;
        while (i < v.size()) {
            if (Entities.isRelatedTo((Entity)v.get(i), relative, relations, depth, null)) {
                rm.add(v.get(i));
            }
            ++i;
        }
        v.removeAll(rm);
    }

    public static double compareStrings(String str1, String str2) {
        ArrayList pairs1 = Logic.wordLetterPairs(str1.toUpperCase());
        ArrayList pairs2 = Logic.wordLetterPairs(str2.toUpperCase());
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        int i = 0;
        while (i < pairs1.size()) {
            Object pair1 = pairs1.get(i);
            int j = 0;
            while (j < pairs2.size()) {
                Object pair2 = pairs2.get(j);
                if (pair1.equals(pair2)) {
                    ++intersection;
                    pairs2.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return 2.0 * (double)intersection / (double)union;
    }

    private static ArrayList wordLetterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        String[] words = str.split("\\s");
        int w = 0;
        while (w < words.length) {
            String[] pairsInWord = Logic.letterPairs(words[w]);
            int p = 0;
            while (p < pairsInWord.length) {
                allPairs.add(pairsInWord[p]);
                ++p;
            }
            ++w;
        }
        return allPairs;
    }

    private static String[] letterPairs(String str) {
        int numPairs = str.length() - 1;
        if (numPairs < 1) {
            return new String[0];
        }
        String[] pairs = new String[numPairs];
        int i = 0;
        while (i < numPairs) {
            pairs[i] = str.substring(i, i + 2);
            ++i;
        }
        return pairs;
    }

    Question getNewQuestion(int mode) {
        this.newQuestion(mode);
        return this.q;
    }

    Question.Stem generateNewStem() {
        return this.newIncorrect(this.incorrect, this.q.root, this.q.correctStem.get((int)0).entity, this.q.direction, this.q.mode);
    }

    void setQuestion(Question qu) {
    }

    public void setStem(Question.Stem stem, Entity newItem) {
        stem.entity = newItem;
        stem.reasoning = Essay.getText(newItem);
    }

    static class TryAgain
    extends RuntimeException {
        TryAgain() {
        }
    }
}

