/*
 * Decompiled with CFR 0.152.
 */
package medicine.mcq;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import medicine.Entity;
import medicine.EntityData;
import medicine.gui.NavigatorPanel;
import medicine.gui.QuickAddDialog;
import medicine.mcq.Logic;
import medicine.mcq.Question;
import medicine.mcq.RootCreator;

public class EditMCQDialog
extends JDialog {
    Action delQAction = new AbstractAction("Delete"){

        public void actionPerformed(ActionEvent e) {
            EditMCQDialog.this.qs.remove(EditMCQDialog.this.qt.getSelectedRow());
            EditMCQDialog.this.tm.fireTableDataChanged();
        }
    };
    Action saveQAction = new AbstractAction("Save"){

        public void actionPerformed(ActionEvent e) {
            EditMCQDialog.this.currentQ.updateQuestion();
            EditMCQDialog.this.qs.add(EditMCQDialog.this.currentQ.curQuestion);
            EditMCQDialog.this.tm.fireTableDataChanged();
        }
    };
    NavigatorPanel externalNavigator = null;
    QPanel currentQ = new QPanel();
    JButton newButton = new JButton("New Question");
    JPanel optionPanel = new JPanel();
    JComboBox typecombo = new JComboBox<String>(Logic.MODE_NAMES);
    JCheckBox randcheck = new JCheckBox("Random root");
    JCheckBox restrRtCheck = new JCheckBox("Restrict root");
    JCheckBox restrChCheck = new JCheckBox("Restrict stems");
    int mode;
    JPanel leftPanel = new JPanel();
    JTable qt = new JTable();
    JScrollPane tabScr = new JScrollPane();
    JPanel leftBot = new JPanel();
    JButton del = new JButton(this.delQAction);
    JButton save = new JButton(this.saveQAction);
    JSplitPane split = new JSplitPane(1);
    Vector<Question> qs = new Vector();
    QuestionTableModel tm = new QuestionTableModel();
    ListSelectionListener sl = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            int sr = EditMCQDialog.this.qt.getSelectedRow();
            if (sr > 0 && sr < EditMCQDialog.this.qs.size()) {
                Question q = EditMCQDialog.this.qs.get(sr);
                EditMCQDialog.this.currentQ.updateQuestion();
                EditMCQDialog.this.currentQ.setQuestion(q);
            }
        }
    };
    public static String FILE = "mcqs.txt";
    public static String FILENAME = "C:\\" + FILE;
    WindowListener wl = new WindowAdapter(){

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            boolean doExit = false;
            PrintWriter w = null;
            try {
                try {
                    w = new PrintWriter(new FileOutputStream(FILENAME));
                    Question.writeText(EditMCQDialog.this.qs, w);
                    doExit = true;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    int r = JOptionPane.showConfirmDialog(EditMCQDialog.this.currentQ, "The Questions could not be saved due to " + x + ". Close anyway?", "Save Error", 2, 0);
                    if (r == 0) {
                        doExit = true;
                    }
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (doExit) {
                        EditMCQDialog.this.setVisible(false);
                    }
                }
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (Exception exception) {}
                }
                if (doExit) {
                    EditMCQDialog.this.setVisible(false);
                }
            }
        }
    };
    int correctIndex;
    Logic logic = new Logic();

    public EditMCQDialog(EntityData ed, Entity entity) {
        this.logic.ed = ed;
        this.logic.seed = entity;
        try {
            FILENAME = String.valueOf(new JFileChooser().getFileSystemView().getDefaultDirectory().getCanonicalPath()) + File.separator + FILE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
        this.setTitle("Multiple Choice");
        this.setSize(1000, 700);
        this.newQuestion();
        this.addWindowListener(this.wl);
    }

    public void setNavigator(NavigatorPanel n) {
        this.externalNavigator = n;
    }

    void initComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.split);
        this.add((Component)this.optionPanel, "North");
        this.optionPanel.setBorder(new EtchedBorder(1));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMCQDialog.this.newQuestion();
            }
        });
        this.optionPanel.add(this.typecombo);
        this.typecombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                EditMCQDialog.this.mode = EditMCQDialog.this.typecombo.getSelectedIndex();
                EditMCQDialog.this.newQuestion();
            }
        });
        this.optionPanel.add(this.randcheck);
        this.randcheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EditMCQDialog.this.logic.randomroot = EditMCQDialog.this.randcheck.isSelected();
                EditMCQDialog.this.restrRtCheck.setEnabled(EditMCQDialog.this.logic.randomroot);
            }
        });
        this.optionPanel.add(this.restrRtCheck);
        this.randcheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EditMCQDialog.this.logic.restrRoot = EditMCQDialog.this.randcheck.isSelected();
            }
        });
        this.restrRtCheck.setEnabled(false);
        this.optionPanel.add(this.newButton);
        this.split.add((Component)this.currentQ, "right");
        this.split.setResizeWeight(0.7);
        this.currentQ.setMinimumSize(new Dimension(10, 10));
        this.split.add((Component)this.leftPanel, "left");
        this.leftPanel.setPreferredSize(new Dimension(140, 200));
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.add((Component)this.tabScr, "Center");
        this.leftPanel.add((Component)this.leftBot, "South");
        this.tabScr.getViewport().setView(this.qt);
        this.leftBot.add(this.del);
        this.leftBot.add(this.save);
        this.qt.setModel(this.tm);
        this.qt.getSelectionModel().addListSelectionListener(this.sl);
        this.qt.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.qt.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.qt.getColumnModel().getColumn(2).setPreferredWidth(1);
        this.qt.getColumnModel().getColumn(3).setPreferredWidth(1);
        this.loadQuestions();
    }

    void loadQuestions() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(FILENAME)));
            this.qs = Question.readText(br, this.logic.ed);
        }
        catch (Exception x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this.currentQ, "Unable to read question file due to " + x);
        }
    }

    void newQuestion() {
        boolean success = false;
        int n = 0;
        do {
            try {
                this.currentQ.setQuestion(this.logic.getNewQuestion(this.typecombo.getSelectedIndex()));
                success = true;
            }
            catch (IllegalStateException x) {
                if (!this.logic.randomroot) {
                    JOptionPane.showMessageDialog(null, x.toString());
                    x.printStackTrace();
                    return;
                }
            }
            catch (Logic.TryAgain tryAgain) {
                // empty catch block
            }
            if (++n <= 50 || success) continue;
            throw new IllegalStateException("Can't find any questions");
        } while (!success && this.logic.randomroot);
    }

    class QPanel
    extends JPanel {
        Action questionEditAction = new AbstractAction("Scenario"){

            public void actionPerformed(ActionEvent e) {
                RootCreator rc = new RootCreator(QPanel.this.curQuestion.root, QPanel.this.curQuestion.direction, QPanel.this.curQuestion.correctStem.get((int)0).entity, QPanel.this.questionText.getText());
                rc.setModal(true);
                rc.setVisible(true);
            }
        };
        JPanel qpanel = new JPanel();
        StemPanel[] stemPanels = new StemPanel[5];
        ButtonGroup bg = new ButtonGroup();
        JTextArea questionText = new JTextArea();
        Question curQuestion;
        JPanel lowerPanel = new JPanel();
        JRadioButton dif1 = new JRadioButton("Finals");
        JRadioButton dif2 = new JRadioButton("Part 1");
        JRadioButton dif3 = new JRadioButton("Membership");
        JRadioButton dif4 = new JRadioButton("CCST");
        JRadioButton[] difs = new JRadioButton[]{this.dif1, this.dif2, this.dif3, this.dif4};
        AbstractButton dif0 = new JToggleButton();
        JPanel questionTopPanel = new JPanel();
        JButton editQuestionButton = new JButton(this.questionEditAction);
        FocusListener fl = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        };

        QPanel() {
            this.initComponents();
        }

        void initComponents() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.qpanel, "Center");
            this.qpanel.setLayout(new GridLayout(7, 1));
            this.qpanel.add(this.questionTopPanel);
            this.questionTopPanel.setLayout(new BorderLayout());
            this.questionTopPanel.add((Component)this.questionText, "Center");
            this.questionTopPanel.add((Component)this.editQuestionButton, "East");
            this.questionText.setLineWrap(true);
            this.questionText.setWrapStyleWord(true);
            int i = 0;
            while (i < this.stemPanels.length) {
                this.stemPanels[i] = new StemPanel();
                this.qpanel.add(this.stemPanels[i]);
                ++i;
            }
            this.questionText.addFocusListener(this.fl);
            this.setBorder(new EtchedBorder(0));
            this.add((Component)this.lowerPanel, "South");
            this.lowerPanel.add(this.dif1);
            this.lowerPanel.add(this.dif2);
            this.lowerPanel.add(this.dif3);
            this.lowerPanel.add(this.dif4);
            this.bg.add(this.dif1);
            this.bg.add(this.dif2);
            this.bg.add(this.dif3);
            this.bg.add(this.dif4);
            this.bg.add(this.dif0);
        }

        void setQuestion(Question q) {
            this.curQuestion = q;
            Question.Stem correct = q.getCorrectStems().get(0);
            Vector<Question.Stem> incorrect = q.getIncorrectStems();
            int correctIx = (int)Math.floor(Math.random() * 5.0);
            int i = 0;
            while (i < incorrect.size() + 1) {
                if (i == correctIx) {
                    this.stemPanels[i].setStem(q.correctStem.get(0));
                } else {
                    int inci = i - (i > correctIx ? 1 : 0);
                    this.stemPanels[i].setStem(incorrect.get(inci));
                }
                ++i;
            }
            this.questionText.setText(q.head);
            if (q.difficulty > 0) {
                this.difs[q.difficulty - 1].setSelected(true);
            } else {
                this.dif0.setSelected(true);
            }
            EditMCQDialog.this.correctIndex = correctIx;
        }

        public void updateQuestion() {
            this.curQuestion.correctStem.set(0, this.stemPanels[EditMCQDialog.this.correctIndex].stem);
            int i = 0;
            while (i < this.stemPanels.length - 1) {
                int ix = i + (i >= EditMCQDialog.this.correctIndex ? 1 : 0);
                this.curQuestion.errorStems.set(i, this.stemPanels[ix].stem);
                ++i;
            }
            this.curQuestion.head = this.questionText.getText();
            this.curQuestion.difficulty = this.dif1.isSelected() ? 1 : (this.dif2.isSelected() ? 2 : (this.dif3.isSelected() ? 3 : (this.dif4.isSelected() ? 4 : 0)));
        }

        class StemPanel
        extends JPanel {
            Action regenAction = new AbstractAction("Regenerate"){

                public void actionPerformed(ActionEvent e) {
                    if (!StemPanel.this.stem.correct) {
                        boolean stop = false;
                        int n = 0;
                        while (!stop) {
                            try {
                                StemPanel.this.setStem(((QPanel)((StemPanel)StemPanel.this).QPanel.this).EditMCQDialog.this.logic.generateNewStem());
                                stop = true;
                            }
                            catch (Logic.TryAgain x) {
                                if (++n <= 20) continue;
                                stop = true;
                            }
                        }
                    }
                }
            };
            Action regenFromText = new AbstractAction("Change..."){

                public void actionPerformed(ActionEvent e) {
                    String base;
                    Entity newItem = null;
                    if (StemPanel.this.stemTxt.getText().equalsIgnoreCase(StemPanel.this.stem.entity.name) && !(StemPanel.this.stem.entity instanceof Question.FakeEntity)) {
                        base = "";
                    } else {
                        base = StemPanel.this.stemTxt.getText();
                        Vector v = ((QPanel)((StemPanel)StemPanel.this).QPanel.this).EditMCQDialog.this.logic.ed.findEntities(base, true, false);
                        if (v.size() == 1) {
                            newItem = (Entity)v.get(0);
                        }
                    }
                    if (newItem == null) {
                        QuickAddDialog d = new QuickAddDialog(((QPanel)((StemPanel)StemPanel.this).QPanel.this).EditMCQDialog.this.logic.ed);
                        if (base != null && base.length() > 0) {
                            d.combo.setSelectedItem(base);
                        }
                        d.setVisible(true);
                        if (d.entity != null) {
                            newItem = d.entity;
                        }
                    }
                    if (newItem != null) {
                        ((QPanel)((StemPanel)StemPanel.this).QPanel.this).EditMCQDialog.this.logic.setStem(StemPanel.this.stem, newItem);
                        StemPanel.this.setStem(StemPanel.this.stem);
                    }
                }
            };
            Action goToItem = new AbstractAction("Go to"){

                public void actionPerformed(ActionEvent e) {
                    if (((QPanel)((StemPanel)StemPanel.this).QPanel.this).EditMCQDialog.this.externalNavigator != null) {
                        ((QPanel)((StemPanel)StemPanel.this).QPanel.this).EditMCQDialog.this.externalNavigator.setEntity(StemPanel.this.stem.entity);
                    }
                }
            };
            JTextArea stemTxt = new JTextArea();
            JTextArea explTxt = new JTextArea();
            JScrollPane exScr = new JScrollPane();
            JPanel butpan = new JPanel();
            JButton regenBut = new JButton(this.regenAction);
            JButton goToBut = new JButton(this.goToItem);
            JButton regenFromTextBut = new JButton(this.regenFromText);
            Question.Stem stem;
            FocusListener fl = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    StemPanel.this.updateStem();
                }
            };

            StemPanel() {
                this.setLayout(new BoxLayout(this, 0));
                this.add(this.stemTxt);
                this.add(this.butpan);
                this.add(this.exScr);
                this.butpan.setLayout(new GridLayout(3, 1));
                this.butpan.add(this.regenBut);
                this.butpan.add(this.goToBut);
                this.butpan.add(this.regenFromTextBut);
                this.exScr.getViewport().setView(this.explTxt);
                this.stemTxt.addFocusListener(this.fl);
                this.explTxt.addFocusListener(this.fl);
                this.explTxt.setLineWrap(true);
                this.explTxt.setWrapStyleWord(true);
                this.setBorder(new EtchedBorder(1));
                this.explTxt.setAutoscrolls(true);
                this.stemTxt.setLineWrap(true);
                this.stemTxt.setWrapStyleWord(true);
                this.exScr.setPreferredSize(new Dimension(400, 100));
                this.explTxt.setFont(new Font("SansSerif", 0, 12));
            }

            void setStem(Question.Stem s) {
                this.stem = s;
                this.stemTxt.setText(s.entity.toString());
                this.explTxt.setText(s.reasoning);
                this.explTxt.setCaretPosition(0);
                this.stemTxt.setBorder(new MatteBorder(2, 2, 2, 2, this.stem.correct ? Color.red : Color.gray));
                this.stemTxt.setPreferredSize(new Dimension(150, 50));
            }

            void updateStem() {
                this.stem.reasoning = this.explTxt.getText();
                if (!this.stem.entity.name.equals(this.stemTxt.getText())) {
                    this.stem.entity = new Question.FakeEntity(this.stemTxt.getText());
                }
            }
        }
    }

    class QuestionTableModel
    extends AbstractTableModel {
        String[] colnames = new String[]{"Root", "Correct", "Difficulty", "Status"};

        QuestionTableModel() {
        }

        public int getRowCount() {
            return EditMCQDialog.this.qs.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int r, int c) {
            Question q = EditMCQDialog.this.qs.get(r);
            switch (c) {
                case 0: {
                    return q.root;
                }
                case 1: {
                    return q.correctStem.get((int)0).entity;
                }
                case 2: {
                    return q.difficulty;
                }
                case 3: {
                    return q.status;
                }
            }
            return null;
        }

        public String getColumnName(int i) {
            return this.colnames[i];
        }
    }
}

