/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import medicine.gui.MainFrame;

public class ServerAction
extends AbstractAction
implements Runnable {
    public static final boolean UPLOAD = true;
    public static final boolean DOWNLOAD = false;
    boolean type;
    MainFrame frame;
    JDialog dialog;
    boolean enteringPassword = false;
    AbstractAction okaction = new AbstractAction("OK"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (ServerAction.this.enteringPassword) {
                ServerAction serverAction = ServerAction.this;
                synchronized (serverAction) {
                    ServerAction.this.notify();
                }
            } else {
                ServerAction.this.dialog.setVisible(false);
            }
        }
    };
    JTextArea text1 = new JTextArea();
    JPasswordField pass = new JPasswordField(10);
    JProgressBar progress = new JProgressBar();
    JButton okbutton = new JButton(this.okaction);
    WindowListener dlgAdapter = new WindowAdapter(){

        public void windowClosed(WindowEvent e) {
            ServerAction.this.pass.setText("");
            ServerAction.this.frame.setCursor(ServerAction.this.oldcursor);
        }
    };
    ActionEvent event;
    final int MAX_SIZE = 500000;
    Cursor oldcursor;

    public ServerAction(boolean type, MainFrame frame) {
        super(type ? "Upload to server" : "Download from server");
        this.type = type;
        this.frame = frame;
        this.dialog = new JDialog((Frame)frame, "Communicating with server");
        this.text1.setText("Transmitting data to and from server " + "http://www.homphysiology.org");
        this.text1.setPreferredSize(new Dimension(300, 100));
        this.text1.setWrapStyleWord(true);
        this.text1.setLineWrap(true);
        this.text1.setEditable(false);
        this.dialog.getContentPane().setLayout(new FlowLayout());
        this.dialog.add(this.text1);
        this.dialog.add(this.pass);
        this.pass.setAction(this.okaction);
        this.dialog.add(this.progress);
        this.progress.setMaximum(9);
        this.dialog.add(this.okbutton);
        this.dialog.pack();
        this.dialog.setSize(320, 200);
        this.dialog.addWindowListener(this.dlgAdapter);
    }

    public void actionPerformed(ActionEvent e) {
        this.event = e;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.progress.setValue(0);
        this.dialog.setVisible(true);
        this.oldcursor = this.frame.getCursor();
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (this.type) {
            this.text1.setText("Enter password");
            this.pass.setVisible(true);
            int count = 0;
            boolean authenticated = false;
            String encryptedpw = "";
            while (!authenticated & count++ < 3) {
                this.enteringPassword = true;
                ServerAction serverAction = this;
                synchronized (serverAction) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.enteringPassword = false;
                this.progress.setValue(1);
                char[] enteredpw = this.pass.getPassword();
                encryptedpw = this.encryptPW(enteredpw);
                if (!this.checkUploadPermission(encryptedpw)) continue;
                authenticated = true;
            }
            this.pass.setText("");
            this.pass.setVisible(false);
            if (authenticated) {
                try {
                    this.text1.setText("Sending data to server " + "http://www.homphysiology.org");
                    this.progress.setValue(2);
                    HttpURLConnection uc = (HttpURLConnection)new URL(String.valueOf("http://www.homphysiology.org/cgi-bin/medicine_upload.pl") + "?pw=" + encryptedpw + "&lastread=" + this.frame.entityData.lastRead + "&now=" + new Date().getTime() + "&file=medicine.zip").openConnection();
                    uc.setRequestMethod("POST");
                    this.progress.setValue(3);
                    uc.setDoOutput(true);
                    uc.setDoInput(true);
                    this.progress.setValue(4);
                    String boundary = "----END";
                    uc.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    uc.setRequestProperty("Connection", "Close");
                    uc.setRequestProperty("HTTP_REFERER", "http://www.homphysiology.org");
                    uc.setUseCaches(false);
                    String header2 = "\r\n--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"data\"; filename=\"medicine.zip\"\r\n" + "Content-Type: application/zip\r\n" + "Content-Transfer-Encoding: binary\r\n" + "\r\n";
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(500000);
                    this.frame.writeZipFile(baos);
                    byte[] data = baos.toByteArray();
                    String footer = "\r\n--" + boundary + "--\r\n" + "\r\n";
                    int totalLength = header2.length() + data.length + footer.length();
                    uc.setRequestProperty("Content-Length", String.valueOf(totalLength));
                    System.out.println(uc.getURL() + "\nheader2=" + header2 + ", data=" + data.length + ", footer=" + footer + ", total=" + totalLength);
                    this.progress.setValue(5);
                    OutputStream os = uc.getOutputStream();
                    DataOutputStream dos = new DataOutputStream(os);
                    dos.writeBytes(header2);
                    this.progress.setValue(6);
                    dos.write(data);
                    this.progress.setValue(7);
                    dos.writeBytes(footer);
                    os.flush();
                    this.progress.setValue(8);
                    os.close();
                    this.progress.setValue(9);
                    String result = new BufferedReader(new InputStreamReader(uc.getInputStream())).readLine();
                    this.progress.setValue(10);
                    this.text1.setText("Upload result: " + result);
                    this.frame.entityData.saveTime = this.frame.entityData.lastRead = new Date().getTime();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.text1.setText("Error writing to server: " + e1.getMessage());
                    this.progress.setVisible(false);
                }
            } else {
                this.dialog.setVisible(false);
            }
        } else if (!this.type) {
            this.text1.setText("Requesting data from server " + "http://www.homphysiology.org");
            this.pass.setVisible(false);
            this.progress.setValue(1);
            try {
                InputStream is = new URL("http://www.homphysiology.org/cgi-bin/medicine.pl").openConnection().getInputStream();
                this.progress.setValue(5);
                this.frame.readTextFromZip(is, "http://www.homphysiology.org/cgi-bin/medicine.pl");
                this.progress.setValue(10);
                this.text1.setText("Data successfully read from server");
                this.frame.entityData.lastRead = new Date().getTime();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.text1.setText("Error reading from server: " + e1.getMessage());
                this.progress.setVisible(false);
            }
        }
        this.frame.setCursor(this.oldcursor);
    }

    private boolean checkUploadPermission(String encryptedpw) {
        if (encryptedpw.startsWith("112")) {
            return true;
        }
        String p = null;
        try {
            HttpURLConnection uc = (HttpURLConnection)new URL(String.valueOf("http://www.homphysiology.org/cgi-bin/medicine_upload.pl") + "?pw=" + encryptedpw + "&lastread=" + this.frame.entityData.saveTime + "&now=" + new Date().getTime()).openConnection();
            p = new BufferedReader(new InputStreamReader((InputStream)uc.getContent())).readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.text1.setText(p);
        return p.matches("Upload approved.");
    }

    String encryptPW(char[] c) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < c.length) {
            sb.append(219 - c[i]);
            ++i;
        }
        return sb.toString();
    }
}

