/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import medicine.Entity;

class SList
extends JPanel {
    SListImpl impl = new SListImpl();
    JPanel extras = new JPanel();
    public int relation;
    Entity mainentity;
    int caret = -1;
    static int dw = 0;
    JList extralist = new JList();

    public SList() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.impl, "Center");
        this.add((Component)this.extras, "South");
        this.extras.setLayout(new BorderLayout());
        this.extras.add((Component)this.extralist, "Center");
        this.extras.add((Component)new JPanel(), "North");
    }

    void setExtras() {
        if (this.relation == 2 || this.relation == 1 || this.mainentity == null) {
            this.extralist.setVisible(false);
            return;
        }
        Vector extraitems = new Vector();
        if (this.mainentity.parents.size() > 0) {
            for (Entity p : this.mainentity.parents) {
                Vector tmp = this.getDirectRelativesIncAllParents(p, this.relation, new Vector());
                if (tmp == null) continue;
                extraitems.addAll(tmp);
            }
        }
        if (extraitems != null && extraitems.size() > 0) {
            this.extralist.setListData(extraitems);
            this.extralist.setFont(this.extralist.getFont().deriveFont(9.0f));
            this.extralist.setBackground(SystemColor.control);
            this.extralist.setVisible(true);
        } else {
            this.extralist.setVisible(false);
        }
    }

    Vector getDirectRelativesIncAllParents(Entity e, int direction, Vector exclude) {
        if (exclude.contains(e)) {
            return null;
        }
        exclude.add(e);
        Vector result = null;
        for (Entity p : e.parents) {
            Vector tmp = this.getDirectRelativesIncAllParents(p, direction, exclude);
            if (tmp == null) continue;
            if (result == null) {
                result = tmp;
                continue;
            }
            result.addAll(tmp);
        }
        Vector mycauses = null;
        if (e.listOf(direction).size() != 0) {
            Vector<Entity> v = new Vector<Entity>();
            for (Entity ei : e.listOf(direction)) {
                if (exclude.contains(ei)) continue;
                v.add(ei);
            }
            mycauses = this.formatCauses(v, e);
        }
        if (result == null) {
            return mycauses;
        }
        if (mycauses == null) {
            return result;
        }
        result.addAll(mycauses);
        return result;
    }

    String getInheritedItemsPrefix() {
        if (this.relation == 4) {
            return "Causing ";
        }
        if (this.relation == 8) {
            return "Due to ";
        }
        return "";
    }

    Vector formatCauses(Vector list, Entity source) {
        Vector<Object> out = new Vector<Object>();
        if (list.size() > 0) {
            out.add("<HTML><B>" + this.getInheritedItemsPrefix() + source.toString() + ":</B></HTML>");
            for (Entity e : list) {
                out.add(e);
            }
        }
        return out;
    }

    public Object getSelectedValue() {
        return this.impl.getSelectedValue();
    }

    public int locationToIndex(Point locationInDropList) {
        return this.impl.locationToIndex(locationInDropList);
    }

    public int getCaretIndex() {
        return this.impl.getCaretIndex();
    }

    public Rectangle getCellBounds(int ix, int ix2) {
        return this.impl.getCellBounds(ix, ix2);
    }

    public ListModel getModel() {
        return this.impl.getModel();
    }

    public void setCaretIndex(int i) {
        this.impl.setCaretIndex(i);
    }

    public void setListData(Entity entity, Vector parents) {
        this.impl.setListData(entity, parents);
    }

    public void setSelectionBackground(Color color) {
        this.impl.setSelectionBackground(color);
    }

    public Object[] getSelectedValues() {
        return this.impl.getSelectedValues();
    }

    public void doAddDoubleclickListener(MouseListener dcl) {
        this.impl.addMouseListener(dcl);
        this.extralist.addMouseListener(dcl);
    }

    public class SListImpl
    extends JList {
        LCR lcr = new LCR();
        Color caretColor = this.getSelectionBackground();

        public ListCellRenderer getCellRenderer() {
            return this.lcr;
        }

        public SListImpl() {
            this.setUI(new SListUI());
        }

        public void setListData(Entity e, Vector v) {
            super.setListData(v);
            SList.this.mainentity = e;
            SList.this.setExtras();
        }

        public String getToolTipText(MouseEvent e) {
            int ix = this.locationToIndex(e.getPoint());
            if (ix >= 0 && ix < this.getModel().getSize()) {
                double[] x;
                Object o = this.getModel().getElementAt(ix);
                String p = "";
                if (SList.this.mainentity != null && (x = SList.this.mainentity.probsOf(SList.this.relation)) != null && x.length > ix && !Double.isNaN(x[ix])) {
                    p = " " + Double.toString(x[ix]) + "%";
                }
                return String.valueOf(((Entity)o).toString()) + p;
            }
            return super.getToolTipText(e);
        }

        public void setSelectionBackground(Color c) {
            super.setSelectionBackground(c);
            this.caretColor = c != null ? new Color(c.getRed() / 2, c.getGreen() / 2, c.getBlue() / 2) : Color.gray;
        }

        public void setCaretIndex(int ci) {
            SList.this.caret = ci;
            if (SList.this.caret >= 0) {
                if (SList.this.caret > 0) {
                    this.ensureIndexIsVisible(SList.this.caret - 1);
                }
                this.ensureIndexIsVisible(SList.this.caret + 1);
                this.ensureIndexIsVisible(SList.this.caret);
            }
            this.repaint();
        }

        public int getCaretIndex() {
            return SList.this.caret;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (SList.this.caret < 0) {
                return;
            }
            Point p = this.indexToLocation(SList.this.caret);
            if (p == null) {
                p = new Point();
            }
            if (SList.this.caret == this.getModel().getSize()) {
                if (SList.this.caret == 0) {
                    p.y = 1;
                } else {
                    p = this.indexToLocation(SList.this.caret - 1);
                    int h = (int)this.getCellRenderer().getListCellRendererComponent(this, this.getModel().getElementAt(SList.this.caret - 1), SList.this.caret - 1, false, false).getPreferredSize().getHeight();
                    p.y += h;
                }
            }
            g.setColor(this.caretColor);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(3.0f));
            g.drawLine(dw, p.y, this.getWidth() - dw, p.y);
        }

        class LCR
        extends DefaultListCellRenderer {
            Icon piecon = new Piecon();
            Color piebg = Color.white;
            Color piefg = Color.black;
            int pier = 7;
            int xmarg = 1;
            int ymarg = 1;
            double prob;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                double[] ps;
                String s = value.toString();
                this.setText(s);
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.prob = Double.NaN;
                if (value instanceof Entity & ((SListImpl)SListImpl.this).SList.this.mainentity != null && (ps = ((SListImpl)SListImpl.this).SList.this.mainentity.probsOf(((SListImpl)SListImpl.this).SList.this.relation)) != null && index < ps.length) {
                    this.prob = ps[index];
                }
                if (!Double.isNaN(this.prob)) {
                    this.setIcon(this.piecon);
                } else {
                    this.setIcon(null);
                }
                return this;
            }

            class Piecon
            implements Icon {
                Piecon() {
                }

                public int getIconHeight() {
                    return LCR.this.pier * 2 + LCR.this.ymarg;
                }

                public int getIconWidth() {
                    return LCR.this.pier * 2 + LCR.this.xmarg;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (!Double.isNaN(LCR.this.prob)) {
                        g.setColor(LCR.this.piebg);
                        int w = LCR.this.getWidth();
                        g.fillOval(LCR.this.xmarg, LCR.this.ymarg, LCR.this.pier * 2, LCR.this.pier * 2);
                        g.setColor(LCR.this.piefg);
                        g.drawOval(LCR.this.xmarg, LCR.this.ymarg, LCR.this.pier * 2, LCR.this.pier * 2);
                        g.fillArc(LCR.this.xmarg, LCR.this.ymarg, LCR.this.pier * 2, LCR.this.pier * 2, 90, -((int)(360.0 * LCR.this.prob / 100.0)));
                    }
                }
            }
        }

        class SListUI
        extends BasicListUI {
            SListUI() {
            }

            protected MouseInputListener createMouseInputListener() {
                return new MyMouseInputHandler();
            }

            public class MyMouseInputHandler
            extends BasicListUI.MouseInputHandler {
                public MyMouseInputHandler() {
                    super(SListUI.this);
                }

                public void mouseDragged(MouseEvent e) {
                }
            }
        }
    }
}

