/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.MainApplication;
import medicine.TransferableEntity;
import medicine.gui.EntityChooser;
import medicine.gui.EntityPanel;
import medicine.gui.FindDialog;
import medicine.gui.QuickAddDialog;
import medicine.gui.SList;

public class NavigatorPanel
extends JPanel
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel superpanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    JPanel subpanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    EntityPanel entitypanel = new EntityPanel();
    JPanel causepanel = new JPanel();
    JLabel jLabel3 = new JLabel();
    JScrollPane jScrollPane3 = new JScrollPane();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel effectspanel = new JPanel();
    JLabel jLabel4 = new JLabel();
    JScrollPane jScrollPane4 = new JScrollPane();
    BorderLayout borderLayout5 = new BorderLayout();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem9 = new JMenuItem();
    JMenuItem jMenuItem8 = new JMenuItem();
    JPopupMenu listEditPopup = new JPopupMenu();
    JMenuItem jMenuItem6 = new JMenuItem();
    JMenuItem jMenuItem10 = new JMenuItem();
    JMenu probMenu = new JMenu();
    SList causelist = new SList();
    SList effectlist = new SList();
    SList treatlist = new SList();
    SList treatmentlist = new SList();
    SList superlist = new SList();
    SList sublist = new SList();
    SList[] lists;
    static int MAX_HISTORY = 20;
    Vector<Entity> history = new Vector();
    int historyPointer = 0;
    Entity entity;
    public Action backAction = new AbstractAction("<"){

        public void actionPerformed(ActionEvent e) {
            if (NavigatorPanel.this.historyPointer < NavigatorPanel.this.history.size() && NavigatorPanel.this.historyPointer > 0) {
                NavigatorPanel.this.setEntity(NavigatorPanel.this.history.get(NavigatorPanel.this.historyPointer - 1));
            }
        }
    };
    public Action forwardAction = new AbstractAction(">"){

        public void actionPerformed(ActionEvent e) {
            if (NavigatorPanel.this.historyPointer < NavigatorPanel.this.history.size() - 1) {
                NavigatorPanel.this.setEntity(NavigatorPanel.this.history.get(NavigatorPanel.this.historyPointer + 1));
            }
        }
    };
    public boolean canMove = true;
    boolean canEdit = true;
    MouseListener dcl = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (NavigatorPanel.this.canMove && e.getClickCount() == 2) {
                if (src instanceof JList) {
                    Object s = ((JList)src).getSelectedValue();
                    if (s != null && s instanceof Entity) {
                        Entity ent = (Entity)s;
                        NavigatorPanel.this.setEntity(ent);
                    }
                } else {
                    Object s;
                    SList list = NavigatorPanel.this.findSList(src);
                    if (list != null && (s = list.getSelectedValue()) != null && s instanceof Entity) {
                        Entity ent = (Entity)s;
                        NavigatorPanel.this.setEntity(ent);
                    }
                }
            }
        }
    };
    Action probExactAction = new ProbabilityAction(0.0, "Value..."){

        public void actionPerformed(ActionEvent e) {
            String s = JOptionPane.showInputDialog("Enter value (percent)");
            this.p = Double.parseDouble(s);
            super.actionPerformed(e);
        }
    };
    Action copyaction = new AbstractAction("Copy"){

        public void actionPerformed(ActionEvent e) {
            SList l = NavigatorPanel.this.findSList(e.getSource());
            if (l == null && NavigatorPanel.this.popupSource != null) {
                l = NavigatorPanel.this.popupSource;
            }
            if (l != null) {
                Object[] o = l.getSelectedValues();
                if (o.length == 1) {
                    Entity f = (Entity)l.getSelectedValue();
                    if (f != null) {
                        NavigatorPanel.this.setClipboard(f);
                    }
                } else if (o.length > 1) {
                    NavigatorPanel.this.setClipboard(Arrays.asList(o));
                }
            }
        }
    };
    Action pasteaction = new AbstractAction("Paste"){

        public void actionPerformed(ActionEvent e) {
            SList l = NavigatorPanel.this.findSList(e.getSource());
            if (l == null && NavigatorPanel.this.popupSource != null) {
                l = NavigatorPanel.this.popupSource;
            }
            if (l != null) {
                int rel = NavigatorPanel.this.relationFromList(l);
                Object o = NavigatorPanel.this.getClipboard();
                if (o instanceof Entity) {
                    NavigatorPanel.this.entity.connect((Entity)o, rel);
                } else if (o instanceof List) {
                    Iterator i = ((List)o).iterator();
                    while (i.hasNext()) {
                        NavigatorPanel.this.entity.connect((Entity)i.next(), rel);
                    }
                }
                NavigatorPanel.this.redisplay();
            }
        }
    };
    Action cutaction = new AbstractAction("Cut"){

        public void actionPerformed(ActionEvent e) {
            SList l = NavigatorPanel.this.findSList(e.getSource());
            if (l == null && NavigatorPanel.this.popupSource != null) {
                l = NavigatorPanel.this.popupSource;
            }
            if (l != null) {
                Object[] o = l.getSelectedValues();
                if (o.length == 1) {
                    Entity f = (Entity)l.getSelectedValue();
                    if (f != null) {
                        NavigatorPanel.this.setClipboard(f);
                    }
                } else if (o.length > 1) {
                    NavigatorPanel.this.setClipboard(Arrays.asList(o));
                }
                NavigatorPanel.this.deleteSelectedItem(l);
            }
            NavigatorPanel.this.redisplay();
        }
    };
    Action clearprobaction = new ProbabilityAction(Double.NaN, "Clear probability");
    Object tmp = null;
    SList popupSource = null;
    MouseListener mcl = new MouseAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            if (NavigatorPanel.this.canEdit && e.getModifiers() == 4) {
                NavigatorPanel.this.listEditPopup.show((Component)e.getSource(), e.getX(), e.getY());
                NavigatorPanel.this.popupSource = NavigatorPanel.this.findSList(e.getSource());
            }
            if (NavigatorPanel.this.moving != null) {
                if (NavigatorPanel.this.currentdroplist != null) {
                    Vector from = NavigatorPanel.this.entity.listOf(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist));
                    Vector to = NavigatorPanel.this.entity.listOf(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdroplist));
                    Entity entity = NavigatorPanel.this.moving;
                    synchronized (entity) {
                        int ifrom = from.indexOf(NavigatorPanel.this.moving);
                        int dest = NavigatorPanel.this.currentdroplist.getCaretIndex();
                        if (from == to) {
                            NavigatorPanel.this.entity.moveListItem(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist), ifrom, dest);
                        }
                        if (from != to) {
                            if (Entities.numConnections(NavigatorPanel.this.entity) > 1) {
                                NavigatorPanel.this.entity.disconnect(NavigatorPanel.this.moving, NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist));
                            } else {
                                from.remove(NavigatorPanel.this.moving);
                                NavigatorPanel.this.moving.listOf(Entity.inverseOf(NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdraglist))).remove(NavigatorPanel.this.entity);
                            }
                            NavigatorPanel.this.entity.connect(NavigatorPanel.this.moving, NavigatorPanel.this.relationFromList(NavigatorPanel.this.currentdroplist));
                            to.remove(NavigatorPanel.this.moving);
                            to.insertElementAt(NavigatorPanel.this.moving, dest);
                        }
                        NavigatorPanel.this.moving = null;
                    }
                    NavigatorPanel.this.currentdroplist.setCaretIndex(-1);
                    NavigatorPanel.this.redisplay();
                } else {
                    NavigatorPanel.this.moving = null;
                }
            }
        }
    };
    Entity moving;
    SList currentdraglist;
    SList currentdroplist;
    MouseMotionListener mml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            if (NavigatorPanel.this.moving == null) {
                NavigatorPanel.this.currentdraglist = NavigatorPanel.this.findSList((Container)e.getSource());
            }
            NavigatorPanel.this.moving = (Entity)NavigatorPanel.this.currentdraglist.getSelectedValue();
            if (NavigatorPanel.this.moving != null) {
                int y;
                Point oo = ((Component)e.getSource()).getLocationOnScreen();
                Point no = NavigatorPanel.this.getLocationOnScreen();
                int x = e.getX() + oo.x - no.x;
                Component c = NavigatorPanel.this.findComponentAt(x, y = e.getY() + oo.y - no.y);
                SList list = NavigatorPanel.this.findSList(c);
                if (list != null) {
                    int yy;
                    Point mo = list.getLocationOnScreen();
                    int xx = e.getX() + oo.x - mo.x;
                    Point locationInDropList = new Point(xx, yy = e.getY() + oo.y - mo.y);
                    int ix = list.locationToIndex(locationInDropList);
                    if (ix < 0 || !list.getCellBounds(ix, ix).contains(locationInDropList)) {
                        ix = list.getModel().getSize();
                    }
                    if (list.getCaretIndex() != ix || list != NavigatorPanel.this.currentdroplist) {
                        if (NavigatorPanel.this.currentdroplist != null) {
                            NavigatorPanel.this.currentdroplist.setCaretIndex(-1);
                        }
                        list.setCaretIndex(ix);
                        NavigatorPanel.this.currentdroplist = list;
                    }
                } else if (NavigatorPanel.this.currentdroplist != null) {
                    NavigatorPanel.this.currentdroplist.setCaretIndex(-1);
                    NavigatorPanel.this.currentdroplist = null;
                }
            }
        }
    };
    JMenuItem jMenuItem1 = new JMenuItem();

    public NavigatorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lists = new SList[]{this.superlist, this.sublist, this.causelist, this.effectlist, this.treatlist, this.treatmentlist};
        int i = 0;
        while (i < this.lists.length) {
            this.lists[i].doAddDoubleclickListener(this.dcl);
            this.lists[i].impl.addMouseListener(this.mcl);
            this.lists[i].impl.addMouseMotionListener(this.mml);
            this.lists[i].impl.registerKeyboardAction(this, "Delete", KeyStroke.getKeyStroke(127, 0), 1);
            this.lists[i].impl.getInputMap().put(KeyStroke.getKeyStroke(67, 2), this.copyaction);
            this.lists[i].impl.getInputMap().put(KeyStroke.getKeyStroke(86, 2), this.pasteaction);
            this.lists[i].impl.getInputMap().put(KeyStroke.getKeyStroke(88, 2), this.cutaction);
            this.lists[i].impl.getActionMap().put(this.copyaction, this.copyaction);
            this.lists[i].impl.getActionMap().put(this.pasteaction, this.pasteaction);
            this.lists[i].impl.getActionMap().put(this.cutaction, this.cutaction);
            ++i;
        }
        this.addComponentListener(new ComponentAdapter(){

            public synchronized void componentResized(ComponentEvent e) {
                NavigatorPanel.this.setPanelSizes();
            }
        });
    }

    public void setEntity(Entity e) {
        this.entity = e;
        this.init();
        if (this.history.contains(e)) {
            this.historyPointer = this.history.indexOf(e);
        } else {
            this.history.add(e);
            this.historyPointer = this.history.size() - 1;
            if (this.history.size() > MAX_HISTORY) {
                this.history.remove(0);
                --this.historyPointer;
            }
        }
    }

    public JPopupMenu getHistoryMenu() {
        JPopupMenu m = new JPopupMenu();
        Iterator<Entity> iterator = this.history.iterator();
        while (iterator.hasNext()) {
            Entity e;
            final Entity fe = e = iterator.next();
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(new AbstractAction(e.name){

                public void actionPerformed(ActionEvent ev) {
                    NavigatorPanel.this.setEntity(fe);
                }
            });
            m.add(mi);
            if (!e.equals(this.entity)) continue;
            mi.setState(true);
        }
        return m;
    }

    void clearHistory() {
        this.history.removeAllElements();
        this.historyPointer = 0;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void init() {
        if (this.entity != null) {
            this.superlist.setListData(this.entity, this.entity.parents);
            this.sublist.setListData(this.entity, this.entity.children);
            this.causelist.setListData(this.entity, this.entity.causes);
            this.effectlist.setListData(this.entity, this.entity.effects);
            this.treatlist.setListData(this.entity, this.entity.treats);
            this.treatmentlist.setListData(this.entity, this.entity.treatments);
        } else {
            Vector nullv = new Vector();
            this.superlist.setListData(null, nullv);
            this.sublist.setListData(null, nullv);
            this.causelist.setListData(null, nullv);
            this.effectlist.setListData(null, nullv);
            this.treatlist.setListData(null, nullv);
            this.treatmentlist.setListData(null, nullv);
        }
        this.entitypanel.setEntity(this.entity);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setText("Superclasses");
        this.superpanel.setLayout(this.borderLayout2);
        this.subpanel.setLayout(this.borderLayout3);
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setText("Subtypes");
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setText("Causes");
        this.causepanel.setLayout(this.borderLayout4);
        this.jScrollPane3.setPreferredSize(new Dimension(100, 150));
        this.jLabel4.setFont(new Font("Dialog", 1, 12));
        this.jLabel4.setText("Effects");
        this.effectspanel.setLayout(this.borderLayout5);
        this.jScrollPane4.setPreferredSize(new Dimension(100, 150));
        this.jMenu1.setText("Add");
        this.jMenuItem9.setText("Delete");
        this.jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuDelete(e);
            }
        });
        this.jMenuItem8.setText("New item");
        this.jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.addNewItem(e);
            }
        });
        this.jMenuItem6.setFont(new Font("Dialog", 1, 12));
        this.jMenuItem6.setText("Go to");
        this.jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuGoto(e);
            }
        });
        this.jMenuItem10.setText("Existing item");
        this.jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuAddExist(e);
            }
        });
        this.causelist.setBackground(new Color(216, 225, 255));
        this.causelist.setToolTipText("List of causes");
        this.causelist.setSelectionBackground(new Color(128, 128, 255));
        this.effectlist.setBackground(new Color(255, 215, 225));
        this.effectlist.setToolTipText("List of consequences");
        this.effectlist.setSelectionBackground(Color.red);
        this.superlist.setToolTipText("List of superclasses");
        this.sublist.setToolTipText("List of subclasses");
        this.superpanel.setPreferredSize(new Dimension(337, 60));
        this.subpanel.setPreferredSize(new Dimension(311, 60));
        this.causelist.relation = 4;
        this.effectlist.relation = 8;
        this.superlist.relation = 1;
        this.sublist.relation = 2;
        this.treatmentlist.relation = 32;
        this.treatlist.relation = 16;
        this.entitypanel.setEditable(true);
        this.jMenuItem1.setText("Quick add...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.menuQuickAdd(e);
            }
        });
        this.add((Component)this.superpanel, "North");
        this.superpanel.add((Component)this.jLabel1, "West");
        this.superpanel.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.subpanel, "South");
        this.subpanel.add((Component)this.jLabel2, "West");
        this.subpanel.add((Component)this.jScrollPane2, "Center");
        this.add((Component)this.entitypanel, "Center");
        this.add((Component)this.causepanel, "West");
        this.causepanel.add((Component)this.jLabel3, "North");
        this.causepanel.add((Component)this.jScrollPane3, "Center");
        this.add((Component)this.effectspanel, "East");
        this.effectspanel.add((Component)this.jLabel4, "North");
        this.effectspanel.add((Component)this.jScrollPane4, "Center");
        this.jScrollPane4.getViewport().add((Component)this.effectlist, null);
        this.jScrollPane3.getViewport().add((Component)this.causelist, null);
        this.jScrollPane2.getViewport().add((Component)this.sublist, null);
        this.jScrollPane1.getViewport().add((Component)this.superlist, null);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem8);
        this.jMenu1.add(this.jMenuItem10);
        this.listEditPopup.add(this.jMenuItem6);
        this.listEditPopup.addSeparator();
        this.listEditPopup.add(this.jMenu1);
        this.listEditPopup.add(this.jMenuItem9);
        this.listEditPopup.add(this.cutaction);
        this.listEditPopup.add(this.copyaction);
        this.listEditPopup.add(this.pasteaction);
        this.listEditPopup.addSeparator();
        this.listEditPopup.add(this.probMenu);
        this.probMenu.setText("Probability");
        this.probMenu.add(new ProbabilityAction(0.1));
        this.probMenu.add(new ProbabilityAction(1.0));
        this.probMenu.add(new ProbabilityAction(10.0));
        this.probMenu.add(new ProbabilityAction(20.0));
        this.probMenu.add(new ProbabilityAction(40.0));
        this.probMenu.add(new ProbabilityAction(50.0));
        this.probMenu.add(new ProbabilityAction(60.0));
        this.probMenu.add(new ProbabilityAction(80.0));
        this.probMenu.add(new ProbabilityAction(90.0));
        this.probMenu.add(new ProbabilityAction(99.0));
        this.probMenu.add(new ProbabilityAction(100.0));
        this.probMenu.add(this.probExactAction);
        this.listEditPopup.add(this.clearprobaction);
        this.entitypanel.treatscroll.getViewport().setView(this.treatlist);
        this.entitypanel.treatmentscroll.getViewport().setView(this.treatmentlist);
    }

    public void setEditable(boolean t) {
        this.canEdit = t;
        this.entitypanel.setEditable(t);
    }

    public boolean isEditable() {
        return this.canEdit;
    }

    void find(EntityData d) {
        FindDialog fd = new FindDialog(d);
        fd.setModal(true);
        fd.show();
        if (fd.entity != null) {
            this.setEntity(fd.entity);
        }
    }

    public void actionPerformed(ActionEvent e) {
        SList list;
        String s = e.getActionCommand();
        if (this.canEdit && s.equals("Delete") && (list = this.findSList(e.getSource())) != null) {
            this.deleteSelectedItem(list);
        }
    }

    public void setClipboard(Object o) {
        this.tmp = o;
        TransferableEntity.listener.actionPerformed(new ActionEvent(o, 0, "ClipboardChanged"));
    }

    public Object getClipboard() {
        return this.tmp;
    }

    SList findSList(Object c) {
        if (c == null) {
            return null;
        }
        if (c instanceof SList) {
            return (SList)c;
        }
        if (c instanceof Container) {
            return this.findSList(((Container)c).getParent());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanelSizes() {
        int w = this.getWidth();
        int h = this.getHeight();
        this.causepanel.setPreferredSize(new Dimension(w / 4, 100));
        this.effectspanel.setPreferredSize(new Dimension(w / 4, 100));
        this.subpanel.setPreferredSize(new Dimension(100, h / 4));
        this.superpanel.setPreferredSize(new Dimension(100, h / 4));
        this.invalidate();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        this.repaint();
    }

    void menuGoto(ActionEvent e) {
        Entity ent = (Entity)this.popupSource.getSelectedValue();
        if (ent != null) {
            this.setEntity(ent);
        }
    }

    void addNewItem(ActionEvent e) {
        int conn = Entity.inverseOf(this.relationFromList(this.popupSource));
        Entity ne = MainApplication.frame.getData().addNewEntity(this.entity, conn);
        this.setEntity(ne);
        JTextField t = this.entitypanel.namepanel;
        t.requestFocus();
        t.setSelectionStart(0);
        t.setSelectionEnd(t.getText().length());
    }

    int relationFromList(SList l) {
        if (l == this.superlist) {
            return 1;
        }
        if (l == this.sublist) {
            return 2;
        }
        if (l == this.causelist) {
            return 4;
        }
        if (l == this.effectlist) {
            return 8;
        }
        if (l == this.treatlist) {
            return 16;
        }
        if (l == this.treatmentlist) {
            return 32;
        }
        return -1;
    }

    void menuDelete(ActionEvent e) {
        this.deleteSelectedItem(this.popupSource);
    }

    void deleteSelectedItem(SList l) {
        Object[] o = l.getSelectedValues();
        boolean changed = false;
        int i = 0;
        while (i < o.length) {
            Entity ent = (Entity)o[i];
            if (ent != null) {
                this.entity.disconnect(ent, this.relationFromList(l));
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.redisplay();
        }
    }

    void menuQuickAdd(ActionEvent e) {
        EntityData data = this.entitypanel.getFrameData();
        QuickAddDialog q = new QuickAddDialog(data);
        q.show();
        if (q.entity != null) {
            this.entity.connect(q.entity, this.relationFromList(this.popupSource));
            if (q.createdNewEntity) {
                this.setEntity(q.entity);
            }
        }
        this.redisplay();
    }

    void menuAddExist(ActionEvent e) {
        EntityChooser ec = new EntityChooser();
        ec.setModal(true);
        ec.navigator.setEntity(this.entity);
        ec.show();
        if (ec.entity != null) {
            this.entity.connect(ec.entity, this.relationFromList(this.popupSource));
        }
        this.redisplay();
    }

    public void redisplay() {
        this.setEntity(this.entity);
    }

    public SList getFocusedList() {
        int i = 0;
        while (i < this.lists.length) {
            if (this.lists[i].hasFocus()) {
                return this.lists[i];
            }
            ++i;
        }
        return null;
    }

    class ProbabilityAction
    extends AbstractAction {
        double p;

        ProbabilityAction(double d) {
            super(String.valueOf(d) + "%");
            this.p = d;
        }

        ProbabilityAction(double d, String name) {
            super(name);
            this.p = d;
        }

        public void actionPerformed(ActionEvent e) {
            SList l = NavigatorPanel.this.findSList(e.getSource());
            if (l == null && NavigatorPanel.this.popupSource != null) {
                l = NavigatorPanel.this.popupSource;
            }
            if (l != null) {
                Object[] o = l.getSelectedValues();
                int i = 0;
                while (i < o.length) {
                    int rel = NavigatorPanel.this.relationFromList(l);
                    int idx = NavigatorPanel.this.entity.listOf(rel).indexOf(o[i]);
                    NavigatorPanel.this.entity.setProbOf(rel, idx, this.p);
                    ++i;
                }
                if (Double.isNaN(this.p)) {
                    NavigatorPanel.this.entity.checkIfProbsClear();
                }
            }
        }
    }
}

