/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;

class MultiChoiceLogic {
    int MODE_RANDOM_TYPED = 0;
    int MODE_RANDOM_RELATED = 1;
    int MODE_COMPLETELY_RANDOM = 2;
    int MODE_SOUNDS_SIMILAR = 3;
    int MODE_BROTHER_OF_CORRECT = 4;
    int MODE_BROTHER_OF_ROOT = 5;
    String[] MODE_NAMES = new String[]{"Random typed", "Random related", "Random.", "Looks similar", "Brother of correct", "Brother of root"};
    EntityData ed;
    Entity seed;
    int N = 4;
    boolean randomroot = false;
    boolean restrRoot = false;
    boolean restrChoice = false;
    int[] DIRECTIONS = new int[]{4, 8, 32, 16};
    String[][] questionHead = new String[][]{{"Which of the following is most likely to be the cause of ", "?"}, {"Which of the following are commonly associated with ", "?"}, {"Which of the following might be used to treat ", "?"}, {"Which of the following is most likely to be treated with ", "?"}};
    Entity root;
    Entity correct;
    Entity[] incorrect;
    int direction;
    String question;
    int mode = this.MODE_RANDOM_TYPED;
    String infoText;
    String[] infoIncor;
    String infoCorrect;

    MultiChoiceLogic() {
    }

    void newQuestion() {
        Entity p;
        int d2;
        int d1;
        if (this.randomroot) {
            boolean ok = false;
            while (!ok) {
                this.root = this.ed.getRandomEntity();
                ok = !this.restrRoot | Entities.hasAStandardUltimateParent(this.root);
            }
        } else {
            this.root = this.seed;
        }
        this.seed = this.root;
        int attempt = 0;
        int numposs = 0;
        do {
            this.direction = (int)Math.floor(Math.random() * (double)this.DIRECTIONS.length);
            d1 = this.DIRECTIONS[this.direction];
            d2 = Entity.inverseOf(d1);
            this.question = String.valueOf(this.questionHead[this.direction][0]) + this.root + this.questionHead[this.direction][1];
        } while ((numposs = this.root.listOf(d1).size()) == 0 && attempt++ < 10);
        if (attempt >= 10) {
            throw new IllegalStateException("Unable to find any questions for " + this.root);
        }
        this.correct = (Entity)this.root.listOf(d1).get((int)Math.floor(Math.random() * (double)numposs));
        Entity correctTypeT = Entities.getUltimateParents(this.correct);
        String rel1 = d1 == 4 ? "Causes" : "Effects";
        String rel2 = d1 == 4 ? "can cause" : "can be caused by";
        String rel3 = d1 == 4 ? "Effects" : "Causes";
        this.incorrect = new Entity[this.N];
        this.infoIncor = new String[this.N];
        if (this.mode == this.MODE_RANDOM_TYPED || this.mode == this.MODE_RANDOM_RELATED || this.mode == this.MODE_COMPLETELY_RANDOM) {
            if (this.correct.parents.size() == 0) {
                throw new TryAgain();
            }
            Entity correctType1 = (Entity)this.correct.parents.get(0);
            Entity correctType2 = null;
            if (correctType1.parents.size() > 0 && Math.random() > 0.5) {
                correctType2 = (Entity)correctType1.parents.get(0);
            }
            Entity correctType0 = Entities.getUltimateParents(this.correct);
            int i = 0;
            while (i < this.N) {
                Entity tmp;
                attempt = 0;
                boolean sametype = false;
                do {
                    tmp = this.ed.getRandomEntity();
                    if (this.mode == this.MODE_RANDOM_RELATED) {
                        Entity tmpp;
                        sametype = tmp.parents.size() == 0 ? false : (tmpp = (Entity)tmp.parents.get(0)) == correctType1;
                        this.infoIncor[i] = tmp + " is related to " + this.correct + " by being a type of " + correctType1;
                        continue;
                    }
                    if (this.mode == this.MODE_RANDOM_TYPED) {
                        sametype = Entities.getUltimateParents(tmp) == correctType0;
                        this.infoIncor[i] = tmp + " is a random " + correctType0;
                        continue;
                    }
                    if (this.mode != this.MODE_COMPLETELY_RANDOM) continue;
                    sametype = true;
                    this.infoIncor[i] = tmp + " is completely random";
                } while ((!sametype || Entities.isRelatedTo(this.root, tmp, d2 | 1 | 2, 3, null) || this.anyarrayequal(this.incorrect, i - 1, tmp) || this.correct == tmp) && attempt++ < 5000);
                if (attempt >= 5000) {
                    throw new IllegalStateException("Unable to find an unrelated (" + d1 + ") item to " + this.root + ", of type " + correctType1);
                }
                this.infoText = "randomly related";
                this.incorrect[i] = tmp;
                int n = i;
                this.infoIncor[n] = String.valueOf(this.infoIncor[n]) + ". " + rel3 + " include " + Entities.listToText(this.incorrect[i].listOf(d2));
                ++i;
            }
        } else if (this.mode == this.MODE_SOUNDS_SIMILAR) {
            Collection es = this.ed.getAllEntities();
            double[] score = new double[es.size()];
            double[] hiscore = new double[this.N];
            Entity[] hient = new Entity[this.N];
            int idx = 0;
            int i = 0;
            while (i < this.N) {
                hiscore[i] = Double.MIN_VALUE;
                ++i;
            }
            for (Entity ei : es) {
                if (ei != this.correct && !Entities.isRelatedTo(ei, this.correct, 3 | d1, 2, null)) {
                    score[idx] = MultiChoiceLogic.compareStrings(ei.name, this.correct.name);
                    if (score[idx] > hiscore[0]) {
                        int inspos = 0;
                        while (inspos < this.N - 1 && score[idx] > hiscore[inspos + 1]) {
                            ++inspos;
                        }
                        int j = 0;
                        while (j < inspos) {
                            hiscore[j] = hiscore[j + 1];
                            hient[j] = hient[j + 1];
                            ++j;
                        }
                        hiscore[inspos] = score[idx];
                        hient[inspos] = ei;
                    }
                    this.infoText = "Lexically similar to " + this.correct;
                }
                ++idx;
            }
            i = 0;
            while (i < this.N) {
                this.incorrect[i] = hient[i];
                this.infoIncor[i] = hient[i] + " has similarity " + hiscore[i] + " to " + this.correct;
                ++i;
            }
        } else if (this.mode == this.MODE_BROTHER_OF_CORRECT) {
            if (this.correct.parents.size() == 0) {
                throw new TryAgain();
            }
            p = (Entity)this.correct.parents.get(0);
            Vector s = new Vector(Entities.getExtensiveListOf(2, p, 10));
            this.filterOutRelations(s, this.root, d2 | 2, 3);
            s.remove(this.correct);
            this.infoText = "Brothers of " + this.correct;
            if (s.size() < this.N) {
                if (p.parents.size() > 0) {
                    p = (Entity)p.parents.get(0);
                }
                s = new Vector(Entities.getExtensiveListOf(2, p, 10));
                this.filterOutRelations(s, this.root, d2 | 2, 3);
                s.remove(this.correct);
                if (s.size() < this.N) {
                    throw new TryAgain();
                }
                this.infoText = "Cousins of " + this.correct;
            }
            Vector r = this.choose(s, this.N);
            int i = 0;
            while (i < this.N) {
                this.incorrect[i] = (Entity)r.get(i);
                this.infoIncor[i] = r.get(i) + " is a type of " + p;
                ++i;
            }
        } else if (this.mode == this.MODE_BROTHER_OF_ROOT) {
            if (this.root.parents.size() == 0) {
                throw new TryAgain();
            }
            p = (Entity)this.root.parents.get(0);
            HashSet<Entity> exclude = new HashSet<Entity>();
            exclude.add(this.root);
            Set brothrs = Entities.getExtensiveListOf(2, p, 2, exclude);
            HashSet rels = new HashSet();
            for (Entity b : brothrs) {
                exclude = new HashSet();
                exclude.add(this.root);
                rels.addAll(Entities.getExtensiveListOf(d1, b, 1, exclude));
            }
            rels.removeAll(brothrs);
            Vector v = new Vector(rels);
            this.filterOutRelations(v, this.root, d2, 3);
            v = this.choose(v, this.N);
            this.infoText = String.valueOf(Entities.getRelationNamesFromBits(d1)) + "s of the brothers (& nephews) of " + this.root;
            int i = 0;
            while (i < this.N) {
                this.incorrect[i] = (Entity)v.get(i);
                Vector ch = Entities.findRelationChains(p, this.incorrect[i], 2 | d1, 4, null, null, null, 0);
                if (ch.size() == 0) {
                    throw new IllegalStateException("Could not find chain for brother of root: " + p + "'s children's " + Entities.getRelationNamesFromBits(d1) + " don't include " + this.incorrect[i]);
                }
                int shortest = 0;
                int shortlen = 100;
                int j = 0;
                while (j < ch.size()) {
                    int tmp = ((Vector)ch.get(j)).size();
                    if (tmp < shortlen) {
                        shortest = j;
                        shortlen = tmp;
                    }
                    ++j;
                }
                Vector inf = (Vector)ch.get(shortest);
                Collections.reverse(inf);
                this.infoIncor[i] = Entities.chainText(inf);
                ++i;
            }
        }
        this.infoText = "Incorrect answers are all " + this.infoText;
        Vector corrD2 = this.correct.listOf(d2);
        corrD2.remove(this.root);
        this.infoCorrect = String.valueOf(rel1) + " of " + this.root + " include " + Entities.listToText(this.root.listOf(d1)) + ". \n" + this.correct + " also " + rel2 + " " + Entities.listToText(corrD2) + ".";
    }

    boolean anyarrayequal(Entity[] a, int N, Entity e) {
        boolean f = false;
        int i = 0;
        while (i < N) {
            if (a[i] == e) {
                f = true;
            }
            ++i;
        }
        return f;
    }

    Vector choose(Collection s, int n) {
        int ns = s.size();
        Vector result = new Vector();
        if (ns < n) {
            throw new IllegalStateException("Cannot choose " + n + " items from a set " + s + " of " + ns);
        }
        Vector<Integer> r = new Vector<Integer>();
        int i = 0;
        while (i < ns) {
            r.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(r);
        Iterator it = s.iterator();
        int un = 0;
        int i2 = 0;
        while (i2 < ns) {
            Object o = it.next();
            int j = 0;
            while (j < n) {
                if ((Integer)r.get(j) == i2) {
                    result.add(o);
                    ++un;
                }
                ++j;
            }
            if (un >= n) break;
            ++i2;
        }
        return result;
    }

    void filterOutRelations(Vector v, Entity relative, int relations, int depth) {
        Vector rm = new Vector();
        int i = 0;
        while (i < v.size()) {
            if (Entities.isRelatedTo((Entity)v.get(i), relative, relations, depth, null)) {
                rm.add(v.get(i));
            }
            ++i;
        }
        v.removeAll(rm);
    }

    public static double compareStrings(String str1, String str2) {
        ArrayList pairs1 = MultiChoiceLogic.wordLetterPairs(str1.toUpperCase());
        ArrayList pairs2 = MultiChoiceLogic.wordLetterPairs(str2.toUpperCase());
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        int i = 0;
        while (i < pairs1.size()) {
            Object pair1 = pairs1.get(i);
            int j = 0;
            while (j < pairs2.size()) {
                Object pair2 = pairs2.get(j);
                if (pair1.equals(pair2)) {
                    ++intersection;
                    pairs2.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return 2.0 * (double)intersection / (double)union;
    }

    private static ArrayList wordLetterPairs(String str) {
        ArrayList<String> allPairs = new ArrayList<String>();
        String[] words = str.split("\\s");
        int w = 0;
        while (w < words.length) {
            String[] pairsInWord = MultiChoiceLogic.letterPairs(words[w]);
            int p = 0;
            while (p < pairsInWord.length) {
                allPairs.add(pairsInWord[p]);
                ++p;
            }
            ++w;
        }
        return allPairs;
    }

    private static String[] letterPairs(String str) {
        int numPairs = str.length() - 1;
        if (numPairs < 1) {
            return new String[0];
        }
        String[] pairs = new String[numPairs];
        int i = 0;
        while (i < numPairs) {
            pairs[i] = str.substring(i, i + 2);
            ++i;
        }
        return pairs;
    }

    class TryAgain
    extends RuntimeException {
        TryAgain() {
        }
    }
}

